<?xml version="1.0" encoding="UTF-8" ?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
<xsl:output method="html"></xsl:output>

<xsl:template match="/">
    <xsl:apply-templates/>
</xsl:template>

<xsl:template match="subject">
    <div style="white-space:nowrap;">
    <xsl:choose>
        <xsl:when test="@isread">
            <img src="/lams/images/tool/mb/mb_post.gif" with="21" height="21" border="0"/>
        </xsl:when>
        <xsl:otherwise>
            <img src="/lams/images/tool/mb/mb_post_new.gif" with="21" height="21" border="0"/>
        </xsl:otherwise>
    </xsl:choose>    
    <a class="navMb">
        <xsl:attribute name="href">thread.do?method=getSingleThread&#38;threadId=<xsl:value-of select="/subject/@threadId"/>&#38;messageId=<xsl:value-of select="@sid"/></xsl:attribute>
        <xsl:value-of select="/subject/startmessage/@shortmessage"/>
    </a>&#160; 
    <span class="mbPost"><xsl:value-of select="@authorname"/></span>&#160;  
    <span class="mbPostLight"><xsl:value-of select="@postdate"/></span>
    </div>
    <xsl:apply-templates/>
</xsl:template>

<xsl:template match="message">
    <!-- Add the | indent graphics -->
    <div style="white-space:nowrap;">
    <xsl:for-each select="ancestor::*">
        <xsl:if test="name()!='subject' and name()!='startmessage'">
            <!-- we need to walk up the tree to see if the parent has any siblings -->
            <xsl:choose>
                <xsl:when test="count(following-sibling::*) &gt; 0">
                    <img src="/lams/images/tool/mb/mb_i.gif" with="21" height="21" border="0"/>
                </xsl:when>
                <xsl:otherwise>
                    <img src="/lams/images/tool/mb/shim.gif" width="21" height="21" border="0"/>
                </xsl:otherwise>
            </xsl:choose>                
        </xsl:if>
    </xsl:for-each>
    <xsl:choose>
        <xsl:when test="count(following-sibling::*) &gt; 0">
            <img src="/lams/images/tool/mb/mb_t.gif" with="21" height="21" border="0"/>
        </xsl:when>
        <xsl:otherwise>
            <img src="/lams/images/tool/mb/mb_l.gif" with="21" height="21" border="0"/>
        </xsl:otherwise>
    </xsl:choose>
    <!-- decide read/new post -->
    <xsl:choose>
        <xsl:when test="@isread">
            <img src="/lams/images/tool/mb/mb_post.gif" with="21" height="21" border="0"/>
        </xsl:when>
        <xsl:otherwise>
            <img src="/lams/images/tool/mb/mb_post_new.gif" with="21" height="21" border="0"/>
        </xsl:otherwise>
    </xsl:choose>    
    <!-- format the line out -->
    <a class="navMb">
        <xsl:attribute name="href">thread.do?method=getSingleThread&#38;threadId=<xsl:value-of select="/subject/@threadId"/>&#38;messageId=<xsl:value-of select="@sid"/></xsl:attribute>
        <xsl:value-of select="@shortmessage"/>
    </a>&#160; 
    <span class="mbPost"><xsl:value-of select="@authorname"/></span>&#160;  
    <span class="mbPostLight"><xsl:value-of select="@postdate"/></span>
    </div>
    <!-- recurse through all nodes -->
    <xsl:apply-templates/>
</xsl:template>

<!-- write out the text -->
<xsl:template match="messageText"/>

</xsl:stylesheet>