/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.ld.security.web;

import com.webmcq.ld.ws.ExtUserLoginMap;
import com.webmcq.ld.ws.ExtUserLoginMapManager;
import com.webmcq.ld.ws.UserManagementServiceDelegate;
import com.webmcq.ld.ws.dao.ServerNotFoundException;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.security.auth.login.FailedLoginException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.sql.DataSource;
import org.lamsfoundation.ld.security.AuthenticateException;
import org.lamsfoundation.ld.security.Authenticator;
import org.lamsfoundation.ld.util.MethodDispatcher;

public class LoginRequestServlet
extends HttpServlet {
    private static final String JNDI_DATASOURCE = "java:/MySqlDS";
    private static final String PASSWORD_QUERY = "select password from tbl_user where login=?";
    public static final String URLDECODER_CODING = "US-ASCII";
    public static final int PASSWORD_LENGTH = 10;

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        HttpSession hses = request.getSession(true);
        String username = request.getParameter("uid");
        String serverid = request.getParameter("sid");
        String timestamp = request.getParameter("ts");
        String hash = request.getParameter("hash");
        String method = request.getParameter("method");
        String loginRequestUsername = (String)hses.getAttribute("loginRequestUsername");
        if (loginRequestUsername != null && loginRequestUsername.equals(username)) {
            String url = MethodDispatcher.getMethodURL(request);
            response.sendRedirect(response.encodeRedirectURL(url));
            return;
        }
        if (loginRequestUsername != null && !loginRequestUsername.equals(username)) {
            hses.invalidate();
            hses = request.getSession(true);
        } else if (request.getRemoteUser() != null && loginRequestUsername == null) {
            hses.invalidate();
            hses = request.getSession(true);
        }
        if (username == null || method == null || serverid == null || timestamp == null || hash == null) {
            response.sendError(401, "Login Failed - login parameters missing");
            return;
        }
        try {
            Authenticator.authenticate(timestamp, username, method, serverid, hash);
        }
        catch (AuthenticateException e) {
            response.sendError(401, "Login Failed - authentication error");
            return;
        }
        catch (ServerNotFoundException e) {
            response.sendError(401, "Login Failed - your server has not been registered in LAMS");
            return;
        }
        String lamsUsername = null;
        ExtUserLoginMap map = ExtUserLoginMapManager.getExtUserLoginMapByUsernameAndServerId(username, serverid);
        if (map == null) {
            try {
                lamsUsername = UserManagementServiceDelegate.getUserDataAndCreateUser(serverid, username);
            }
            catch (Exception e) {
                throw new ServletException(e.getMessage(), (Throwable)e);
            }
        } else {
            lamsUsername = map.getLogin();
        }
        hses.setAttribute("lamsUsername", (Object)lamsUsername);
        String pass = null;
        try {
            pass = this.getUserPassword(lamsUsername);
        }
        catch (Exception e) {
            response.sendError(401, "Login Failed - user does not exist");
            return;
        }
        hses.setAttribute("loginRequestUsername", (Object)username);
        response.sendRedirect("j_security_check?j_username=" + lamsUsername + "&j_password=" + pass);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getUserPassword(String username) throws FailedLoginException, NamingException, SQLException {
        InitialContext ctx = new InitialContext();
        DataSource ds = (DataSource)ctx.lookup(JNDI_DATASOURCE);
        Connection conn = null;
        String password = null;
        try {
            conn = ds.getConnection();
            PreparedStatement ps = conn.prepareStatement(PASSWORD_QUERY);
            ps.setString(1, username);
            ResultSet rs = ps.executeQuery();
            if (!rs.next()) {
                throw new FailedLoginException("invalid username");
            }
            password = rs.getString(1);
            rs.close();
            Object var9_8 = null;
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            if (conn != null && !conn.isClosed()) {
                conn.close();
            }
            throw throwable;
        }
        if (conn != null && !conn.isClosed()) {
            conn.close();
        }
        return password;
    }
}

