/*
 * Decompiled with CFR 0.152.
 */
package com.webmcq.ld.util;

import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.log4j.Logger;

public class JspRedirectStrategy {
    public static final String AUTH_OBJECT_NAME = "authorizationObjectName";
    public static final String PRE_SECURITY_CHECK = "preSecurityCheckStatus";
    public static final String SECURITY_CHECK_PASSED = "securityCheckPassed";
    public static final String SECURITY_CHECK_FAILED = "securityCheckFailed";
    public static final String WELCOME_PAGE = "index.jsp";
    private static Logger log = Logger.getLogger((Class)(class$com$webmcq$ld$util$JspRedirectStrategy == null ? (class$com$webmcq$ld$util$JspRedirectStrategy = JspRedirectStrategy.class$("com.webmcq.ld.util.JspRedirectStrategy")) : class$com$webmcq$ld$util$JspRedirectStrategy));
    static /* synthetic */ Class class$com$webmcq$ld$util$JspRedirectStrategy;

    public static boolean loginPageRedirected(HttpServletRequest request, HttpServletResponse response) throws IOException {
        HttpSession session = request.getSession(false);
        if (session == null) {
            log.debug((Object)"===>LOGIN PAGE: session not found, simply stop here.");
            return true;
        }
        String checkStatus = (String)session.getAttribute(AUTH_OBJECT_NAME);
        String id = session.getId();
        if (session.isNew()) {
            session.invalidate();
            String referer = request.getHeader("Referer");
            if (referer == null) {
                log.debug((Object)("===>LOGIN PAGE: user is accessing login page directly, redirect to index.jsp" + id));
                response.sendRedirect(WELCOME_PAGE);
            } else {
                log.debug((Object)("===>LOGIN PAGE: user is accessing login page directly, goto " + referer + id));
                response.sendRedirect(referer);
            }
            return true;
        }
        if (checkStatus == null) {
            session.setAttribute(AUTH_OBJECT_NAME, (Object)PRE_SECURITY_CHECK);
            log.debug((Object)("===>LOGIN PAGE: never hit login page before, auth obj created" + id));
            return false;
        }
        if (checkStatus.equals(PRE_SECURITY_CHECK)) {
            log.debug((Object)("===>LOGIN PAGE: accessing login page before login succeed:" + id));
            return false;
        }
        if (checkStatus.equals(SECURITY_CHECK_PASSED)) {
            log.debug((Object)("===>LOGIN PAGE: accessing login after login succeed, redirect toindex.jsp" + id));
            response.sendRedirect(WELCOME_PAGE);
            return true;
        }
        if (checkStatus.equals(SECURITY_CHECK_FAILED)) {
            session.invalidate();
            response.sendRedirect(WELCOME_PAGE);
            log.debug((Object)("===>LOGIN PAGE: requesting login page directly after login failed, start new login process" + id));
            return true;
        }
        log.debug((Object)("===>LOGIN PAGE: logically impossible to be here, no valid status found :" + id));
        return true;
    }

    public static boolean errorPageRedirected(HttpServletRequest request, HttpServletResponse response) throws IOException {
        HttpSession session = request.getSession(false);
        if (session == null) {
            log.debug((Object)"===>ERROR PAGE: Session not found, simply stop.");
            return true;
        }
        String checkStatus = (String)session.getAttribute(AUTH_OBJECT_NAME);
        String id = session.getId();
        if (checkStatus == null) {
            log.debug((Object)("===>ERROR PAGE: requesting error page directly, redirect toindex.jsp" + id));
            session.invalidate();
            response.sendRedirect(WELCOME_PAGE);
            return true;
        }
        if (checkStatus.equals(PRE_SECURITY_CHECK)) {
            log.debug((Object)("===>ERROR PAGE: found preSecurityCheck, update auth obj, continue login" + id));
            session.setAttribute(AUTH_OBJECT_NAME, (Object)SECURITY_CHECK_FAILED);
            return false;
        }
        if (checkStatus.equals(SECURITY_CHECK_PASSED)) {
            log.debug((Object)("===>ERROR PAGE: trying to access error page directly after login succeed " + id));
            response.sendRedirect(WELCOME_PAGE);
            return true;
        }
        if (checkStatus.equals(SECURITY_CHECK_FAILED)) {
            log.debug((Object)("===>ERROR PAGE: previous page is error page as well, continue error page" + id));
            return false;
        }
        log.debug((Object)("===>ERROR PAGE: logically impossible to be here, stop." + id));
        return true;
    }

    public static void welcomePageStatusUpdate(HttpServletRequest request, HttpServletResponse response) {
        HttpSession session = request.getSession(false);
        if (session.getAttribute(AUTH_OBJECT_NAME) == null || !session.getAttribute(AUTH_OBJECT_NAME).equals(SECURITY_CHECK_PASSED)) {
            log.debug((Object)"===>LOGIN PAGE: welcomePageStatusUpdate.");
        }
        session.setAttribute(AUTH_OBJECT_NAME, (Object)new String(SECURITY_CHECK_PASSED));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

