/*
 * Decompiled with CFR 0.152.
 */
package com.webmcq.ld.tool.voterank.dto;

import com.webmcq.ld.service.UserNotFoundException;
import com.webmcq.ld.service.UserServiceDelegate;
import com.webmcq.ld.tool.voterank.PollContentBean;
import com.webmcq.ld.tool.voterank.dto.AllVoteData;
import com.webmcq.ld.tool.voterank.dto.NominationVoteData;
import com.webmcq.ld.tool.voterank.dto.PollContentNominationResultsData;
import com.webmcq.ld.tool.voterank.interfaces.PollContentData;
import com.webmcq.ld.tool.voterank.interfaces.PollContentLocal;
import com.webmcq.ld.tool.voterank.interfaces.VoteData;
import com.webmcq.ld.tool.voterank.interfaces.VoteLocal;
import com.webmcq.ld.usermanagement.UserData;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.collections.Bag;
import org.apache.commons.collections.TreeBag;
import org.apache.log4j.Logger;

public class PollDTOFactory {
    private static Logger log = Logger.getLogger((Class)(class$com$webmcq$ld$tool$voterank$dto$PollDTOFactory == null ? (class$com$webmcq$ld$tool$voterank$dto$PollDTOFactory = PollDTOFactory.class$("com.webmcq.ld.tool.voterank.dto.PollDTOFactory")) : class$com$webmcq$ld$tool$voterank$dto$PollDTOFactory));
    static /* synthetic */ Class class$com$webmcq$ld$tool$voterank$dto$PollDTOFactory;

    public static PollContentNominationResultsData getNominations(PollContentLocal pollContent) {
        if (pollContent == null) {
            return null;
        }
        PollContentNominationResultsData dataHolder = new PollContentNominationResultsData();
        dataHolder.setNominees(pollContent.getNominationsAsStrings());
        dataHolder.setPollInfo(pollContent.getData());
        return dataHolder;
    }

    public static PollContentNominationResultsData getIndividualResultsData(long userId, PollContentLocal pollContent) {
        if (pollContent == null) {
            return null;
        }
        PollContentNominationResultsData dataHolder = new PollContentNominationResultsData();
        dataHolder.setNominees(pollContent.getNominationsAsStrings());
        dataHolder.setPollInfo(pollContent.getData());
        HashSet<VoteData> voteDataColl = new HashSet<VoteData>();
        Iterator iter = pollContent.getIndividualVotes(userId).iterator();
        while (iter.hasNext()) {
            VoteLocal vote = (VoteLocal)iter.next();
            voteDataColl.add(vote.getData());
        }
        dataHolder.setResults(voteDataColl, false);
        return dataHolder;
    }

    public static PollContentNominationResultsData getSummaryResultsData(PollContentLocal pollContent) {
        if (pollContent == null) {
            return null;
        }
        PollContentNominationResultsData dataHolder = new PollContentNominationResultsData();
        dataHolder.setNominees(pollContent.getNominationsAsStrings());
        dataHolder.setPollInfo(pollContent.getData());
        HashSet<VoteData> voteDataColl = new HashSet<VoteData>();
        Iterator iter = pollContent.getSummaryVotes().iterator();
        while (iter.hasNext()) {
            VoteLocal vote = (VoteLocal)iter.next();
            if (!vote.isSummaryVote()) continue;
            voteDataColl.add(vote.getData());
        }
        dataHolder.setResults(voteDataColl, true);
        return dataHolder;
    }

    public static PollContentNominationResultsData createDummyResults(long taskInstanceId) {
        PollContentNominationResultsData data = new PollContentNominationResultsData();
        PollContentData pollInfo = new PollContentData(0, taskInstanceId, "Data Missing", "Data Missing", "Data Missing", new Boolean(false), 0, "", false, PollContentBean.COMPLETE, null, false, 0, 0);
        data.setPollInfo(pollInfo);
        data.setNominees(new HashSet());
        data.setResults(new HashSet(), false);
        return data;
    }

    public static AllVoteData getAllIndividualResultsData(PollContentLocal pollContent, HashMap cachedLSessionUser) {
        VoteLocal vote;
        if (pollContent == null) {
            return null;
        }
        AllVoteData data = new AllVoteData();
        HashMap userCache = new HashMap();
        data.setPollInfo(pollContent.getData());
        TreeMap<String, NominationVoteData> nominationColl = new TreeMap<String, NominationVoteData>();
        Iterator iter = pollContent.getSummaryVotes().iterator();
        while (iter.hasNext()) {
            vote = (VoteLocal)iter.next();
            NominationVoteData nomVoteData = PollDTOFactory.getNominationData(vote);
            nominationColl.put(vote.getNormalisedNomination(), nomVoteData);
        }
        iter = pollContent.getIndividualVotes().iterator();
        while (iter.hasNext()) {
            vote = (VoteLocal)iter.next();
            String nominationNormalised = vote.getNormalisedNomination();
            NominationVoteData nomVoteData = (NominationVoteData)nominationColl.get(nominationNormalised);
            if (nomVoteData == null) {
                log.warn((Object)("getAllIndividualResultsData: individual vote found but no matching summary vote. Ignoring vote. " + vote.getData()));
                continue;
            }
            nomVoteData.getVoters().add((Object)PollDTOFactory.getUser(vote.getUserId(), userCache, cachedLSessionUser));
        }
        data.setNominees(nominationColl);
        return data;
    }

    private static NominationVoteData getNominationData(VoteLocal vote) {
        if (vote == null) {
            return null;
        }
        NominationVoteData data = new NominationVoteData();
        data.setNomination(vote.getNomination());
        data.setNominationNormalised(vote.getNormalisedNomination());
        data.setNumVotes(vote.getNumVotes());
        data.setVoters((Bag)new TreeBag());
        return data;
    }

    private static String getUser(long userId, Map userCache, HashMap cachedSessionUser) {
        Long userIdL = new Long(userId);
        String username = (String)userCache.get(userIdL);
        if (username == null) {
            try {
                UserData user;
                UserData userData = user = cachedSessionUser == null ? null : (UserData)cachedSessionUser.get(userIdL);
                if (user == null) {
                    user = UserServiceDelegate.findCompleteUser(userId);
                }
                if ((username = user.getLogin()) != null) {
                    userCache.put(userIdL, username);
                }
            }
            catch (UserNotFoundException e) {
                log.error((Object)("Fail to find user: " + userId), (Throwable)e);
            }
        }
        return username != null ? username : "User #" + userId;
    }

    public static AllVoteData createDummyAllVotes(long taskInstanceId) {
        AllVoteData data = new AllVoteData();
        PollContentData pollInfo = new PollContentData(0, taskInstanceId, "Data Missing", "Data Missing", "Data Missing", new Boolean(false), 0, "", false, PollContentBean.COMPLETE, null, false, 0, 0);
        data.setPollInfo(pollInfo);
        data.setNominees(new TreeMap());
        return data;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

