/*
 * Decompiled with CFR 0.152.
 */
package com.webmcq.ld.tool.survey.web;

import com.webmcq.ld.controller.LearningSession;
import com.webmcq.ld.tool.survey.entity.SurQuestionVO;
import com.webmcq.ld.tool.survey.entity.SurSurveyVO;
import com.webmcq.ld.util.exception.SystemException;
import java.util.Iterator;
import javax.servlet.http.HttpServletRequest;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.validator.DynaValidatorForm;

public class ReportForm
extends DynaValidatorForm {
    public void reset(ActionMapping mapping, HttpServletRequest request) {
    }

    public ActionErrors validate(ActionMapping mapping, HttpServletRequest request) {
        ActionErrors errors = new ActionErrors();
        return errors;
    }

    public void buildReportForm(HttpServletRequest request, SurSurveyVO survey, LearningSession curLession, int surveyClassSize, int numberOfLeanerCompleted) {
        if (survey == null || survey.getSurQuestions() == null) {
            throw new SystemException("The requested survey is not available in the database.");
        }
        this.set("sessionId", new Long(survey.getTaskinstanceId()));
        this.set("learningSequenceName", curLession.getTitle());
        this.set("totalLearnerNum", new Integer(surveyClassSize));
        this.set("NumOfCompletedLeaner", new Integer(numberOfLeanerCompleted));
        this.set("survey", survey);
    }

    public SurQuestionVO getQuestionFromSurvey(String questionId) {
        if (questionId == null) {
            throw new SystemException("Fail to get question identifier for question report");
        }
        SurSurveyVO survey = (SurSurveyVO)this.get("survey");
        Iterator i = survey.getSurQuestions().iterator();
        while (i.hasNext()) {
            SurQuestionVO q = (SurQuestionVO)i.next();
            if (q.getDisplayOrder() != Integer.parseInt(questionId)) continue;
            return q;
        }
        throw new SystemException("The requested question does not exist!");
    }

    public String buildXLSReport() {
        int totalLeaners = (Integer)this.get("totalLearnerNum");
        int completedLeaners = (Integer)this.get("NumOfCompletedLeaner");
        int percent = Math.round((float)completedLeaners / (float)totalLeaners * 100.0f);
        SurSurveyVO survey = (SurSurveyVO)this.get("survey");
        StringBuffer sb = new StringBuffer();
        sb.append("Sequence Name:\t" + (String)this.get("learningSequenceName") + "\n").append("Start Date:\t" + survey.getStartDate().toString() + " \n").append("Total number of students in class:\t" + totalLeaners + " \n").append("Total number of students that completed survey:\t" + completedLeaners + " (" + percent + "%)\n").append("\n\n");
        Iterator i = survey.getSurQuestions().iterator();
        while (i.hasNext()) {
            SurQuestionVO q = (SurQuestionVO)i.next();
            sb.append(q.getXLSCandidateAnswerString()).append("\n").append(q.getXLSQuestionUserString()).append("\n\n");
        }
        return sb.toString();
    }
}

