/*
 * Decompiled with CFR 0.152.
 */
package com.webmcq.ld.tool.survey;

import com.webmcq.ld.content.SurveyCandidateAnswers;
import com.webmcq.ld.content.SurveyContent;
import com.webmcq.ld.content.SurveyQuestionEntry;
import com.webmcq.ld.controller.dto.TaskInstanceData;
import com.webmcq.ld.tool.survey.entity.SurCandidateAnswerVO;
import com.webmcq.ld.tool.survey.entity.SurQuestionUsersVO;
import com.webmcq.ld.tool.survey.entity.SurQuestionVO;
import com.webmcq.ld.tool.survey.entity.SurSurveyVO;
import com.webmcq.ld.tool.survey.entity.SurUserResponseVO;
import com.webmcq.ld.util.exception.DataAccessException;
import com.webmcq.ld.util.exception.HibernateExceptionTranslater;
import com.webmcq.ld.util.persistence.BaseDAO;
import com.webmcq.ld.util.persistence.PersistenceSession;
import java.lang.reflect.InvocationTargetException;
import java.util.Date;
import java.util.Iterator;
import java.util.TreeSet;
import net.sf.hibernate.HibernateException;
import net.sf.hibernate.JDBCException;
import net.sf.hibernate.Transaction;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.log4j.Logger;

public class SurveyDAO
extends BaseDAO {
    private static Logger log = Logger.getLogger((Class)(class$com$webmcq$ld$tool$survey$SurveyDAO == null ? (class$com$webmcq$ld$tool$survey$SurveyDAO = SurveyDAO.class$("com.webmcq.ld.tool.survey.SurveyDAO")) : class$com$webmcq$ld$tool$survey$SurveyDAO));
    private HibernateExceptionTranslater translater = new HibernateExceptionTranslater();
    private static final String LOAD_SURVEY_BY_TASKINSTANCE = "from SurSurveyVO s where s.taskinstanceId = :taskInstance";
    private static final String COUNT_USER_RESPONSED = "select distinct u.userId from SurQuestionUsersVO u left join fetch u.question as ques where ques.survey = :survey group by u.userId";
    static /* synthetic */ Class class$com$webmcq$ld$tool$survey$SurveyDAO;
    static /* synthetic */ Class class$com$webmcq$ld$tool$survey$entity$SurQuestionVO;

    public SurveyDAO() {
    }

    public SurveyDAO(PersistenceSession sess) {
        super(sess);
    }

    public SurSurveyVO getSurveyByTaskInstance(long taskInstance) throws DataAccessException {
        try {
            return (SurSurveyVO)this.sess.persistece().createQuery(LOAD_SURVEY_BY_TASKINSTANCE).setLong("taskInstance", taskInstance).uniqueResult();
        }
        catch (HibernateException e) {
            log.error((Object)("Unable to load survey using task instance [" + taskInstance + "]:" + e.getMessage()));
            throw this.translater.translate("Get Survey by task instance", LOAD_SURVEY_BY_TASKINSTANCE, e);
        }
    }

    public SurQuestionVO getQuestion(long questionId) {
        return (SurQuestionVO)super.find(class$com$webmcq$ld$tool$survey$entity$SurQuestionVO == null ? (class$com$webmcq$ld$tool$survey$entity$SurQuestionVO = SurveyDAO.class$("com.webmcq.ld.tool.survey.entity.SurQuestionVO")) : class$com$webmcq$ld$tool$survey$entity$SurQuestionVO, questionId);
    }

    public int countUserResponsed(SurSurveyVO survey) throws DataAccessException {
        try {
            return this.sess.persistece().createQuery(COUNT_USER_RESPONSED).setEntity("survey", (Object)survey).list().size();
        }
        catch (HibernateException e) {
            log.error((Object)("Unable to count number of user responsed:" + e.getMessage()));
            throw this.translater.translate("count number of user responsed", COUNT_USER_RESPONSED, e);
        }
    }

    public void buildSurveyFromContent(TaskInstanceData taskInstance, SurveyContent sContent) throws DataAccessException {
        this.initializePersistenceSession(false);
        Transaction tx = this.sess.startTransaction();
        try {
            SurSurveyVO survey = this.getSurveyByTaskInstance(taskInstance.getSid());
            if (survey != null) {
                log.info((Object)("Existing survey is found: " + survey.toString()));
            } else {
                survey = new SurSurveyVO(new TreeSet());
                BeanUtils.copyProperties((Object)survey, (Object)sContent);
                survey.setInstruction(sContent.getBody());
                survey.setTaskinstanceId(taskInstance.getSid());
                survey.setStartDate(new Date(System.currentTimeMillis()));
                this.saveSurvey(survey);
                this.sess.flush();
                this.persistSurveyData(sContent, this.sess, survey);
            }
            tx.commit();
        }
        catch (IllegalAccessException e) {
            log.error((Object)"");
        }
        catch (InvocationTargetException e) {
            log.error((Object)"");
        }
        catch (HibernateException e) {
            log.error((Object)("Unable to persist survey datausing survey content value object:" + e.getMessage()));
            throw this.translater.translate("Build survey data from survey content", "Inserting survey", e);
        }
        finally {
            this.finalizeSession(false);
        }
    }

    public void saveSurvey(SurSurveyVO survey) throws HibernateException {
        this.save(survey);
    }

    public void updateSurvey(SurSurveyVO survey) throws HibernateException {
        this.update(survey);
    }

    public void saveQuestionUser(SurQuestionUsersVO qUser) throws DataAccessException {
        try {
            this.save(qUser);
        }
        catch (HibernateException e) {
            log.error((Object)("Unable to persist Question user data [" + qUser.toString() + "]" + e.getMessage()));
            throw this.translater.translate("Persist Question user data", "Inserting SurQuestionUsersVO", e);
        }
    }

    public void updateQuestionUser(SurQuestionUsersVO qUser) throws DataAccessException {
        try {
            this.update(qUser);
        }
        catch (JDBCException e) {
            throw new DataAccessException("Error in updateQuestionUser", e);
        }
    }

    public void saveUserResponse(SurUserResponseVO response) throws DataAccessException {
        try {
            this.save(response);
        }
        catch (HibernateException e) {
            log.error((Object)("Unable to persist user response data [" + response.toString() + "]" + e.getMessage()));
            throw this.translater.translate("Persist user response data", "Inserting SurUserResponseVO", e);
        }
    }

    public void removeUserResponse(SurUserResponseVO res) throws DataAccessException {
        try {
            this.sess.persistece().delete((Object)res);
        }
        catch (HibernateException e) {
            throw this.translater.translate("Delete user response data", "Deleting SurUserResponseVO", e);
        }
    }

    public void removeQuestionUser(SurQuestionUsersVO qUser) throws DataAccessException {
        try {
            this.sess.persistece().delete((Object)qUser);
        }
        catch (HibernateException e) {
            throw this.translater.translate("Delete question user", "Deleting SurQuestionUsersVO", e);
        }
    }

    private void persistSurveyData(SurveyContent sContent, PersistenceSession sess, SurSurveyVO survey) throws IllegalAccessException, InvocationTargetException {
        Iterator qIter = sContent.getSortedQuestions().iterator();
        while (qIter.hasNext()) {
            SurveyQuestionEntry qEntry = (SurveyQuestionEntry)qIter.next();
            SurQuestionVO question = new SurQuestionVO(survey, new TreeSet(), new TreeSet());
            BeanUtils.copyProperties((Object)question, (Object)qEntry);
            question.setIsOptional(qEntry.getIsOptional() ? 1 : 0);
            question.setIsTextboxEnabled(qEntry.getIsTextBoxEnabled() ? 1 : 0);
            survey.getSurQuestions().add(question);
            sess.flush();
            Iterator aIter = qEntry.getSortedAnswers().iterator();
            while (aIter.hasNext()) {
                SurveyCandidateAnswers aEntry = (SurveyCandidateAnswers)aIter.next();
                SurCandidateAnswerVO cAnswer = new SurCandidateAnswerVO();
                BeanUtils.copyProperties((Object)cAnswer, (Object)aEntry);
                question.getSurCandidateAnswers().add(cAnswer);
                cAnswer.setSurveyQuestion(question);
                sess.flush();
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

