/*
 * Decompiled with CFR 0.152.
 */
package com.webmcq.ld.tool.reportsubmission.web;

import com.webmcq.ld.service.UserNotFoundException;
import com.webmcq.ld.service.UserServiceDelegate;
import com.webmcq.ld.tool.reportsubmission.UserSummaryData;
import com.webmcq.ld.tool.reportsubmission.interfaces.LearnerReportData;
import com.webmcq.ld.tool.reportsubmission.interfaces.ReportReviewData;
import com.webmcq.ld.tool.reportsubmission.interfaces.ReportSubmissionService;
import com.webmcq.ld.tool.reportsubmission.interfaces.ReportSubmissionServiceUtil;
import com.webmcq.ld.tool.reportsubmission.interfaces.SubmissionInfoData;
import com.webmcq.ld.usermanagement.UserRole;
import com.webmcq.ld.util.CSVFile;
import com.webmcq.ld.util.DownloadFile;
import com.webmcq.ld.util.WebUtil;
import com.webmcq.ld.util.exception.SystemException;
import java.io.File;
import java.io.IOException;
import java.rmi.RemoteException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TimeZone;
import java.util.TreeMap;
import javax.ejb.CreateException;
import javax.naming.NamingException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.actions.DispatchAction;

public class ReportMarkingAction
extends DispatchAction {
    public static String JSP_TASK_INSTANCE_ID_TAG = "sessionId";
    public static String JSPINPUT_ERROR_TAG = "error";
    public static String JSPINPUT_INFO_TAG = "info";
    public static String JSPINPUT_USER_NAMES_TAG = "user_names";
    public static String JSPINPUT_SUBMITTED_FILELIST_TAG = "submittedfiles";
    public static String JSP_INPUT_TASKLIST_TAG = "task_list";
    public static String JSPOUTPUT_LEARNERID_TAG = "learnerId";
    public static String JSP_REPORTID_TAG = "reportId";
    public static String JSPINPUT_MARK_TAG = "mark";
    public static String JSPINPUT_COMMENT_TAG = "comment";
    public static String JSPOUTPUT_UPLOADED_FILE_TAG = "file";
    public static String JSPOUTPUT_FILE_DESCRIPTION_TAG = "description";
    public static String JSPINPUT_SUBMITTED_FILELIST_BY_USERID_TAG = "submittedfiles_byuserid";
    public static String JSPINPUT_DOWNLOAD_FILE_TAG = "download";
    public static String JSPOUTPUT_FINISHED = "finished";
    public static String JSPOUTPUT_FULL_MARKS_LIST = "allmarks";
    private static Logger log = Logger.getLogger((Class)(class$com$webmcq$ld$tool$reportsubmission$web$ReportMarkingAction == null ? (class$com$webmcq$ld$tool$reportsubmission$web$ReportMarkingAction = ReportMarkingAction.class$("com.webmcq.ld.tool.reportsubmission.web.ReportMarkingAction")) : class$com$webmcq$ld$tool$reportsubmission$web$ReportMarkingAction));
    static /* synthetic */ Class class$com$webmcq$ld$tool$reportsubmission$web$ReportMarkingAction;

    public ActionForward getStudentList(ActionMapping mapping, ActionForm form, HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        try {
            Integer[] taskInstanceIds = this.getMultipleTaskIds(req);
            log.debug((Object)("getStudentList: taskInstanceIds = " + taskInstanceIds.toString()));
            ActionForward errorScreen = this.checkAuthorised(req, mapping, "view the student list");
            if (errorScreen != null) {
                log.debug((Object)"Going to error screen");
                return errorScreen;
            }
            ReportSubmissionService service = ReportSubmissionServiceUtil.getHome().create();
            ArrayList tasks = new ArrayList();
            for (int i = 0; i < taskInstanceIds.length; ++i) {
                HashMap<String, Object> taskMap = new HashMap<String, Object>();
                SubmissionInfoData info = service.getInfoByTaskInstance(taskInstanceIds[i]);
                taskMap.put(JSPINPUT_INFO_TAG, info);
                Map userDataMap = service.getLearnerNameData(taskInstanceIds[i]);
                taskMap.put(JSPINPUT_USER_NAMES_TAG, userDataMap);
                tasks.add(taskMap);
            }
            req.setAttribute(JSP_INPUT_TASKLIST_TAG, tasks);
            return mapping.findForward("all_learners");
        }
        catch (CreateException e) {
            throw new SystemException(e.getMessage());
        }
        catch (NamingException e) {
            throw new SystemException(e.getMessage());
        }
        catch (Exception e) {
            log.error((Object)"General exception thrown", (Throwable)e);
            throw new SystemException(e.getMessage());
        }
    }

    public ActionForward getStudentDetail(ActionMapping mapping, ActionForm form, HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        try {
            int taskInstanceId = this.getTaskInstanceId(req);
            ReportSubmissionService service = ReportSubmissionServiceUtil.getHome().create();
            ActionForward errorScreen = this.checkAuthorised(req, mapping, "view the report list for a student");
            if (errorScreen != null) {
                return errorScreen;
            }
            int learnerId = -1;
            String error = null;
            try {
                learnerId = WebUtil.checkInteger(JSPOUTPUT_LEARNERID_TAG, req.getParameter(JSPOUTPUT_LEARNERID_TAG));
            }
            catch (IllegalArgumentException e) {
                log.error((Object)("Unable to get learner id for taskInstance: " + taskInstanceId + " " + e.getMessage()));
                error = "Learner not found";
            }
            SortedMap submittedInfo = service.getUploadedFileInfoByTaskInstanceLearner(taskInstanceId, learnerId);
            this.setLearnerPageParameters(req, taskInstanceId, new Long(learnerId), service, error, submittedInfo);
            return mapping.findForward("learner_detail");
        }
        catch (CreateException e) {
            throw new SystemException(e.getMessage());
        }
        catch (NamingException e) {
            throw new SystemException(e.getMessage());
        }
        catch (Exception e) {
            log.error((Object)"General exception thrown", (Throwable)e);
            throw new SystemException(e.getMessage());
        }
    }

    public ActionForward getFileForMark(ActionMapping mapping, ActionForm form, HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        try {
            int taskInstanceId = this.getTaskInstanceId(req);
            ReportSubmissionService service = ReportSubmissionServiceUtil.getHome().create();
            String error = null;
            ActionForward errorScreen = this.checkAuthorised(req, mapping, "retrieve file details for marking");
            if (errorScreen != null) {
                return errorScreen;
            }
            int learnerId = -1;
            try {
                learnerId = WebUtil.checkInteger(JSPOUTPUT_LEARNERID_TAG, req.getParameter(JSPOUTPUT_LEARNERID_TAG));
            }
            catch (IllegalArgumentException e) {
                log.error((Object)("Unable to get learner id for taskInstance: " + taskInstanceId + " " + e.getMessage()));
                error = "Learner not found";
            }
            int reportId = -1;
            try {
                reportId = WebUtil.checkInteger(JSP_REPORTID_TAG, req.getParameter(JSP_REPORTID_TAG));
            }
            catch (IllegalArgumentException e) {
                log.error((Object)("Unable to get report id for taskInstance: " + taskInstanceId + " " + e.getMessage()));
                error = error + " Report not found";
            }
            SortedMap submittedInfo = service.getUploadedFileInfoByReportSid(reportId);
            this.setLearnerPageParameters(req, taskInstanceId, new Long(learnerId), service, error, submittedInfo);
            return mapping.findForward("mark");
        }
        catch (CreateException e) {
            throw new SystemException(e.getMessage());
        }
        catch (NamingException e) {
            throw new SystemException(e.getMessage());
        }
        catch (Exception e) {
            log.error((Object)"General exception thrown", (Throwable)e);
            throw new SystemException(e.getMessage());
        }
    }

    public ActionForward submitMark(ActionMapping mapping, ActionForm form, HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        try {
            ActionForward errorScreen = this.checkAuthorised(req, mapping, "submit marks");
            if (errorScreen != null) {
                return errorScreen;
            }
            int taskInstanceId = this.getTaskInstanceId(req);
            ReportSubmissionService service = ReportSubmissionServiceUtil.getHome().create();
            String error = null;
            int learnerId = -1;
            try {
                learnerId = WebUtil.checkInteger(JSPOUTPUT_LEARNERID_TAG, req.getParameter(JSPOUTPUT_LEARNERID_TAG));
            }
            catch (IllegalArgumentException e) {
                log.error((Object)("Unable to get learner id for taskInstance: " + taskInstanceId + " " + e.getMessage()));
                error = "Learner not found";
            }
            int reportId = -1;
            try {
                reportId = WebUtil.checkInteger(JSP_REPORTID_TAG, req.getParameter(JSP_REPORTID_TAG));
            }
            catch (IllegalArgumentException e) {
                log.error((Object)("Unable to get report id for taskInstance: " + taskInstanceId + " " + e.getMessage()));
                error = error + " Report not found";
            }
            String username = null;
            username = WebUtil.getUsername(req);
            long userId = UserServiceDelegate.findUserId(username);
            String comment = req.getParameter(JSPINPUT_COMMENT_TAG);
            String mark = req.getParameter(JSPINPUT_MARK_TAG);
            service.markReport(taskInstanceId, reportId, userId, mark, comment, "");
            SortedMap submittedInfo = service.getUploadedFileInfoByTaskInstanceLearner(taskInstanceId, learnerId);
            this.setLearnerPageParameters(req, taskInstanceId, new Long(learnerId), service, error, submittedInfo);
            return mapping.findForward("learner_detail");
        }
        catch (CreateException e) {
            throw new SystemException(e.getMessage());
        }
        catch (NamingException e) {
            throw new SystemException(e.getMessage());
        }
        catch (Exception e) {
            log.error((Object)"General exception thrown", (Throwable)e);
            throw new SystemException(e.getMessage());
        }
    }

    public ActionForward getAllMarks(ActionMapping mapping, ActionForm form, HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        try {
            ActionForward errorScreen = this.checkAuthorised(req, mapping, "view all marks");
            if (errorScreen != null) {
                return errorScreen;
            }
            int taskInstanceId = this.getTaskInstanceId(req);
            ReportSubmissionService service = ReportSubmissionServiceUtil.getHome().create();
            String error = null;
            this.setLearnerPageParameters(req, taskInstanceId, null, service, error, null);
            SortedMap submittedInfo = service.getUploadedFileInfoByTaskInstance(taskInstanceId);
            req.setAttribute(JSPINPUT_SUBMITTED_FILELIST_BY_USERID_TAG, (Object)this.convertFileData(submittedInfo));
            return mapping.findForward("all_marks");
        }
        catch (CreateException e) {
            throw new SystemException(e.getMessage());
        }
        catch (NamingException e) {
            throw new SystemException(e.getMessage());
        }
        catch (Exception e) {
            log.error((Object)"General exception thrown", (Throwable)e);
            throw new SystemException(e.getMessage());
        }
    }

    public ActionForward getAllMarksAsCSV(ActionMapping mapping, ActionForm form, HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        try {
            ActionForward errorScreen = this.checkAuthorised(req, mapping, "download the marks file");
            if (errorScreen != null) {
                return errorScreen;
            }
            int taskInstanceId = this.getTaskInstanceId(req);
            ReportSubmissionService service = ReportSubmissionServiceUtil.getHome().create();
            SubmissionInfoData info = service.getInfoByTaskInstance(taskInstanceId);
            String username = null;
            username = WebUtil.getUsername(req);
            String error = null;
            SortedMap submittedInfo = service.getUploadedFileInfoByTaskInstance(taskInstanceId);
            Map sortedByUserId = this.convertFileData(submittedInfo);
            Map userDataMap = service.getLearnerNameData(taskInstanceId);
            File outputFile = null;
            if (userDataMap == null) {
                error = "Unable to send CSV file - the user data for learners is missing";
            } else {
                SimpleDateFormat format = new SimpleDateFormat("yyyyMMddHHmmss");
                format.setTimeZone(TimeZone.getDefault());
                String dateString = format.format(new Date());
                String dir = info.getFinalDirName();
                String filename = username + '_' + taskInstanceId + "_marks_" + dateString + ".csv";
                outputFile = new File(dir, filename);
                CSVFile writer = new CSVFile(outputFile);
                this.generateCSVData(writer, userDataMap, sortedByUserId);
                writer.close();
            }
            if (error == null) {
                req.setAttribute(JSPINPUT_INFO_TAG, (Object)info);
                req.setAttribute(JSPINPUT_DOWNLOAD_FILE_TAG, (Object)outputFile.getAbsolutePath());
                return mapping.findForward("download_marks");
            }
            req.setAttribute(JSPINPUT_ERROR_TAG, (Object)error);
            return mapping.findForward("error");
        }
        catch (CreateException e) {
            throw new SystemException(e.getMessage());
        }
        catch (NamingException e) {
            throw new SystemException(e.getMessage());
        }
        catch (IOException e) {
            log.error((Object)"IO exception thrown", (Throwable)e);
            throw new SystemException(e.getMessage());
        }
        catch (Exception e) {
            log.error((Object)"General exception thrown", (Throwable)e);
            throw new SystemException(e.getMessage());
        }
    }

    private void generateCSVData(CSVFile writer, Map userDataMap, Map sortedByUserId) throws IOException {
        UserSummaryData user;
        String[] heading = new String[]{"Username", "Firstname", "Lastname", "Filename", "Date Mark Released", "Mark", "Comment"};
        writer.write(heading);
        TreeMap<String, UserSummaryData> sortedUserDataMap = new TreeMap<String, UserSummaryData>();
        Iterator iter = userDataMap.values().iterator();
        while (iter.hasNext()) {
            user = (UserSummaryData)iter.next();
            String username = user.getLogin();
            if (username == null) {
                username = "unknown";
                log.error((Object)("generateCSVData: username missing for user " + user.toString() + " marks file may be missing learners"));
            }
            sortedUserDataMap.put(username, user);
        }
        iter = sortedUserDataMap.values().iterator();
        while (iter.hasNext()) {
            user = (UserSummaryData)iter.next();
            Long userId = new Long(user.getSid());
            String username = user.getLogin();
            String firstname = user.getFirstName();
            String lastname = user.getLastName();
            if (sortedByUserId == null) {
                String[] entry = new String[]{username, firstname, lastname, null, null, null, null};
                writer.write(entry);
                continue;
            }
            ArrayList fileArray = (ArrayList)sortedByUserId.get(userId);
            if (fileArray == null || fileArray.size() == 0) {
                String[] entry = new String[]{username, firstname, lastname, null, null, null, null};
                writer.write(entry);
                continue;
            }
            String filename = null;
            Iterator fileIterator = fileArray.iterator();
            while (fileIterator.hasNext()) {
                Object[] arr = (Object[])fileIterator.next();
                LearnerReportData report = (LearnerReportData)arr[0];
                filename = report.getFilenameNoPath();
                this.outputReviewDetails(writer, username, firstname, lastname, filename, (List)arr[1]);
            }
        }
    }

    private void outputReviewDetails(CSVFile writer, String username, String firstname, String lastname, String filename, List reviews) throws IOException {
        if (reviews.size() == 0) {
            String[] entry = new String[]{username, firstname, lastname, filename, null, null, null};
            writer.write(entry);
        } else {
            Iterator reviewIterator = reviews.iterator();
            while (reviewIterator.hasNext()) {
                ReportReviewData review = (ReportReviewData)reviewIterator.next();
                Date date = review.getDateMarkReleased();
                String dateMarkReleased = date != null ? date.toString() : null;
                String mark = this.reformatSlash(review.getMark());
                String comment = this.reformatSlash(review.getReviewersComment());
                String[] entry = new String[]{username, firstname, lastname, filename, dateMarkReleased, mark, comment};
                writer.write(entry);
            }
        }
    }

    private String reformatSlash(String inputString) {
        if (inputString == null) {
            return "";
        }
        StringBuffer newStrBuf = new StringBuffer(inputString);
        for (int pos = 0; pos < newStrBuf.length(); ++pos) {
            if (newStrBuf.charAt(pos) != '/') continue;
            if (pos + 1 >= newStrBuf.length()) {
                newStrBuf.setCharAt(pos, '\\');
                continue;
            }
            if (newStrBuf.charAt(pos + 1) != '/') {
                newStrBuf.setCharAt(pos, '\\');
                continue;
            }
            ++pos;
        }
        return newStrBuf.toString();
    }

    public ActionForward releaseMarks(ActionMapping mapping, ActionForm form, HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        try {
            ActionForward errorScreen = this.checkAuthorised(req, mapping, "release marks to students");
            if (errorScreen != null) {
                return errorScreen;
            }
            int taskInstanceId = this.getTaskInstanceId(req);
            ReportSubmissionService service = ReportSubmissionServiceUtil.getHome().create();
            String error = null;
            boolean emailsSent = service.releaseAllMarks(taskInstanceId);
            if (!emailsSent) {
                req.setAttribute(JSPINPUT_ERROR_TAG, (Object)"Marks released but couldn't send emails with marks to one or more learners");
            }
            this.setLearnerPageParameters(req, taskInstanceId, null, service, error, null);
            SortedMap submittedInfo = service.getUploadedFileInfoByTaskInstance(taskInstanceId);
            req.setAttribute(JSPINPUT_SUBMITTED_FILELIST_BY_USERID_TAG, (Object)this.convertFileData(submittedInfo));
            return mapping.findForward("all_marks");
        }
        catch (CreateException e) {
            throw new SystemException(e.getMessage());
        }
        catch (NamingException e) {
            throw new SystemException(e.getMessage());
        }
        catch (Exception e) {
            log.error((Object)"General exception thrown", (Throwable)e);
            throw new SystemException(e.getMessage());
        }
    }

    private void setLearnerPageParameters(HttpServletRequest req, int taskInstanceId, Long learnerId, ReportSubmissionService service, String error, Map submittedFiles) throws RemoteException, UserNotFoundException {
        SubmissionInfoData info = service.getInfoByTaskInstance(taskInstanceId);
        if (info != null) {
            req.setAttribute(JSPINPUT_INFO_TAG, (Object)info);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)(JSPINPUT_SUBMITTED_FILELIST_TAG + " being set to " + (submittedFiles != null ? submittedFiles.toString() : "null")));
        }
        if (submittedFiles != null) {
            req.setAttribute(JSPINPUT_SUBMITTED_FILELIST_TAG, (Object)submittedFiles);
        }
        if (error != null) {
            req.setAttribute(JSPINPUT_ERROR_TAG, (Object)error);
        }
        Map userDataMap = learnerId != null ? service.getSingleLearnerNameData(taskInstanceId, learnerId) : service.getLearnerNameData(taskInstanceId);
        if (log.isDebugEnabled()) {
            log.debug((Object)(JSPINPUT_USER_NAMES_TAG + " being set to " + (userDataMap != null ? userDataMap.toString() : "null")));
        }
        if (userDataMap != null) {
            req.setAttribute(JSPINPUT_USER_NAMES_TAG, (Object)userDataMap);
        }
    }

    private int getTaskInstanceId(HttpServletRequest req) {
        String taskInstanceIdParam = req.getParameter(JSP_TASK_INSTANCE_ID_TAG);
        int taskInstanceId = -1;
        if (taskInstanceIdParam == null || "".equals(taskInstanceIdParam)) {
            log.error((Object)"No taskInstanceId in request");
            this.dumpReqDetails(req);
            throw new NullPointerException("no taskInstanceId");
        }
        taskInstanceId = Integer.parseInt(taskInstanceIdParam);
        return taskInstanceId;
    }

    private Integer[] getMultipleTaskIds(HttpServletRequest req) {
        String[] taskInstanceIdParam = req.getParameterValues(JSP_TASK_INSTANCE_ID_TAG);
        Integer[] taskInstanceIds = new Integer[taskInstanceIdParam.length];
        for (int i = 0; i < taskInstanceIdParam.length; ++i) {
            if (taskInstanceIdParam == null || "".equals(taskInstanceIdParam)) continue;
            taskInstanceIds[i] = new Integer(taskInstanceIdParam[i]);
        }
        if (taskInstanceIdParam.length == 0) {
            log.error((Object)"No taskInstanceId in request");
            this.dumpReqDetails(req);
        }
        return taskInstanceIds;
    }

    private void dumpReqDetails(HttpServletRequest req) {
        Object name;
        Enumeration enumeration = req.getAttributeNames();
        while (enumeration.hasMoreElements()) {
            name = enumeration.nextElement();
            log.info((Object)("Attribute " + name + "=" + req.getAttribute((String)name)));
        }
        enumeration = req.getParameterNames();
        while (enumeration.hasMoreElements()) {
            name = enumeration.nextElement();
            log.info((Object)("Parameter" + name + "=" + req.getParameter((String)name)));
        }
    }

    private Map convertFileData(Map fileData) {
        if (fileData != null) {
            HashMap<Long, ArrayList<Object[]>> data = new HashMap<Long, ArrayList<Object[]>>();
            Iterator iter = fileData.values().iterator();
            while (iter.hasNext()) {
                Object[] reportarray = (Object[])iter.next();
                LearnerReportData report = (LearnerReportData)reportarray[0];
                Long learnerId = report.getSubmitterUserId();
                ArrayList<Object[]> reports = (ArrayList<Object[]>)data.get(learnerId);
                if (reports == null) {
                    reports = new ArrayList<Object[]>();
                    data.put(learnerId, reports);
                }
                reports.add(reportarray);
            }
            return data;
        }
        return null;
    }

    public ActionForward getReportFile(ActionMapping mapping, ActionForm form, HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        try {
            String downloadFilename = req.getParameter(JSPINPUT_DOWNLOAD_FILE_TAG);
            ActionForward errorScreen = this.checkAuthorised(req, mapping, "download a report file " + downloadFilename);
            if (errorScreen != null) {
                return errorScreen;
            }
            int taskInstanceId = this.getTaskInstanceId(req);
            ReportSubmissionService service = ReportSubmissionServiceUtil.getHome().create();
            SubmissionInfoData info = service.getInfoByTaskInstance(taskInstanceId);
            String error = null;
            String username = null;
            username = WebUtil.getUsername(req);
            if (downloadFilename == null) {
                error = "No filename given";
            } else {
                String dirName = info.getFinalDirName();
                log.debug((Object)("Comparing download file " + downloadFilename + " with " + dirName));
                if (!downloadFilename.startsWith(dirName)) {
                    log.error((Object)("Suspicious attempt to download a file - file not in our normal download paths: " + downloadFilename + " user " + username));
                    error = "Filename " + downloadFilename + " may not be downloaded";
                } else {
                    File file = new File(downloadFilename);
                    DownloadFile.download(res, this.getServlet().getServletContext(), file.getName(), downloadFilename, null);
                    return null;
                }
            }
            req.setAttribute(JSPINPUT_ERROR_TAG, (Object)error);
            return mapping.findForward("error");
        }
        catch (CreateException e) {
            throw new SystemException(e.getMessage());
        }
        catch (NamingException e) {
            throw new SystemException(e.getMessage());
        }
        catch (IOException e) {
            log.error((Object)"IO exception thrown", (Throwable)e);
            throw new SystemException(e.getMessage());
        }
        catch (Exception e) {
            log.error((Object)"General exception thrown", (Throwable)e);
            throw new SystemException(e.getMessage());
        }
    }

    private ActionForward checkAuthorised(HttpServletRequest req, ActionMapping mapping, String actionDescription) throws Exception {
        boolean isStaff = req.isUserInRole(UserRole.STAFF.getName());
        log.debug((Object)("Is staff? " + isStaff));
        if (!isStaff) {
            String error = "You are not authorised to " + actionDescription + ". You must be a staff member.";
            log.error((Object)("Suspicious attempt to " + actionDescription + " - user not entitled to so. User " + WebUtil.getUsername(req)));
            req.setAttribute(JSPINPUT_ERROR_TAG, (Object)error);
            return mapping.findForward("error");
        }
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

