/*
 * Decompiled with CFR 0.152.
 */
package com.webmcq.ld.tool.nb.web;

import com.webmcq.ld.controller.ControllerException;
import com.webmcq.ld.controller.DisplayTaskData;
import com.webmcq.ld.controller.web.ToolAction;
import com.webmcq.ld.service.UserServiceDelegate;
import com.webmcq.ld.tool.StaffMonitorNotifier;
import com.webmcq.ld.tool.nb.NBException;
import com.webmcq.ld.tool.nb.interfaces.NBEntryData;
import com.webmcq.ld.tool.nb.interfaces.NBSectionData;
import com.webmcq.ld.tool.nb.interfaces.NBService;
import com.webmcq.ld.tool.nb.interfaces.NBServiceUtil;
import com.webmcq.ld.usermanagement.UserRole;
import com.webmcq.ld.util.WebUtil;
import com.webmcq.ld.util.exception.SystemException;
import java.io.IOException;
import javax.ejb.CreateException;
import javax.naming.NamingException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class NoticeBoardAction
extends ToolAction {
    private static Logger log = Logger.getLogger((Class)(class$com$webmcq$ld$tool$nb$web$NoticeBoardAction == null ? (class$com$webmcq$ld$tool$nb$web$NoticeBoardAction = NoticeBoardAction.class$("com.webmcq.ld.tool.nb.web.NoticeBoardAction")) : class$com$webmcq$ld$tool$nb$web$NoticeBoardAction));
    public static final String TOOL_TYPE = "nb";
    public static final String MODIFY_MODE_TAG = "modify";
    public static final String VIEW_ONLY_MODE_TAG = "viewOnly";
    public static final String PREVIEW_CHECKUP = "previewCheckup";
    public static final String NEW_ENTRY_CONTENT_TAG = "newEntryContent";
    public static final String NEW_ENTRY_TITLE_TAG = "newEntryTitle";
    public static final String ENTRY_ID_TAG = "entryId";
    public static final String SESSION_TAG = "session";
    static /* synthetic */ Class class$com$webmcq$ld$tool$nb$web$NoticeBoardAction;

    public ActionForward getSection(ActionMapping mapping, ActionForm form, HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        try {
            log.debug((Object)"getSection");
            int sessionId = WebUtil.readIntParam(req, "sessionId");
            String mode = WebUtil.readStrParam(req, "mode");
            log.debug((Object)("\tmode: " + mode));
            String sessionType = (String)req.getSession().getAttribute(SESSION_TAG);
            if (mode.equals("view") && sessionType != null && sessionType.equals("preview")) {
                req.setAttribute(PREVIEW_CHECKUP, (Object)PREVIEW_CHECKUP);
            }
            if ("view".equals(mode)) {
                req.setAttribute(VIEW_ONLY_MODE_TAG, (Object)mode);
            } else if ("checkup".equals(mode)) {
                req.setAttribute(VIEW_ONLY_MODE_TAG, (Object)mode);
            }
            NBService service = NBServiceUtil.getHome().create();
            NBSectionData section = service.getSectionBySession(sessionId);
            service.refresh(section.getSid());
            NBEntryData[] entries = service.getEntries(section.getSid());
            if (log.isDebugEnabled()) {
                String text = null;
                for (int i = 0; i < entries.length; ++i) {
                    text = entries[i].getTitle();
                    log.debug((Object)(i + " title: " + text + "\n"));
                    text = entries[i].getContent();
                    log.debug((Object)(i + " content: " + text + "\n"));
                }
            }
            for (int indexEntry = 0; indexEntry < entries.length; ++indexEntry) {
                Boolean defineLater = entries[indexEntry].getDefineLater();
                if (defineLater == null || !defineLater.booleanValue()) continue;
                req.setAttribute(MODIFY_MODE_TAG, (Object)"todefinelater");
                req.setAttribute(VIEW_ONLY_MODE_TAG, (Object)"view");
                break;
            }
            req.setAttribute("section", (Object)section);
            req.setAttribute("entries", (Object)entries);
            req.setAttribute(SESSION_TAG, (Object)sessionType);
            WebUtil.saveToken(req, "transactionKeyNoticeBoard", this.generateToken(req));
            return mapping.findForward("section");
        }
        catch (CreateException e) {
            throw new SystemException(e.getMessage());
        }
        catch (NamingException e) {
            throw new SystemException(e.getMessage());
        }
    }

    public ActionForward completeSession(ActionMapping mapping, ActionForm form, HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        try {
            if (WebUtil.isTokenValid(req, "transactionKeyNoticeBoard")) {
                WebUtil.resetToken(req, "transactionKeyNoticeBoard");
                req.getSession().removeAttribute("transactionDoneNoticeBoard");
                log.debug((Object)"completeSession");
                String username = WebUtil.getUsername(req);
                long userId = UserServiceDelegate.findUserId(username);
                int sessionId = WebUtil.readIntParam(req, "sessionId");
                NBService service = NBServiceUtil.getHome().create();
                DisplayTaskData displayTaskData = service.completeSession(userId, sessionId);
                NBSectionData section = service.getSectionBySession(sessionId);
                this.notifyNoticeBoard(sessionId, section.getTitle());
                ActionForward action = this.displayTask(displayTaskData, mapping, form, req, res);
                req.getSession().setAttribute("transactionDoneNoticeBoard", (Object)action);
                return action;
            }
            return this.duplicateSubmission(mapping, req, "transactionDoneNoticeBoard");
        }
        catch (CreateException e) {
            throw new SystemException(e.getMessage());
        }
        catch (NamingException e) {
            throw new SystemException(e.getMessage());
        }
        catch (NBException e) {
            throw new SystemException(e.getMessage());
        }
        catch (SystemException e) {
            return mapping.findForward("error");
        }
        catch (Exception e) {
            throw new SystemException(e.getMessage());
        }
    }

    public ActionForward insertEntryNoticeBoard(ActionMapping mapping, ActionForm form, HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        try {
            log.debug((Object)"insertEntryNoticeBoard");
            int sessionId = WebUtil.readIntParam(req, "sessionId");
            String newTitle = req.getParameter(NEW_ENTRY_TITLE_TAG);
            String newContent = req.getParameter(NEW_ENTRY_CONTENT_TAG);
            NBService service = NBServiceUtil.getHome().create();
            NBSectionData section = service.getSectionBySession(sessionId);
            service.insertEntry(section.getSid(), newTitle, newContent);
            service.refresh(section.getSid());
            NBEntryData[] entries = service.getEntries(section.getSid());
            req.setAttribute("section", (Object)section);
            req.setAttribute("entries", (Object)entries);
            req.setAttribute(VIEW_ONLY_MODE_TAG, (Object)"view");
            return mapping.findForward("section");
        }
        catch (CreateException e) {
            throw new SystemException(e.getMessage());
        }
        catch (NBException e) {
            throw new SystemException(e.getMessage());
        }
        catch (NamingException e) {
            throw new SystemException(e.getMessage());
        }
    }

    public ActionForward updateEntryNoticeBoard(ActionMapping mapping, ActionForm form, HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        try {
            log.debug((Object)"updateEntryNoticeBoard");
            String newTitle = req.getParameter(NEW_ENTRY_TITLE_TAG);
            String newContent = req.getParameter(NEW_ENTRY_CONTENT_TAG);
            int entryId = WebUtil.readIntParam(req, ENTRY_ID_TAG);
            NBService service = NBServiceUtil.getHome().create();
            service.updateEntry(entryId, newTitle, newContent);
            return this.getMonitorNoticeBoard(mapping, form, req, res);
        }
        catch (CreateException e) {
            throw new SystemException(e.getMessage());
        }
        catch (NBException e) {
            throw new SystemException(e.getMessage());
        }
        catch (NamingException e) {
            throw new SystemException(e.getMessage());
        }
    }

    public ActionForward getMonitorNoticeBoard(ActionMapping mapping, ActionForm form, HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        try {
            log.debug((Object)"getMonitorNoticeBoard");
            int sessionId = WebUtil.readIntParam(req, "sessionId");
            req.setAttribute(VIEW_ONLY_MODE_TAG, (Object)"view");
            NBService service = NBServiceUtil.getHome().create();
            NBSectionData section = service.getSectionBySession(sessionId);
            service.refresh(section.getSid());
            NBEntryData[] entries = service.getEntries(section.getSid());
            if (req.isUserInRole(UserRole.STAFF.getName())) {
                for (int indexEntry = 0; indexEntry < entries.length; ++indexEntry) {
                    Boolean defineLater = entries[indexEntry].getDefineLater();
                    if (defineLater == null || !defineLater.booleanValue()) continue;
                    req.setAttribute("entrytoupdate", (Object)entries[indexEntry]);
                    req.setAttribute(MODIFY_MODE_TAG, (Object)"todefine");
                    break;
                }
            }
            req.setAttribute("section", (Object)section);
            req.setAttribute("entries", (Object)entries);
            return mapping.findForward("section");
        }
        catch (CreateException e) {
            throw new SystemException(e.getMessage());
        }
        catch (NamingException e) {
            throw new SystemException(e.getMessage());
        }
    }

    private void notifyNoticeBoard(long taskInstanceId, String title) throws NBException {
        try {
            String toolpath = "tool/nb/nb.do?method=getMonitorNoticeBoard&sessionId=" + taskInstanceId;
            StaffMonitorNotifier.notifyControllerOfURL(taskInstanceId, TOOL_TYPE, title, toolpath);
        }
        catch (ControllerException e) {
            throw new NBException(e);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

