/*
 * Decompiled with CFR 0.152.
 */
package com.webmcq.ld.tool.mb;

import com.webmcq.ld.activities.AbstractTaskVO;
import com.webmcq.ld.controller.DisplayTaskData;
import com.webmcq.ld.controller.dto.GroupData;
import com.webmcq.ld.controller.dto.TaskInstanceData;
import com.webmcq.ld.tool.ToolException;
import com.webmcq.ld.tool.mb.MBException;
import com.webmcq.ld.tool.mb.MBForumVO;
import com.webmcq.ld.tool.mb.MBMessageVO;
import com.webmcq.ld.tool.mb.MBThreadVO;
import com.webmcq.ld.util.exception.SystemException;
import com.webmcq.ld.util.persistence.BaseDAO;
import com.webmcq.ld.util.persistence.PersistenceSession;
import java.util.List;
import net.sf.hibernate.HibernateException;
import net.sf.hibernate.Query;
import net.sf.hibernate.Session;
import net.sf.hibernate.Transaction;

public class MBServiceDAO
extends BaseDAO {
    public MBServiceDAO() {
    }

    public MBServiceDAO(PersistenceSession sess) {
        super(sess);
    }

    public void disconnect() throws HibernateException {
        this.sess.persistece().disconnect();
    }

    public void close() throws HibernateException {
        this.sess.persistece().close();
    }

    public void createSession(AbstractTaskVO task, TaskInstanceData taskInstance, GroupData group, String outputContentDestination, Long inputContentId, Long outputContentId) throws ToolException, SystemException {
    }

    public DisplayTaskData completeSession(long userId, long sessionId) throws MBException {
        return null;
    }

    public MBThreadVO getThread(long forumId, long threadId) throws HibernateException {
        Session s = this.sess.persistece();
        Query query = s.createQuery("from mb2_thread in class com.webmcq.ld.tool.mb.MBThreadVO where mb2_thread.forumId = ? and mb2_thread.sid = ?");
        query.setLong(0, forumId);
        query.setLong(1, threadId);
        List results = query.list();
        if (results != null && results.size() == 1) {
            MBThreadVO thread = (MBThreadVO)results.get(0);
            return thread;
        }
        if (results != null && results.size() > 1) {
            throw new HibernateException("multiple results returned. expected one or none");
        }
        return null;
    }

    public MBMessageVO getMessage(long threadId, long messageId) throws HibernateException {
        Session s = this.sess.persistece();
        Query query = s.createQuery("from mb2_thread in class com.webmcq.ld.tool.mb.MBMessageVO where mb2_thread.threadId = ? and mb2_thread.sid = ?");
        query.setLong(0, threadId);
        query.setLong(1, messageId);
        List results = query.list();
        if (results != null && results.size() == 1) {
            MBMessageVO message = (MBMessageVO)results.get(0);
            return message;
        }
        if (results != null && results.size() > 1) {
            throw new HibernateException("multiple results returned. expected one or none");
        }
        return null;
    }

    public MBForumVO getForumData(long sessionId) throws HibernateException {
        Session s = this.sess.persistece();
        Query query = s.createQuery("from mb2_forum in class com.webmcq.ld.tool.mb.MBForumVO where mb2_forum.sessionId = ?");
        query.setLong(0, sessionId);
        List results = query.list();
        if (results != null && results.size() == 1) {
            MBForumVO forum = (MBForumVO)results.get(0);
            return forum;
        }
        if (results != null && results.size() > 1) {
            throw new HibernateException("multiple results returned. expected one or none");
        }
        return null;
    }

    public List getForums(long sessionId) throws HibernateException {
        Session s = this.sess.persistece();
        Query query = s.createQuery("from mb2_forum in class com.webmcq.ld.tool.mb.MBForumVO where mb2_forum.sessionId = ?");
        query.setLong(0, sessionId);
        return query.list();
    }

    public List listAllForums() throws HibernateException {
        Session s = this.sess.persistece();
        List list = s.find("from mb2_forum in class com.webmcq.ld.tool.mb.MBForumVO");
        return list;
    }

    public void addThread(MBThreadVO thread) throws HibernateException {
        this.save(thread);
    }

    public void updateThread(MBThreadVO thread) throws HibernateException {
        this.saveOrUpdate(thread);
    }

    public void addMessage(MBMessageVO message) throws HibernateException {
        this.save(message);
    }

    public void addForum(MBForumVO forum) throws HibernateException {
        this.save(forum);
    }

    public void save(Object object) throws HibernateException {
        Session s = this.sess.persistece();
        Transaction tx = s.beginTransaction();
        try {
            s.save(object);
            s.flush();
            tx.commit();
        }
        catch (HibernateException e) {
            tx.rollback();
            throw e;
        }
    }

    public void saveOrUpdate(Object object) throws HibernateException {
        Session s = this.sess.persistece();
        Transaction tx = s.beginTransaction();
        try {
            s.saveOrUpdate(object);
            s.flush();
            tx.commit();
        }
        catch (HibernateException e) {
            tx.rollback();
            throw e;
        }
    }
}

