/*
 * Decompiled with CFR 0.152.
 */
package com.webmcq.ld.tool.chat.flashserver;

import com.webmcq.ld.tool.chat.flashserver.ChatDaemonThread;
import com.webmcq.ld.tool.chat.flashserver.ChatRoom;
import com.webmcq.ld.tool.chat.flashserver.ChatUser;
import com.webmcq.ld.tool.chat.flashserver.FlashPacket;
import com.webmcq.ld.tool.chat.flashserver.GroupMember;
import com.webmcq.ld.tool.chat.flashserver.RequestHandler;
import com.webmcq.ld.util.WDDXProcessor;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.log4j.Logger;

public class EnterRequestHandler
extends RequestHandler {
    protected static final Logger log = Logger.getLogger((Class)(class$com$webmcq$ld$tool$chat$flashserver$EnterRequestHandler == null ? (class$com$webmcq$ld$tool$chat$flashserver$EnterRequestHandler = EnterRequestHandler.class$("com.webmcq.ld.tool.chat.flashserver.EnterRequestHandler")) : class$com$webmcq$ld$tool$chat$flashserver$EnterRequestHandler));
    static /* synthetic */ Class class$com$webmcq$ld$tool$chat$flashserver$EnterRequestHandler;

    public EnterRequestHandler(ChatDaemonThread server) {
        super(server);
    }

    public FlashPacket process(FlashPacket packet, SelectionKey key, SocketChannel socket) {
        log.debug((Object)"it is EnterRequest");
        String chatgroup = packet.getChatroom();
        String roomIdString = packet.getChatroomId();
        String nickname = packet.getFrom();
        String memberIdString = packet.getMemberId();
        long chatRoomId = -1L;
        long memberId = -1L;
        GroupMember member = null;
        ChatRoom chatRoom = null;
        FlashPacket response = null;
        ChatUser user = (ChatUser)key.attachment();
        member = user.findMembership(chatgroup);
        if (member == null) {
            log.error((Object)"  membership not found");
            response = this.mebershipNotFoundError(packet, chatgroup);
            log.error((Object)("  response=" + response));
            return response;
        }
        log.debug((Object)"got the member object");
        chatRoom = member.getChatRoom();
        if (chatRoom == null) {
            log.error((Object)"  chatroom not attached");
            response = this.roomNotFoundError(packet, chatgroup);
            log.error((Object)("  response=" + response));
            return response;
        }
        log.debug((Object)"got the room object");
        log.debug((Object)" --- members Hashmap ---");
        log.debug((Object)chatRoom.getRoomName());
        log.debug((Object)("" + chatRoom.getRoomId()));
        Map members = chatRoom.getMembers();
        Set keySet = members.keySet();
        Iterator i = keySet.iterator();
        while (i.hasNext()) {
            String name = (String)i.next();
            log.debug((Object)(" ***** " + name));
        }
        log.debug((Object)" --- members Hashmap ---");
        member.setPresence("chat");
        log.debug((Object)"sending ENTER_RESPONSE (SUCCESS)");
        chatRoomId = chatRoom.getRoomId();
        this.sendEnterSuccess(packet, chatRoomId, chatgroup, key, socket);
        chatRoom.announceNewMember(member);
        chatRoom.sendMemberRoster(member, key, socket);
        this.sendAllChatRoomMessages(chatRoom, key, socket);
        response = this.enterComplete(packet, chatRoomId, chatgroup);
        log.debug((Object)"ENTER_REQUEST completed");
        return response;
    }

    private void sendAllChatRoomMessages(ChatRoom chatRoom, SelectionKey key, SocketChannel socket) {
        LinkedList messages = chatRoom.getAllChatRoomMessages();
        for (int i = 0; i < messages.size(); ++i) {
            FlashPacket packet = (FlashPacket)messages.get(i);
            try {
                RequestHandler.writeResponse(WDDXProcessor.serialize(packet), key, socket);
                continue;
            }
            catch (IOException e) {
                log.error((Object)e);
            }
        }
    }

    protected FlashPacket mebershipNotFoundError(FlashPacket packet, String chatgroup) {
        FlashPacket response = new FlashPacket();
        try {
            BeanUtils.copyProperties((Object)response, (Object)packet);
        }
        catch (IllegalAccessException ie) {
            log.error((Object)ie);
        }
        catch (InvocationTargetException ie) {
            log.error((Object)ie);
        }
        response.setType("ENTER_RESPONSE");
        String to = packet.getFrom();
        response.setTo(to);
        response.setFrom(this.hostName);
        response.setStatus("ERROR");
        response.setStatusCode("501");
        response.setBodyText("membership record not found");
        return response;
    }

    protected FlashPacket roomNotFoundError(FlashPacket packet, String chatgroup) {
        FlashPacket response = new FlashPacket();
        try {
            BeanUtils.copyProperties((Object)response, (Object)packet);
        }
        catch (IllegalAccessException ie) {
            log.error((Object)ie);
        }
        catch (InvocationTargetException ie) {
            log.error((Object)ie);
        }
        response.setType("ENTER_RESPONSE");
        String to = packet.getFrom();
        response.setTo(to);
        response.setFrom(this.hostName);
        response.setStatus("ERROR");
        response.setStatusCode("502");
        response.setBodyText("membership has no room attatched: " + chatgroup);
        return response;
    }

    protected FlashPacket enterComplete(FlashPacket packet, long chatRoomId, String chatgroup) {
        FlashPacket response = new FlashPacket();
        try {
            BeanUtils.copyProperties((Object)response, (Object)packet);
        }
        catch (IllegalAccessException ie) {
            log.error((Object)ie);
        }
        catch (InvocationTargetException ie) {
            log.error((Object)ie);
        }
        response.setType("ENTER_COMPLETE");
        String to = packet.getFrom();
        response.setTo(to);
        response.setFrom(this.hostName);
        response.setStatus("SUCCESS");
        response.setStatusCode("200");
        String chatRoomIdString = String.valueOf(chatRoomId);
        response.setChatroomId(chatRoomIdString);
        return response;
    }

    protected void sendEnterSuccess(FlashPacket packet, long chatRoomId, String chatgroup, SelectionKey key, SocketChannel socket) {
        FlashPacket response = new FlashPacket();
        try {
            BeanUtils.copyProperties((Object)response, (Object)packet);
        }
        catch (IllegalAccessException ie) {
            log.error((Object)ie);
        }
        catch (InvocationTargetException ie) {
            log.error((Object)ie);
        }
        response.setType("ENTER_RESPONSE");
        String to = packet.getFrom();
        response.setTo(to);
        response.setFrom(this.hostName);
        response.setStatus("SUCCESS");
        response.setStatusCode("200");
        String chatRoomIdString = String.valueOf(chatRoomId);
        response.setChatroomId(chatRoomIdString);
        String xmlString = null;
        try {
            xmlString = WDDXProcessor.serialize(response);
            log.debug((Object)("serialized = " + xmlString));
            RequestHandler.writeResponse(xmlString, key, socket);
        }
        catch (IOException e) {
            log.error((Object)e);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

