/*
 * Decompiled with CFR 0.152.
 */
package com.webmcq.ld.tool.chat.flashserver;

import com.allaire.wddx.WddxDeserializationException;
import com.webmcq.ld.tool.chat.flashserver.ChatRoomRegistry;
import com.webmcq.ld.tool.chat.flashserver.ChatUser;
import com.webmcq.ld.tool.chat.flashserver.EnterRequestHandler;
import com.webmcq.ld.tool.chat.flashserver.FlashPacket;
import com.webmcq.ld.tool.chat.flashserver.GroupMessageHandler;
import com.webmcq.ld.tool.chat.flashserver.JoinRequestHandler;
import com.webmcq.ld.tool.chat.flashserver.LeaveRequestHandler;
import com.webmcq.ld.tool.chat.flashserver.LoginRequestHandler;
import com.webmcq.ld.tool.chat.flashserver.LogoffRequestHandler;
import com.webmcq.ld.tool.chat.flashserver.RequestHandler;
import com.webmcq.ld.tool.chat.flashserver.ServerShell;
import com.webmcq.ld.tool.chat.flashserver.UserRegistry;
import com.webmcq.ld.tool.chat.servlet.ChatArchive;
import com.webmcq.ld.util.WDDXProcessor;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class ChatDaemonThread
extends Thread {
    protected static final Logger log = Logger.getLogger((Class)(class$com$webmcq$ld$tool$chat$flashserver$ChatDaemonThread == null ? (class$com$webmcq$ld$tool$chat$flashserver$ChatDaemonThread = ChatDaemonThread.class$("com.webmcq.ld.tool.chat.flashserver.ChatDaemonThread")) : class$com$webmcq$ld$tool$chat$flashserver$ChatDaemonThread));
    public static final byte EOL_MARK = 0;
    public static final byte[] eolBytes = new byte[]{0};
    private static final int DEFAULT_PORT = 9800;
    private static final int UNSIGNED_INT16_MAX_VALUE = 65535;
    private int port = 9800;
    private ServerSocket serverSocket = null;
    private boolean isListening = false;
    private boolean isInterrupted = false;
    private UserRegistry userRegistry = null;
    private ChatRoomRegistry chatRoomRegistry = null;
    private ServerShell serverShell = null;
    private String hostName = null;
    private Map connections = new HashMap();
    private Object connectionsLock = new Object();
    private Selector sel = null;
    private ServerSocketChannel server = null;
    private SocketChannel socket = null;
    private LoginRequestHandler loginHandler = null;
    private JoinRequestHandler joinHandler = null;
    private EnterRequestHandler enterHandler = null;
    private GroupMessageHandler groupMessageHandler = null;
    private LeaveRequestHandler leaveHandler = null;
    private LogoffRequestHandler logoffHandler = null;
    static /* synthetic */ Class class$com$webmcq$ld$tool$chat$flashserver$ChatDaemonThread;

    public ChatDaemonThread(ServerShell serverShell, String hostName, int port) throws IOException {
        super("ChatDaemonThread");
        this.serverShell = serverShell;
        this.hostName = hostName != null && !hostName.equals("") ? hostName : InetAddress.getLocalHost().getHostAddress();
        log.debug((Object)("setting port: " + port));
        if (port < 1240 || port > 65535) {
            log.error((Object)("bad port number: " + port));
            port = 9800;
            log.error((Object)("using default port: " + port));
        }
        this.port = port;
        this.userRegistry = new UserRegistry(this);
        this.chatRoomRegistry = new ChatRoomRegistry();
        this.loginHandler = new LoginRequestHandler(this);
        this.joinHandler = new JoinRequestHandler(this);
        this.enterHandler = new EnterRequestHandler(this);
        this.groupMessageHandler = new GroupMessageHandler(this);
        this.leaveHandler = new LeaveRequestHandler(this);
        this.logoffHandler = new LogoffRequestHandler(this);
        this.initializeOperations();
    }

    private void initializeOperations() throws IOException {
        try {
            this.sel = Selector.open();
            this.server = ServerSocketChannel.open();
            this.server.configureBlocking(false);
            InetAddress ia = InetAddress.getByName(this.hostName);
            InetSocketAddress isa = new InetSocketAddress(this.port);
            this.server.socket().bind(isa);
            log.debug((Object)("bound non-blocking socket: " + this.hostName + ":" + this.port));
        }
        catch (IOException ioe) {
            log.error((Object)"java.io.IOException", (Throwable)ioe);
            throw ioe;
        }
    }

    public void run() {
        this.isListening = true;
        SelectionKey acceptKey = null;
        try {
            acceptKey = this.server.register(this.sel, 16);
            log.debug((Object)"About to block on select()");
            try {
                boolean shutdown = false;
                while (acceptKey.selector().select() > 0 && !shutdown) {
                    try {
                        String message;
                        Set<SelectionKey> readyKeys = this.sel.selectedKeys();
                        Iterator<SelectionKey> it = readyKeys.iterator();
                        while (it.hasNext()) {
                            SelectionKey key = it.next();
                            it.remove();
                            if (key.isValid() && key.isAcceptable()) {
                                ServerSocketChannel ssc = (ServerSocketChannel)key.channel();
                                this.socket = ssc.accept();
                                this.socket.configureBlocking(false);
                                SelectionKey another = this.socket.register(this.sel, 5);
                            }
                            if (key.isValid() && key.isReadable()) {
                                message = this.processMessage(this.readFromChannel(key), key);
                                if (message != null && !message.equals("")) {
                                    log.debug((Object)message);
                                    RequestHandler.writeResponse(message, key, (SocketChannel)key.channel());
                                }
                                this.processQueuedMessages(key);
                                continue;
                            }
                            if (!key.isValid() || !key.isWritable()) continue;
                            this.processQueuedMessages(key);
                        }
                        if (!this.isListening) {
                            log.info((Object)"chat server shutdown process starts");
                            if (acceptKey.selector().select() > 0) {
                                readyKeys = this.sel.selectedKeys();
                                it = readyKeys.iterator();
                                FlashPacket packet = new FlashPacket();
                                packet.setType("SERVER_SHUTDOWN");
                                packet.setFrom(this.hostName);
                                packet.setBodyText("Chat server is shutting down. You have to reconnect when the service resumes.");
                                message = WDDXProcessor.serialize(packet);
                                while (it.hasNext()) {
                                    SelectionKey key = it.next();
                                    it.remove();
                                    if (!key.isValid() || !key.isReadable() && !key.isWritable()) continue;
                                    RequestHandler.writeResponse(message, key, this.socket);
                                }
                            }
                            shutdown = true;
                            log.info((Object)"chat server shutdown process complete");
                        }
                        try {
                            Thread.sleep(300L);
                        }
                        catch (Exception e) {
                        }
                    }
                    catch (IOException ioe) {
                        log.error((Object)"java.io.IOException", (Throwable)ioe);
                        this.socket.close();
                    }
                }
                log.debug((Object)"main non-blocking loop has ended");
            }
            catch (IOException ioe) {
                log.error((Object)"java.io.IOException", (Throwable)ioe);
            }
        }
        catch (ClosedChannelException cce) {
            cce.getStackTrace();
        }
        log.debug((Object)"leaving run()");
    }

    private void processQueuedMessages(SelectionKey key) {
        ChatUser chatUser = (ChatUser)key.attachment();
        if (chatUser != null && chatUser.isMessages()) {
            LinkedList messages = chatUser.getMessagesToSend();
            for (int i = 0; i < messages.size(); ++i) {
                String message = (String)messages.get(i);
                if (message == null) continue;
                try {
                    RequestHandler.writeResponse(message, key, (SocketChannel)key.channel());
                    continue;
                }
                catch (IOException ioe) {
                    log.error((Object)"java.io.IOException", (Throwable)ioe);
                }
            }
            chatUser.clearMessagesToSend();
        }
    }

    private String processMessage(String message, SelectionKey key) {
        if (message != null && !message.equals("")) {
            log.debug((Object)("got an XML Packet: " + message));
            FlashPacket packet = null;
            try {
                Object obj = WDDXProcessor.deserialize(message);
                if (obj != null) {
                    log.debug((Object)("deserialized: " + obj));
                    packet = new FlashPacket();
                    Hashtable table = null;
                    if (obj instanceof Hashtable) {
                        table = (Hashtable)obj;
                        packet.fillFromHashtable(table);
                    } else if (obj instanceof FlashPacket) {
                        packet = (FlashPacket)obj;
                    }
                    String type = packet.getType();
                    log.debug((Object)("Packet type:" + type));
                    FlashPacket response = null;
                    if (type.equals("LOGIN_REQUEST")) {
                        response = this.loginHandler.process(packet, key, this.socket);
                    } else if (type.equals("JOIN_REQUEST")) {
                        response = this.joinHandler.process(packet, key, this.socket);
                    } else if (type.equals("ENTER_REQUEST")) {
                        response = this.enterHandler.process(packet, key, this.socket);
                    } else if (type.equals("GROUP_MESSAGE")) {
                        response = this.groupMessageHandler.process(packet, key, this.socket);
                    } else if (type.equals("LEAVE_REQUEST")) {
                        response = this.leaveHandler.process(packet, key, this.socket);
                    } else if (type.equals("LOGOFF_REQUEST")) {
                        response = this.logoffHandler.process(packet, key, this.socket);
                    } else {
                        log.error((Object)("Unknown FlashPacket type: " + type));
                    }
                    log.debug((Object)("response = " + response));
                    if (response != null) {
                        return WDDXProcessor.serialize(response);
                    }
                    log.info((Object)"response = null (is this really an error?)");
                    return null;
                }
                log.error((Object)"falied to convert it to a packet");
                return null;
            }
            catch (WddxDeserializationException e) {
                log.error((Object)("WddxDeserializationException: " + (Object)((Object)e)));
                return null;
            }
            catch (IOException ioe) {
                log.error((Object)("java.io.IOException: " + ioe));
                return null;
            }
        }
        log.debug((Object)"Received empty or null message on read. Could be a disconnect.");
        return null;
    }

    private String readFromChannel(SelectionKey key) {
        try {
            int nBytes = 0;
            StringBuffer result = new StringBuffer();
            this.socket = (SocketChannel)key.channel();
            ByteBuffer buf = ByteBuffer.allocate(10240);
            log.debug((Object)"About to read message");
            nBytes = this.socket.read(buf);
            if (nBytes != -1) {
                buf.flip();
                Charset charset = Charset.forName("us-ascii");
                CharsetDecoder decoder = charset.newDecoder();
                CharBuffer charBuffer = decoder.decode(buf);
                result.append(charBuffer.toString());
                while ((nBytes = this.socket.read(buf)) > 0) {
                    buf.flip();
                    charBuffer = decoder.decode(buf);
                    result.append(charBuffer.toString());
                    log.debug((Object)".");
                }
                int iEOLMark = 0;
                String sResults = null;
                iEOLMark = result.toString().indexOf(0);
                sResults = iEOLMark != -1 ? result.toString().substring(0, iEOLMark) : result.toString();
                log.debug((Object)("Read message: " + sResults));
                return sResults;
            }
            log.debug((Object)"Message was -1 bytes long off socket.read()");
            this.socket.close();
            return null;
        }
        catch (IOException ioe) {
            log.error((Object)"java.io.IOException", (Throwable)ioe);
            try {
                this.socket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return null;
        }
    }

    public void die() {
        log.info((Object)"die() method");
        this.setIsListening(false);
    }

    public void finalize() {
        this.die();
    }

    public ChatArchive getChatRoomArchive(String chatgroup) {
        ChatArchive archive = this.chatRoomRegistry.getChatRoomArchive(chatgroup);
        return archive;
    }

    public UserRegistry getUserRegistry() {
        return this.userRegistry;
    }

    public void setUserRegistry(UserRegistry userRegistry) {
        this.userRegistry = userRegistry;
    }

    public ChatRoomRegistry getChatRoomRegistry() {
        return this.chatRoomRegistry;
    }

    public String getHostName() {
        return this.hostName;
    }

    public boolean isListening() {
        return this.isListening;
    }

    public void setIsListening(boolean isListening) {
        this.isListening = isListening;
    }

    public ServerShell getServerShell() {
        return this.serverShell;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

