/*
 * Decompiled with CFR 0.152.
 */
package com.webmcq.ld.controller.web;

import com.webmcq.ld.activities.LearningDesignDefnVO;
import com.webmcq.ld.activities.dao.LearningDesignDefnDAO;
import com.webmcq.ld.controller.ControllerException;
import com.webmcq.ld.controller.LearningSession;
import com.webmcq.ld.controller.SyncTaskInstance;
import com.webmcq.ld.controller.ToolUrl;
import com.webmcq.ld.controller.dao.LearningSessionDAO;
import com.webmcq.ld.controller.dto.ActivityInstanceData;
import com.webmcq.ld.controller.dto.AllSessionData;
import com.webmcq.ld.controller.dto.ControllerDTOFactory;
import com.webmcq.ld.controller.dto.LearnerData;
import com.webmcq.ld.controller.dto.LearningSessionData;
import com.webmcq.ld.controller.dto.PersonalProgressData;
import com.webmcq.ld.controller.dto.SyncPointData;
import com.webmcq.ld.controller.dto.ToolUrlGroupData;
import com.webmcq.ld.controller.tool.interfaces.SupportToolService;
import com.webmcq.ld.controller.tool.interfaces.SupportToolServiceUtil;
import com.webmcq.ld.controller.util.WDDXUtil;
import com.webmcq.ld.service.StaffServiceDelegate;
import com.webmcq.ld.service.UserServiceDelegate;
import com.webmcq.ld.service.interfaces.LearnerService;
import com.webmcq.ld.service.interfaces.LearnerServiceUtil;
import com.webmcq.ld.service.interfaces.StaffService;
import com.webmcq.ld.service.interfaces.StaffServiceUtil;
import com.webmcq.ld.usermanagement.OrganisationCompleteData;
import com.webmcq.ld.usermanagement.interfaces.ShwaaUserData;
import com.webmcq.ld.usermanagement.interfaces.UserManagementService;
import com.webmcq.ld.usermanagement.interfaces.UserManagementServiceUtil;
import com.webmcq.ld.util.WebUtil;
import com.webmcq.ld.util.persistence.PersistenceSession;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.log4j.Logger;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.actions.DispatchAction;

public class StaffAction
extends DispatchAction {
    private static Logger log = Logger.getLogger((Class)(class$com$webmcq$ld$controller$web$StaffAction == null ? (class$com$webmcq$ld$controller$web$StaffAction = StaffAction.class$("com.webmcq.ld.controller.web.StaffAction")) : class$com$webmcq$ld$controller$web$StaffAction));
    static /* synthetic */ Class class$com$webmcq$ld$controller$web$StaffAction;

    public ActionForward getAllToolUrls(ActionMapping mapping, ActionForm form, HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        try {
            log.debug((Object)"getAllToolUrls");
            long sessionId = WebUtil.readIntParam(req, "sid");
            StaffService service = StaffServiceUtil.getHome().create();
            ToolUrl[] monitorUrls = service.getMonitorTasks(sessionId);
            service.remove();
            ToolUrlGroupData[] data = ControllerDTOFactory.buildToolUrlGroupData(monitorUrls);
            String packet = WDDXUtil.createACKMessage("getAllToolUrls", data, sessionId);
            res.getWriter().print(packet);
            return null;
        }
        catch (Exception e) {
            res.getWriter().print(WDDXUtil.createCriticalErrorMsg(e, "getAllToolUrls"));
            e.printStackTrace();
            throw new ServletException((Throwable)e);
        }
    }

    public ActionForward getSessionInfo(ActionMapping mapping, ActionForm form, HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        try {
            log.debug((Object)"getSessionInfo");
            long userId = UserServiceDelegate.findUserId(WebUtil.getUsername(req));
            long sessionId = WebUtil.readLongParam(req, "sid");
            HttpSession session = req.getSession();
            session.setAttribute("MLearningSessionID", (Object)String.valueOf(sessionId));
            LearnerService service = LearnerServiceUtil.getHome().create();
            LearningSessionData data = service.getLearningSession(userId, sessionId);
            service.remove();
            String packet = WDDXUtil.createACKMessage("getSessionInfo", data, sessionId);
            res.getWriter().print(packet);
            return null;
        }
        catch (IllegalArgumentException e) {
            res.getWriter().print(WDDXUtil.createCriticalErrorMsg(e, "getSessionInfo"));
            return null;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ServletException((Throwable)e);
        }
    }

    public ActionForward getAllSessionTitles(ActionMapping mapping, ActionForm form, HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        try {
            log.debug((Object)"getAllSessionTitles");
            long userId = UserServiceDelegate.findUserId(WebUtil.getUsername(req));
            StaffService service = StaffServiceUtil.getHome().create();
            LearningSessionData[][] sessions = service.getAllSessions(userId);
            AllSessionData data = new AllSessionData(sessions[0], sessions[1]);
            service.remove();
            String packet = WDDXUtil.createACKMessage("getAllSessionTitles", data);
            res.getWriter().print(packet);
            return null;
        }
        catch (IllegalArgumentException e) {
            res.getWriter().print(WDDXUtil.createCriticalErrorMsg(e, "getArchivedLearningSessions"));
            return null;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ServletException((Throwable)e);
        }
    }

    public ActionForward createSession(ActionMapping mapping, ActionForm form, HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        try {
            log.debug((Object)"createSession");
            String username = WebUtil.getUsername(req);
            int ldId = WebUtil.readIntParam(req, "sid");
            String title = WebUtil.readStrParam(req, "title");
            String description = WebUtil.readStrParam(req, "description", true);
            String sessionType = WebUtil.readStrParam(req, "session");
            if (sessionType == null) {
                sessionType = "normal";
            }
            long sessionId = StaffServiceDelegate.createLearningSession(username, ldId, title, description, sessionType);
            req.getSession(true).setAttribute("session", (Object)sessionType);
            String packet = WDDXUtil.createACKMessage("createSession", null, sessionId);
            res.getWriter().print(packet);
            return null;
        }
        catch (IllegalArgumentException e) {
            res.getWriter().print(WDDXUtil.createCriticalErrorMsg(e, "createSession"));
            return null;
        }
        catch (ControllerException e) {
            res.getWriter().print(WDDXUtil.createCriticalErrorMsg(e, "createSession"));
            return null;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ServletException((Throwable)e);
        }
    }

    public ActionForward startSession(ActionMapping mapping, ActionForm form, HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        try {
            log.debug((Object)"startSession");
            int sessionId = WebUtil.readIntParam(req, "sid");
            StaffServiceDelegate.start(sessionId);
            String msg = WDDXUtil.createACKMessage("startSession", sessionId);
            res.getWriter().print(msg);
            return null;
        }
        catch (IllegalArgumentException e) {
            res.getWriter().print(WDDXUtil.createCriticalErrorMsg(e, "startSession"));
            return null;
        }
        catch (ControllerException e) {
            res.getWriter().print(WDDXUtil.createErrorMsg(e, "startSession"));
            return null;
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
    }

    public ActionForward archiveSession(ActionMapping mapping, ActionForm form, HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        try {
            log.debug((Object)"archiveSession");
            long learningSessionId = WebUtil.readLongParam(req, "sid");
            StaffService service = StaffServiceUtil.getHome().create();
            service.archive(learningSessionId);
            service.remove();
            LearningSession.getInstance().removeLearningSessionUserFromCache(String.valueOf(learningSessionId));
            String packet = WDDXUtil.createACKMessage("archiveSession", learningSessionId);
            res.getWriter().print(packet);
            return null;
        }
        catch (Exception e) {
            res.getWriter().print(WDDXUtil.createCriticalErrorMsg(e, "archiveSession"));
            e.printStackTrace();
            throw new ServletException((Throwable)e);
        }
    }

    public ActionForward removeSession(ActionMapping mapping, ActionForm form, HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        try {
            log.debug((Object)"removeSession");
            long learningSessionId = WebUtil.readLongParam(req, "sid");
            String sessionType = WebUtil.readStrParam(req, "session");
            if (sessionType.equals("preview")) {
                this.removePreviewClass(learningSessionId);
            }
            StaffService service = StaffServiceUtil.getHome().create();
            service.removeLearningSession(learningSessionId);
            service.remove();
            String packet = WDDXUtil.createACKMessage("removeSession", learningSessionId);
            res.getWriter().print(packet);
            return null;
        }
        catch (Exception e) {
            log.debug((Object)e);
            return null;
        }
    }

    private void removePreviewClass(long learningSessionId) throws Exception {
        PersistenceSession sess = null;
        try {
            sess = new PersistenceSession();
            LearningSessionDAO lsDao = new LearningSessionDAO(sess);
            LearningSession lsession = lsDao.find(learningSessionId);
            long organisationId = lsession.getOrganisationId();
            UserManagementService service = UserManagementServiceUtil.getHome().create();
            service.deleteOrganisation(organisationId, false, false);
            LearningDesignDefnDAO ldDao = new LearningDesignDefnDAO(sess);
            LearningDesignDefnVO ld = ldDao.find(lsession.getLearningDesignId());
            ld.unlockDesign();
            ldDao.update(ld);
            sess.flush();
        }
        catch (Exception e) {
            log.debug((Object)("Exception occured while deleting the Preview Class:" + e.getMessage()));
            throw new Exception(e.getMessage());
        }
        finally {
            sess.close();
        }
    }

    public ActionForward getAllProgress(ActionMapping mapping, ActionForm form, HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        try {
            log.debug((Object)"getAllProgress");
            long learningSessionId = WebUtil.readIntParam(req, "sessionId");
            LearnerService service = LearnerServiceUtil.getHome().create();
            PersonalProgressData[] data = service.getAllProgress(learningSessionId);
            service.remove();
            String packet = WDDXUtil.createACKMessage("getAllProgress", data);
            res.getWriter().print(packet);
            return null;
        }
        catch (IllegalArgumentException e) {
            res.getWriter().print(WDDXUtil.createCriticalErrorMsg(e, "getAllProgress"));
            return null;
        }
        catch (ControllerException e) {
            res.getWriter().print(WDDXUtil.createCriticalErrorMsg(e, "getAllProgress"));
            return null;
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
    }

    public ActionForward getLearnerInfo(ActionMapping mapping, ActionForm form, HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        try {
            log.debug((Object)"getLearnerInfo");
            long sessionId = WebUtil.readLongParam(req, "sid");
            LearnerData[] data = StaffServiceDelegate.getAllLearners(sessionId);
            String packet = WDDXUtil.createACKMessage("getLearnerInfo", data, sessionId);
            res.getWriter().print(packet);
            return null;
        }
        catch (IllegalArgumentException e) {
            res.getWriter().print(WDDXUtil.createCriticalErrorMsg(e, "getLearnerInfo"));
            return null;
        }
        catch (ControllerException e) {
            res.getWriter().print(WDDXUtil.createCriticalErrorMsg(e, "getLearnerInfo"));
            return null;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ServletException((Throwable)e);
        }
    }

    public ActionForward setActivityLock(ActionMapping mapping, ActionForm form, HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        try {
            log.debug((Object)"setActivityLock");
            long sessionId = WebUtil.readLongParam(req, "sid");
            long activityId = WebUtil.readLongParam(req, "activityId");
            boolean lock = WebUtil.readBooleanParam(req, "lock");
            StaffServiceDelegate.setActivityInstanceLock(sessionId, activityId, lock);
            String packet = WDDXUtil.createACKMessage("setActivityLock", sessionId);
            res.getWriter().print(packet);
            return null;
        }
        catch (IllegalArgumentException e) {
            res.getWriter().print(WDDXUtil.createCriticalErrorMsg(e, "setActivityLock"));
            return null;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ServletException((Throwable)e);
        }
    }

    public ActionForward setTaskLock(ActionMapping mapping, ActionForm form, HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        try {
            long sessionId = WebUtil.readLongParam(req, "sid");
            long taskId = WebUtil.readLongParam(req, "taskId");
            boolean lock = WebUtil.readBooleanParam(req, "lock");
            log.debug((Object)("setTaskLock: sessionId=" + sessionId + ", taskId=" + taskId));
            StaffServiceDelegate.setTaskInstanceLock(sessionId, taskId, lock);
            String packet = WDDXUtil.createACKMessage("setTaskLock", sessionId);
            res.getWriter().print(packet);
            return null;
        }
        catch (IllegalArgumentException e) {
            res.getWriter().print(WDDXUtil.createCriticalErrorMsg(e, "setTaskLock"));
            return null;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ServletException((Throwable)e);
        }
    }

    public ActionForward getAllSyncInfo(ActionMapping mapping, ActionForm form, HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        try {
            log.debug((Object)"getAllSyncInfo");
            long sessionId = WebUtil.readLongParam(req, "sid");
            SyncPointData[] data = StaffServiceDelegate.getAllSyncPoints(sessionId);
            String packet = WDDXUtil.createACKMessage("getAllSyncInfo", data, sessionId);
            res.getWriter().print(packet);
            return null;
        }
        catch (IllegalArgumentException e) {
            res.getWriter().print(WDDXUtil.createCriticalErrorMsg(e, "getAllSyncInfo"));
            return null;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ServletException((Throwable)e);
        }
    }

    public ActionForward turnTeacherSyncOff(ActionMapping mapping, ActionForm form, HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        try {
            log.debug((Object)"turnTeacherSyncOff");
            long taskInstanceId = WebUtil.readIntParam(req, "sessionId");
            long userId = UserServiceDelegate.findUserId(WebUtil.getUsername(req));
            SupportToolService service = SupportToolServiceUtil.getHome().create();
            service.turnTeacherSyncOff(userId, taskInstanceId);
            SyncTaskInstance task = service.getSyncTask(taskInstanceId);
            service.remove();
            String packet = WDDXUtil.createACKMessage("turnTeacherSyncOff", task.getLearningSession().getSid());
            res.getWriter().print(packet);
            return null;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ServletException(e.getMessage());
        }
    }

    public ActionForward getActivityInfo(ActionMapping mapping, ActionForm form, HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        try {
            log.debug((Object)"getActivityInfo");
            long sessionId = WebUtil.readLongParam(req, "sid");
            long activityId = WebUtil.readLongParam(req, "activityId");
            ActivityInstanceData data = StaffServiceDelegate.getActivityInfo(sessionId, activityId);
            String packet = WDDXUtil.createACKMessage("getActivityInfo", data, sessionId);
            res.getWriter().print(packet);
            return null;
        }
        catch (IllegalArgumentException e) {
            res.getWriter().print(WDDXUtil.createCriticalErrorMsg(e, "getActivityInfo"));
            return null;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ServletException((Throwable)e);
        }
    }

    public ActionForward enableSession(ActionMapping mapping, ActionForm form, HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        try {
            long sessionId = WebUtil.readLongParam(req, "sid");
            boolean lock = WebUtil.readBooleanParam(req, "lock");
            log.debug((Object)("enableSession: sid: " + sessionId + ", lock: " + lock));
            StaffServiceDelegate.setLearningSessionAvailability(sessionId, lock);
            String packet = WDDXUtil.createACKMessage("enableSession", sessionId);
            res.getWriter().print(packet);
            return null;
        }
        catch (IllegalArgumentException e) {
            res.getWriter().print(WDDXUtil.createCriticalErrorMsg(e, "setTaskLock"));
            return null;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ServletException((Throwable)e);
        }
    }

    public ActionForward startPreviewSession(ActionMapping mapping, ActionForm form, HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        try {
            int sessionId = WebUtil.readIntParam(req, "sid");
            String username = WebUtil.getUsername(req);
            ShwaaUserData user = UserServiceDelegate.find(username);
            Long adminUserId = user.getUid();
            Long organisationID = this.createPreviewClass(adminUserId);
            this.setPreviewSessionOrganisationID(sessionId, organisationID);
            StaffServiceDelegate.start(sessionId);
            String msg = WDDXUtil.createACKMessage("startPreviewSession", sessionId);
            res.getWriter().print(msg);
            return null;
        }
        catch (IllegalArgumentException e) {
            res.getWriter().print(WDDXUtil.createCriticalErrorMsg(e, "startPreviewSession"));
            return null;
        }
        catch (ControllerException e) {
            res.getWriter().print(WDDXUtil.createErrorMsg(e, "startPreviewSession"));
            return null;
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
    }

    private void setPreviewSessionOrganisationID(int sessionID, Long organisationID) throws Exception {
        try {
            PersistenceSession sess = new PersistenceSession();
            LearningSessionDAO lsDao = new LearningSessionDAO(sess);
            LearningSession lsession = lsDao.find(sessionID);
            lsession.setOrganisation(organisationID);
            lsDao.update(lsession);
            sess.flush();
        }
        catch (Exception e) {
            log.debug((Object)"Exception occured while setting the OrganisationID for Preview Session");
            throw new Exception(e.getMessage());
        }
    }

    private Long createPreviewClass(Long adminUserId) throws Exception {
        try {
            OrganisationCompleteData ocd = new OrganisationCompleteData(new Long(-1L), "Preview Class", "This is a preview Class", false, null, true, false);
            UserManagementService service = UserManagementServiceUtil.getHome().create();
            Long organisationID = service.updateOrganisation(ocd, false, adminUserId);
            log.debug((Object)("Preview Class ID:" + organisationID));
            service.updateUserMembership(adminUserId, organisationID, new Integer(0), false, adminUserId);
            return organisationID;
        }
        catch (Exception e) {
            log.debug((Object)("Exception while creating the Preview Class: " + e.getMessage()));
            throw new Exception(e.getMessage());
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

