/*
 * Decompiled with CFR 0.152.
 */
package com.webmcq.ld.controller.tool.web;

import com.webmcq.ld.controller.ControllerException;
import com.webmcq.ld.controller.DisplayTaskData;
import com.webmcq.ld.controller.Learner;
import com.webmcq.ld.controller.OptionalTaskInstance;
import com.webmcq.ld.controller.TaskInstance;
import com.webmcq.ld.controller.tool.interfaces.SupportToolService;
import com.webmcq.ld.controller.tool.interfaces.SupportToolServiceUtil;
import com.webmcq.ld.controller.web.ToolAction;
import com.webmcq.ld.service.LearnerServiceDelegate;
import com.webmcq.ld.service.UserNotFoundException;
import com.webmcq.ld.service.UserServiceDelegate;
import com.webmcq.ld.service.interfaces.LearnerService;
import com.webmcq.ld.service.interfaces.LearnerServiceUtil;
import com.webmcq.ld.usermanagement.interfaces.ShwaaUserData;
import com.webmcq.ld.util.WebUtil;
import com.webmcq.ld.util.exception.SystemException;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class OptionAction
extends ToolAction {
    private static Logger log = Logger.getLogger((Class)(class$com$webmcq$ld$controller$tool$web$OptionAction == null ? (class$com$webmcq$ld$controller$tool$web$OptionAction = OptionAction.class$("com.webmcq.ld.controller.tool.web.OptionAction")) : class$com$webmcq$ld$controller$tool$web$OptionAction));
    public static final String MODE_TAG = "mode";
    public static final String VIEW_ONLY_MODE_TAG = "viewOnly";
    static /* synthetic */ Class class$com$webmcq$ld$controller$tool$web$OptionAction;

    public ActionForward getOptions(ActionMapping mapping, ActionForm form, HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        try {
            Learner learner;
            log.debug((Object)"getOptions");
            String mode = WebUtil.readStrParam(req, MODE_TAG);
            log.debug((Object)("getOptions mode=" + mode));
            if ("checkup".equals(mode)) {
                req.setAttribute(VIEW_ONLY_MODE_TAG, (Object)mode);
            }
            long sessionId = WebUtil.readIntParam(req, "sessionId");
            String username = WebUtil.getUsername(req);
            ShwaaUserData user = UserServiceDelegate.find(username);
            SupportToolService supportService = SupportToolServiceUtil.getHome().create();
            OptionalTaskInstance selectionTask = supportService.getTaskInstance(sessionId);
            if (selectionTask.countActivitiesDone(learner = selectionTask.getLearningSession().findLearner(user)) == selectionTask.countActivities()) {
                DisplayTaskData displayTaskData = LearnerServiceDelegate.moveToNextTask(selectionTask.getSid(), user.getUid());
                ActionForward action = this.displayTask(displayTaskData, mapping, form, req, res);
                this.setRefresh(req, true);
                return action;
            }
            if (selectionTask.hasCompleted(learner)) {
                req.setAttribute("finished", (Object)"finished");
            }
            req.setAttribute("task", (Object)selectionTask.getTask());
            req.setAttribute("sessionId", (Object)new Long(sessionId));
            req.setAttribute("activities", (Object)supportService.getOptionalActivities(user, selectionTask.getSid()));
            supportService.remove();
            WebUtil.saveToken(req, "transactionKeyOptional", this.generateToken(req));
            return mapping.findForward("options");
        }
        catch (UserNotFoundException e) {
            throw new SystemException(e.getMessage());
        }
        catch (ControllerException e) {
            throw new SystemException(e.getMessage());
        }
        catch (Exception e) {
            throw new SystemException(e.getMessage());
        }
    }

    public ActionForward chooseActivity(ActionMapping mapping, ActionForm form, HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        try {
            log.debug((Object)"chooseActivity");
            long activityId = WebUtil.readLongParam(req, "activity");
            long sessionId = WebUtil.readIntParam(req, "sessionId");
            String username = WebUtil.getUsername(req);
            ShwaaUserData user = UserServiceDelegate.find(username);
            SupportToolService supportService = SupportToolServiceUtil.getHome().create();
            TaskInstance taskInstance = supportService.getChosenOptionalActivity(activityId, sessionId);
            supportService.remove();
            log.debug((Object)("task instance finally found: " + taskInstance.getSid()));
            LearnerService service = LearnerServiceUtil.getHome().create();
            DisplayTaskData displayTaskData = service.gotoTask(taskInstance.getSid(), user);
            service.remove();
            ActionForward action = this.displayTask(displayTaskData, mapping, form, req, res);
            return action;
        }
        catch (UserNotFoundException e) {
            throw new SystemException(e.getMessage());
        }
        catch (ControllerException e) {
            throw new SystemException(e.getMessage());
        }
        catch (Exception e) {
            throw new SystemException(e.getMessage());
        }
    }

    public ActionForward finish(ActionMapping mapping, ActionForm form, HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        try {
            if (WebUtil.isTokenValid(req, "transactionKeyOptional")) {
                log.debug((Object)"finish");
                WebUtil.resetToken(req, "transactionKeyOptional");
                req.getSession().removeAttribute("transactionDoneOptional");
                long sessionId = WebUtil.readIntParam(req, "sessionId");
                String username = WebUtil.getUsername(req);
                ShwaaUserData user = UserServiceDelegate.find(username);
                SupportToolService supportService = SupportToolServiceUtil.getHome().create();
                OptionalTaskInstance selectionTask = supportService.getTaskInstance(sessionId);
                supportService.remove();
                DisplayTaskData displayTaskData = LearnerServiceDelegate.moveToNextTask(selectionTask.getSid(), user.getUid());
                ActionForward action = this.displayTask(displayTaskData, mapping, form, req, res);
                this.setRefresh(req, true);
                req.getSession().setAttribute("transactionDoneOptional", (Object)action);
                return action;
            }
            return this.duplicateSubmission(mapping, req, "transactionDoneOptional");
        }
        catch (Exception e) {
            throw new SystemException(e.getMessage());
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

