/*
 * Decompiled with CFR 0.152.
 */
package com.webmcq.ld.controller.dto;

import com.webmcq.ld.controller.Activity;
import com.webmcq.ld.controller.Learner;
import com.webmcq.ld.controller.LearningSession;
import com.webmcq.ld.controller.LearningSessionException;
import com.webmcq.ld.controller.OptionalTaskInstance;
import com.webmcq.ld.controller.SyncTaskInstance;
import com.webmcq.ld.controller.TaskInstance;
import com.webmcq.ld.controller.ToolUrl;
import com.webmcq.ld.controller.dto.ActivityData;
import com.webmcq.ld.controller.dto.GroupData;
import com.webmcq.ld.controller.dto.LearnerData;
import com.webmcq.ld.controller.dto.LearningSessionData;
import com.webmcq.ld.controller.dto.SimpleOrganisationData;
import com.webmcq.ld.controller.dto.SyncPointData;
import com.webmcq.ld.controller.dto.ToolUrlGroupData;
import com.webmcq.ld.controller.dto.UserNameData;
import com.webmcq.ld.controller.learner.Group;
import com.webmcq.ld.service.UserNotFoundException;
import com.webmcq.ld.service.UserServiceDelegate;
import com.webmcq.ld.usermanagement.OrganisationCompleteData;
import com.webmcq.ld.usermanagement.UserData;
import com.webmcq.ld.usermanagement.UserManagementException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;

public class ControllerDTOFactory {
    private static Logger log = Logger.getLogger((Class)(class$com$webmcq$ld$controller$dto$ControllerDTOFactory == null ? (class$com$webmcq$ld$controller$dto$ControllerDTOFactory = ControllerDTOFactory.class$("com.webmcq.ld.controller.dto.ControllerDTOFactory")) : class$com$webmcq$ld$controller$dto$ControllerDTOFactory));
    static /* synthetic */ Class class$com$webmcq$ld$controller$dto$ControllerDTOFactory;

    public static GroupData buildGroupData(Group group, long learningSessionId) throws UserNotFoundException {
        log.debug((Object)("getGroup: " + group));
        GroupData groupData = new GroupData(group.getSid(), group.getName());
        HashMap<Long, UserNameData> users = new HashMap<Long, UserNameData>();
        Iterator i = group.getMembers().keySet().iterator();
        HashMap cachedUsers = LearningSession.getInstance().getLearningSessionUsers(String.valueOf(learningSessionId));
        while (i.hasNext()) {
            Learner learner = (Learner)group.getMembers().get(i.next());
            UserNameData userData = ControllerDTOFactory.getUser(learner, cachedUsers);
            users.put(new Long(learner.getUserId()), userData);
        }
        log.debug((Object)"created UserData map");
        groupData.setMembers(users);
        return groupData;
    }

    public static SimpleOrganisationData buildOrganisationData(OrganisationCompleteData org) {
        return new SimpleOrganisationData(org.getSid(), org.getName(), org.getDescription(), org.isAccountOrganisation(), org.isReadOnly(), org.getUsers().size());
    }

    public static LearningSessionData buildLearningSessionData(LearningSession lsession) {
        return new LearningSessionData(lsession.getSid(), lsession.getTitle(), lsession.getDescription(), lsession.getStatus(), lsession.getOrganisationId(), lsession.getStartedTime(), lsession.getLearnerGroup().getLearners().size(), lsession.getArchived(), lsession.getLearningDesignId(), lsession.isAvailable());
    }

    public static LearningSessionData[] buildLearningSessionDatas(List list) {
        LearningSessionData[] result = new LearningSessionData[list.size()];
        for (int j = 0; j < list.size(); ++j) {
            LearningSession element = (LearningSession)list.get(j);
            result[j] = ControllerDTOFactory.buildLearningSessionData(element);
        }
        return result;
    }

    public static LearningSessionData buildDetailedLearningSessionData(long userId, LearningSession lsession) throws UserManagementException {
        LearningSessionData data = ControllerDTOFactory.buildLearningSessionData(lsession);
        if (lsession.getOrganisationId() != -1L) {
            data.setOrganisation(ControllerDTOFactory.buildOrganisationData(UserServiceDelegate.findOrganisation(lsession.getOrganisationId(), userId)));
        }
        return data;
    }

    public static LearningSessionData[] buildDetailedLearningSessionDatas(long userId, List list) throws UserManagementException {
        LearningSessionData[] result = new LearningSessionData[list.size()];
        for (int j = 0; j < list.size(); ++j) {
            LearningSession element = (LearningSession)list.get(j);
            result[j] = ControllerDTOFactory.buildDetailedLearningSessionData(userId, element);
        }
        return result;
    }

    public static ActivityData buildActivityData(Activity activity) {
        return new ActivityData(activity.getSid(), activity.getTitle(), activity.getDescription(), false);
    }

    private static UserNameData getUser(Learner learner, HashMap cachedUsers) throws UserNotFoundException {
        UserData user;
        UserData userData = user = cachedUsers == null ? null : (UserData)cachedUsers.get(new Long(learner.getUserId()));
        if (user == null) {
            user = UserServiceDelegate.findCompleteUser(learner.getUserId());
            LearningSession.getInstance().cacheLearningSessionUsers(String.valueOf(learner.getLearningSession().getSid()), user);
        }
        UserNameData userData2 = new UserNameData(user.getSid(), user.getLogin(), user.getFirstName(), user.getLastName());
        return userData2;
    }

    public static ToolUrlGroupData[] buildToolUrlGroupData(ToolUrl[] urls) {
        HashMap<String, ToolUrlGroupData> tools = new HashMap<String, ToolUrlGroupData>();
        for (int i = 0; i < urls.length; ++i) {
            ToolUrlGroupData toolGroup = (ToolUrlGroupData)tools.get(urls[i].getToolType());
            if (toolGroup == null) {
                toolGroup = new ToolUrlGroupData(urls[i].getToolType());
                tools.put(toolGroup.getTooltype(), toolGroup);
            }
            toolGroup.addToolUrl(urls[i]);
        }
        return tools.values().toArray(new ToolUrlGroupData[tools.size()]);
    }

    public static LearnerData[] buildLearnerData(Learner[] learners, long learningDesignId) throws LearningSessionException, UserNotFoundException {
        log.debug((Object)("buildLearnerData: learningDesignId : " + learningDesignId));
        LearnerData[] data = new LearnerData[learners.length];
        HashMap cachedUsers = LearningSession.getInstance().getLearningSessionUsers(String.valueOf(learningDesignId));
        log.debug((Object)("buildLearnerData: cachedUsers" + cachedUsers));
        for (int i = 0; i < learners.length; ++i) {
            UserNameData userData = ControllerDTOFactory.getUser(learners[i], cachedUsers);
            data[i] = new LearnerData(learners[i].getSid(), learners[i].getUserId(), learners[i].getStatus(), userData.getLogin(), userData.getFirstName(), userData.getLastName());
            TaskInstance taskInstance = learners[i].getCurrentTaskInstance();
            if (taskInstance == null) {
                data[i].setTaskId(0L);
                data[i].setActivityId(0L);
            } else {
                data[i].setTaskId(taskInstance.getTaskSid());
                Activity act = learners[i].getCurrentActivity();
                if (act == null) {
                    if (learners[i].getCurrentTaskInstance() instanceof OptionalTaskInstance) {
                        data[i].setActivityId(taskInstance.getTaskSid());
                    } else {
                        data[i].setActivityId(0L);
                    }
                } else {
                    data[i].setActivityId(act.getSid());
                }
            }
            data[i].setPastTaskIds(learners[i].getPastTaskInstanceIds());
            data[i].setCurrentTaskUrls(learners[i].checkup());
        }
        return data;
    }

    public static SyncPointData[] buildSyncPointData(SyncTaskInstance[] tasks) throws LearningSessionException {
        SyncPointData[] data = new SyncPointData[tasks.length];
        for (int i = 0; i < tasks.length; ++i) {
            data[i] = new SyncPointData(tasks[i].getSid(), tasks[i].getTaskSid(), tasks[i].getSyncPoint().isTeacherSyncOn());
        }
        return data;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

