/*
 * Decompiled with CFR 0.152.
 */
package com.webmcq.ld.controller;

import com.webmcq.ld.activities.ActivityDefnVO;
import com.webmcq.ld.controller.ActivityInstance;
import com.webmcq.ld.controller.ControllerException;
import com.webmcq.ld.controller.DisplayTaskData;
import com.webmcq.ld.controller.Learner;
import com.webmcq.ld.controller.LearningSession;
import com.webmcq.ld.controller.OptionalTask;
import com.webmcq.ld.controller.Task;
import com.webmcq.ld.controller.TaskInstance;
import com.webmcq.ld.controller.ToolProxy;
import com.webmcq.ld.controller.dao.ToolNotFoundException;
import com.webmcq.ld.controller.design.TaskManager;
import com.webmcq.ld.controller.dto.ActivityData;
import com.webmcq.ld.controller.dto.TaskInstanceData;
import com.webmcq.ld.controller.learner.Group;
import com.webmcq.ld.util.exception.SystemException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.ejb.EJBException;
import org.apache.log4j.Logger;

public class OptionalTaskInstance
extends TaskInstance {
    private static final String TOOL_TYPE = "option_selection";
    private List subTaskInstances;
    private ToolProxy toolProxy;
    private static Logger log = Logger.getLogger((Class)(class$com$webmcq$ld$controller$OptionalTaskInstance == null ? (class$com$webmcq$ld$controller$OptionalTaskInstance = OptionalTaskInstance.class$("com.webmcq.ld.controller.OptionalTaskInstance")) : class$com$webmcq$ld$controller$OptionalTaskInstance));
    static /* synthetic */ Class class$com$webmcq$ld$controller$OptionalTaskInstance;

    private OptionalTaskInstance() {
    }

    public OptionalTaskInstance(LearningSession lsession, Group group, Task task, List subTaskInstances) {
        super(lsession, group);
        this.subTaskInstances = subTaskInstances;
        this.setTask(task);
    }

    private void setTask(Task task) {
        if (task == null) {
            this.setTaskSid(0L);
        } else {
            this.setTaskSid(task.getSid());
        }
    }

    public void complete(Learner learner) {
    }

    public boolean hasCompleted(Learner learner) {
        try {
            return this.countActivitiesDone(learner) >= this.getOptionalTask().getMinActivitiesRequired();
        }
        catch (ControllerException e) {
            throw new EJBException((Exception)e);
        }
    }

    public boolean isComplete() {
        return false;
    }

    public TaskInstanceData getData() {
        return new TaskInstanceData(this.getSid(), this.getTask().getTitle(), 0, this.getTaskSid(), this.getLearningSession().getOwnerId(), null, this.getLearningSession().getSid());
    }

    public Task getTask() {
        return TaskManager.getOptionalTask(this.getLearningSession().getLearningDesignId(), this.getTaskSid());
    }

    public void prepareTool() throws ControllerException {
        try {
            log.debug((Object)("prepareTool: " + this.getSid() + ": " + this.subTaskInstances.size()));
            if (this.getToolProxy() != null) {
                log.debug((Object)"prepareTool: already bound");
                return;
            }
            log.debug((Object)"prepareTool: binding");
            ToolProxy tool = ToolProxy.findToolProxy(TOOL_TYPE);
            log.debug((Object)("prepareTool: tool found " + tool));
            this.setToolProxy(tool);
        }
        catch (ToolNotFoundException e) {
            throw new SystemException(e);
        }
    }

    public DisplayTaskData run(Learner learner) {
        log.info((Object)("run: learner " + learner.getSid()));
        DisplayTaskData displayTaskData = new DisplayTaskData(42);
        displayTaskData.setSessionId(learner.getLearningSession().getSid());
        displayTaskData.setTaskId(this.getSid());
        displayTaskData.setUrlA(this.getToolProxy().getUrl(this, "run"));
        return displayTaskData;
    }

    public DisplayTaskData view() {
        DisplayTaskData displayTaskData = new DisplayTaskData(52);
        if (this.isLocked()) {
            displayTaskData.setUrlA(this.getToolProxy().getUrl(this, "view"));
        } else {
            displayTaskData.setUrlA(this.getToolProxy().getUrl(this, "run"));
        }
        return displayTaskData;
    }

    public String[] checkup(Learner learner) {
        String[] urls = new String[]{this.getToolProxy().getUrl(this, "checkup") + "&userId=" + learner.getUserId()};
        return urls;
    }

    public DisplayTaskData resume(Learner learner) {
        log.info((Object)("resume: learner " + learner.getSid()));
        DisplayTaskData displayTaskData = new DisplayTaskData(50);
        displayTaskData.setSessionId(learner.getLearningSession().getSid());
        displayTaskData.setTaskId(this.getSid());
        displayTaskData.setUrlA(this.getToolProxy().getUrl(this, "resume"));
        return displayTaskData;
    }

    public ToolProxy getToolProxy() {
        return this.toolProxy;
    }

    public void setToolProxy(ToolProxy tool) {
        this.toolProxy = tool;
    }

    public List getSubTaskInstances() {
        return this.subTaskInstances;
    }

    private void setSubTaskInstances(List subTaskInstances) {
        this.subTaskInstances = subTaskInstances;
    }

    public int countActivitiesToDo(Learner learner) throws ControllerException {
        ActivityData[] activities = this.getActivities(learner);
        int activitiesToDo = 0;
        for (int i = 0; i < activities.length; ++i) {
            if (activities[i].getDone()) continue;
            ++activitiesToDo;
        }
        return activitiesToDo;
    }

    public int countActivitiesDone(Learner learner) throws ControllerException {
        int activitiesDone = 0;
        Iterator iter = this.subTaskInstances.iterator();
        while (iter.hasNext()) {
            TaskInstance subTaskInstance = (TaskInstance)iter.next();
            if (!learner.hasTaken(subTaskInstance)) continue;
            ++activitiesDone;
        }
        return activitiesDone;
    }

    public int getMinActivitiesRequired() {
        return this.getOptionalTask().getMinActivitiesRequired();
    }

    public int countActivities() {
        return this.subTaskInstances.size();
    }

    public ActivityData getFirstActivityUndone(Learner learner) throws ControllerException {
        ActivityData[] activities = this.getActivities(learner);
        for (int i = 0; i < activities.length; ++i) {
            if (activities[i].getDone()) continue;
            return activities[i];
        }
        return null;
    }

    public List getActivities() {
        return this.getOptionalTask().getActivities();
    }

    public ActivityData[] getActivities(Learner learner) throws ControllerException {
        ArrayList<ActivityData> activities = new ArrayList<ActivityData>();
        Iterator i = this.getActivities().iterator();
        while (i.hasNext()) {
            ActivityDefnVO activity = (ActivityDefnVO)i.next();
            ActivityData data = new ActivityData(activity.getSid(), activity.getTitle(), activity.getDescription(), false);
            TaskInstance subTaskInstance = this.getSubTaskInstance(activity.getSid());
            if (learner.hasTaken(subTaskInstance)) {
                data.setDone(true);
            }
            activities.add(data);
        }
        return activities.toArray(new ActivityData[0]);
    }

    public TaskInstance getSubTaskInstance(long activityId) throws ControllerException {
        TaskInstance subTaskInstance = null;
        Iterator i = this.subTaskInstances.iterator();
        while (i.hasNext()) {
            TaskInstance taskInstance = (TaskInstance)i.next();
            if (taskInstance.getTask().getActivity().getSid() != activityId) continue;
            subTaskInstance = taskInstance;
            break;
        }
        if (subTaskInstance != null) {
            return subTaskInstance;
        }
        throw new ControllerException("Can not find task for activity in Optional Activity");
    }

    public ActivityDefnVO getActivity(long activityId) throws ControllerException {
        List activities = this.getOptionalTask().getActivities();
        Iterator i = activities.iterator();
        while (i.hasNext()) {
            ActivityDefnVO activity = (ActivityDefnVO)i.next();
            if (activity.getSid() != activityId) continue;
            return activity;
        }
        throw new ControllerException("activity not found: ");
    }

    public TaskInstance getFirstTask(long activityId) throws ControllerException {
        ActivityDefnVO activity = this.getActivity(activityId);
        return this.getFirstTask(activity);
    }

    private TaskInstance getFirstTask(ActivityDefnVO activity) throws ControllerException {
        return this.getSubTask(activity.getFirstTask().getSid());
    }

    private TaskInstance getSubTask(long taskId) {
        Iterator i = this.subTaskInstances.iterator();
        while (i.hasNext()) {
            TaskInstance taskInstance = (TaskInstance)i.next();
            if (taskInstance.getTaskSid() != taskId) continue;
            return taskInstance;
        }
        return null;
    }

    private OptionalTask getOptionalTask() {
        return (OptionalTask)this.getTask();
    }

    public String getToolType() {
        return null;
    }

    public ActivityInstance getActivityInstance() {
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

