/*
 * Decompiled with CFR 0.152.
 */
package com.webmcq.ld.controller;

import com.webmcq.ld.controller.ControllerException;
import com.webmcq.ld.controller.DisplayTaskData;
import com.webmcq.ld.controller.Learner;
import com.webmcq.ld.controller.TaskInstance;
import com.webmcq.ld.controller.dao.LearnerDAO;
import com.webmcq.ld.controller.design.LearningDesign;
import com.webmcq.ld.controller.learner.Group;
import com.webmcq.ld.controller.learner.LearnerGroup;
import com.webmcq.ld.controller.session.LearningDesignSession;
import com.webmcq.ld.controller.web.WebApplicationContext;
import com.webmcq.ld.usermanagement.UserData;
import com.webmcq.ld.usermanagement.interfaces.ShwaaUserData;
import com.webmcq.ld.util.persistence.PersistenceSession;
import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.Set;
import javax.servlet.ServletContext;
import org.apache.log4j.Logger;

public class LearningSession
implements Serializable {
    public static final int CREATED = 0;
    public static final int RUNNING = 2;
    public static final long NOT_INITIALISED = -1L;
    public static final int ACTIVE = 0;
    public static final int ARCHIVED = 1;
    public static final int PREVIEW = 2;
    private long sid;
    private String title;
    private String description;
    private int status;
    private long ownerId;
    private long organisationId;
    private LearnerGroup learnerGroup;
    private int learningDesignId;
    private LearningDesign design;
    private Date startedTime;
    private int archived;
    private boolean available;
    private Set taskInstance;
    private static Logger log = Logger.getLogger((Class)(class$com$webmcq$ld$controller$LearningSession == null ? (class$com$webmcq$ld$controller$LearningSession = LearningSession.class$("com.webmcq.ld.controller.LearningSession")) : class$com$webmcq$ld$controller$LearningSession));
    static /* synthetic */ Class class$com$webmcq$ld$controller$LearningSession;

    public Set getTaskInstance() {
        return this.taskInstance;
    }

    public void setTaskInstance(Set taskInstance) {
        this.taskInstance = taskInstance;
    }

    private LearningSession() {
    }

    public LearningSession(ShwaaUserData owner, int ldId, String title, String desc, String sessionType) {
        this.learningDesignId = ldId;
        this.design = new LearningDesign(ldId);
        this.title = title;
        this.description = desc;
        this.ownerId = owner.getUid();
        this.status = 0;
        this.organisationId = -1L;
        this.learnerGroup = new LearnerGroup();
        this.archived = sessionType.equals("preview") ? 2 : 0;
        this.available = true;
    }

    public static LearningSession getInstance() {
        return new LearningSession();
    }

    public void setOrganisation(long organisationId) throws ControllerException {
        if (this.getStatus() != 0) {
            throw new ControllerException("can not set organisation for learning session '" + this.getSid() + "' in status '" + this.getStatus() + "'");
        }
        this.organisationId = organisationId;
    }

    public DisplayTaskData join(PersistenceSession sess, UserData user) throws ControllerException {
        log.debug((Object)"join");
        if (this.getStatus() != 2) {
            throw new ControllerException("can not join learning session " + this.getSid() + " status " + this.getStatus());
        }
        if (!user.isInOrganisation(new Long(this.organisationId))) {
            throw new ControllerException("user '" + user.getSid() + "' can not join: not a member");
        }
        Learner newLearner = this.learnerGroup.join(user, this);
        log.debug((Object)("user '" + user.getSid() + "' joined learning session '" + this.getSid() + "'"));
        TaskInstance taskInstance = newLearner.getNextTaskInstance(sess);
        DisplayTaskData displayTaskData = newLearner.toNextTask(sess, taskInstance);
        newLearner.setCurrentTaskInstance(taskInstance);
        LearnerDAO dao = new LearnerDAO(sess);
        dao.update(newLearner);
        displayTaskData.setMessageType(51);
        return displayTaskData;
    }

    public void start(PersistenceSession sess) throws ControllerException {
        log.info((Object)("learning session '" + this.getSid() + "' starts"));
        if (this.getStatus() != 0) {
            throw new ControllerException("can not start the learning session " + this.getSid() + " status " + this.getStatus());
        }
        if (this.organisationId == -1L) {
            throw new ControllerException("no organisation is set.");
        }
        this.init(sess);
        this.getLearningDesign().setAsUsed();
        this.setStatus(2);
        this.startedTime = new Date();
    }

    private void init(PersistenceSession sess) throws ControllerException {
        LearningDesignSession ldSession = new LearningDesignSession(this.getLearningDesign(), this);
        ldSession.init(sess);
    }

    public LearningDesignSession getLearningDesignSession() {
        return new LearningDesignSession(this.getLearningDesign(), this);
    }

    public String getDescription() {
        return this.description;
    }

    public long getSid() {
        return this.sid;
    }

    public int getStatus() {
        return this.status;
    }

    public String getTitle() {
        return this.title;
    }

    private void setDescription(String description) {
        this.description = description;
    }

    private void setSid(long sid) {
        this.sid = sid;
    }

    private void setStatus(int status) {
        this.status = status;
    }

    private void setTitle(String title) {
        this.title = title;
    }

    public long getOwnerId() {
        return this.ownerId;
    }

    private void setOwnerId(long ownerId) {
        this.ownerId = ownerId;
    }

    public String toString() {
        return "learning session: " + this.sid;
    }

    public int getLearningDesignId() {
        return this.learningDesignId;
    }

    public void setLearningDesignId(int learningDesignId) {
        this.learningDesignId = learningDesignId;
    }

    public long getOrganisationId() {
        return this.organisationId;
    }

    private void setOrganisationId(long organisationId) {
        this.organisationId = organisationId;
    }

    public Date getStartedTime() {
        return this.startedTime;
    }

    private void setStartedTime(Date startedTime) {
        this.startedTime = startedTime;
    }

    public int getArchived() {
        return this.archived;
    }

    public void setArchived(int b) {
        this.archived = b;
    }

    public boolean isAvailable() {
        return this.available;
    }

    public void setAvailable(boolean b) {
        this.available = b;
    }

    public LearningDesign getLearningDesign() {
        if (this.design == null) {
            this.design = new LearningDesign(this.learningDesignId);
        }
        return this.design;
    }

    public LearnerGroup getLearnerGroup() {
        return this.learnerGroup;
    }

    private void setLearnerGroup(LearnerGroup group) {
        this.learnerGroup = group;
    }

    public Group getLearners() {
        return this.learnerGroup.getLearners();
    }

    public Learner findLearner(ShwaaUserData user) {
        return this.learnerGroup.findLearner(user);
    }

    public Learner findLearner(long userId) {
        return this.learnerGroup.findLearner(userId);
    }

    public HashMap getLearningSessionUsers(String learningSessionId) {
        ServletContext context = WebApplicationContext.getInstance().getServletContext();
        return (HashMap)context.getAttribute(learningSessionId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cacheLearningSessionUsers(String learningSessionId, UserData curUser) {
        ServletContext context;
        ServletContext servletContext = context = WebApplicationContext.getInstance().getServletContext();
        synchronized (servletContext) {
            HashMap<Long, UserData> sessionUsersMap = (HashMap<Long, UserData>)context.getAttribute(learningSessionId);
            if (sessionUsersMap == null) {
                sessionUsersMap = new HashMap<Long, UserData>();
            }
            if (!sessionUsersMap.containsKey(curUser.getSid())) {
                sessionUsersMap.put(curUser.getSid(), curUser);
                context.setAttribute(learningSessionId, sessionUsersMap);
            }
        }
    }

    public void removeLearningSessionUserFromCache(String learningSessionId) {
        ServletContext context = WebApplicationContext.getInstance().getServletContext();
        context.removeAttribute(learningSessionId);
    }

    private void init() throws ControllerException {
        LearningDesignSession sess = new LearningDesignSession(this.getLearningDesign(), this);
        sess.init();
    }

    public void start() throws ControllerException {
        log.info((Object)("learning session '" + this.getSid() + "' starts"));
        if (this.getStatus() != 0) {
            throw new ControllerException("can not start the learning session " + this.getSid() + " status " + this.getStatus());
        }
        if (this.organisationId == -1L) {
            throw new ControllerException("no organisation is set.");
        }
        this.init();
        this.getLearningDesign().setAsUsed();
        this.setStatus(2);
        this.startedTime = new Date();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

