/*
 * Decompiled with CFR 0.152.
 */
package com.webmcq.ld.content;

import com.webmcq.ld.content.Content;
import com.webmcq.ld.content.ContentGroup;
import com.webmcq.ld.content.ControlContent;
import com.webmcq.ld.content.LDContentKey;
import com.webmcq.ld.controller.ControllerException;
import com.webmcq.ld.util.HibernateUtilFactory;
import com.webmcq.ld.util.exception.SystemException;
import java.io.Serializable;
import java.util.List;
import javax.ejb.EJBException;
import javax.naming.NamingException;
import net.sf.hibernate.Hibernate;
import net.sf.hibernate.HibernateException;
import net.sf.hibernate.Session;
import net.sf.hibernate.type.Type;
import org.apache.log4j.Logger;

public class ContentDAO {
    private static Logger log = Logger.getLogger((Class)(class$com$webmcq$ld$content$ContentDAO == null ? (class$com$webmcq$ld$content$ContentDAO = ContentDAO.class$("com.webmcq.ld.content.ContentDAO")) : class$com$webmcq$ld$content$ContentDAO));
    static /* synthetic */ Class class$com$webmcq$ld$content$ContentDAO;
    static /* synthetic */ Class class$com$webmcq$ld$content$Content;

    public static void store(Content content) {
        log.debug((Object)("store: " + content));
        Session sess = null;
        try {
            sess = ContentDAO.getSession();
            sess.saveOrUpdate((Object)content);
            sess.flush();
        }
        catch (HibernateException e) {
            throw new EJBException((Exception)((Object)e));
        }
        finally {
            ContentDAO.closeSession(sess);
        }
    }

    public static void insert(Content content) {
        log.debug((Object)("insert: " + content));
        Session sess = null;
        try {
            sess = ContentDAO.getSession();
            sess.save((Object)content);
            sess.flush();
        }
        catch (HibernateException e) {
            throw new EJBException((Exception)((Object)e));
        }
        finally {
            ContentDAO.closeSession(sess);
        }
    }

    public static void store(ContentGroup contentGroup) {
        log.debug((Object)("store: " + contentGroup));
        Session sess = null;
        try {
            sess = ContentDAO.getSession();
            sess.saveOrUpdate((Object)contentGroup);
            sess.flush();
        }
        catch (HibernateException e) {
            throw new EJBException((Exception)((Object)e));
        }
        finally {
            ContentDAO.closeSession(sess);
        }
    }

    public static Content find(long contentId) throws ControllerException {
        Session sess = null;
        try {
            sess = ContentDAO.getSession();
            Content content = (Content)sess.load(class$com$webmcq$ld$content$Content == null ? (class$com$webmcq$ld$content$Content = ContentDAO.class$("com.webmcq.ld.content.Content")) : class$com$webmcq$ld$content$Content, (Serializable)new Long(contentId));
            if (content == null) {
                throw new ControllerException("content '" + contentId + "' not found");
            }
            log.debug((Object)("content found: '" + content.getSid() + "'"));
            Content content2 = content;
            return content2;
        }
        catch (HibernateException e) {
            throw new EJBException((Exception)((Object)e));
        }
        finally {
            ContentDAO.closeSession(sess);
        }
    }

    public static Long findContentId(LDContentKey key) {
        Session sess = null;
        try {
            sess = ContentDAO.getSession();
            List list = sess.find("from ckey in class com.webmcq.ld.content.LDContentKey where ckey.learningDesignId = ?  and ckey.learningDesignContentId = ? and ckey.learningSessionId = ?", new Object[]{new Long(key.getLearningDesignId()), new Long(key.getLearningDesignContentId()), new Long(key.getLearningSessionId())}, new Type[]{Hibernate.LONG, Hibernate.LONG, Hibernate.LONG});
            if (list.size() == 0) {
                Long l = null;
                return l;
            }
            LDContentKey foundKey = (LDContentKey)list.get(0);
            log.debug((Object)("content id found: '" + key + "'"));
            Long l = new Long(foundKey.getContentId());
            return l;
        }
        catch (HibernateException e) {
            throw new EJBException((Exception)((Object)e));
        }
        finally {
            ContentDAO.closeSession(sess);
        }
    }

    public static void insert(LDContentKey key) {
        Session sess = null;
        try {
            sess = ContentDAO.getSession();
            ControlContent content = new ControlContent();
            sess.save((Object)content);
            key.setContentId(content.getSid());
            sess.save((Object)key);
            sess.flush();
        }
        catch (HibernateException e) {
            throw new EJBException((Exception)((Object)e));
        }
        finally {
            ContentDAO.closeSession(sess);
        }
    }

    private static Session getSession() throws EJBException {
        try {
            return HibernateUtilFactory.getInstance().getSessionFactory().openSession();
        }
        catch (NamingException e) {
            throw new EJBException((Exception)e);
        }
        catch (HibernateException e) {
            throw new EJBException((Exception)((Object)e));
        }
    }

    private static void closeSession(Session sess) {
        try {
            if (sess != null) {
                sess.close();
            }
        }
        catch (HibernateException e) {
            throw new EJBException((Exception)((Object)e));
        }
    }

    public static void remove(long id) throws SystemException {
        try {
            Content content = ContentDAO.find(id);
        }
        catch (ControllerException ce) {
            log.debug((Object)("No such content with contentID of " + id + " found"));
            return;
        }
        Session session = null;
        try {
            String query = "from obj in class com.webmcq.ld.content.Content where obj.sid = ?";
            session = ContentDAO.getSession();
            session.delete(query, (Object)new Long(id), (Type)Hibernate.LONG);
            session.flush();
        }
        catch (HibernateException e) {
            log.debug((Object)("HibernateException:" + e.getMessage()));
            throw new SystemException(e);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

