/*
 * Decompiled with CFR 0.152.
 */
package com.webmcq.ld.activities.authoring;

import com.webmcq.ld.activities.authoring.LDWDDXValueObjectFactory;
import com.webmcq.ld.activities.authoring.LDWDDXValueObjectStorer;
import com.webmcq.ld.service.UserNotFoundException;
import com.webmcq.ld.service.UserServiceDelegate;
import com.webmcq.ld.usermanagement.UserData;
import com.webmcq.ld.util.BaseSessionBean;
import com.webmcq.ld.util.ClientStatusMessage;
import com.webmcq.ld.util.WDDXProcessor;
import java.util.Hashtable;
import java.util.Iterator;
import org.apache.log4j.Logger;

public class LDAuthoringServiceBean
extends BaseSessionBean {
    private static Logger logger = Logger.getLogger((String)(class$com$webmcq$ld$activities$authoring$LDAuthoringServiceBean == null ? (class$com$webmcq$ld$activities$authoring$LDAuthoringServiceBean = LDAuthoringServiceBean.class$("com.webmcq.ld.activities.authoring.LDAuthoringServiceBean")) : class$com$webmcq$ld$activities$authoring$LDAuthoringServiceBean).getName());
    static /* synthetic */ Class class$com$webmcq$ld$activities$authoring$LDAuthoringServiceBean;

    public String learningDesignListWDDX(boolean validOnly, String username) {
        String wddxPacket = null;
        Object result = null;
        logger.debug((Object)("Request for list of learning designs received - username" + username));
        UserData user = this.getUser(username);
        if (user == null) {
            return this.getUserIdErrorPacket(username);
        }
        try {
            result = LDWDDXValueObjectFactory.getInstance().newLearningDesignListValueObject(validOnly, user, user.getHomeOrg());
        }
        catch (Exception e) {
            result = new ClientStatusMessage("Error", "Unable to list learning designs. Error message " + e.getMessage(), "");
            logger.error((Object)"Error getting learning design definitions ", (Throwable)e);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("learning design list value object is" + result.toString()));
        }
        try {
            wddxPacket = WDDXProcessor.serialize(result);
        }
        catch (Exception e) {
            logger.error((Object)("Unable to create learning design packet to send to client. Trying to send data " + (result != null ? result.toString() : "NULL")), (Throwable)e);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Send WDDXPacket " + wddxPacket));
        }
        return wddxPacket;
    }

    public String learningDesignRequestWDDX(Long id, String username) {
        String wddxPacket = null;
        Object result = null;
        logger.debug((Object)("Request received for learning design #" + id + " username=" + username));
        UserData user = this.getUser(username);
        if (user == null) {
            return this.getUserIdErrorPacket(username);
        }
        if (id == null) {
            result = new ClientStatusMessage("Error", "Activity sequence key missing.", "");
        } else {
            try {
                result = LDWDDXValueObjectFactory.getInstance().newLearningDesignValueObject(id, user);
            }
            catch (Exception e) {
                result = new ClientStatusMessage("Error", e.getMessage(), id.toString());
                logger.error((Object)("Unable to create learning design packet to send to client. Trying to send learning design # " + id), (Throwable)e);
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("learning design value object is" + result.toString()));
        }
        try {
            wddxPacket = WDDXProcessor.serialize(result);
        }
        catch (Exception e) {
            logger.error((Object)("Unable to create learning design packet to send to client. Trying to send data " + (result != null ? result.toString() : "NULL")), (Throwable)e);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Send WDDXPacket " + wddxPacket));
        }
        return wddxPacket;
    }

    private boolean containsNulls(String packet) {
        return packet.indexOf("<null />") != -1;
    }

    public String storeLDDataWDDX(String ldWddxPacket, String username) {
        String outputWddxPacket = null;
        Long userId = this.getUserId(username);
        if (userId == null) {
            return this.getUserIdErrorPacket(username);
        }
        if (this.containsNulls(ldWddxPacket)) {
            logger.error((Object)"Unable to process WDDX packet from client due to containing '<null/>' - this would cause WDDX to crash.");
            logger.error((Object)("Packet was " + ldWddxPacket));
            try {
                outputWddxPacket = WDDXProcessor.serialize(new ClientStatusMessage("Error", "Unable to store due to an internal error. Contact support for help\n  The WDDX packet contains an invalid string", null));
                return outputWddxPacket;
            }
            catch (Exception e2) {
                logger.error((Object)"Unable to tell client that packet wasn't stored: ", (Throwable)e2);
            }
        }
        Hashtable ldHashTable = null;
        ClientStatusMessage result = null;
        LDWDDXValueObjectStorer ldStore = new LDWDDXValueObjectStorer();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Request received to store learning design data" + ldWddxPacket));
        }
        try {
            ldHashTable = (Hashtable)WDDXProcessor.deserialize(ldWddxPacket);
            logger.debug((Object)("~~~~~>ldHashTable size: " + ldHashTable.size()));
            Iterator iter = ldHashTable.keySet().iterator();
            while (iter.hasNext()) {
                String key = (String)iter.next();
                logger.debug((Object)("~~~~~~>key: " + key + "    value:" + ldHashTable.get(key).toString()));
            }
        }
        catch (Exception e) {
            try {
                logger.error((Object)"Unable to process WDDX packet from client: ", (Throwable)e);
                logger.error((Object)("Packet was " + ldWddxPacket));
                outputWddxPacket = WDDXProcessor.serialize(new ClientStatusMessage("Error", "Unable to store . Sorry. \n Exception was \"" + e.getMessage() + "\"", e.getMessage()));
            }
            catch (Exception e2) {
                logger.error((Object)"Unable to process WDDX packet from client: ", (Throwable)e);
                logger.error((Object)"Unable to tell client that it wasn't stored: ", (Throwable)e2);
            }
            return outputWddxPacket;
        }
        if (ldHashTable == null) {
            result = new ClientStatusMessage("Error", "There doesn't seem to be any information to save. Unable to store activities.", null);
        } else if (LDWDDXValueObjectStorer.isLibrary((String)ldHashTable.get("objectType"))) {
            try {
                result = ldStore.processLibraryActivity(ldHashTable, userId);
            }
            catch (Exception e) {
                result = new ClientStatusMessage("Error", "Unable to store library activity due to database error. See server log." + e.getMessage(), null);
            }
        } else if (LDWDDXValueObjectStorer.isLearningDesign((String)ldHashTable.get("objectType"))) {
            try {
                result = ldStore.processLearningDesign(ldHashTable, userId);
            }
            catch (Exception e) {
                result = new ClientStatusMessage("Error", "Unable to store activity sequence due to database error. See server log." + e.getMessage(), null);
            }
        } else {
            result = new ClientStatusMessage("Error", LDWDDXValueObjectStorer.getExpectedLibraryLearningDesign() + " received " + (String)ldHashTable.get("objectType") + " Unable to store .", null);
        }
        try {
            outputWddxPacket = WDDXProcessor.serialize(result);
        }
        catch (Exception e) {
            String message = "Unable to tell client what has happened! Unable to serialise response for client, response was ";
            message = message + (result != null ? ((Object)result).toString() : " NULL");
            logger.error((Object)message, (Throwable)e);
        }
        return outputWddxPacket;
    }

    public String libraryContentsRequestWDDX(Long id, String username) {
        String wddxPacket = null;
        Object result = null;
        logger.debug((Object)("Request received for library contents #" + (id == null ? "null" : id.toString()) + " username=" + username));
        UserData user = this.getUser(username);
        if (user == null) {
            return this.getUserIdErrorPacket(username);
        }
        try {
            result = LDWDDXValueObjectFactory.getInstance().newLibraryValueObject(id, user);
        }
        catch (Exception e) {
            String message = "Unable to create library packet to send to client - internal error.";
            if (id != null) {
                message = message + " Trying to send library " + id.toString();
                result = new ClientStatusMessage("Error", message, id.toString());
            } else {
                result = new ClientStatusMessage("Error", message, null);
            }
            logger.error((Object)message, (Throwable)e);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("\t" + result.toString()));
        }
        try {
            wddxPacket = WDDXProcessor.serialize(result);
        }
        catch (Exception e) {
            logger.error((Object)("Unable to create library packet to send to client. Trying to send data " + (result != null ? result.toString() : "NULL")), (Throwable)e);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Send WDDXPacket " + wddxPacket));
        }
        return wddxPacket;
    }

    public String deleteLibraryPackageWDDX(Long packageSid, String username) {
        String wddxPacket = null;
        ClientStatusMessage result = null;
        LDWDDXValueObjectStorer ldStore = new LDWDDXValueObjectStorer();
        Long userId = this.getUserId(username);
        if (userId == null) {
            return this.getUserIdErrorPacket(username);
        }
        try {
            ldStore.deleteLibraryPackage(null, packageSid, userId);
            result = new ClientStatusMessage("Deleted", "Package deleted from library", packageSid.toString());
        }
        catch (Exception e) {
            result = new ClientStatusMessage("Error", "Unable to delete package from library. Error message " + e.getMessage(), "");
        }
        try {
            wddxPacket = WDDXProcessor.serialize(result);
        }
        catch (Exception e) {
            logger.error((Object)("Unable to create learning design packet to send to client. Trying to send data " + (result != null ? ((Object)result).toString() : "NULL")), (Throwable)e);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Send WDDXPacket " + wddxPacket));
        }
        return wddxPacket;
    }

    public String deleteLibraryWDDX(Long librarySid, String username) {
        String wddxPacket = null;
        ClientStatusMessage result = null;
        LDWDDXValueObjectStorer ldStore = new LDWDDXValueObjectStorer();
        try {
            ldStore.deleteLibrary(librarySid);
            result = new ClientStatusMessage("Deleted", "Library deleted", librarySid.toString());
        }
        catch (Exception e) {
            result = new ClientStatusMessage("Error", "Unable to delete library. Error message " + e.getMessage(), "");
        }
        try {
            wddxPacket = WDDXProcessor.serialize(result);
        }
        catch (Exception e) {
            logger.error((Object)("Unable to create learning design packet to send to client. Trying to send data " + (result != null ? ((Object)result).toString() : "NULL")), (Throwable)e);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Send WDDXPacket " + wddxPacket));
        }
        return wddxPacket;
    }

    public String deleteLearningDesignWDDX(Long ldSid, String username) {
        String wddxPacket = null;
        ClientStatusMessage result = null;
        Long userId = this.getUserId(username);
        if (userId == null) {
            return this.getUserIdErrorPacket(username);
        }
        LDWDDXValueObjectStorer ldStore = new LDWDDXValueObjectStorer();
        try {
            ldStore.deleteLearningDesign(ldSid.intValue(), userId);
            result = new ClientStatusMessage("Deleted", "Learning design deleted", ldSid.toString());
        }
        catch (Exception e) {
            result = new ClientStatusMessage("Error", "Unable to delete learning desing. Error message " + e.getMessage(), "");
        }
        try {
            wddxPacket = WDDXProcessor.serialize(result);
        }
        catch (Exception e) {
            logger.error((Object)("Unable to create learning design packet to send to client. Trying to send data " + (result != null ? ((Object)result).toString() : "NULL")), (Throwable)e);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Send WDDXPacket " + wddxPacket));
        }
        return wddxPacket;
    }

    private Long getUserId(String username) {
        try {
            return new Long(UserServiceDelegate.findUserId(username));
        }
        catch (UserNotFoundException e) {
            logger.error((Object)("Trying to update data from authoring client. Username " + username + " unknown"));
            return null;
        }
    }

    private UserData getUser(String username) {
        try {
            return UserServiceDelegate.findCompleteUser(username);
        }
        catch (UserNotFoundException e) {
            logger.error((Object)("Trying to update data from authoring client. Username " + username + " unknown"));
            return null;
        }
    }

    private String getUserIdErrorPacket(String username) {
        try {
            String outputWddxPacket = WDDXProcessor.serialize(new ClientStatusMessage("Error", "Username " + username + " not recognised.", null));
            return outputWddxPacket;
        }
        catch (Exception e2) {
            logger.error((Object)"Unable to tell client that packet wasn't stored: ", (Throwable)e2);
            return null;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

