/*
 * Decompiled with CFR 0.152.
 */
package com.webmcq.ld.util.persistence;

import com.webmcq.ld.util.HibernateUtilFactory;
import com.webmcq.ld.util.exception.DataAccessException;
import com.webmcq.ld.util.exception.SystemException;
import java.sql.SQLException;
import javax.naming.NamingException;
import net.sf.hibernate.HibernateException;
import net.sf.hibernate.JDBCException;
import net.sf.hibernate.LockMode;
import net.sf.hibernate.Session;
import net.sf.hibernate.Transaction;
import org.apache.log4j.Logger;

public class PersistenceSession {
    private static Logger log = Logger.getLogger((Class)(class$com$webmcq$ld$util$persistence$PersistenceSession == null ? (class$com$webmcq$ld$util$persistence$PersistenceSession = PersistenceSession.class$("com.webmcq.ld.util.persistence.PersistenceSession")) : class$com$webmcq$ld$util$persistence$PersistenceSession));
    private Session sess;
    static /* synthetic */ Class class$com$webmcq$ld$util$persistence$PersistenceSession;

    public PersistenceSession(Session session) {
        this.sess = session;
    }

    public PersistenceSession() throws SystemException {
        try {
            this.sess = HibernateUtilFactory.getInstance().getSessionFactory().openSession();
        }
        catch (NamingException e) {
            throw new SystemException(e);
        }
        catch (HibernateException e) {
            throw new SystemException(e);
        }
    }

    public Session persistece() {
        return this.sess;
    }

    public void flush() throws SystemException {
        try {
            this.sess.flush();
        }
        catch (HibernateException e) {
            if (e instanceof JDBCException && ((JDBCException)((Object)e)).getErrorCode() == 1062) {
                log.debug((Object)"We got duplicate insertion. Ignore it.");
                return;
            }
            throw new SystemException(e);
        }
    }

    public void flushWithJDBCException() throws JDBCException {
        try {
            this.sess.flush();
        }
        catch (HibernateException e) {
            if (e instanceof JDBCException) {
                throw (JDBCException)((Object)e);
            }
            throw new SystemException(e);
        }
    }

    public void close() throws SystemException {
        try {
            if (this.sess.connection() != null) {
                this.sess.connection().close();
            }
            if (this.sess != null) {
                this.sess.close();
            }
            this.sess = null;
        }
        catch (HibernateException e) {
            throw new SystemException(e);
        }
        catch (SQLException e) {
            throw new SystemException(e);
        }
    }

    public Transaction startTransaction() {
        try {
            return this.sess.beginTransaction();
        }
        catch (HibernateException e) {
            throw new SystemException(e);
        }
    }

    public void commitTransaction(Transaction tx) {
        try {
            tx.commit();
        }
        catch (HibernateException e) {
            throw new SystemException(e);
        }
    }

    public void rollbackTransaction(Transaction tx) {
        try {
            tx.rollback();
        }
        catch (HibernateException e) {
            throw new SystemException(e);
        }
    }

    public void commit() throws SystemException {
        try {
            this.sess.connection().commit();
        }
        catch (HibernateException e) {
            throw new SystemException(e);
        }
        catch (SQLException e) {
            throw new SystemException(e);
        }
    }

    public void lockSession(Object obj, LockMode mode) {
        try {
            this.sess.lock(obj, mode);
        }
        catch (HibernateException e) {
            throw new SystemException(e);
        }
    }

    public void disconnect() throws DataAccessException {
        try {
            this.sess.disconnect();
        }
        catch (HibernateException e) {
            throw new DataAccessException("Unable to disconnect hibernate session", e);
        }
    }

    public void reconnect() throws DataAccessException {
        try {
            this.sess.reconnect();
        }
        catch (HibernateException e) {
            throw new DataAccessException("Unable to reconnect hibernate session", e);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

