/*
 * Decompiled with CFR 0.152.
 */
package com.webmcq.ld.util;

import com.allaire.wddx.WddxDeserializationException;
import com.allaire.wddx.WddxDeserializer;
import com.allaire.wddx.WddxSerializer;
import com.webmcq.ld.util.WDDXProcessorConversionException;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.xml.sax.InputSource;

public class WDDXProcessor {
    private static Logger logger = Logger.getLogger((String)(class$com$webmcq$ld$util$WDDXProcessor == null ? (class$com$webmcq$ld$util$WDDXProcessor = WDDXProcessor.class$("com.webmcq.ld.util.WDDXProcessor")) : class$com$webmcq$ld$util$WDDXProcessor).getName());
    WDDXProcessor m_theRealMe = null;
    static /* synthetic */ Class class$com$webmcq$ld$util$WDDXProcessor;

    private WDDXProcessor() {
    }

    WDDXProcessor getInstance() {
        if (this.m_theRealMe == null) {
            this.m_theRealMe = new WDDXProcessor();
        }
        return this.m_theRealMe;
    }

    public static String replaceNewline(String inputPacket) {
        String ret = null;
        if (inputPacket != null) {
            ret = StringUtils.replace((String)inputPacket, (String)"%0D%0A", (String)"\r\n");
        }
        return ret;
    }

    public static Object deserialize(String wddxPacket) throws WddxDeserializationException {
        Object result;
        String replacedString = WDDXProcessor.replaceNewline(wddxPacket);
        InputSource tempSource = new InputSource(new StringReader(replacedString));
        String parserClass = "javax.xml.parsers.SAXParser";
        WddxDeserializer tempDeserializer = new WddxDeserializer(parserClass);
        try {
            result = tempDeserializer.deserialize(tempSource);
        }
        catch (IOException e) {
            throw new WddxDeserializationException((Exception)e);
        }
        return result;
    }

    public static String serialize(Object data) throws IOException {
        WddxSerializer tempws = new WddxSerializer();
        StringWriter tempsw = new StringWriter();
        tempws.serialize(data, (Writer)tempsw);
        return tempsw.toString();
    }

    public static int convertToInt(String identifier, Object value) throws WDDXProcessorConversionException {
        int result = -255;
        if (value == null) {
            throw new WDDXProcessorConversionException(identifier + " is null, cannot convert to an int");
        }
        try {
            result = ((Number)value).intValue();
            return result;
        }
        catch (Exception e) {
            try {
                String textValue = (String)value;
                if (textValue.length() == 0) {
                    return -1;
                }
                double dTemp = Double.parseDouble(textValue);
                result = (int)dTemp;
            }
            catch (Exception e2) {
                throw new WDDXProcessorConversionException("Unable to convert value " + identifier + ":" + value + " to an int");
            }
            return result;
        }
    }

    public static Integer nullSafeCovertToInteger(String identifier, Object value) throws WDDXProcessorConversionException {
        if (value == null) {
            throw new IllegalArgumentException("[" + identifier + "] is null. We can't convert null value to integer");
        }
        return WDDXProcessor.convertToInteger(identifier, value);
    }

    public static Integer convertToInteger(String identifier, Object value) throws WDDXProcessorConversionException {
        Integer result = null;
        if (value == null) {
            return null;
        }
        try {
            result = new Integer(((Number)value).intValue());
            return result;
        }
        catch (Exception e) {
            try {
                String textValue = (String)value;
                if (textValue.length() == 0) {
                    return null;
                }
                int posPeriod = textValue.indexOf(46);
                if (posPeriod > 0) {
                    textValue = textValue.substring(0, posPeriod);
                }
                result = new Integer(textValue);
            }
            catch (Exception e2) {
                throw new WDDXProcessorConversionException("Unable to convert value " + identifier + ":" + value + " to an int");
            }
            return result;
        }
    }

    public static Long convertToLong(String identifier, Object value) throws WDDXProcessorConversionException {
        Long result = null;
        if (value == null) {
            return null;
        }
        try {
            result = new Long(((Number)value).intValue());
            return result;
        }
        catch (Exception e) {
            try {
                String textValue = (String)value;
                if (textValue.length() == 0) {
                    return null;
                }
                int posPeriod = textValue.indexOf(46);
                if (posPeriod > 0) {
                    textValue = textValue.substring(0, posPeriod);
                }
                result = new Long(textValue);
            }
            catch (Exception e2) {
                throw new WDDXProcessorConversionException("Unable to convert value " + identifier + ":" + value + " to an int");
            }
            return result;
        }
    }

    public static Boolean convertToBoolean(String identifier, Object value) throws WDDXProcessorConversionException {
        Boolean result = null;
        if (value == null) {
            return null;
        }
        try {
            result = (Boolean)value;
            logger.debug((Object)("identifier " + identifier + " was Boolean value " + value + " becomes " + result));
            return result;
        }
        catch (Exception e) {
            try {
                String textValue = (String)value;
                if (textValue.length() == 0) {
                    return null;
                }
                result = new Boolean(textValue);
                logger.debug((Object)("identifier " + identifier + " was String value " + value + " becomes " + result));
                return result;
            }
            catch (Exception e2) {
                throw new WDDXProcessorConversionException("Unable to convert value " + identifier + ":" + value + " to a Boolean");
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

