/*
 * Decompiled with CFR 0.152.
 */
package com.webmcq.ld.util;

import com.webmcq.ld.service.UserNotFoundException;
import com.webmcq.ld.service.UserServiceDelegate;
import java.util.Collection;
import java.util.Hashtable;
import javax.ejb.EJBException;
import javax.ejb.SessionContext;
import javax.jms.JMSException;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.QueueSender;
import javax.jms.QueueSession;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.rmi.PortableRemoteObject;

public class EJBUtil {
    public static Context initialContext = null;

    public static final Object lookup(Context ctx, String name, Class classType) throws NamingException {
        return PortableRemoteObject.narrow((Object)ctx.lookup(name), (Class)classType);
    }

    public static final String readEnvString(String location) throws NamingException {
        InitialContext ctx = new InitialContext();
        return (String)ctx.lookup("java:comp/env/" + location);
    }

    public static final int readEnvInt(String location) throws NamingException {
        InitialContext ctx = new InitialContext();
        Integer num = (Integer)ctx.lookup("java:comp/env/" + location);
        return num;
    }

    public static final Hashtable getContextEnv() throws NamingException {
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("java.naming.factory.initial", "org.jnp.interfaces.NamingContextFactory");
        env.put("java.naming.factory.url.pkgs", "org.jboss.naming:org.jnp.interfaces");
        env.put("java.naming.provider.url", "jnp://localhost:1099");
        return env;
    }

    public static final Object findSingle(Collection coll) {
        if (coll.size() == 0) {
            return null;
        }
        return coll.iterator().next();
    }

    public static final QueueSession getQueueSession(QueueConnection conn) {
        try {
            return conn.createQueueSession(false, 1);
        }
        catch (JMSException e) {
            throw new EJBException((Exception)((Object)e));
        }
    }

    public static final QueueSender getQueueSender(QueueConnection conn, String queueName) {
        try {
            QueueSession sess = conn.createQueueSession(false, 1);
            if (initialContext == null) {
                initialContext = new InitialContext();
            }
            Queue queue = (Queue)initialContext.lookup(queueName);
            return sess.createSender(queue);
        }
        catch (NamingException e) {
            throw new EJBException((Exception)e);
        }
        catch (JMSException e) {
            throw new EJBException((Exception)((Object)e));
        }
    }

    public static final QueueConnection getQueueConnection() {
        try {
            if (initialContext == null) {
                initialContext = new InitialContext();
            }
            QueueConnectionFactory factory = (QueueConnectionFactory)initialContext.lookup("ConnectionFactory");
            QueueConnection conn = factory.createQueueConnection();
            return conn;
        }
        catch (NamingException e) {
            throw new EJBException((Exception)e);
        }
        catch (JMSException e) {
            throw new EJBException((Exception)((Object)e));
        }
    }

    public static final long getUserId(SessionContext context) throws UserNotFoundException {
        String username = context.getCallerPrincipal().getName();
        long userId = UserServiceDelegate.findUserId(username);
        return userId;
    }

    public static final String getUserName(SessionContext context) {
        String username = context.getCallerPrincipal().getName();
        return username;
    }
}

