/*
 * Decompiled with CFR 0.152.
 */
package com.webmcq.ld.tool.voterank.web;

import com.webmcq.ld.controller.ControllerException;
import com.webmcq.ld.controller.DisplayTaskData;
import com.webmcq.ld.controller.web.ToolAction;
import com.webmcq.ld.service.UserServiceDelegate;
import com.webmcq.ld.tool.StaffMonitorNotifier;
import com.webmcq.ld.tool.voterank.dto.AllVoteData;
import com.webmcq.ld.tool.voterank.dto.PollContentNominationResultsData;
import com.webmcq.ld.tool.voterank.dto.PollDTOFactory;
import com.webmcq.ld.tool.voterank.interfaces.PollNominationData;
import com.webmcq.ld.tool.voterank.interfaces.VoteRankService;
import com.webmcq.ld.tool.voterank.interfaces.VoteRankServiceUtil;
import com.webmcq.ld.usermanagement.UserRole;
import com.webmcq.ld.util.WebUtil;
import com.webmcq.ld.util.exception.SystemException;
import java.io.IOException;
import java.rmi.RemoteException;
import java.util.HashSet;
import javax.ejb.CreateException;
import javax.naming.NamingException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class VoteRankAction
extends ToolAction {
    public static String JSP_TASK_INSTANCE_ID_TAG = "sessionId";
    public static String JSPINPUT_ERROR_TAG = "error";
    public static String JSPINPUT_POLL_NOMINEE_INFO_TAG = "info";
    public static String JSPINPUT_POLL_RESULTS_TAG = "results";
    public static String JSPINPUT_ALL_VOTES_TAG = "allvotes";
    public static String JSPOUTPUT_VOTES_FROM_LIST_TAG = "nomination";
    public static String JSPOUTPUT_VOTE_FROM_USERENTRY_TAG = "userentry";
    public static String JSPOUTPUT_VOTE_FROM_NEWNOMINATION_TAG = "newnomination";
    public static String JSPOUTPUT_LIST_NOMINATION = "listnomination";
    public static String SHOW_VOTES_ONLY = "votesonly";
    public static String VOTERANK_PATH = "/tool/voterank/voterank";
    public static String JSPINPUT_MODE_TAG = "mode";
    public static String STUDENT_ID_TAG = "userId";
    public static final String MODIFY_MODE_TAG = "modify";
    public static final String PREVIEW_CHECKUP = "previewCheckup";
    private static Logger log = Logger.getLogger((Class)(class$com$webmcq$ld$tool$voterank$web$VoteRankAction == null ? (class$com$webmcq$ld$tool$voterank$web$VoteRankAction = VoteRankAction.class$("com.webmcq.ld.tool.voterank.web.VoteRankAction")) : class$com$webmcq$ld$tool$voterank$web$VoteRankAction));
    static /* synthetic */ Class class$com$webmcq$ld$tool$voterank$web$VoteRankAction;

    public ActionForward dispatch(ActionMapping mapping, ActionForm form, HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        try {
            int taskInstanceId = WebUtil.readIntParam(req, JSP_TASK_INSTANCE_ID_TAG);
            String mode = WebUtil.readStrParam(req, JSPINPUT_MODE_TAG);
            log.debug((Object)("access: mode: " + mode));
            String sessionType = (String)req.getSession().getAttribute("session");
            req.setAttribute("session", (Object)sessionType);
            if (mode.equals("view") && sessionType != null && sessionType.equals("preview")) {
                req.setAttribute(PREVIEW_CHECKUP, (Object)PREVIEW_CHECKUP);
            }
            if ("run".equals(mode) || "resume".equals(mode)) {
                VoteRankService service = VoteRankServiceUtil.getHome().create();
                if (service.isVoteEndedOrHasVoted(this.getUserId(req), taskInstanceId)) {
                    return this.getMyVote(mapping, form, req, res);
                }
                return this.getPoll(mapping, form, req, res);
            }
            if ("view".equals(mode)) {
                return this.getMyVote(mapping, form, req, res);
            }
            if ("checkup".equals(mode)) {
                return this.getStudentsVote(mapping, form, req, res);
            }
            throw new SystemException("unrecognized access mode: '" + mode + "'");
        }
        catch (NamingException e) {
            log.error((Object)"dispatch: Exception occured", (Throwable)e);
            throw new SystemException(e);
        }
        catch (CreateException e) {
            log.error((Object)"dispatch: Exception occured", (Throwable)e);
            throw new SystemException(e);
        }
        catch (Exception e) {
            log.error((Object)"dispatch: Exception occured", (Throwable)e);
            throw new SystemException(e);
        }
    }

    private long getUserId(HttpServletRequest req) throws ServletException {
        try {
            String username = WebUtil.getUsername(req);
            return UserServiceDelegate.findUserId(username);
        }
        catch (Exception e) {
            throw new SystemException(e);
        }
    }

    public ActionForward viewPoll(ActionMapping mapping, ActionForm form, HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        try {
            int taskInstanceId = WebUtil.readIntParam(req, JSP_TASK_INSTANCE_ID_TAG);
            log.debug((Object)("viewPoll taskInstanceId: " + taskInstanceId));
            VoteRankService service = VoteRankServiceUtil.getHome().create();
            PollContentNominationResultsData info = service.getInfoNomineesByTaskInstance(taskInstanceId);
            if (info == null) {
                log.error((Object)("No poll information available for task " + taskInstanceId));
                info = PollDTOFactory.createDummyResults(taskInstanceId);
            }
            req.setAttribute(JSPINPUT_POLL_NOMINEE_INFO_TAG, (Object)info);
            return mapping.findForward("viewpoll");
        }
        catch (CreateException e) {
            log.error((Object)"getPoll: Exception occured", (Throwable)e);
            throw new SystemException(e.getMessage());
        }
        catch (NamingException e) {
            log.error((Object)"getPoll: Exception occured", (Throwable)e);
            throw new SystemException(e.getMessage());
        }
        catch (Exception e) {
            log.error((Object)"getPoll: Exception occured", (Throwable)e);
            throw new SystemException(e.getMessage());
        }
    }

    public ActionForward getPoll(ActionMapping mapping, ActionForm form, HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        try {
            int taskInstanceId = WebUtil.readIntParam(req, JSP_TASK_INSTANCE_ID_TAG);
            log.debug((Object)("getPoll taskInstanceId: " + taskInstanceId));
            String mode = WebUtil.readStrParam(req, JSPINPUT_MODE_TAG);
            req.setAttribute(JSP_TASK_INSTANCE_ID_TAG, (Object)new Long(taskInstanceId));
            long learningSessionId = WebUtil.retrieveLearningSessionIdFromSession(req, mode);
            VoteRankService service = VoteRankServiceUtil.getHome().create();
            AllVoteData allVotes = service.getAllVotes(taskInstanceId, learningSessionId);
            PollContentNominationResultsData info = service.getInfoNomineesByTaskInstance(taskInstanceId);
            if (info == null) {
                log.error((Object)("No poll information available for task " + taskInstanceId));
                info = PollDTOFactory.createDummyResults(taskInstanceId);
            }
            if (allVotes.getDefineLater() != null && allVotes.getDefineLater().booleanValue()) {
                req.setAttribute(MODIFY_MODE_TAG, (Object)"todefine");
                req.setAttribute(JSPINPUT_MODE_TAG, (Object)"view");
            }
            req.setAttribute(JSPINPUT_POLL_NOMINEE_INFO_TAG, (Object)info);
            return mapping.findForward("poll");
        }
        catch (CreateException e) {
            log.error((Object)"getPoll: Exception occured", (Throwable)e);
            throw new SystemException(e.getMessage());
        }
        catch (NamingException e) {
            log.error((Object)"getPoll: Exception occured", (Throwable)e);
            throw new SystemException(e.getMessage());
        }
        catch (Exception e) {
            log.error((Object)"getPoll: Exception occured", (Throwable)e);
            throw new SystemException(e.getMessage());
        }
    }

    public ActionForward putVote(ActionMapping mapping, ActionForm form, HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        try {
            int taskInstanceId = WebUtil.readIntParam(req, JSP_TASK_INSTANCE_ID_TAG);
            log.debug((Object)("putVote entry taskInstanceId: " + taskInstanceId));
            long userId = this.getUserId(req);
            HashSet<String> votes = new HashSet<String>();
            String[] nominations = req.getParameterValues(JSPOUTPUT_VOTES_FROM_LIST_TAG);
            String polltimeNomination = req.getParameter(JSPOUTPUT_VOTE_FROM_USERENTRY_TAG);
            if (nominations != null) {
                for (int i = 0; i < nominations.length; ++i) {
                    votes.add(nominations[i]);
                }
            }
            if (polltimeNomination != null && polltimeNomination.length() > 0) {
                votes.add(polltimeNomination);
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Got the following nominations for task " + taskInstanceId + " user " + userId + ": " + votes));
            }
            VoteRankService service = VoteRankServiceUtil.getHome().create();
            service.putVote(taskInstanceId, userId, votes);
            PollContentNominationResultsData info = service.getInfoVotesByVoter(taskInstanceId, userId);
            if (info == null) {
                log.error((Object)("Poll info for task instance id " + taskInstanceId + " not found"));
                info = PollDTOFactory.createDummyResults(taskInstanceId);
            }
            req.setAttribute(JSPINPUT_POLL_RESULTS_TAG, (Object)info);
            String monitorTitle = info.getTitle();
            this.notifyVotesReceived(taskInstanceId, monitorTitle);
            return mapping.findForward("votereceived");
        }
        catch (CreateException e) {
            log.error((Object)"putVote: Exception occured", (Throwable)e);
            throw new SystemException(e.getMessage());
        }
        catch (NamingException e) {
            log.error((Object)"putVote: Exception occured", (Throwable)e);
            throw new SystemException(e.getMessage());
        }
        catch (RemoteException e) {
            log.error((Object)"putVote: Exception occured", (Throwable)e);
            throw new SystemException(e.getMessage());
        }
        catch (Exception e) {
            log.error((Object)"putVote: Exception occured", (Throwable)e);
            throw new SystemException(e.getMessage());
        }
    }

    public ActionForward putEndOfVoting(ActionMapping mapping, ActionForm form, HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        try {
            int taskInstanceId = WebUtil.readIntParam(req, JSP_TASK_INSTANCE_ID_TAG);
            log.debug((Object)("putEndOfVoting taskInstanceId: " + taskInstanceId));
            VoteRankService service = VoteRankServiceUtil.getHome().create();
            service.markVoteEnded(taskInstanceId);
            return this.getAllVotes(mapping, form, req, res);
        }
        catch (CreateException e) {
            log.error((Object)"putVote: Exception occured", (Throwable)e);
            throw new SystemException(e.getMessage());
        }
        catch (NamingException e) {
            log.error((Object)"putVote: Exception occured", (Throwable)e);
            throw new SystemException(e.getMessage());
        }
        catch (RemoteException e) {
            log.error((Object)"putVote: Exception occured", (Throwable)e);
            throw new SystemException(e.getMessage());
        }
        catch (Exception e) {
            log.error((Object)"putVote: Exception occured", (Throwable)e);
            throw new SystemException(e.getMessage());
        }
    }

    public ActionForward getAllResults(ActionMapping mapping, ActionForm form, HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        try {
            int taskInstanceId = WebUtil.readIntParam(req, JSP_TASK_INSTANCE_ID_TAG);
            String mode = req.getParameter(JSPINPUT_MODE_TAG);
            req.setAttribute(JSPINPUT_MODE_TAG, (Object)mode);
            VoteRankService service = VoteRankServiceUtil.getHome().create();
            log.debug((Object)("getAllResults mode is " + mode));
            PollContentNominationResultsData info = service.getInfoResultsByTaskInstance(taskInstanceId);
            if (info == null) {
                log.error((Object)("Poll info for task instance id " + taskInstanceId + " not found"));
                info = PollDTOFactory.createDummyResults(taskInstanceId);
            }
            req.setAttribute(JSPINPUT_POLL_RESULTS_TAG, (Object)info);
            log.debug((Object)("Poll info is " + info.toString()));
            log.debug((Object)("show votes only is " + req.getParameter(SHOW_VOTES_ONLY) + "progressive display is " + info.getPollInfo().getProgressiveDisplay()));
            if (req.getParameter(SHOW_VOTES_ONLY) != null) {
                return mapping.findForward("pollresultshort");
            }
            WebUtil.saveToken(req, "transactionKeyVote", this.generateToken(req));
            return mapping.findForward("pollresult");
        }
        catch (CreateException e) {
            log.error((Object)"getResults: Exception occured", (Throwable)e);
            throw new SystemException(e.getMessage());
        }
        catch (NamingException e) {
            log.error((Object)"getResults: Exception occured", (Throwable)e);
            throw new SystemException(e.getMessage());
        }
        catch (RemoteException e) {
            log.error((Object)"getResults: Exception occured", (Throwable)e);
            throw new SystemException(e.getMessage());
        }
        catch (Exception e) {
            log.error((Object)"getResults: Exception occured", (Throwable)e);
            throw new SystemException(e.getMessage());
        }
    }

    public ActionForward getMyVote(ActionMapping mapping, ActionForm form, HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        return this.getIndividualVote(mapping, form, req, res, this.getUserId(req));
    }

    public ActionForward getStudentsVote(ActionMapping mapping, ActionForm form, HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        long studentId = WebUtil.readLongParam(req, STUDENT_ID_TAG);
        return this.getIndividualVote(mapping, form, req, res, studentId);
    }

    private ActionForward getIndividualVote(ActionMapping mapping, ActionForm form, HttpServletRequest req, HttpServletResponse res, long userId) throws IOException, ServletException {
        try {
            int taskInstanceId = WebUtil.readIntParam(req, JSP_TASK_INSTANCE_ID_TAG);
            log.debug((Object)("getAllResults taskInstanceId: " + taskInstanceId));
            String mode = req.getParameter(JSPINPUT_MODE_TAG);
            req.setAttribute(JSPINPUT_MODE_TAG, (Object)mode);
            VoteRankService service = VoteRankServiceUtil.getHome().create();
            PollContentNominationResultsData info = service.getInfoVotesByVoter(taskInstanceId, userId);
            if (info == null) {
                log.error((Object)("Poll info for task instance id " + taskInstanceId + " not found"));
                info = PollDTOFactory.createDummyResults(taskInstanceId);
            }
            req.setAttribute(JSPINPUT_POLL_RESULTS_TAG, (Object)info);
            return mapping.findForward("votereceived");
        }
        catch (CreateException e) {
            log.error((Object)"getResults: Exception occured", (Throwable)e);
            throw new SystemException(e.getMessage());
        }
        catch (NamingException e) {
            log.error((Object)"getResults: Exception occured", (Throwable)e);
            throw new SystemException(e.getMessage());
        }
        catch (RemoteException e) {
            log.error((Object)"getResults: Exception occured", (Throwable)e);
            throw new SystemException(e.getMessage());
        }
        catch (Exception e) {
            log.error((Object)"getResults: Exception occured", (Throwable)e);
            throw new SystemException(e.getMessage());
        }
    }

    public ActionForward putComplete(ActionMapping mapping, ActionForm form, HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        try {
            if (WebUtil.isTokenValid(req, "transactionKeyVote")) {
                WebUtil.resetToken(req, "transactionKeyVote");
                req.getSession().removeAttribute("transactionDoneVote");
                log.debug((Object)"complete task instance");
                int taskInstanceId = WebUtil.readIntParam(req, JSP_TASK_INSTANCE_ID_TAG);
                VoteRankService service = VoteRankServiceUtil.getHome().create();
                DisplayTaskData displayTaskData = service.completeSession(this.getUserId(req), taskInstanceId);
                ActionForward action = this.displayTask(displayTaskData, mapping, form, req, res);
                req.getSession().setAttribute("transactionDoneVote", (Object)action);
                return action;
            }
            return this.duplicateSubmission(mapping, req, "transactionDoneVote");
        }
        catch (CreateException e) {
            log.error((Object)"putComplete: Exception occured", (Throwable)e);
            throw new SystemException(e.getMessage());
        }
        catch (NamingException e) {
            log.error((Object)"putComplete: Exception occured", (Throwable)e);
            throw new SystemException(e.getMessage());
        }
        catch (RemoteException e) {
            log.error((Object)"putComplete: Exception occured", (Throwable)e);
            throw new SystemException(e.getMessage());
        }
        catch (SystemException e) {
            return mapping.findForward("error");
        }
        catch (Exception e) {
            log.error((Object)"putComplete: Exception occured", (Throwable)e);
            throw new SystemException(e.getMessage());
        }
    }

    public ActionForward getAllVotes(ActionMapping mapping, ActionForm form, HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        try {
            int taskInstanceId = WebUtil.readIntParam(req, JSP_TASK_INSTANCE_ID_TAG);
            String mode = req.getParameter(JSPINPUT_MODE_TAG);
            req.setAttribute(JSPINPUT_MODE_TAG, (Object)mode);
            long learningSessionId = WebUtil.retrieveLearningSessionIdFromSession(req, mode);
            AllVoteData allVotes = null;
            if (!req.isUserInRole(UserRole.STAFF.getName())) {
                String username = WebUtil.getUsername(req);
                log.error((Object)("User " + username + " requested vote summary for task instance " + taskInstanceId + ". User not authorised - not staff role"));
                req.setAttribute(JSPINPUT_ERROR_TAG, (Object)"You are not authorised to see the summary - you must have staff privileges.");
                allVotes = PollDTOFactory.createDummyAllVotes(taskInstanceId);
            } else {
                VoteRankService service = VoteRankServiceUtil.getHome().create();
                allVotes = service.getAllVotes(taskInstanceId, learningSessionId);
                if (allVotes == null) {
                    log.error((Object)("Votes for task instance id " + taskInstanceId + " not found"));
                    allVotes = PollDTOFactory.createDummyAllVotes(taskInstanceId);
                }
                if (req.isUserInRole(UserRole.STAFF.getName())) {
                    PollNominationData[] info = service.getNomineesData(taskInstanceId);
                    req.setAttribute(JSPINPUT_POLL_NOMINEE_INFO_TAG, (Object)info);
                    if (allVotes.getDefineLater() != null && allVotes.getDefineLater().booleanValue()) {
                        req.setAttribute(MODIFY_MODE_TAG, (Object)"todefine");
                    }
                }
            }
            log.debug((Object)("allVotes is " + allVotes.toString()));
            req.setAttribute(JSPINPUT_ALL_VOTES_TAG, (Object)allVotes);
            return mapping.findForward("allvotes");
        }
        catch (CreateException e) {
            log.error((Object)"getResults: Exception occured", (Throwable)e);
            throw new SystemException(e.getMessage());
        }
        catch (NamingException e) {
            log.error((Object)"getResults: Exception occured", (Throwable)e);
            throw new SystemException(e.getMessage());
        }
        catch (RemoteException e) {
            log.error((Object)"getResults: Exception occured", (Throwable)e);
            throw new SystemException(e.getMessage());
        }
        catch (Exception e) {
            log.error((Object)"getResults: Exception occured", (Throwable)e);
            throw new SystemException(e.getMessage());
        }
    }

    public ActionForward insertNomination(ActionMapping mapping, ActionForm form, HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        try {
            log.debug((Object)"insertNomination");
            int taskInstanceId = WebUtil.readIntParam(req, JSP_TASK_INSTANCE_ID_TAG);
            String newNomination = req.getParameter(JSPOUTPUT_VOTE_FROM_NEWNOMINATION_TAG);
            VoteRankService service = VoteRankServiceUtil.getHome().create();
            service.insertNomination(taskInstanceId, newNomination);
            return this.getAllVotes(mapping, form, req, res);
        }
        catch (CreateException e) {
            throw new SystemException(e.getMessage());
        }
        catch (NamingException e) {
            throw new SystemException(e.getMessage());
        }
        catch (Exception e) {
            throw new SystemException(e.getMessage());
        }
    }

    public ActionForward updatePollingDefineLater(ActionMapping mapping, ActionForm form, HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        try {
            log.debug((Object)"updatePollingDefine");
            int taskInstanceId = WebUtil.readIntParam(req, JSP_TASK_INSTANCE_ID_TAG);
            VoteRankService service = VoteRankServiceUtil.getHome().create();
            service.updatePollingDefineLater(false, taskInstanceId);
            return this.viewPoll(mapping, form, req, res);
        }
        catch (CreateException e) {
            throw new SystemException(e.getMessage());
        }
        catch (NamingException e) {
            throw new SystemException(e.getMessage());
        }
        catch (Exception e) {
            throw new SystemException(e.getMessage());
        }
    }

    public ActionForward deleteNomination(ActionMapping mapping, ActionForm form, HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        try {
            log.debug((Object)"deleteNomination");
            int taskInstanceId = WebUtil.readIntParam(req, JSP_TASK_INSTANCE_ID_TAG);
            int nominationId = WebUtil.readIntParam(req, JSPOUTPUT_LIST_NOMINATION);
            VoteRankService service = VoteRankServiceUtil.getHome().create();
            service.removeNomination(taskInstanceId, nominationId);
            return this.getAllVotes(mapping, form, req, res);
        }
        catch (CreateException e) {
            throw new SystemException(e.getMessage());
        }
        catch (NamingException e) {
            throw new SystemException(e.getMessage());
        }
        catch (Exception e) {
            throw new SystemException(e.getMessage());
        }
    }

    private void notifyVotesReceived(long taskInstanceId, String title) throws SystemException {
        try {
            String toolpath = "/tool/voterank/voterank.do?method=getAllVotes&sessionId=" + taskInstanceId;
            StaffMonitorNotifier.notifyControllerOfURL(taskInstanceId, "ranking", title, toolpath);
        }
        catch (ControllerException e) {
            throw new SystemException(e);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

