/*
 * Decompiled with CFR 0.152.
 */
package com.webmcq.ld.tool.urlcontent;

import com.webmcq.ld.activities.AbstractTaskVO;
import com.webmcq.ld.activities.SimpleTaskVO;
import com.webmcq.ld.content.Content;
import com.webmcq.ld.content.UrlContent;
import com.webmcq.ld.content.UrlContentEntry;
import com.webmcq.ld.content.UrlContentEntryInstruction;
import com.webmcq.ld.controller.ControllerException;
import com.webmcq.ld.controller.DisplayTaskData;
import com.webmcq.ld.controller.TaskInstance;
import com.webmcq.ld.controller.dao.TaskInstanceNotFoundException;
import com.webmcq.ld.controller.dto.GroupData;
import com.webmcq.ld.controller.dto.TaskInstanceData;
import com.webmcq.ld.service.ContentServiceDelegate;
import com.webmcq.ld.service.LearnerServiceDelegate;
import com.webmcq.ld.tool.NotifyStaffUrlThread;
import com.webmcq.ld.tool.StaffMonitorNotifier;
import com.webmcq.ld.tool.ToolException;
import com.webmcq.ld.tool.urlcontent.URLContentException;
import com.webmcq.ld.tool.urlcontent.dto.URLContentDTOFactory;
import com.webmcq.ld.tool.urlcontent.dto.URLData;
import com.webmcq.ld.tool.urlcontent.interfaces.URLContentData;
import com.webmcq.ld.tool.urlcontent.interfaces.URLContentLocal;
import com.webmcq.ld.tool.urlcontent.interfaces.URLContentPK;
import com.webmcq.ld.tool.urlcontent.interfaces.URLContentUtil;
import com.webmcq.ld.tool.urlcontent.interfaces.URLEntryInstructionLocal;
import com.webmcq.ld.tool.urlcontent.interfaces.URLEntryInstructionUtil;
import com.webmcq.ld.tool.urlcontent.interfaces.URLEntryLocal;
import com.webmcq.ld.tool.urlcontent.interfaces.URLEntryPK;
import com.webmcq.ld.tool.urlcontent.interfaces.URLEntryUtil;
import com.webmcq.ld.tool.urlcontent.interfaces.URLLearnerData;
import com.webmcq.ld.tool.urlcontent.interfaces.URLLearnerLocal;
import com.webmcq.ld.tool.urlcontent.interfaces.URLLearnerUtil;
import com.webmcq.ld.tool.urlcontent.web.URLContentAction;
import com.webmcq.ld.util.BaseSessionBean;
import com.webmcq.ld.util.EJBUtil;
import com.webmcq.ld.util.exception.SystemException;
import java.util.Collection;
import java.util.Iterator;
import java.util.SortedSet;
import javax.ejb.CreateException;
import javax.ejb.EJBException;
import javax.ejb.FinderException;
import javax.ejb.RemoveException;
import javax.naming.NamingException;
import org.apache.log4j.Logger;

public abstract class URLContentServiceBean
extends BaseSessionBean {
    private static Logger log = Logger.getLogger((Class)(class$com$webmcq$ld$tool$urlcontent$URLContentServiceBean == null ? (class$com$webmcq$ld$tool$urlcontent$URLContentServiceBean = URLContentServiceBean.class$("com.webmcq.ld.tool.urlcontent.URLContentServiceBean")) : class$com$webmcq$ld$tool$urlcontent$URLContentServiceBean));
    static /* synthetic */ Class class$com$webmcq$ld$tool$urlcontent$URLContentServiceBean;

    public URLContentLocal getUrlContentLocal(int taskInstanceId) {
        log.debug((Object)"getUrlContentLocal");
        URLContentLocal cachedURLContent = null;
        try {
            Collection entries = URLContentUtil.getLocalHome().findByTaskInstanceId(taskInstanceId);
            cachedURLContent = (URLContentLocal)EJBUtil.findSingle(entries);
        }
        catch (NamingException e) {
            log.error((Object)"Naming exception thrown trying to get the UrlContent content", (Throwable)e);
            throw new EJBException((Exception)e);
        }
        catch (FinderException e) {
            log.debug((Object)"Threw Finder exception");
        }
        log.debug((Object)("Returning " + (cachedURLContent != null ? cachedURLContent.getData().toString() : "null")));
        return cachedURLContent;
    }

    public void removeEntry(int taskInstanceId, int entrySid) {
        this.getUrlContentLocal(taskInstanceId);
        URLEntryLocal entry = null;
        try {
            URLEntryPK pk = new URLEntryPK(entrySid);
            entry = URLEntryUtil.getLocalHome().findByPrimaryKey(pk);
            entry.remove();
        }
        catch (NamingException e) {
            log.error((Object)"Naming exception thrown trying to get the UrlContent URLEntry content", (Throwable)e);
            throw new EJBException((Exception)e);
        }
        catch (RemoveException e) {
            log.error((Object)"Remove exception thrown trying to remove an URLEntry content", (Throwable)e);
            throw new EJBException((Exception)((Object)e));
        }
        catch (FinderException e) {
            // empty catch block
        }
    }

    private URLEntryLocal getURLEntryLocal(int taskInstanceId, int entrySid) {
        this.getUrlContentLocal(taskInstanceId);
        URLEntryLocal entry = null;
        try {
            URLEntryPK pk = new URLEntryPK(entrySid);
            entry = URLEntryUtil.getLocalHome().findByPrimaryKey(pk);
        }
        catch (NamingException e) {
            log.error((Object)"Naming exception thrown trying to get the UrlContent URLEntry content", (Throwable)e);
            throw new EJBException((Exception)e);
        }
        catch (FinderException e) {
            // empty catch block
        }
        return entry;
    }

    public void createSession(SimpleTaskVO task, TaskInstanceData instance, GroupData group, Long outputContentId, Content content) {
        try {
            URLContentLocal urlContent = this.getUrlContentLocal((int)instance.getSid());
            if (content != null) {
                urlContent = "urlcontent".equals(content.theContentType()) ? this.createContent((UrlContent)content, instance.getSid()) : this.createContent(content, instance.getSid());
                urlContent.setToolType(task.getToolType());
            }
            if (group != null) {
                log.debug((Object)("Creating membership from " + group.toString()));
                this.createLearners(group, urlContent);
            }
            StaffMonitorNotifier.notifyControllerOfURL(instance.getSid(), urlContent.getToolType(), urlContent.getTitle(), URLContentAction.getStaffPath(instance.getSid()));
        }
        catch (CreateException e) {
            log.error((Object)"Exception occured", (Throwable)e);
            throw new EJBException((Exception)((Object)e));
        }
        catch (NamingException e) {
            log.error((Object)"Exception occured", (Throwable)e);
            throw new EJBException((Exception)e);
        }
        catch (ControllerException e) {
            log.error((Object)"Exception occured", (Throwable)e);
            throw new SystemException(e);
        }
    }

    public void updateContent(int contentId, String description, String title, Boolean defineLater) throws RemoveException {
        try {
            URLContentPK pk = new URLContentPK(contentId);
            URLContentLocal urlContent = URLContentUtil.getLocalHome().findByPrimaryKey(pk);
            urlContent.setTitle(title);
            urlContent.setDescription(description);
            urlContent.setDefineLater(defineLater);
        }
        catch (NamingException e) {
            log.error((Object)"Naming exception thrown trying to get the UrlContent content", (Throwable)e);
            throw new EJBException((Exception)e);
        }
        catch (FinderException e) {
            log.debug((Object)"Threw Finder exception");
        }
    }

    public void removeContent(int taskInstanceId) throws RemoveException {
        try {
            Collection entries = URLContentUtil.getLocalHome().findByTaskInstanceId(taskInstanceId);
            Iterator iter = entries.iterator();
            while (iter.hasNext()) {
                URLContentLocal urlContent = (URLContentLocal)iter.next();
                urlContent.remove();
            }
        }
        catch (NamingException e) {
            log.error((Object)"Naming exception thrown trying to get the UrlContent content", (Throwable)e);
            throw new EJBException((Exception)e);
        }
        catch (FinderException e) {
            log.debug((Object)"Threw Finder exception");
        }
    }

    public URLContentLocal createContent(String toolType, String title, String body, long taskInstanceId) throws CreateException, NamingException {
        URLContentLocal urlContent = URLContentUtil.getLocalHome().create();
        urlContent.setTitle(title);
        urlContent.setDescription(body);
        urlContent.setTaskInstanceId(taskInstanceId);
        urlContent.setToolType(toolType);
        urlContent.setDefineLater(new Boolean(false));
        urlContent.setLearnerSubmissionRuntimeURL(false);
        urlContent.setStaffSubmissionRuntimeURL(false);
        urlContent.setLearnerSubmissionRuntimeFile(false);
        urlContent.setStaffSubmissionRuntimeFile(false);
        return urlContent;
    }

    public URLContentLocal createContent(Content content, long taskInstanceId) throws CreateException, NamingException {
        URLContentLocal urlContent = URLContentUtil.getLocalHome().create();
        urlContent.setTitle(content.getTitle());
        urlContent.setDescription(content.getBody());
        urlContent.setTaskInstanceId(taskInstanceId);
        urlContent.setDefineLater(content.isDefineLater());
        urlContent.setLearnerSubmissionRuntimeURL(false);
        urlContent.setStaffSubmissionRuntimeURL(false);
        urlContent.setLearnerSubmissionRuntimeFile(false);
        urlContent.setStaffSubmissionRuntimeFile(false);
        URLEntryLocal urlItem = URLEntryUtil.getLocalHome().create();
        urlItem.setShowButtons(false);
        urlItem.setOrderIndex(1);
        urlItem.setTitle(content.getBody());
        urlItem.setURL(content.getBody());
        urlItem.setTaskInstanceId(taskInstanceId);
        urlContent.getEntries().add(urlItem);
        return urlContent;
    }

    private URLContentLocal createContent(UrlContent inputContent, long taskInstanceId) throws CreateException, NamingException {
        URLContentLocal urlContent = URLContentUtil.getLocalHome().create();
        urlContent.setTitle(inputContent.getTitle());
        urlContent.setDescription(inputContent.getBody());
        urlContent.setTaskInstanceId(taskInstanceId);
        urlContent.setMinNumToComplete(inputContent.getMinNumToComplete());
        urlContent.setDefineLater(inputContent.isDefineLater());
        urlContent.setLearnerSubmissionRuntimeURL(inputContent.isRuntimeSubmissionLearnerURL());
        urlContent.setStaffSubmissionRuntimeURL(inputContent.isRuntimeSubmissionStaffURL());
        urlContent.setLearnerSubmissionRuntimeFile(inputContent.isRuntimeSubmissionLearnerFile());
        urlContent.setStaffSubmissionRuntimeFile(inputContent.isRuntimeSubmissionStaffFile());
        if (inputContent.getUrls() != null) {
            Iterator iter = inputContent.getUrls().iterator();
            while (iter.hasNext()) {
                UrlContentEntry element = (UrlContentEntry)iter.next();
                URLEntryLocal urlItem = this.createURLEntry(element, taskInstanceId, null, null);
                urlContent.addEntry(urlItem);
            }
        }
        return urlContent;
    }

    private URLEntryLocal createURLEntry(UrlContentEntry inputUrlEntry, long taskInstanceId, Long userId, String username) throws CreateException, NamingException {
        if (inputUrlEntry == null) {
            return null;
        }
        URLEntryLocal urlItem = URLEntryUtil.getLocalHome().create();
        urlItem.setOrderIndex(inputUrlEntry.getViewOrder());
        urlItem.setTitle(inputUrlEntry.getTitle());
        urlItem.setURL(inputUrlEntry.getUrl());
        urlItem.setTaskInstanceId(taskInstanceId);
        urlItem.setContributerUserId(userId);
        urlItem.setContributerUsername(username);
        urlItem.setPreferDownload(inputUrlEntry.isPreferDownload());
        urlItem.setShowButtons(inputUrlEntry.isShowButtons());
        int maxOrderIndex = -1;
        if (inputUrlEntry.getInstructions() != null) {
            Iterator instructIter = inputUrlEntry.getInstructions().iterator();
            while (instructIter.hasNext()) {
                UrlContentEntryInstruction instruction = (UrlContentEntryInstruction)instructIter.next();
                URLEntryInstructionLocal instructionItem = URLEntryInstructionUtil.getLocalHome().create();
                instructionItem.setOrderIndex(instruction.getViewOrder());
                instructionItem.setText(instruction.getInstruction());
                maxOrderIndex = Math.max(maxOrderIndex, instruction.getViewOrder());
                urlItem.getInstructions().add(instructionItem);
            }
        }
        urlItem.setMaxOrderIndex(maxOrderIndex);
        return urlItem;
    }

    private URLEntryLocal createURLEntry(String url, String title, String instruction, long taskInstanceId, Long userId, String username, boolean preferDownload) throws CreateException, NamingException {
        URLEntryLocal urlItem = URLEntryUtil.getLocalHome().create();
        urlItem.setTitle(title);
        urlItem.setURL(url);
        urlItem.setTaskInstanceId(taskInstanceId);
        urlItem.setContributerUserId(userId);
        urlItem.setContributerUsername(username);
        urlItem.setOrderIndex(-1);
        urlItem.setPreferDownload(preferDownload);
        if (instruction != null && instruction.length() > 0) {
            URLEntryInstructionLocal instructionItem = URLEntryInstructionUtil.getLocalHome().create();
            instructionItem.setOrderIndex(0);
            instructionItem.setText(instruction);
            urlItem.getInstructions().add(instructionItem);
            urlItem.setMaxOrderIndex(0);
        }
        return urlItem;
    }

    public void createLearners(GroupData group, URLContentLocal urlContent) throws CreateException, NamingException {
        if (group == null || group.getMembers() == null) {
            return;
        }
        Iterator iter = group.getMembers().keySet().iterator();
        while (iter.hasNext()) {
            Long userId = (Long)iter.next();
            URLLearnerLocal learner = URLLearnerUtil.getLocalHome().create();
            learner.setUserId(userId);
            urlContent.getLearners().add(learner);
        }
    }

    public void createSession(AbstractTaskVO task, TaskInstanceData taskInstance, GroupData group, String outputContentDestination, Long inputContentId, Long outputContentId) throws ToolException, SystemException {
        try {
            Content content = null;
            if (inputContentId != null) {
                content = ContentServiceDelegate.getContent(inputContentId);
            }
            this.createSession((SimpleTaskVO)task, taskInstance, group, outputContentId, content);
        }
        catch (ControllerException e) {
            this.getSessionContext().setRollbackOnly();
            throw new ToolException(e);
        }
        catch (Exception e) {
            this.getSessionContext().setRollbackOnly();
            e.printStackTrace();
            throw new SystemException(e);
        }
    }

    public URLContentData getGeneralInfo(int taskInstanceId, long userId) throws URLContentException {
        log.debug((Object)("getGeneralInfo: taskInstanceId " + taskInstanceId + " userId " + userId));
        URLContentLocal urlContent = this.getUrlContentLocal(taskInstanceId);
        if (urlContent == null) {
            log.error((Object)("getGeneralInfo: no urlContent task information found '" + taskInstanceId + "'"));
            throw new URLContentException("No information for this task found");
        }
        return urlContent.getData();
    }

    public SortedSet getURLSet(int taskInstanceId, long userId) throws URLContentException {
        log.debug((Object)("getLearnerList: taskInstanceId " + taskInstanceId + " userId " + userId));
        URLContentLocal urlContent = null;
        urlContent = this.getUrlContentLocal(taskInstanceId);
        if (urlContent == null) {
            log.error((Object)("getLearnerList: no urlContent task information found '" + taskInstanceId + "'"));
            throw new URLContentException("No information for this task found");
        }
        URLLearnerLocal learner = urlContent.getLearner(userId);
        return URLContentDTOFactory.createLearnerEntriesSet(urlContent.getEntries(), learner);
    }

    public URLData getURLDetails(int taskInstanceId, long userId, int entrySid, int desiredInstructionNumber) throws URLContentException {
        log.debug((Object)("getURLDetails: taskInstanceId " + taskInstanceId + " entrySid " + entrySid));
        URLContentLocal urlContent = this.getUrlContentLocal(taskInstanceId);
        if (urlContent == null) {
            log.error((Object)("submitURL: no urlContent task information found '" + taskInstanceId + "'"));
            throw new URLContentException("No information for this task found");
        }
        URLLearnerLocal learner = urlContent.getLearner(userId);
        URLEntryLocal urlEntry = this.getURLEntryLocal(taskInstanceId, entrySid);
        if (urlEntry == null) {
            log.error((Object)("getURLDetails: no url entry found with sid '" + entrySid + "'"));
            throw new URLContentException("No information for this URL found");
        }
        boolean done = learner != null ? learner.isEntryDone(urlEntry.getSid()) : false;
        return URLContentDTOFactory.createURLData(urlEntry, done, desiredInstructionNumber);
    }

    public String getURL(int taskInstanceId, int entrySid) throws URLContentException {
        log.debug((Object)("getURL: taskInstanceId " + taskInstanceId + " entrySid " + entrySid));
        URLEntryLocal urlEntry = this.getURLEntryLocal(taskInstanceId, entrySid);
        if (urlEntry == null) {
            log.error((Object)("getURLDetails: no url entry found with sid '" + entrySid + "'"));
            throw new URLContentException("No information for this URL found");
        }
        return urlEntry.getURL();
    }

    public void submitURL(int taskInstanceId, long userId, String username, String url, String title, String instruction, boolean isFileUrl) throws URLContentException {
        log.debug((Object)("submitURL: newEntry " + url));
        URLContentLocal urlContent = this.getUrlContentLocal(taskInstanceId);
        if (urlContent == null) {
            log.error((Object)("submitURL: no urlContent task information found '" + taskInstanceId + "'"));
            throw new URLContentException("No information for this task found");
        }
        URLEntryLocal urlEntry = null;
        try {
            urlEntry = this.createURLEntry(url, title, instruction, taskInstanceId, new Long(userId), username, isFileUrl);
            urlContent.addEntry(urlEntry);
        }
        catch (NamingException e) {
            log.error((Object)"Exception occured", (Throwable)e);
            throw new EJBException((Exception)e);
        }
        catch (CreateException e) {
            log.error((Object)"Exception occured", (Throwable)e);
            throw new EJBException((Exception)((Object)e));
        }
    }

    public void setEntryDone(int taskInstanceId, long userId, int entrySid) throws URLContentException {
        log.debug((Object)("setEntryDone: entrySid " + entrySid));
        URLContentLocal urlContent = this.getUrlContentLocal(taskInstanceId);
        if (urlContent == null) {
            log.error((Object)("submitURL: no urlContent task information found '" + taskInstanceId + "'"));
            throw new URLContentException("No information for this task found");
        }
        URLLearnerLocal learner = urlContent.getLearner(userId);
        if (learner == null) {
            log.error((Object)("submitURL: no learner found: task '" + taskInstanceId + "' user id '" + userId + "'"));
            throw new URLContentException("No information for this task found");
        }
        learner.addDoneId(entrySid);
    }

    private boolean isEnoughDone(int taskInstanceId, long userId) throws URLContentException {
        log.debug((Object)("areAllDone: taskInstanceId " + taskInstanceId + " userId " + userId));
        URLContentLocal urlContent = this.getUrlContentLocal(taskInstanceId);
        if (urlContent == null) {
            log.error((Object)("areAllDone: no urlContent task information found '" + taskInstanceId + "'"));
            throw new URLContentException("No information for this task found.");
        }
        URLLearnerLocal learner = urlContent.getLearner(userId);
        if (learner == null) {
            log.error((Object)("areAllDone: No matching learner found for task " + taskInstanceId + " user id " + userId + ". Unable to complete"));
            throw new URLContentException("User is not part of this task group.");
        }
        int numDone = learner != null ? learner.getNumEntriesDone() : 0;
        return numDone >= urlContent.getMinNumToComplete();
    }

    private URLLearnerLocal createLearner(URLContentLocal urlContent, long userId) throws URLContentException {
        try {
            URLLearnerLocal learner = URLLearnerUtil.getLocalHome().create();
            learner.setUserId(userId);
            urlContent.getLearners().add(learner);
            return learner;
        }
        catch (NamingException e) {
            throw new URLContentException("failed to create learner: " + e.getMessage());
        }
        catch (CreateException e) {
            throw new URLContentException("failed to create learner: " + e.getMessage());
        }
    }

    public URLLearnerData getLearner(int taskInstanceId, long userId) throws URLContentException {
        log.debug((Object)("getLearner: taskInstanceId " + taskInstanceId + " userId " + userId));
        URLContentLocal urlContent = this.getUrlContentLocal(taskInstanceId);
        if (urlContent == null) {
            log.error((Object)("areAllDone: no urlContent task information found '" + taskInstanceId + "'"));
            throw new URLContentException("No information for this task found.");
        }
        URLLearnerLocal learner = urlContent.getLearner(userId);
        if (learner == null) {
            learner = this.createLearner(urlContent, userId);
        }
        return learner.getData();
    }

    public DisplayTaskData completeSession(int taskInstanceId, long userId) throws URLContentException, EJBException {
        DisplayTaskData displayTaskData = null;
        if (!this.isEnoughDone(taskInstanceId, userId)) {
            throw new URLContentException("Not enough pages have been viewed so you may not finish yet!");
        }
        try {
            displayTaskData = LearnerServiceDelegate.moveToNextTask(taskInstanceId, userId);
        }
        catch (TaskInstanceNotFoundException e) {
            throw new URLContentException("Task Instance not found: " + taskInstanceId, e);
        }
        catch (ControllerException e) {
            throw new URLContentException("Controller reported an error", e);
        }
        catch (SystemException e) {
            throw e;
        }
        return displayTaskData;
    }

    private void notifyStaffUrl(long taskInstanceId, String title, String toolType) {
        String toolpath = URLContentAction.getStaffPath(taskInstanceId);
        NotifyStaffUrlThread notify = new NotifyStaffUrlThread(taskInstanceId, title, toolType, toolpath);
        notify.start();
    }

    public void deleteSession(TaskInstance taskInstance, Long inputContentId, Long outputContentId) throws ToolException, SystemException {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

