/*
 * Decompiled with CFR 0.152.
 */
package com.webmcq.ld.tool.survey.web;

import com.webmcq.ld.service.UserNotFoundException;
import com.webmcq.ld.service.UserServiceDelegate;
import com.webmcq.ld.tool.survey.entity.SurQuestionVO;
import com.webmcq.ld.tool.survey.entity.SurSurveyVO;
import com.webmcq.ld.util.WebUtil;
import com.webmcq.ld.util.exception.SystemException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessage;
import org.apache.struts.validator.DynaValidatorForm;

public class QuestionnaireForm
extends DynaValidatorForm {
    private static final String PARAM_RESET = "reset";
    private static final String PARAM_VALIDATE = "validate";
    private static final boolean OPTIONAL = true;
    private static final String PARAM_MODE = "mode";

    public void reset(ActionMapping mapping, HttpServletRequest request) {
        if (this.shouldWeReset(request)) {
            this.resetSurveyQuestions();
        }
    }

    public void resetSurveyQuestions() {
        ArrayList questions = (ArrayList)this.get("surveyQuestions");
        ArrayList<SurQuestionVO> newQuestions = new ArrayList<SurQuestionVO>();
        Iterator i = questions.iterator();
        while (i.hasNext()) {
            SurQuestionVO q = (SurQuestionVO)i.next();
            q.setUserResponses(new String[0]);
            q.setOtherResponse("");
            newQuestions.add(q);
        }
        this.set("surveyQuestions", newQuestions);
    }

    public ActionErrors validate(ActionMapping mapping, HttpServletRequest request) {
        ActionErrors errors = new ActionErrors();
        if (this.shouldWeValidate(request)) {
            this.checkForCompulsoryQuestions("error.question.compulsory", (ArrayList)super.get("surveyQuestions"), errors);
            this.checkForSimpleChoiceQuestion("error.response.invalid", (ArrayList)super.get("surveyQuestions"), errors);
        }
        return errors;
    }

    private void checkForCompulsoryQuestions(String fieldKey, ArrayList questions, ActionErrors errors) {
        StringBuffer errorMsg = new StringBuffer();
        Iterator i = questions.iterator();
        while (i.hasNext()) {
            SurQuestionVO q = (SurQuestionVO)i.next();
            if (!this.isEmptyResForCompulsoryQues(q)) continue;
            errorMsg.append("Question [" + q.getDisplayOrder() + "] ");
        }
        if (errorMsg.length() != 0) {
            ActionMessage error = new ActionMessage("error.question.compulsory", (Object)errorMsg);
            errors.add(fieldKey, error);
        }
    }

    private void checkForSimpleChoiceQuestion(String fieldKey, ArrayList questions, ActionErrors errors) {
        Iterator i = questions.iterator();
        while (i.hasNext()) {
            SurQuestionVO q = (SurQuestionVO)i.next();
            if (!q.getQuestionType().equals("simpleChoice") || !this.isMultipleRespForSimpleChoice(q)) continue;
            ActionMessage error = new ActionMessage("error.response.invalid", (Object)("Question [" + q.getDisplayOrder() + "] "));
            errors.add(fieldKey, error);
        }
    }

    public void buildQuestionnaireForm(String username, SurSurveyVO survey) {
        if (survey == null || survey.getSurQuestions() == null) {
            throw new SystemException("The requested survey is not available in the database.");
        }
        try {
            BeanUtils.copyProperties((Object)((Object)this), (Object)survey);
            survey.setUpStrutsQuestionResponse(username);
            ArrayList<Object> surveyQuestions = new ArrayList<Object>(Arrays.asList(survey.getSurQuestions().toArray()));
            this.set("surveyQuestions", surveyQuestions);
        }
        catch (IllegalAccessException e) {
            throw new SystemException("IllegalAccessException occured when the survey is building questionnaire form", e);
        }
        catch (InvocationTargetException e) {
            throw new SystemException("InvocationTargetException occured when the survey is building questionnaire form", e);
        }
        this.set("startDate", new Date(System.currentTimeMillis()).toString());
    }

    public List buildUserResponseVO(HttpServletRequest request) {
        ArrayList questions = (ArrayList)this.get("surveyQuestions");
        if (!this.isQuestionReady(questions)) {
            throw new SystemException("Fail to get responses from users;");
        }
        ArrayList responses = new ArrayList();
        try {
            long userId = UserServiceDelegate.findUserId(WebUtil.getUsername(request));
            Iterator i = questions.iterator();
            while (i.hasNext()) {
                SurQuestionVO q = (SurQuestionVO)i.next();
                responses.addAll(q.getUserResponsesAsList(userId, WebUtil.getUsername(request)));
            }
        }
        catch (UserNotFoundException e) {
            throw new SystemException("UserNotFoundException occured in buildUserResponseVO", e);
        }
        return responses;
    }

    private boolean isEmptyResForCompulsoryQues(SurQuestionVO q) {
        if (q.getIsOptional() == 0) {
            if (q.getOtherResponse() == null && q.getUserResponses().length == 0) {
                return true;
            }
            if (q.getUserResponses().length == 0 && q.getOtherResponse().trim().equals("")) {
                return true;
            }
        }
        return false;
    }

    private boolean isMultipleRespForSimpleChoice(SurQuestionVO question) {
        if (question.getUserResponses().length > 2) {
            return true;
        }
        return question.getUserResponses().length > 0 && question.isOtherResponseAvailable();
    }

    private boolean isQuestionReady(ArrayList questions) {
        return questions != null && questions.size() != 0;
    }

    private boolean isResumeMode(HttpServletRequest request) {
        String mode = WebUtil.readStrParam(request, PARAM_MODE, true);
        return mode != null && mode.equals("resume");
    }

    private boolean shouldWeReset(HttpServletRequest request) {
        String reset = WebUtil.readStrParam(request, PARAM_RESET, true);
        if (this.isResumeMode(request)) {
            return false;
        }
        return reset == null || reset.equals("true");
    }

    private boolean shouldWeValidate(HttpServletRequest request) {
        String validate = WebUtil.readStrParam(request, PARAM_VALIDATE, true);
        return validate != null && validate.equals("true");
    }
}

