/*
 * Decompiled with CFR 0.152.
 */
package com.webmcq.ld.tool.simpleassessment.web;

import com.webmcq.ld.controller.ControllerException;
import com.webmcq.ld.controller.DisplayTaskData;
import com.webmcq.ld.controller.web.ToolAction;
import com.webmcq.ld.service.UserServiceDelegate;
import com.webmcq.ld.tool.StaffMonitorNotifier;
import com.webmcq.ld.tool.simpleassessment.MarkFileBuilder;
import com.webmcq.ld.tool.simpleassessment.dto.AnswerResult;
import com.webmcq.ld.tool.simpleassessment.dto.AttemptData;
import com.webmcq.ld.tool.simpleassessment.dto.MarkSummaryData;
import com.webmcq.ld.tool.simpleassessment.interfaces.QuestionInfoData;
import com.webmcq.ld.tool.simpleassessment.interfaces.SimpleAssessmentService;
import com.webmcq.ld.tool.simpleassessment.interfaces.SimpleAssessmentServiceUtil;
import com.webmcq.ld.usermanagement.UserRole;
import com.webmcq.ld.util.DownloadFile;
import com.webmcq.ld.util.WebUtil;
import com.webmcq.ld.util.exception.BusinessException;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.ejb.CreateException;
import javax.ejb.EJBException;
import javax.naming.NamingException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class SimpleAssessmentAction
extends ToolAction {
    public static final String TOOL_TYPE = "simpleassessment";
    public static final String JSP_TASK_INSTANCE_ID_TAG = "sessionId";
    public static final String JSP_INFO_TAG = "info";
    public static final String JSP_QUESTION_SET_TAG = "questionset";
    public static final String JSP_QUESTION_MAP_TAG = "questionmap";
    public static final String JSP_ATTEMPT_NO_TAG = "attemptno";
    public static final String JSP_PREVIOUS_RESULTS_TAG = "prevresults";
    public static final String JSP_BEST_RESULTS_TAG = "bestresults";
    public static final String JSP_SHOW_FINISHED_TAG = "showFinished";
    public static final String JSP_SHOW_REDO_TAG = "showRedo";
    public static final String JSP_SUMMARY_TAG = "summary";
    public static final String JSP_DOWNLOAD_TAG = "download";
    public static final String JSP_COMPLETION_MESSAGE_TAG = "completionmessage";
    public static final String JSP_ERROR_TAG = "error";
    public static final String JSP_ANSWER_START_TAG = "answer_";
    public static final int JSP_ANSWER_TAG_ANSWER_INDEX_LENGTH = 7;
    public static String JSP_MODE_TAG = "mode";
    public static String STUDENT_ID_TAG = "userId";
    private static Logger log = Logger.getLogger((Class)(class$com$webmcq$ld$tool$simpleassessment$web$SimpleAssessmentAction == null ? (class$com$webmcq$ld$tool$simpleassessment$web$SimpleAssessmentAction = SimpleAssessmentAction.class$("com.webmcq.ld.tool.simpleassessment.web.SimpleAssessmentAction")) : class$com$webmcq$ld$tool$simpleassessment$web$SimpleAssessmentAction));
    static /* synthetic */ Class class$com$webmcq$ld$tool$simpleassessment$web$SimpleAssessmentAction;

    public ActionForward dispatch(ActionMapping mapping, ActionForm form, HttpServletRequest req, HttpServletResponse res) throws ServletException {
        String mode = WebUtil.readStrParam(req, JSP_MODE_TAG);
        log.debug((Object)("access: mode: " + mode));
        if ("run".equals(mode) || "resume".equals(mode)) {
            return this.checkNewAssessment(mapping, form, req, res);
        }
        if ("view".equals(mode)) {
            return this.viewAssessment(mapping, form, req, res);
        }
        if ("checkup".equals(mode)) {
            long studentId = WebUtil.readLongParam(req, STUDENT_ID_TAG);
            return this.doViewAttempt(mapping, form, req, res, null, null, studentId, mode);
        }
        log.error((Object)("unrecognized access mode: '" + mode + "'"));
        return mapping.findForward(JSP_ERROR_TAG);
    }

    public ActionForward viewAssessment(ActionMapping mapping, ActionForm form, HttpServletRequest req, HttpServletResponse res) throws ServletException {
        try {
            log.debug((Object)"viewAssessment");
            SimpleAssessmentService service = SimpleAssessmentServiceUtil.getHome().create();
            return this.doViewAttempt(mapping, form, req, res, service, null, this.getUserId(req), req.getParameter(JSP_MODE_TAG));
        }
        catch (Exception e) {
            log.error((Object)"viewAssessment: Exception occured", (Throwable)e);
            return mapping.findForward(JSP_ERROR_TAG);
        }
    }

    public ActionForward getNewAssessment(ActionMapping mapping, ActionForm form, HttpServletRequest req, HttpServletResponse res) throws ServletException {
        log.debug((Object)"getNewAssessment");
        try {
            return this.doNewAssessment(mapping, form, req, res, null);
        }
        catch (Exception e) {
            log.error((Object)"getNewAssessment: Exception occured", (Throwable)e);
            return mapping.findForward(JSP_ERROR_TAG);
        }
    }

    public ActionForward saveAssessment(ActionMapping mapping, ActionForm form, HttpServletRequest req, HttpServletResponse res) throws ServletException {
        try {
            int taskInstanceId = WebUtil.readIntParam(req, JSP_TASK_INSTANCE_ID_TAG);
            String username = WebUtil.getUsername(req);
            long userId = UserServiceDelegate.findUserId(username);
            SimpleAssessmentService service = SimpleAssessmentServiceUtil.getHome().create();
            ArrayList<AnswerResult> newAnswers = new ArrayList<AnswerResult>();
            boolean errorOccured = false;
            Iterator paramKeyIterator = req.getParameterMap().keySet().iterator();
            while (paramKeyIterator.hasNext()) {
                String key = (String)paramKeyIterator.next();
                if (!key.startsWith(JSP_ANSWER_START_TAG)) continue;
                String sidString = key.substring(7);
                log.debug((Object)("tag " + key + " has sid string " + sidString));
                int sid = -1;
                try {
                    sid = Integer.parseInt(sidString);
                }
                catch (NumberFormatException e) {
                    log.error((Object)("Unable to get question sid from answer tag. Answer was " + key + "=" + req.getParameter(key)));
                    errorOccured = true;
                }
                newAnswers.add(new AnswerResult(sid, req.getParameter(key)));
            }
            AttemptData attempt = service.saveAttempt(taskInstanceId, userId, username, newAnswers);
            if (errorOccured || attempt == null) {
                return mapping.findForward(JSP_ERROR_TAG);
            }
            QuestionInfoData info = service.getQuestionInfoByTaskInstance(taskInstanceId);
            if (info == null) {
                log.error((Object)("No question information available for task " + taskInstanceId));
                info = this.createDummyInfo(taskInstanceId);
            }
            this.notifyAssessments(info, req.getServerPort());
            return this.doViewAttempt(mapping, form, req, res, service, info, this.getUserId(req), req.getParameter(JSP_MODE_TAG));
        }
        catch (Exception e) {
            log.error((Object)"saveAssessment: Exception occured", (Throwable)e);
            return mapping.findForward(JSP_ERROR_TAG);
        }
    }

    public ActionForward getSummaryData(ActionMapping mapping, ActionForm form, HttpServletRequest req, HttpServletResponse res) throws ServletException {
        try {
            AttemptData bestAttempt;
            MarkSummaryData summary;
            int taskInstanceId = WebUtil.readIntParam(req, JSP_TASK_INSTANCE_ID_TAG);
            log.debug((Object)("getSummaryData taskInstanceId: " + taskInstanceId));
            long userId = this.getUserId(req);
            String mode = req.getParameter(JSP_MODE_TAG);
            SimpleAssessmentService service = SimpleAssessmentServiceUtil.getHome().create();
            QuestionInfoData info = service.getQuestionInfoByTaskInstance(taskInstanceId);
            if (info == null) {
                log.error((Object)("No question information available for task " + taskInstanceId));
                info = this.createDummyInfo(taskInstanceId);
            }
            if ((summary = service.getMarkSummary(taskInstanceId, false)) == null) {
                log.error((Object)("No summary information available for task " + taskInstanceId));
                summary = this.createDummySummary(taskInstanceId);
            }
            if ((bestAttempt = service.getBestAttempt(taskInstanceId, userId)) == null) {
                log.error((Object)("No attempt information available for task " + taskInstanceId));
                bestAttempt = this.createDummyAttempt(userId);
            }
            req.setAttribute(JSP_INFO_TAG, (Object)info);
            req.setAttribute(JSP_SUMMARY_TAG, (Object)summary);
            req.setAttribute(JSP_MODE_TAG, (Object)mode);
            req.setAttribute(JSP_SHOW_FINISHED_TAG, (Object)new Boolean(this.canFinish(bestAttempt.getMark(), info.getMinPassMark(), mode, info.getAllowRedo())));
            req.setAttribute(JSP_SHOW_REDO_TAG, (Object)new Boolean(this.canRedo(info.getAllowRedo(), mode)));
            int totalMark = info.getTotalMark() != null ? info.getMinPassMark() : 0;
            req.setAttribute(JSP_COMPLETION_MESSAGE_TAG, (Object)this.getCompletionMessage(bestAttempt.getMark(), info.getMinPassMark(), totalMark));
            WebUtil.saveToken(req, "transactionKeySimpleAssessment", this.generateToken(req));
            return mapping.findForward(JSP_SUMMARY_TAG);
        }
        catch (Exception e) {
            log.error((Object)"getSummaryData: Exception occured", (Throwable)e);
            throw new ServletException(e.getMessage());
        }
    }

    public ActionForward getMonitorSummary(ActionMapping mapping, ActionForm form, HttpServletRequest req, HttpServletResponse res) throws ServletException {
        try {
            MarkSummaryData summary;
            int taskInstanceId = WebUtil.readIntParam(req, JSP_TASK_INSTANCE_ID_TAG);
            log.debug((Object)("getMonitorSummary taskInstanceId: " + taskInstanceId));
            ActionForward errorScreen = this.checkAuthorised(mapping, req);
            if (errorScreen != null) {
                return errorScreen;
            }
            SimpleAssessmentService service = SimpleAssessmentServiceUtil.getHome().create();
            QuestionInfoData info = service.getQuestionInfoByTaskInstance(taskInstanceId);
            if (info == null) {
                log.error((Object)("No question information available for task " + taskInstanceId));
                info = this.createDummyInfo(taskInstanceId);
            }
            if ((summary = service.getMarkSummary(taskInstanceId, true)) == null) {
                log.error((Object)("No summary information available for task " + taskInstanceId));
                summary = this.createDummySummary(taskInstanceId);
            }
            req.setAttribute(JSP_INFO_TAG, (Object)info);
            req.setAttribute(JSP_SUMMARY_TAG, (Object)summary);
            req.setAttribute(JSP_MODE_TAG, (Object)req.getParameter(JSP_MODE_TAG));
            return mapping.findForward("monitorsummary");
        }
        catch (Exception e) {
            log.error((Object)"getMonitorSummary: Exception occured", (Throwable)e);
            throw new ServletException(e.getMessage());
        }
    }

    public ActionForward getAllMarksAsCSV(ActionMapping mapping, ActionForm form, HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        try {
            ActionForward errorScreen = this.checkAuthorised(mapping, req);
            if (errorScreen != null) {
                return errorScreen;
            }
            int taskInstanceId = WebUtil.readIntParam(req, JSP_TASK_INSTANCE_ID_TAG);
            SimpleAssessmentService service = SimpleAssessmentServiceUtil.getHome().create();
            QuestionInfoData info = service.getQuestionInfoByTaskInstance(taskInstanceId);
            MarkSummaryData summary = service.getMarkSummary(taskInstanceId, true);
            if (info == null || summary == null) {
                log.error((Object)("getAllMarksAsCSV: Information missing for task " + taskInstanceId + " info " + info + " summary " + summary));
                return mapping.findForward(JSP_ERROR_TAG);
            }
            MarkFileBuilder factory = new MarkFileBuilder();
            String downloadFilename = factory.createFile(info, summary, this.getUserId(req));
            req.setAttribute(JSP_MODE_TAG, (Object)req.getParameter(JSP_MODE_TAG));
            req.setAttribute(JSP_INFO_TAG, (Object)info);
            req.setAttribute(JSP_DOWNLOAD_TAG, (Object)downloadFilename);
            return mapping.findForward(JSP_DOWNLOAD_TAG);
        }
        catch (CreateException e) {
            throw new ServletException(e.getMessage());
        }
        catch (NamingException e) {
            throw new ServletException(e.getMessage());
        }
        catch (IOException e) {
            log.error((Object)"IO exception thrown", (Throwable)e);
            throw new ServletException(e.getMessage());
        }
        catch (Exception e) {
            log.error((Object)"General exception thrown", (Throwable)e);
            throw new ServletException(e.getMessage());
        }
    }

    public ActionForward getFile(ActionMapping mapping, ActionForm form, HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        try {
            String downloadFilename = req.getParameter(JSP_DOWNLOAD_TAG);
            ActionForward errorScreen = this.checkAuthorised(mapping, req);
            if (errorScreen != null) {
                return errorScreen;
            }
            int taskInstanceId = WebUtil.readIntParam(req, JSP_TASK_INSTANCE_ID_TAG);
            SimpleAssessmentService service = SimpleAssessmentServiceUtil.getHome().create();
            QuestionInfoData info = service.getQuestionInfoByTaskInstance(taskInstanceId);
            String username = null;
            username = WebUtil.getUsername(req);
            if (downloadFilename != null) {
                File fullpath = new File(downloadFilename);
                String dirName = info.getTaskDirectory();
                log.debug((Object)("Comparing download file " + fullpath.getParent() + " with " + dirName));
                if (fullpath.getParent() == null || !fullpath.getParent().equals(dirName)) {
                    log.error((Object)("Suspicious attempt to download a file - file not in our normal download paths: " + downloadFilename + " user " + username));
                } else {
                    String shortName = fullpath.getName();
                    DownloadFile.download(res, this.getServlet().getServletContext(), shortName, downloadFilename, null);
                    return null;
                }
            }
            return mapping.findForward(JSP_ERROR_TAG);
        }
        catch (CreateException e) {
            throw new ServletException(e.getMessage());
        }
        catch (NamingException e) {
            throw new ServletException(e.getMessage());
        }
        catch (IOException e) {
            log.error((Object)"IO exception thrown", (Throwable)e);
            throw new ServletException(e.getMessage());
        }
        catch (Exception e) {
            log.error((Object)"General exception thrown", (Throwable)e);
            throw new ServletException(e.getMessage());
        }
    }

    public ActionForward putComplete(ActionMapping mapping, ActionForm form, HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        log.debug((Object)"putComplete");
        try {
            int taskInstanceId = WebUtil.readIntParam(req, JSP_TASK_INSTANCE_ID_TAG);
            SimpleAssessmentService service = SimpleAssessmentServiceUtil.getHome().create();
            try {
                if (WebUtil.isTokenValid(req, "transactionKeySimpleAssessment")) {
                    WebUtil.resetToken(req, "transactionKeySimpleAssessment");
                    req.getSession().removeAttribute("transactionDoneSimpleAssessment");
                    DisplayTaskData displayTaskData = service.completeSession(taskInstanceId, this.getUserId(req));
                    ActionForward action = this.displayTask(displayTaskData, mapping, form, req, res);
                    req.getSession().setAttribute("transactionDoneSimpleAssessment", (Object)action);
                    return action;
                }
                return this.duplicateSubmission(mapping, req, "transactionDoneSimpleAssessment");
            }
            catch (BusinessException e) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"completeSession failed", (Throwable)e);
                }
                req.setAttribute(JSP_ERROR_TAG, (Object)e.getMessage());
                return mapping.findForward(JSP_ERROR_TAG);
            }
        }
        catch (Exception e) {
            log.error((Object)"putComplete: Exception occured", (Throwable)e);
            return mapping.findForward(JSP_ERROR_TAG);
        }
    }

    private long getUserId(HttpServletRequest req) throws ServletException {
        try {
            String username = WebUtil.getUsername(req);
            return UserServiceDelegate.findUserId(username);
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
    }

    private ActionForward checkAuthorised(ActionMapping mapping, HttpServletRequest req) throws Exception {
        boolean isStaff = req.isUserInRole(UserRole.STAFF.getName());
        if (!isStaff) {
            log.error((Object)("Suspicious attempt to view marks for assessment - user not entitled to so. User " + WebUtil.getUsername(req)));
            return mapping.findForward(JSP_ERROR_TAG);
        }
        return null;
    }

    private QuestionInfoData createDummyInfo(int taskInstanceId) {
        QuestionInfoData data = new QuestionInfoData();
        data.setDescription("No information found");
        data.setSid(-1);
        data.setTaskInstanceId(taskInstanceId);
        data.setTitle("Questions Missing");
        data.setTotalMark(new Integer(0));
        return data;
    }

    private AttemptData createDummyAttempt(long userId) {
        AttemptData data = new AttemptData();
        data.setAnswers(new TreeSet());
        data.setAttemptCount(0);
        data.setMark(new Integer(0));
        data.setSid(-1);
        data.setSubmittedDate(null);
        data.setUserId(userId);
        return data;
    }

    private MarkSummaryData createDummySummary(long userId) {
        return new MarkSummaryData(new TreeMap(), new Integer(0), 0, 0, 0, 0, 0);
    }

    private boolean canFinish(Integer mark, int passMark, String mode, boolean redoAllowed) {
        log.debug((Object)("Can finish: checking mark" + mark + " passMark " + passMark + " mode " + mode));
        return ("run".equals(mode) || "resume".equals(mode)) && mark != null && mark >= passMark;
    }

    private boolean canRedo(boolean redoAllowed, String mode) {
        log.debug((Object)("canRedo: checking redoAllowed" + redoAllowed + " mode " + mode));
        return redoAllowed && ("run".equals(mode) || "resume".equals(mode));
    }

    private String getCompletionMessage(Integer mark, int passMark, int totalMark) {
        log.debug((Object)("getCompletionMessage: checking mark" + mark + " passMark " + passMark + " totalMark " + totalMark));
        if (passMark > 0 && mark != null && mark < passMark) {
            return "Must get at least " + passMark + " out of " + totalMark + " to finish.";
        }
        return "";
    }

    public ActionForward checkNewAssessment(ActionMapping mapping, ActionForm form, HttpServletRequest req, HttpServletResponse res) throws ServletException {
        try {
            String mode = WebUtil.readStrParam(req, JSP_MODE_TAG);
            int taskInstanceId = WebUtil.readIntParam(req, JSP_TASK_INSTANCE_ID_TAG);
            SimpleAssessmentService service = SimpleAssessmentServiceUtil.getHome().create();
            long userId = this.getUserId(req);
            AttemptData bestAttempt = service.getBestAttempt(taskInstanceId, userId);
            if (bestAttempt == null) {
                return this.doNewAssessment(mapping, form, req, res, service);
            }
            QuestionInfoData info = service.getQuestionInfoByTaskInstance(taskInstanceId);
            if (info == null) {
                log.error((Object)("No question information available for task " + taskInstanceId));
                info = this.createDummyInfo(taskInstanceId);
            }
            if (info.getAllowRedo()) {
                req.setAttribute(JSP_BEST_RESULTS_TAG, (Object)bestAttempt);
                req.setAttribute(JSP_MODE_TAG, (Object)mode);
                req.setAttribute(JSP_INFO_TAG, (Object)info);
                return mapping.findForward("checkRedoAssessment");
            }
            return this.doViewAttempt(mapping, form, req, res, service, info, userId, mode);
        }
        catch (Exception e) {
            log.error((Object)"getQuestions: Exception occured", (Throwable)e);
            return mapping.findForward(JSP_ERROR_TAG);
        }
    }

    private ActionForward doNewAssessment(ActionMapping mapping, ActionForm form, HttpServletRequest req, HttpServletResponse res, SimpleAssessmentService inputService) throws ServletException {
        try {
            Set questions;
            int taskInstanceId = WebUtil.readIntParam(req, JSP_TASK_INSTANCE_ID_TAG);
            String mode = req.getParameter(JSP_MODE_TAG);
            log.debug((Object)("doNewAssessment taskInstanceId: " + taskInstanceId + " mode " + mode));
            SimpleAssessmentService service = inputService != null ? inputService : SimpleAssessmentServiceUtil.getHome().create();
            QuestionInfoData info = service.getQuestionInfoByTaskInstance(taskInstanceId);
            if (info == null) {
                log.error((Object)("No question information available for task " + taskInstanceId));
                info = this.createDummyInfo(taskInstanceId);
            }
            if ((questions = service.getSortedQuestionsByTaskInstance(taskInstanceId)) == null) {
                questions = new HashSet();
            }
            req.setAttribute(JSP_INFO_TAG, (Object)info);
            req.setAttribute(JSP_QUESTION_SET_TAG, (Object)questions);
            req.setAttribute(JSP_MODE_TAG, (Object)mode);
            return mapping.findForward("questions");
        }
        catch (Exception e) {
            log.error((Object)"doNewAssessment: Exception occured", (Throwable)e);
            throw new ServletException(e.getMessage());
        }
    }

    private ActionForward doViewAttempt(ActionMapping mapping, ActionForm form, HttpServletRequest req, HttpServletResponse res, SimpleAssessmentService inputService, QuestionInfoData inputInfo, long userId, String mode) throws ServletException {
        try {
            QuestionInfoData info;
            int taskInstanceId = WebUtil.readIntParam(req, JSP_TASK_INSTANCE_ID_TAG);
            log.debug((Object)("doViewAttempt: taskInstanceId: " + taskInstanceId));
            SimpleAssessmentService service = inputService != null ? inputService : SimpleAssessmentServiceUtil.getHome().create();
            QuestionInfoData questionInfoData = info = inputInfo != null ? inputInfo : service.getQuestionInfoByTaskInstance(taskInstanceId);
            if (info == null) {
                log.error((Object)("No question information available for task " + taskInstanceId));
                info = this.createDummyInfo(taskInstanceId);
            }
            AttemptData previousAttempt = service.getLastAttempt(taskInstanceId, userId);
            AttemptData bestAttempt = service.getBestAttempt(taskInstanceId, userId);
            if (previousAttempt != null) {
                req.setAttribute(JSP_PREVIOUS_RESULTS_TAG, (Object)previousAttempt);
                req.setAttribute(JSP_ATTEMPT_NO_TAG, (Object)new Integer(previousAttempt.getAttemptCount()));
                req.setAttribute(JSP_SHOW_FINISHED_TAG, (Object)new Boolean(this.canFinish(bestAttempt.getMark(), info.getMinPassMark(), mode, info.getAllowRedo())));
                int totalMark = info.getTotalMark() != null ? info.getTotalMark() : 0;
                req.setAttribute(JSP_COMPLETION_MESSAGE_TAG, (Object)this.getCompletionMessage(bestAttempt.getMark(), info.getMinPassMark(), totalMark));
                if (bestAttempt != null && previousAttempt.getAttemptCount() != bestAttempt.getAttemptCount()) {
                    req.setAttribute(JSP_BEST_RESULTS_TAG, (Object)bestAttempt);
                }
            } else {
                previousAttempt = this.createDummyAttempt(userId);
                req.setAttribute(JSP_PREVIOUS_RESULTS_TAG, (Object)previousAttempt);
                req.setAttribute(JSP_ATTEMPT_NO_TAG, (Object)new Integer(0));
                req.setAttribute(JSP_SHOW_FINISHED_TAG, (Object)new Boolean(false));
            }
            HashMap questions = service.getQuestionMapByTaskInstance(taskInstanceId);
            if (questions == null) {
                questions = new HashMap();
            }
            req.setAttribute(JSP_INFO_TAG, (Object)info);
            req.setAttribute(JSP_QUESTION_MAP_TAG, questions);
            req.setAttribute(JSP_MODE_TAG, (Object)mode);
            req.setAttribute(JSP_SHOW_REDO_TAG, (Object)new Boolean(this.canRedo(info.getAllowRedo(), mode)));
            WebUtil.saveToken(req, "transactionKeySimpleAssessment", this.generateToken(req));
            return mapping.findForward("answers");
        }
        catch (Exception e) {
            log.error((Object)"doViewAttempt: Exception occured", (Throwable)e);
            return mapping.findForward(JSP_ERROR_TAG);
        }
    }

    private void notifyAssessments(QuestionInfoData info, int portNo) {
        try {
            String toolpath = "tool/simpleassessment/simpleassessment.do?method=getMonitorSummary&sessionId=" + info.getTaskInstanceId();
            StaffMonitorNotifier.notifyControllerOfURL(info.getTaskInstanceId(), TOOL_TYPE, info.getTitle(), toolpath);
        }
        catch (ControllerException e) {
            throw new EJBException((Exception)e);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

