/*
 * Decompiled with CFR 0.152.
 */
package com.webmcq.ld.tool.simpleassessment;

import com.webmcq.ld.activities.AbstractTaskVO;
import com.webmcq.ld.content.Content;
import com.webmcq.ld.content.QuestionAnswerEntry;
import com.webmcq.ld.content.QuestionContent;
import com.webmcq.ld.content.QuestionEntry;
import com.webmcq.ld.controller.ControllerException;
import com.webmcq.ld.controller.DisplayTaskData;
import com.webmcq.ld.controller.TaskInstance;
import com.webmcq.ld.controller.dao.TaskInstanceNotFoundException;
import com.webmcq.ld.controller.dto.GroupData;
import com.webmcq.ld.controller.dto.TaskInstanceData;
import com.webmcq.ld.service.ConfigurationKeys;
import com.webmcq.ld.service.ContentServiceDelegate;
import com.webmcq.ld.service.LearnerServiceDelegate;
import com.webmcq.ld.service.interfaces.ConfigurationServiceLocal;
import com.webmcq.ld.service.interfaces.ConfigurationServiceUtil;
import com.webmcq.ld.tool.ToolException;
import com.webmcq.ld.tool.simpleassessment.dto.AnswerResult;
import com.webmcq.ld.tool.simpleassessment.dto.AttemptData;
import com.webmcq.ld.tool.simpleassessment.dto.MarkSummaryData;
import com.webmcq.ld.tool.simpleassessment.dto.SimpleAssessmentDTOFactory;
import com.webmcq.ld.tool.simpleassessment.interfaces.AnswerLocal;
import com.webmcq.ld.tool.simpleassessment.interfaces.AnswerUtil;
import com.webmcq.ld.tool.simpleassessment.interfaces.LearnerAttemptLocal;
import com.webmcq.ld.tool.simpleassessment.interfaces.LearnerAttemptUtil;
import com.webmcq.ld.tool.simpleassessment.interfaces.QuestionInfoData;
import com.webmcq.ld.tool.simpleassessment.interfaces.QuestionInfoLocal;
import com.webmcq.ld.tool.simpleassessment.interfaces.QuestionInfoUtil;
import com.webmcq.ld.tool.simpleassessment.interfaces.QuestionLocal;
import com.webmcq.ld.tool.simpleassessment.interfaces.QuestionUtil;
import com.webmcq.ld.util.BaseSessionBean;
import com.webmcq.ld.util.EJBUtil;
import com.webmcq.ld.util.exception.BusinessException;
import com.webmcq.ld.util.exception.SystemException;
import java.io.File;
import java.rmi.RemoteException;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import javax.ejb.CreateException;
import javax.ejb.EJBException;
import javax.ejb.FinderException;
import javax.naming.NamingException;
import org.apache.log4j.Logger;

public abstract class SimpleAssessmentServiceBean
extends BaseSessionBean {
    private static Logger log = Logger.getLogger((Class)(class$com$webmcq$ld$tool$simpleassessment$SimpleAssessmentServiceBean == null ? (class$com$webmcq$ld$tool$simpleassessment$SimpleAssessmentServiceBean = SimpleAssessmentServiceBean.class$("com.webmcq.ld.tool.simpleassessment.SimpleAssessmentServiceBean")) : class$com$webmcq$ld$tool$simpleassessment$SimpleAssessmentServiceBean));
    static /* synthetic */ Class class$com$webmcq$ld$tool$simpleassessment$SimpleAssessmentServiceBean;

    private QuestionInfoLocal getQuestionInfoLocal(int taskInstanceId) {
        QuestionInfoLocal cachedQuestionInfo = null;
        try {
            Collection entries = QuestionInfoUtil.getLocalHome().findByTaskInstanceId(taskInstanceId);
            cachedQuestionInfo = (QuestionInfoLocal)EJBUtil.findSingle(entries);
        }
        catch (NamingException e) {
            log.error((Object)"Naming exception thrown trying to get the question set content", (Throwable)e);
            throw new EJBException((Exception)e);
        }
        catch (FinderException finderException) {
            // empty catch block
        }
        return cachedQuestionInfo;
    }

    private QuestionInfoLocal createNewQuestionInfo(int taskInstanceId, Long outputContentId, Content content) {
        QuestionInfoLocal qsInfo = null;
        try {
            qsInfo = QuestionInfoUtil.getLocalHome().create();
            qsInfo.setTaskInstanceId(taskInstanceId);
            qsInfo.setTitle(content.getTitle());
            qsInfo.setDescription(content.getDescription());
            qsInfo.setInstructions(content.getBody());
            qsInfo.setOutputContentId(outputContentId);
            qsInfo.setTaskDirectory(this.getSessionDirectoryName(taskInstanceId));
            if ("questioncontent".equals(content.theContentType())) {
                QuestionContent inputContent = (QuestionContent)content;
                qsInfo.setAllowRedo(inputContent.isAllowRedo());
                qsInfo.setShowFeedback(inputContent.isShowFeedback());
                int totalMark = 0;
                if (inputContent.getQuestions() != null) {
                    Iterator iter = inputContent.getQuestions().iterator();
                    while (iter.hasNext()) {
                        QuestionEntry entry = (QuestionEntry)iter.next();
                        QuestionLocal question = this.createNewQuestion(entry);
                        qsInfo.getQuestions().add(question);
                        Integer questionMark = question.getMark();
                        if (questionMark == null) continue;
                        totalMark += questionMark.intValue();
                    }
                }
                if (inputContent.isAllowRedo()) {
                    qsInfo.setTotalMinPassMarks(totalMark, inputContent.getMinimumPassMark() != null ? inputContent.getMinimumPassMark() : 0);
                } else {
                    qsInfo.setTotalMinPassMarks(totalMark, 0);
                }
                qsInfo.setShowTopUsernames(inputContent.isShowTopMarkNames());
            } else {
                qsInfo.setTotalMinPassMarks(0, 0);
                qsInfo.setShowTopUsernames(false);
                qsInfo.setAllowRedo(false);
                qsInfo.setShowFeedback(false);
            }
        }
        catch (NamingException e) {
            throw new EJBException((Exception)e);
        }
        catch (CreateException e) {
            throw new EJBException((Exception)((Object)e));
        }
        return qsInfo;
    }

    private QuestionLocal createNewQuestion(QuestionEntry entry) {
        QuestionLocal question = null;
        try {
            question = QuestionUtil.getLocalHome().create();
            question.setQuestion(entry.getQuestion());
            question.setFeedback(entry.getFeedback());
            question.setDisplayOrder(entry.getDisplayOrder());
            if (entry.getMark() != null) {
                question.setMark(entry.getMark());
            } else {
                question.setMark(new Integer(0));
            }
            if (entry.getCandidateAnswers() != null) {
                Iterator iter = entry.getCandidateAnswers().iterator();
                while (iter.hasNext()) {
                    QuestionAnswerEntry answerentry = (QuestionAnswerEntry)iter.next();
                    if (answerentry.getAnswer() == null || answerentry.getAnswer().length() <= 0) continue;
                    AnswerLocal answer = this.createNewPossibleAnswer(answerentry);
                    question.getPossibleAnswers().add(answer);
                }
            }
        }
        catch (NamingException e) {
            throw new EJBException((Exception)e);
        }
        catch (CreateException e) {
            throw new EJBException((Exception)((Object)e));
        }
        return question;
    }

    private AnswerLocal createNewPossibleAnswer(QuestionAnswerEntry entry) {
        AnswerLocal answer = null;
        try {
            answer = AnswerUtil.getLocalHome().create();
            answer.setAnswer(entry.getAnswer());
            answer.setCorrect(entry.isCorrect());
            answer.setDisplayOrder(entry.getDisplayOrder());
        }
        catch (NamingException e) {
            throw new EJBException((Exception)e);
        }
        catch (CreateException e) {
            throw new EJBException((Exception)((Object)e));
        }
        return answer;
    }

    private LearnerAttemptLocal createLearnerAttempt(long userId, String username, List newAnswers, QuestionInfoLocal qsInfo) throws EJBException {
        LearnerAttemptLocal attempt = null;
        try {
            attempt = LearnerAttemptUtil.getLocalHome().create();
            HashSet<Integer> questionsAnswered = new HashSet<Integer>();
            attempt = LearnerAttemptUtil.getLocalHome().create();
            attempt.setSubmittedDate(new Date(System.currentTimeMillis()));
            attempt.setUserId(userId);
            attempt.setUsername(username);
            attempt.setAttemptCount(-1);
            attempt.setIsBestAttempt(false);
            int mark = 0;
            Iterator iter = newAnswers.iterator();
            while (iter.hasNext()) {
                AnswerResult answerInput = (AnswerResult)iter.next();
                int questionSid = answerInput.getQuestionSid();
                Integer questionSidInteger = new Integer(questionSid);
                if (!questionsAnswered.contains(questionSidInteger)) {
                    questionsAnswered.add(questionSidInteger);
                    QuestionLocal question = qsInfo.getQuestion(answerInput.getQuestionSid());
                    AnswerLocal answer = this.createLearnerAnswer(answerInput.getAnswer(), question);
                    attempt.getAnswers().add(answer);
                    if (!answer.getCorrect() || question.getMark() == null) continue;
                    mark += question.getMark().intValue();
                    continue;
                }
                log.warn((Object)("Question answered twice. user id " + userId + " question id " + questionSid + " only recording initial answer."));
            }
            attempt.setMark(new Integer(mark));
        }
        catch (NamingException e) {
            throw new EJBException((Exception)e);
        }
        catch (CreateException e) {
            throw new EJBException((Exception)((Object)e));
        }
        return attempt;
    }

    private AnswerLocal createLearnerAnswer(String answerString, QuestionLocal matchingQuestion) {
        AnswerLocal answer = null;
        try {
            answer = AnswerUtil.getLocalHome().create(matchingQuestion.getSid());
            answer.setAnswer(answerString);
            Iterator iter = matchingQuestion.getPossibleAnswers().iterator();
            AnswerLocal matchingAnswer = null;
            while (matchingAnswer == null && iter.hasNext()) {
                AnswerLocal standardAnswer = (AnswerLocal)iter.next();
                if (!standardAnswer.getAnswer().equals(answerString)) continue;
                matchingAnswer = standardAnswer;
            }
            if (matchingAnswer != null) {
                answer.setCorrect(matchingAnswer.getCorrect());
                answer.setDisplayOrder(matchingQuestion.getDisplayOrder());
            } else {
                answer.setCorrect(false);
                answer.setDisplayOrder(new Integer(0));
            }
        }
        catch (NamingException e) {
            throw new EJBException((Exception)e);
        }
        catch (CreateException e) {
            throw new EJBException((Exception)((Object)e));
        }
        return answer;
    }

    public void createSession(AbstractTaskVO task, TaskInstanceData taskInstance, GroupData group, String outputContentDestination, Long inputContentId, Long outputContentId) throws ToolException, SystemException, RemoteException {
        try {
            Content content = null;
            if (inputContentId != null) {
                content = ContentServiceDelegate.getContent(inputContentId);
            }
            QuestionInfoLocal info = this.createNewQuestionInfo((int)taskInstance.getSid(), outputContentId, content);
        }
        catch (ControllerException e) {
            this.getSessionContext().setRollbackOnly();
            throw new ToolException(e);
        }
        catch (Exception e) {
            this.getSessionContext().setRollbackOnly();
            log.error((Object)"Exception occured creating new SimpleAssessment task", (Throwable)e);
            throw new SystemException(e);
        }
    }

    public QuestionInfoData getQuestionInfoByTaskInstance(int taskInstanceId) {
        QuestionInfoLocal qsInfo = this.getQuestionInfoLocal(taskInstanceId);
        if (qsInfo != null) {
            return SimpleAssessmentDTOFactory.getQuestionInfo(qsInfo);
        }
        return null;
    }

    public Map getQuestionMapByTaskInstance(int taskInstanceId) {
        QuestionInfoLocal qsInfo = this.getQuestionInfoLocal(taskInstanceId);
        if (qsInfo != null) {
            return SimpleAssessmentDTOFactory.getQuestionMap(qsInfo);
        }
        return null;
    }

    public SortedSet getSortedQuestionsByTaskInstance(int taskInstanceId) {
        QuestionInfoLocal qsInfo = this.getQuestionInfoLocal(taskInstanceId);
        if (qsInfo != null) {
            return SimpleAssessmentDTOFactory.getQuestionSortedSet(qsInfo);
        }
        return null;
    }

    public AttemptData getAttempt(int taskInstanceId, long userId, int attemptNo) {
        LearnerAttemptLocal attempt;
        if (log.isDebugEnabled()) {
            log.debug((Object)("getAttempt: userId " + userId + " attempt no " + attemptNo));
        }
        QuestionInfoLocal qsInfo = this.getQuestionInfoLocal(taskInstanceId);
        AttemptData data = null;
        if (qsInfo != null && (attempt = qsInfo.getAttempt(userId, attemptNo)) != null) {
            data = SimpleAssessmentDTOFactory.getAttempt(attempt);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("getAttempt: returning " + (data != null ? data.toString() : "null")));
        }
        return data;
    }

    public AttemptData getBestAttempt(int taskInstanceId, long userId) {
        LearnerAttemptLocal attempt;
        if (log.isDebugEnabled()) {
            log.debug((Object)("getBestAttempt: userId " + userId));
        }
        QuestionInfoLocal qsInfo = this.getQuestionInfoLocal(taskInstanceId);
        AttemptData data = null;
        if (qsInfo != null && (attempt = qsInfo.getBestAttempt(userId)) != null) {
            data = SimpleAssessmentDTOFactory.getAttempt(attempt);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("getBestAttempt: returning " + (data != null ? data.toString() : "null")));
        }
        return data;
    }

    public AttemptData getLastAttempt(int taskInstanceId, long userId) {
        LearnerAttemptLocal attempt;
        if (log.isDebugEnabled()) {
            log.debug((Object)("getLastAttempt: userId " + userId));
        }
        QuestionInfoLocal qsInfo = this.getQuestionInfoLocal(taskInstanceId);
        AttemptData data = null;
        if (qsInfo != null && (attempt = qsInfo.getLastAttempt(userId)) != null) {
            data = SimpleAssessmentDTOFactory.getAttempt(attempt);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("getLastAttempt: returning " + (data != null ? data.toString() : "null")));
        }
        return data;
    }

    public AttemptData saveAttempt(int taskInstanceId, long userId, String username, List newAnswers) {
        if (newAnswers == null) {
            log.error((Object)("Unable to store results, no answers given. Task instance " + taskInstanceId + " user " + userId));
            return null;
        }
        QuestionInfoLocal qsInfo = this.getQuestionInfoLocal(taskInstanceId);
        if (qsInfo == null) {
            log.error((Object)("Unable to store results, question information not found. Task instance " + taskInstanceId + " user " + userId));
            return null;
        }
        LearnerAttemptLocal attempt = this.createLearnerAttempt(userId, username, newAnswers, qsInfo);
        qsInfo.addLearnerAttempt(attempt);
        return SimpleAssessmentDTOFactory.getAttempt(attempt);
    }

    public DisplayTaskData completeSession(int taskInstanceId, long userId) throws BusinessException, EJBException, TaskInstanceNotFoundException, ControllerException {
        QuestionInfoLocal qsInfo = this.getQuestionInfoLocal(taskInstanceId);
        DisplayTaskData displayTaskData = null;
        String error = null;
        if (qsInfo != null) {
            LearnerAttemptLocal attempt = qsInfo.getBestAttempt(userId);
            if (attempt == null) {
                error = "Must answer the questions. Cannot continue.";
            } else if (attempt.getMark() == null || attempt.getMark() < qsInfo.getMinPassMark()) {
                error = "Must get at least " + qsInfo.getMinPassMark() + " out of " + qsInfo.getTotalMark() + ". Please redo the assessment.";
            } else {
                displayTaskData = LearnerServiceDelegate.moveToNextTask(taskInstanceId, userId);
            }
        }
        if (error != null) {
            throw new BusinessException(error);
        }
        return displayTaskData;
    }

    public MarkSummaryData getMarkSummary(int taskInstanceId, boolean includeIndividualMarks) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("getMarkSummary: include individual " + includeIndividualMarks));
        }
        QuestionInfoLocal qsInfo = this.getQuestionInfoLocal(taskInstanceId);
        MarkSummaryData data = null;
        if (qsInfo != null) {
            data = SimpleAssessmentDTOFactory.getMarkSummary(qsInfo, includeIndividualMarks);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("getMarkSummary: returning " + (data != null ? data.toString() : "null")));
        }
        return data;
    }

    private String getSessionDirectoryName(long taskInstanceId) throws SystemException {
        try {
            ConfigurationServiceLocal config = ConfigurationServiceUtil.getLocalHome().create();
            String homeDirectory = config.get(ConfigurationKeys.LAMS_HOME);
            if (homeDirectory == null) {
                throw new SystemException("No home directory set up for LAMS. Unable to do report submission. Session id=" + taskInstanceId);
            }
            File dir = new File(homeDirectory, "simpleassessment");
            dir = new File(dir.getPath(), "task" + Long.toString(taskInstanceId));
            return dir.getAbsolutePath();
        }
        catch (CreateException e) {
            throw new EJBException((Exception)((Object)e));
        }
        catch (NamingException e) {
            throw new EJBException((Exception)e);
        }
    }

    public void deleteSession(TaskInstance taskInstance, Long inputContentId, Long outputContentId) throws ToolException, SystemException {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

