/*
 * Decompiled with CFR 0.152.
 */
package com.webmcq.ld.tool.simpleassessment;

import com.webmcq.ld.service.UserNotFoundException;
import com.webmcq.ld.service.UserServiceDelegate;
import com.webmcq.ld.tool.simpleassessment.dto.MarkData;
import com.webmcq.ld.tool.simpleassessment.dto.MarkSummaryData;
import com.webmcq.ld.tool.simpleassessment.interfaces.QuestionInfoData;
import com.webmcq.ld.usermanagement.interfaces.ShwaaUserData;
import com.webmcq.ld.util.CSVFile;
import com.webmcq.ld.util.exception.SystemException;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.SortedMap;
import java.util.TimeZone;
import org.apache.log4j.Logger;

public class MarkFileBuilder {
    private static Logger log = Logger.getLogger((Class)(class$com$webmcq$ld$tool$simpleassessment$MarkFileBuilder == null ? (class$com$webmcq$ld$tool$simpleassessment$MarkFileBuilder = MarkFileBuilder.class$("com.webmcq.ld.tool.simpleassessment.MarkFileBuilder")) : class$com$webmcq$ld$tool$simpleassessment$MarkFileBuilder));
    Map m_users = new HashMap();
    SimpleDateFormat m_longFormat = new SimpleDateFormat("dd MMM yyyy hh:mm:ss a");
    static /* synthetic */ Class class$com$webmcq$ld$tool$simpleassessment$MarkFileBuilder;

    public MarkFileBuilder() {
        this.m_longFormat.setTimeZone(TimeZone.getDefault());
    }

    public String createFile(QuestionInfoData info, MarkSummaryData summaryData, long userId) throws SystemException {
        SortedMap userMarks = summaryData.getMarks();
        String[] heading = this.buildHeading(summaryData.getMaxNumberOfAttempts());
        File filename = this.downloadFile(info.getTaskDirectory(), info.getTaskInstanceId(), userId);
        try {
            CSVFile writer = new CSVFile(filename);
            writer.write(heading);
            if (userMarks != null) {
                Iterator iter = userMarks.values().iterator();
                while (iter.hasNext()) {
                    Map markMap = (Map)iter.next();
                    String[] entry = this.buildLearnerRecord(markMap);
                    log.debug((Object)("Record to be written to file is " + entry.toString()));
                    writer.write(entry);
                }
            }
            writer.close();
        }
        catch (IOException e) {
            log.error((Object)"Unable to write out marks file due to IOException ", (Throwable)e);
            throw new SystemException(e);
        }
        return filename.getAbsolutePath();
    }

    private File downloadFile(String directoryname, long taskInstanceId, long userId) {
        File directory = new File(directoryname);
        if (!directory.exists()) {
            directory.mkdirs();
        }
        if (!directory.canWrite()) {
            log.error((Object)("openFile: Unable to write to directory, cannot create marks file " + directoryname));
            throw new SystemException("openFile: Unable to write to directory, cannot create marks file " + directoryname);
        }
        String username = null;
        try {
            ShwaaUserData user = UserServiceDelegate.find(userId);
            username = user.getLogin();
        }
        catch (UserNotFoundException e) {
            username = "unknown";
        }
        SimpleDateFormat format = new SimpleDateFormat("yyyyMMddHHmmss");
        format.setTimeZone(TimeZone.getDefault());
        String dateString = format.format(new Date(System.currentTimeMillis()));
        String filename = username + '_' + taskInstanceId + "_marks_" + dateString + ".csv";
        return new File(directory, filename);
    }

    private String[] buildLearnerRecord(Map markMap) {
        log.debug((Object)("Processing " + markMap.toString()));
        String[] entry = new String[6 + 2 * markMap.size()];
        int index = 6;
        Iterator mmIterator = markMap.values().iterator();
        while (mmIterator.hasNext()) {
            String dateString;
            MarkData element = (MarkData)mmIterator.next();
            if (entry[0] == null) {
                long userId = element.getUserId();
                try {
                    ShwaaUserData user = this.getUser(userId);
                    entry[0] = user.getLogin();
                    entry[1] = user.getFirstName();
                    entry[2] = user.getLastName();
                    entry[5] = "";
                }
                catch (UserNotFoundException e) {
                    // empty catch block
                }
            }
            String markString = Integer.toString(element.getMark());
            String string = dateString = element.getSubmittedDate() != null ? this.m_longFormat.format(element.getSubmittedDate()) : "";
            if (element.isBestMark()) {
                entry[3] = markString;
                entry[4] = dateString;
            }
            entry[index++] = markString;
            entry[index++] = dateString;
        }
        return entry;
    }

    private String[] buildHeading(Integer maxNumMarks) {
        int max = maxNumMarks != null ? maxNumMarks : 1;
        ArrayList<String> heading = new ArrayList<String>();
        heading.add("Username");
        heading.add("Firstname");
        heading.add("Lastname");
        heading.add("Best Mark");
        heading.add("Best Mark Date");
        heading.add("");
        for (int i = 0; i < max; ++i) {
            heading.add("Previous Mark");
            heading.add("Date");
        }
        return heading.toArray(new String[heading.size()]);
    }

    private ShwaaUserData getUser(long userid) throws UserNotFoundException {
        log.debug((Object)("getUser: " + userid));
        Long id = new Long(userid);
        ShwaaUserData user = (ShwaaUserData)this.m_users.get(id);
        if (user == null) {
            user = UserServiceDelegate.find(userid);
            this.m_users.put(id, user);
        }
        return user;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

