/*
 * Decompiled with CFR 0.152.
 */
package com.webmcq.ld.tool.reportsubmission.web;

import com.webmcq.ld.controller.ControllerException;
import com.webmcq.ld.controller.DisplayTaskData;
import com.webmcq.ld.controller.web.ToolAction;
import com.webmcq.ld.service.UserServiceDelegate;
import com.webmcq.ld.tool.StaffMonitorNotifier;
import com.webmcq.ld.tool.reportsubmission.interfaces.ReportSubmissionService;
import com.webmcq.ld.tool.reportsubmission.interfaces.ReportSubmissionServiceUtil;
import com.webmcq.ld.tool.reportsubmission.interfaces.SubmissionInfoData;
import com.webmcq.ld.tool.reportsubmission.web.FilenameUtils;
import com.webmcq.ld.util.UploadFileUtil;
import com.webmcq.ld.util.WebUtil;
import com.webmcq.ld.util.exception.SystemException;
import java.io.File;
import java.io.IOException;
import java.rmi.RemoteException;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.SortedMap;
import javax.ejb.CreateException;
import javax.ejb.EJBException;
import javax.naming.NamingException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.log4j.Logger;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class ReportSubmissionAction
extends ToolAction {
    public static String JSP_TASK_INSTANCE_ID_TAG = "sessionId";
    public static String JSPINPUT_ERROR_TAG = "error";
    public static String JSPINPUT_WARNING_TAG = "warning";
    public static String JSPINPUT_INFO_TAG = "info";
    public static String JSPINPUT_SUBMITTED_FILELIST_TAG = "submittedfiles";
    public static String JSPOUTPUT_UPLOADED_FILE_TAG = "file";
    public static String JSPOUTPUT_FILE_DESCRIPTION_TAG = "description";
    public static String JSPINPUT_MAX_FILESIZE_TAG = "maxfilesize";
    public static String JSPOUTPUT_FINISHED = "finished";
    public static String JSPOUTPUT_UPLOAD = "upload";
    private static String SCREEN_UPLOAD = "upload";
    private static Logger log = Logger.getLogger((Class)(class$com$webmcq$ld$tool$reportsubmission$web$ReportSubmissionAction == null ? (class$com$webmcq$ld$tool$reportsubmission$web$ReportSubmissionAction = ReportSubmissionAction.class$("com.webmcq.ld.tool.reportsubmission.web.ReportSubmissionAction")) : class$com$webmcq$ld$tool$reportsubmission$web$ReportSubmissionAction));
    static /* synthetic */ Class class$com$webmcq$ld$tool$reportsubmission$web$ReportSubmissionAction;

    public ActionForward dispatch(ActionMapping mapping, ActionForm form, HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        String mode = WebUtil.readStrParam(req, "mode");
        log.debug((Object)("dispatch: mode: " + mode));
        if ("run".equals(mode)) {
            return this.getUploadPage(mapping, form, req, res);
        }
        if ("resume".equals(mode)) {
            return this.getUploadPage(mapping, form, req, res);
        }
        if ("view".equals(mode)) {
            return this.getUploadPage(mapping, form, req, res);
        }
        if ("checkup".equals(mode)) {
            return this.getUploadPage(mapping, form, req, res);
        }
        throw new SystemException("unrecognized access mode: '" + mode + "'");
    }

    public ActionForward getUploadPage(ActionMapping mapping, ActionForm form, HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        try {
            String mode = WebUtil.readStrParam(req, "mode");
            log.debug((Object)("getUploadPage: mode: " + mode));
            if ("view".equals(mode)) {
                req.setAttribute("viewOnly", (Object)mode);
            } else if ("checkup".equals(mode)) {
                req.setAttribute("viewOnly", (Object)mode);
            }
            int taskInstanceId = this.getTaskInstanceId(req);
            ReportSubmissionService service = ReportSubmissionServiceUtil.getHome().create();
            service.getInfoByTaskInstance(taskInstanceId);
            long userId = this.getUserId(req, mode);
            this.setLearnerPageParameters(req, taskInstanceId, userId, service);
            WebUtil.saveToken(req, "transactionKeyReportSubmission", this.generateToken(req));
            return mapping.findForward(SCREEN_UPLOAD);
        }
        catch (CreateException e) {
            throw new SystemException(e.getMessage());
        }
        catch (NamingException e) {
            throw new SystemException(e.getMessage());
        }
        catch (Exception e) {
            log.error((Object)"General exception thrown", (Throwable)e);
            throw new SystemException(e.getMessage());
        }
    }

    private long getUserId(HttpServletRequest req, String mode) throws ServletException {
        try {
            if ("checkup".equals(mode)) {
                return WebUtil.readLongParam(req, "userId");
            }
            String username = WebUtil.getUsername(req);
            return UserServiceDelegate.findUserId(username);
        }
        catch (Exception e) {
            throw new SystemException(e);
        }
    }

    public ActionForward putFile(ActionMapping mapping, ActionForm form, HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        try {
            int taskInstanceId = this.getTaskInstanceId(req);
            String username = null;
            username = WebUtil.getUsername(req);
            long userId = UserServiceDelegate.findUserId(username);
            ReportSubmissionService service = ReportSubmissionServiceUtil.getHome().create();
            SubmissionInfoData info = service.getInfoByTaskInstance(taskInstanceId);
            FileItem fileToUpload = null;
            String description = null;
            String originalFilename = null;
            String errorMessage = null;
            String tokenTransaction = null;
            String tokenSessionTransaction = (String)req.getSession().getAttribute("transactionKeyReportSubmission");
            List items = null;
            try {
                items = UploadFileUtil.getUploadItems(req, false, info.getTempDirName());
                Iterator iter = items.iterator();
                while (iter.hasNext()) {
                    FileItem item = (FileItem)iter.next();
                    log.debug((Object)("Request item: " + item.toString()));
                    if (JSPOUTPUT_FILE_DESCRIPTION_TAG.equals(item.getFieldName())) {
                        description = item.getString();
                        continue;
                    }
                    if (JSPOUTPUT_UPLOADED_FILE_TAG.equals(item.getFieldName()) && item.getName() != null && item.getSize() != 0L) {
                        originalFilename = item.getName();
                        fileToUpload = item;
                        continue;
                    }
                    if (!"transactionKeyReportSubmission".equals(item.getFieldName())) continue;
                    tokenTransaction = item.getString();
                }
            }
            catch (FileUploadException fue) {
                log.error((Object)("Unable to upload file from learner " + username + ", taskInstanceId=" + taskInstanceId + ". Exception occured"), (Throwable)fue);
                errorMessage = "Unable to upload file. Error returned by uploader was:" + fue.getMessage();
                req.setAttribute(JSPINPUT_ERROR_TAG, (Object)errorMessage);
                service.getInfoByTaskInstance(taskInstanceId);
                this.setLearnerPageParameters(req, taskInstanceId, userId, service);
                WebUtil.saveToken(req, "transactionKeyReportSubmission", this.generateToken(req));
                return mapping.findForward(SCREEN_UPLOAD);
            }
            if (fileToUpload == null) {
                if (tokenSessionTransaction != null && tokenTransaction != null) {
                    if (tokenSessionTransaction.equals(tokenTransaction)) {
                        WebUtil.resetToken(req, "transactionKeyReportSubmission");
                        req.getSession().removeAttribute("transactionDoneReportSubmission");
                        DisplayTaskData displayTaskData = service.completeSession(userId, taskInstanceId);
                        ActionForward action = this.displayTask(displayTaskData, mapping, form, req, res);
                        req.getSession().setAttribute("transactionDoneReportSubmission", (Object)action);
                        return action;
                    }
                    return this.duplicateSubmission(mapping, req, "transactionDoneReportSubmission");
                }
                return this.duplicateSubmission(mapping, req, "transactionDoneReportSubmission");
            }
            File origFilename = new File(originalFilename);
            Long fileNum = service.getNextFileNumber(taskInstanceId);
            File newFilename = FilenameUtils.buildNewFilename(info.getFinalDirName(), fileNum, username, origFilename.getName());
            fileToUpload.write(newFilename);
            service.createReportItem(taskInstanceId, userId, username, description, originalFilename, newFilename.getPath(), newFilename.getName());
            this.setLearnerPageParameters(req, taskInstanceId, userId, service);
            this.notifyReportsToMark(taskInstanceId, info.getTitle(), req.getServerPort());
            WebUtil.saveToken(req, "transactionKeyReportSubmission", this.generateToken(req));
            return mapping.findForward(SCREEN_UPLOAD);
        }
        catch (CreateException e) {
            log.error((Object)"Error occured: ", (Throwable)e);
            throw new SystemException(e.getMessage());
        }
        catch (NamingException e) {
            log.error((Object)"Error occured: ", (Throwable)e);
            throw new SystemException(e.getMessage());
        }
        catch (SystemException e) {
            return mapping.findForward("error");
        }
        catch (Exception e) {
            log.error((Object)"Error occured: ", (Throwable)e);
            throw new SystemException(e.getMessage());
        }
    }

    public void setLearnerPageParameters(HttpServletRequest req, int taskInstanceId, long userId, ReportSubmissionService service) throws RemoteException {
        SubmissionInfoData info = service.getInfoByTaskInstance(taskInstanceId);
        if (info != null) {
            req.setAttribute(JSPINPUT_INFO_TAG, (Object)info);
        }
        if (userId >= 0L) {
            SortedMap submittedInfo = service.getUploadedFileInfoByTaskInstanceLearner(taskInstanceId, userId);
            log.debug((Object)(JSPINPUT_SUBMITTED_FILELIST_TAG + " being set to " + (submittedInfo != null ? submittedInfo.toString() : "null")));
            if (submittedInfo != null) {
                req.setAttribute(JSPINPUT_SUBMITTED_FILELIST_TAG, (Object)submittedInfo);
            }
        }
        req.setAttribute(JSPINPUT_MAX_FILESIZE_TAG, (Object)Float.toString(UploadFileUtil.getMaxFileSize()));
    }

    private int getTaskInstanceId(HttpServletRequest req) {
        String taskInstanceIdParam = req.getParameter(JSP_TASK_INSTANCE_ID_TAG);
        int taskInstanceId = -1;
        if (taskInstanceIdParam == null || "".equals(taskInstanceIdParam)) {
            log.error((Object)"No taskInstanceId in request");
            this.dumpReqDetails(req);
            throw new NullPointerException("no taskInstanceId");
        }
        taskInstanceId = Integer.parseInt(taskInstanceIdParam);
        return taskInstanceId;
    }

    private void dumpReqDetails(HttpServletRequest req) {
        Object name;
        Enumeration enumberation = req.getAttributeNames();
        while (enumberation.hasMoreElements()) {
            name = enumberation.nextElement();
            log.info((Object)("Attribute " + name + "=" + req.getAttribute((String)name)));
        }
        enumberation = req.getParameterNames();
        while (enumberation.hasMoreElements()) {
            name = enumberation.nextElement();
            log.info((Object)("Parameter" + name + "=" + req.getParameter((String)name)));
        }
    }

    private void notifyReportsToMark(long taskInstanceId, String title, int portNo) {
        try {
            String toolpath = "tool/reportmarking/reportmarking.do?method=getStudentList&sessionId=" + taskInstanceId;
            StaffMonitorNotifier.notifyControllerOfURL(taskInstanceId, "reportmarking", title, toolpath);
        }
        catch (ControllerException e) {
            throw new EJBException((Exception)e);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

