/*
 * Decompiled with CFR 0.152.
 */
package com.webmcq.ld.tool.groupreport.web;

import com.webmcq.ld.controller.DisplayTaskData;
import com.webmcq.ld.controller.dto.UserNameData;
import com.webmcq.ld.controller.web.ToolAction;
import com.webmcq.ld.service.UserServiceDelegate;
import com.webmcq.ld.service.interfaces.LearnerService;
import com.webmcq.ld.service.interfaces.LearnerServiceUtil;
import com.webmcq.ld.tool.groupreport.interfaces.GroupReportService;
import com.webmcq.ld.tool.groupreport.interfaces.GroupReportServiceUtil;
import com.webmcq.ld.tool.groupreport.interfaces.ReportData;
import com.webmcq.ld.usermanagement.interfaces.ShwaaUserData;
import com.webmcq.ld.util.WDDXProcessor;
import com.webmcq.ld.util.WebUtil;
import com.webmcq.ld.util.exception.SystemException;
import java.io.IOException;
import java.rmi.RemoteException;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import javax.ejb.CreateException;
import javax.naming.NamingException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class GroupReportAction
extends ToolAction {
    public static String JSP_TASK_INSTANCE_ID_TAG = "sessionId";
    public static String JSPINPUT_INFO_TAG = "info";
    public static String JSPINPUT_REPORT_ITEMS_TAG = "items";
    public static String JSPINPUT_USERS_TAG = "users";
    public static String SHOW_ENTRIES_ONLY = "entriesonly";
    public static String JSPOUTPUT_UPDATE_TAG = "update";
    public static String JSPOUTPUT_SCRIBE_FORCE_END_TAG = "force_end";
    public static String JSPOUTPUT_ENTRY_SUBTAG = "entry";
    public static String JSP_GRAPH_NUM_AGREED = "number_agreed";
    public static String JSP_GRAPH_NUM_DISAGREED = "number_disagreed";
    public static String JSP_GRAPH_NUM_IN_GROUP = "number_in_group";
    public static String JSP_GRAPH_NUM_MIN_NUM_AGREE = "number_minimum_agree";
    public static String GROUPREPORT_PATH = "/tool/groupreport/groupreport";
    private static Logger log = Logger.getLogger((Class)(class$com$webmcq$ld$tool$groupreport$web$GroupReportAction == null ? (class$com$webmcq$ld$tool$groupreport$web$GroupReportAction = GroupReportAction.class$("com.webmcq.ld.tool.groupreport.web.GroupReportAction")) : class$com$webmcq$ld$tool$groupreport$web$GroupReportAction));
    static /* synthetic */ Class class$com$webmcq$ld$tool$groupreport$web$GroupReportAction;

    public ActionForward dispatch(ActionMapping mapping, ActionForm form, HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        String mode = WebUtil.readStrParam(req, "mode");
        log.debug((Object)("dispatch: mode: " + mode));
        if ("run".equals(mode)) {
            return this.getExplanation(mapping, form, req, res);
        }
        if ("resume".equals(mode)) {
            return this.getExplanation(mapping, form, req, res);
        }
        if ("view".equals(mode)) {
            return this.getEditor(mapping, form, req, res);
        }
        if ("checkup".equals(mode)) {
            return this.getEditor(mapping, form, req, res);
        }
        throw new ServletException("unrecognized access mode: '" + mode + "'");
    }

    public ActionForward getExplanation(ActionMapping mapping, ActionForm form, HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        try {
            int taskInstanceId = GroupReportAction.getTaskInstanceId(req);
            log.debug((Object)("getExplanation taskInstanceId: " + taskInstanceId));
            long userId = UserServiceDelegate.findUserId(WebUtil.getUsername(req));
            ShwaaUserData user = UserServiceDelegate.find(userId);
            UserNameData userData = new UserNameData(user.getUid(), user.getLogin(), user.getFirstName(), user.getLastName());
            GroupReportService service = GroupReportServiceUtil.getHome().create();
            service.addUser(new Long(userId), userData, taskInstanceId);
            this.setupJSPData(req, service, taskInstanceId);
            ReportData info = (ReportData)req.getAttribute(JSPINPUT_INFO_TAG);
            log.debug((Object)("advanced mode?" + info.getAdvancedMode()));
            if (info.getAdvancedMode()) {
                return mapping.findForward("explanation_advanced");
            }
            return mapping.findForward("explanation");
        }
        catch (CreateException e) {
            throw new ServletException(e.getMessage());
        }
        catch (NamingException e) {
            throw new ServletException(e.getMessage());
        }
        catch (Exception e) {
            log.error((Object)"General exception thrown", (Throwable)e);
            throw new ServletException(e.getMessage());
        }
    }

    public ActionForward getEditor(ActionMapping mapping, ActionForm form, HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        try {
            String username;
            long userId;
            int taskInstanceId = GroupReportAction.getTaskInstanceId(req);
            log.debug((Object)("getEditor getEditor task instance: " + taskInstanceId));
            String mode = req.getParameter("mode");
            log.debug((Object)("getEditor: mode: " + mode));
            if ("view".equals(mode)) {
                req.setAttribute("viewOnly", (Object)mode);
            } else if ("checkup".equals(mode)) {
                req.setAttribute("viewOnly", (Object)mode);
            }
            if ("checkup".equals(mode)) {
                userId = WebUtil.readLongParam(req, "userId");
                username = UserServiceDelegate.find(userId).getLogin();
            } else {
                username = WebUtil.getUsername(req);
                userId = UserServiceDelegate.findUserId(username);
            }
            GroupReportService service = GroupReportServiceUtil.getHome().create();
            String screen = this.selectScreen(req, taskInstanceId, username, userId, service, req.getParameter(SHOW_ENTRIES_ONLY));
            log.debug((Object)("getEditor: screen: " + screen));
            return mapping.findForward(screen);
        }
        catch (CreateException e) {
            log.debug((Object)"Error occured ", (Throwable)e);
            throw new ServletException(e.getMessage());
        }
        catch (NamingException e) {
            log.debug((Object)"Error occured ", (Throwable)e);
            throw new ServletException(e.getMessage());
        }
        catch (Exception e) {
            log.debug((Object)"Error occured ", (Throwable)e);
            throw new ServletException(e.getMessage());
        }
    }

    public Boolean setupJSPData(HttpServletRequest req, GroupReportService service, int taskInstanceId) throws RemoteException {
        Object[] info = service.getInfoByTaskInstance(taskInstanceId);
        req.setAttribute(JSPINPUT_INFO_TAG, (Object)((ReportData)info[0]));
        req.setAttribute(JSPINPUT_REPORT_ITEMS_TAG, (Object)((Collection)info[1]));
        req.setAttribute(JSPINPUT_USERS_TAG, (Object)((Map)info[2]));
        return (Boolean)info[3];
    }

    public String selectScreen(HttpServletRequest req, int taskInstanceId, String username, long userId, GroupReportService service, String showEntriesOnly) throws RemoteException, ServletException {
        Boolean isComplete = this.setupJSPData(req, service, taskInstanceId);
        ReportData info = (ReportData)req.getAttribute(JSPINPUT_INFO_TAG);
        log.debug((Object)("advanced mode?" + info.getAdvancedMode()));
        boolean advancedMode = info.getAdvancedMode();
        Long scribeUserId = service.getScribeUserId(taskInstanceId);
        if (isComplete.booleanValue()) {
            log.debug((Object)("All users agreed, user " + username + " going to submitted screen." + "showEntriesOnly = " + showEntriesOnly));
            if (showEntriesOnly != null) {
                return "shortsubmitted";
            }
            WebUtil.saveToken(req, "transactionKeyGroupReport", this.generateToken(req));
            return "submitted";
        }
        if (scribeUserId != null && scribeUserId == userId) {
            log.debug((Object)("User " + username + " is scribe and getting scribe screen"));
            req.setAttribute("serverUrl", (Object)this.getServerURL());
            return advancedMode ? "scribe_advanced" : "scribe";
        }
        log.debug((Object)("User " + username + " is _not_ scribe and getting review screen"));
        return advancedMode ? "review_advanced" : "review";
    }

    private String getServerURL() throws ServletException {
        try {
            LearnerService service = LearnerServiceUtil.getHome().create();
            String serverUrl = service.getServerURL();
            service.remove();
            return serverUrl;
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
    }

    public ActionForward submitReportDraft(ActionMapping mapping, ActionForm form, HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        HashMap<Long, String> entriesToUpdate = null;
        try {
            log.debug((Object)"scribe entered some updated pages");
            int taskInstanceId = GroupReportAction.getTaskInstanceId(req);
            String username = WebUtil.getUsername(req);
            long userId = UserServiceDelegate.findUserId(username);
            GroupReportService service = GroupReportServiceUtil.getHome().create();
            log.debug((Object)"Collating entry to update");
            if (entriesToUpdate == null) {
                entriesToUpdate = new HashMap<Long, String>();
            }
            Enumeration enumeration = req.getParameterNames();
            while (enumeration.hasMoreElements()) {
                String name = (String)enumeration.nextElement();
                if (!name.startsWith(JSPOUTPUT_ENTRY_SUBTAG)) continue;
                String sidAsString = name.substring(JSPOUTPUT_ENTRY_SUBTAG.length());
                log.debug((Object)("Updating entry " + name + " sid is " + sidAsString));
                Long sid = null;
                try {
                    sid = Long.decode(sidAsString);
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
                log.debug((Object)("Converted sid is " + sid + " new entry is " + req.getParameter(name)));
                if (sid == null) continue;
                entriesToUpdate.put(sid, req.getParameter(name));
            }
            if (entriesToUpdate != null) {
                service.updateReport(taskInstanceId, entriesToUpdate);
            }
            String screen = this.selectScreen(req, taskInstanceId, username, userId, service, req.getParameter(SHOW_ENTRIES_ONLY));
            return mapping.findForward(screen);
        }
        catch (CreateException e) {
            throw new ServletException(e.getMessage());
        }
        catch (NamingException e) {
            throw new ServletException(e.getMessage());
        }
        catch (Exception e) {
            throw new ServletException(e.getMessage());
        }
    }

    public ActionForward forceEnd(ActionMapping mapping, ActionForm form, HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        try {
            log.debug((Object)"scribe triggered force end");
            int taskInstanceId = GroupReportAction.getTaskInstanceId(req);
            String username = WebUtil.getUsername(req);
            long userId = UserServiceDelegate.findUserId(username);
            GroupReportService service = GroupReportServiceUtil.getHome().create();
            service.forceEndReport(taskInstanceId, userId);
            String screen = this.selectScreen(req, taskInstanceId, username, userId, service, req.getParameter(SHOW_ENTRIES_ONLY));
            return mapping.findForward(screen);
        }
        catch (CreateException e) {
            throw new ServletException(e.getMessage());
        }
        catch (NamingException e) {
            throw new ServletException(e.getMessage());
        }
        catch (Exception e) {
            throw new ServletException(e.getMessage());
        }
    }

    public ActionForward setAgree(ActionMapping mapping, ActionForm form, HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        return this.processAgreementForUser(true, mapping, form, req, res);
    }

    public ActionForward setDisagree(ActionMapping mapping, ActionForm form, HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        return this.processAgreementForUser(false, mapping, form, req, res);
    }

    private ActionForward processAgreementForUser(boolean isAgree, ActionMapping mapping, ActionForm form, HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        try {
            int taskInstanceId = GroupReportAction.getTaskInstanceId(req);
            String username = WebUtil.getUsername(req);
            log.debug((Object)(username + " agreed=" + isAgree));
            long userId = UserServiceDelegate.findUserId(username);
            GroupReportService service = GroupReportServiceUtil.getHome().create();
            service.setLearnerAgreement(taskInstanceId, userId, isAgree);
            String screen = this.selectScreen(req, taskInstanceId, username, userId, service, req.getParameter(SHOW_ENTRIES_ONLY));
            return mapping.findForward(screen);
        }
        catch (CreateException e) {
            throw new ServletException(e.getMessage());
        }
        catch (NamingException e) {
            throw new ServletException(e.getMessage());
        }
        catch (Exception e) {
            throw new ServletException(e.getMessage());
        }
    }

    public ActionForward putComplete(ActionMapping mapping, ActionForm form, HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        try {
            if (WebUtil.isTokenValid(req, "transactionKeyGroupReport")) {
                WebUtil.resetToken(req, "transactionKeyGroupReport");
                req.getSession().removeAttribute("transactionDoneGroupeReport");
                log.debug((Object)"complete task instance");
                int taskInstanceId = GroupReportAction.getTaskInstanceId(req);
                String username = WebUtil.getUsername(req);
                long userId = UserServiceDelegate.findUserId(username);
                GroupReportService service = GroupReportServiceUtil.getHome().create();
                DisplayTaskData displayTaskData = service.completeSession(userId, taskInstanceId);
                ActionForward action = this.displayTask(displayTaskData, mapping, form, req, res);
                req.getSession().setAttribute("transactionDoneGroupeReport", (Object)action);
                return action;
            }
            return this.duplicateSubmission(mapping, req, "transactionDoneGroupeReport");
        }
        catch (CreateException e) {
            throw new ServletException(e.getMessage());
        }
        catch (NamingException e) {
            throw new ServletException(e.getMessage());
        }
        catch (SystemException e) {
            return mapping.findForward("error");
        }
        catch (Exception e) {
            log.debug((Object)"Error occured", (Throwable)e);
            throw new ServletException(e.getMessage());
        }
    }

    protected static int getTaskInstanceId(HttpServletRequest req) {
        String taskInstanceIdParam = req.getParameter(JSP_TASK_INSTANCE_ID_TAG);
        int taskInstanceId = -1;
        if (taskInstanceIdParam == null || "".equals(taskInstanceIdParam)) {
            log.debug((Object)"no taskInstanceId");
            throw new NullPointerException("no taskInstanceId");
        }
        taskInstanceId = Integer.parseInt(taskInstanceIdParam);
        return taskInstanceId;
    }

    public ActionForward getStatus(ActionMapping mapping, ActionForm form, HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        try {
            int taskInstanceId = GroupReportAction.getTaskInstanceId(req);
            log.debug((Object)("getStatus taskInstanceId: " + taskInstanceId));
            GroupReportService service = GroupReportServiceUtil.getHome().create();
            Hashtable status = service.getAgreementStatus(taskInstanceId);
            if (status == null) {
                req.setAttribute("error", (Object)"No status values available");
            } else {
                String wddxPacket = WDDXProcessor.serialize(status);
                log.debug((Object)("Writing packet " + wddxPacket));
                res.getWriter().write(wddxPacket);
            }
            return null;
        }
        catch (CreateException e) {
            throw new ServletException(e.getMessage());
        }
        catch (NamingException e) {
            throw new ServletException(e.getMessage());
        }
        catch (Exception e) {
            log.error((Object)"General exception thrown", (Throwable)e);
            throw new ServletException(e.getMessage());
        }
    }

    public ActionForward getGraphData(ActionMapping mapping, ActionForm form, HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        try {
            int taskInstanceId = GroupReportAction.getTaskInstanceId(req);
            log.debug((Object)("getStatus taskInstanceId: " + taskInstanceId));
            GroupReportService service = GroupReportServiceUtil.getHome().create();
            Hashtable status = service.getAgreementStatus(taskInstanceId);
            if (status == null) {
                req.setAttribute("error", (Object)"No status values available");
            } else {
                req.setAttribute(JSP_GRAPH_NUM_AGREED, status.get(JSP_GRAPH_NUM_AGREED));
                req.setAttribute(JSP_GRAPH_NUM_DISAGREED, status.get(JSP_GRAPH_NUM_DISAGREED));
                req.setAttribute(JSP_GRAPH_NUM_IN_GROUP, status.get(JSP_GRAPH_NUM_IN_GROUP));
                req.setAttribute(JSP_GRAPH_NUM_MIN_NUM_AGREE, status.get(JSP_GRAPH_NUM_MIN_NUM_AGREE));
            }
            return mapping.findForward("graph");
        }
        catch (CreateException e) {
            throw new ServletException(e.getMessage());
        }
        catch (NamingException e) {
            throw new ServletException(e.getMessage());
        }
        catch (Exception e) {
            log.error((Object)"General exception thrown", (Throwable)e);
            throw new ServletException(e.getMessage());
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

