/*
 * Decompiled with CFR 0.152.
 */
package com.webmcq.ld.tool.groupreport;

import com.webmcq.ld.activities.AbstractTaskVO;
import com.webmcq.ld.activities.SimpleTaskVO;
import com.webmcq.ld.content.Content;
import com.webmcq.ld.content.interfaces.ContentRepositoryLocal;
import com.webmcq.ld.content.interfaces.ContentRepositoryUtil;
import com.webmcq.ld.controller.ControllerException;
import com.webmcq.ld.controller.DisplayTaskData;
import com.webmcq.ld.controller.TaskInstance;
import com.webmcq.ld.controller.dao.TaskInstanceNotFoundException;
import com.webmcq.ld.controller.dto.GroupData;
import com.webmcq.ld.controller.dto.TaskInstanceData;
import com.webmcq.ld.controller.dto.UserNameData;
import com.webmcq.ld.service.ContentServiceDelegate;
import com.webmcq.ld.service.LearnerServiceDelegate;
import com.webmcq.ld.tool.ToolException;
import com.webmcq.ld.tool.groupreport.GroupReportException;
import com.webmcq.ld.tool.groupreport.interfaces.ReportItemData;
import com.webmcq.ld.tool.groupreport.interfaces.ReportItemLocal;
import com.webmcq.ld.tool.groupreport.interfaces.ReportItemUtil;
import com.webmcq.ld.tool.groupreport.interfaces.ReportLearnerData;
import com.webmcq.ld.tool.groupreport.interfaces.ReportLearnerLocal;
import com.webmcq.ld.tool.groupreport.interfaces.ReportLearnerUtil;
import com.webmcq.ld.tool.groupreport.interfaces.ReportLocal;
import com.webmcq.ld.tool.groupreport.interfaces.ReportUtil;
import com.webmcq.ld.tool.groupreport.web.GroupReportAction;
import com.webmcq.ld.util.BaseSessionBean;
import com.webmcq.ld.util.EJBUtil;
import com.webmcq.ld.util.WebUtil;
import com.webmcq.ld.util.exception.SystemException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.ejb.CreateException;
import javax.ejb.EJBException;
import javax.ejb.FinderException;
import javax.naming.NamingException;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public abstract class GroupReportServiceBean
extends BaseSessionBean {
    private static Logger log = Logger.getLogger((Class)(class$com$webmcq$ld$tool$groupreport$GroupReportServiceBean == null ? (class$com$webmcq$ld$tool$groupreport$GroupReportServiceBean = GroupReportServiceBean.class$("com.webmcq.ld.tool.groupreport.GroupReportServiceBean")) : class$com$webmcq$ld$tool$groupreport$GroupReportServiceBean));
    private final String SEPARATOR = "^";
    static /* synthetic */ Class class$com$webmcq$ld$tool$groupreport$GroupReportServiceBean;

    public void createSession(AbstractTaskVO task, TaskInstanceData taskInstance, GroupData group, String outputContentDestination, Long inputContentId, Long outputContentId) throws ToolException, SystemException {
        try {
            this.createSession((SimpleTaskVO)task, taskInstance, group, outputContentId);
            if (inputContentId != null) {
                Content content = ContentServiceDelegate.getContent(inputContentId);
                this.setContent((int)taskInstance.getSid(), content);
            }
        }
        catch (ControllerException e) {
            this.getSessionContext().setRollbackOnly();
            throw new ToolException(e);
        }
        catch (Exception e) {
            this.getSessionContext().setRollbackOnly();
            e.printStackTrace();
            throw new SystemException(e);
        }
    }

    private void createSession(SimpleTaskVO task, TaskInstanceData instance, GroupData group, Long outputContentId) {
        try {
            Collection entries = ReportUtil.getLocalHome().findByTaskInstanceId((int)instance.getSid());
            ReportLocal reportData = (ReportLocal)EJBUtil.findSingle(entries);
            if (reportData != null) {
                log.warn((Object)("Session for task instance " + instance.toString() + " already exists. Not creating a new set of poll data."));
            } else {
                reportData = ReportUtil.getLocalHome().create();
                reportData.setTaskInstanceId(instance.getSid());
                reportData.setOutputContentId(outputContentId);
                reportData.setGroupName(group.getName());
                Map members = group.getMembers();
                Set groupUserIds = members.keySet();
                Iterator iter = groupUserIds.iterator();
                while (iter.hasNext()) {
                    Long userId = (Long)iter.next();
                    ReportLearnerLocal learner = this.setupUser(userId, (UserNameData)members.get(userId), instance.getSid());
                    reportData.addReportLearner(learner);
                }
                this.getSetupScribe(reportData);
                int minNum = (int)(0.6 * (double)members.size());
                if (minNum == 0) {
                    minNum = 1;
                }
                reportData.setMinNumberToAgree(minNum);
                log.debug((Object)("Setting min number to agree to " + minNum + " of " + members.size()));
            }
        }
        catch (NamingException e) {
            throw new EJBException((Exception)e);
        }
        catch (FinderException e) {
            throw new EJBException((Exception)((Object)e));
        }
        catch (CreateException e) {
            throw new EJBException((Exception)((Object)e));
        }
    }

    public void addUser(Long userId, UserNameData user, long taskInstanceId) throws GroupReportException, SystemException {
        try {
            Collection entries = ReportUtil.getLocalHome().findByTaskInstanceId((int)taskInstanceId);
            ReportLocal report = (ReportLocal)EJBUtil.findSingle(entries);
            if (!report.isGroupMember(userId)) {
                ReportLearnerLocal learner = this.setupUser(userId, user, taskInstanceId);
                report.addReportLearner(learner);
            }
            this.getSetupScribe(report);
        }
        catch (FinderException e) {
            this.getSessionContext().setRollbackOnly();
            throw new GroupReportException(e);
        }
        catch (CreateException e) {
            throw new SystemException(e);
        }
        catch (NamingException e) {
            throw new SystemException(e);
        }
    }

    private ReportLearnerLocal setupUser(Long userId, UserNameData user, long taskInstanceId) throws CreateException, NamingException {
        ReportLearnerLocal learner = ReportLearnerUtil.getLocalHome().create();
        learner.setUserId(userId);
        learner.setUsername(user.getLogin());
        learner.setTaskInstanceId(taskInstanceId);
        learner.setFirstName(user.getFirstName());
        learner.setLastName(user.getLastName());
        learner.setScribe(false);
        return learner;
    }

    private Long getSetupScribe(ReportLocal entry) {
        if (entry == null) {
            return null;
        }
        Long scribeUserId = null;
        if (entry != null && (scribeUserId = entry.getScribeUserId()) == null && (scribeUserId = this.appointScribe(entry.getReportLearners())) != null) {
            entry.setScribe(scribeUserId);
        }
        return scribeUserId;
    }

    public Long getScribeUserId(int taskInstanceId) {
        try {
            Collection entries = ReportUtil.getLocalHome().findByTaskInstanceId(taskInstanceId);
            ReportLocal entry = (ReportLocal)EJBUtil.findSingle(entries);
            return this.getSetupScribe(entry);
        }
        catch (FinderException e) {
            return null;
        }
        catch (NamingException e) {
            throw new EJBException((Exception)e);
        }
    }

    public String getScribeUserName(int taskInstanceId) {
        try {
            Collection entries = ReportUtil.getLocalHome().findByTaskInstanceId(taskInstanceId);
            ReportLocal entry = (ReportLocal)EJBUtil.findSingle(entries);
            Long scribeUserId = this.getSetupScribe(entry);
            String username = null;
            if (scribeUserId != null) {
                username = entry.getScribeUsername();
            }
            return username;
        }
        catch (FinderException e) {
            return null;
        }
        catch (NamingException e) {
            throw new EJBException((Exception)e);
        }
    }

    private Long appointScribe(Collection members) {
        Iterator iter;
        log.debug((Object)("Appointing scribe from members" + members));
        if (members != null && (iter = members.iterator()).hasNext()) {
            ReportLearnerLocal learner = (ReportLearnerLocal)iter.next();
            learner.setScribe(true);
            return new Long(learner.getUserId());
        }
        return null;
    }

    public Object[] getInfoByTaskInstance(int taskInstanceId) {
        try {
            Object[] returnItems = new Object[]{null, null, null, new Boolean(false)};
            Collection entries = ReportUtil.getLocalHome().findByTaskInstanceId(taskInstanceId);
            ReportLocal entry = (ReportLocal)EJBUtil.findSingle(entries);
            if (entry != null) {
                Collection convertedItems = this.convertItemsToData(entry.getReportItems());
                Map convertedUsers = this.convertUsersToData(entry.getReportLearners());
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Returning entry " + entry.getData() + " and " + convertedItems));
                }
                returnItems[0] = entry.getData();
                returnItems[1] = convertedItems;
                returnItems[2] = convertedUsers;
                returnItems[3] = new Boolean(entry.isComplete());
            }
            return returnItems;
        }
        catch (FinderException e) {
            return null;
        }
        catch (NamingException e) {
            throw new EJBException((Exception)e);
        }
    }

    public Hashtable getAgreementStatus(int taskInstanceId) {
        Hashtable<String, Integer> results = new Hashtable<String, Integer>();
        try {
            Collection entries = ReportUtil.getLocalHome().findByTaskInstanceId(taskInstanceId);
            ReportLocal entry = (ReportLocal)EJBUtil.findSingle(entries);
            if (entry != null) {
                results.put("number_agreed", new Integer(entry.getNumAgreed()));
                results.put("number_disagreed", new Integer(entry.getNumDisagreed()));
                results.put("number_in_group", new Integer(entry.getReportLearners().size()));
                results.put("number_minimum_agree", new Integer(entry.getMinNumberToAgree()));
            }
        }
        catch (FinderException e) {
            return null;
        }
        catch (NamingException e) {
            throw new EJBException((Exception)e);
        }
        log.debug((Object)("results for taskInstanceId " + taskInstanceId + " are " + (results != null ? results.toString() : "null")));
        return results;
    }

    public boolean setLearnerAgreement(int taskInstanceId, long userId, boolean agrees) {
        try {
            Collection entries = ReportUtil.getLocalHome().findByTaskInstanceId(taskInstanceId);
            ReportLocal entry = (ReportLocal)EJBUtil.findSingle(entries);
            if (entry != null) {
                boolean startsComplete = entry.isComplete();
                if (agrees) {
                    entry.addAgreedMember(userId);
                } else {
                    entry.addDisagreedMember(userId);
                }
                if (entry.isComplete() && !startsComplete) {
                    this.sendContent(entry);
                }
                return entry.isComplete();
            }
            return false;
        }
        catch (FinderException e) {
        }
        catch (NamingException e) {
            throw new EJBException((Exception)e);
        }
        return false;
    }

    public boolean forceEndReport(int taskInstanceId, long userId) {
        boolean didComplete = false;
        log.debug((Object)"in forceEndReport");
        try {
            Collection entries = ReportUtil.getLocalHome().findByTaskInstanceId(taskInstanceId);
            ReportLocal entry = (ReportLocal)EJBUtil.findSingle(entries);
            if (entry != null && (didComplete = entry.forceCompletion(userId))) {
                this.sendContent(entry);
            }
        }
        catch (FinderException e) {
        }
        catch (NamingException e) {
            throw new EJBException((Exception)e);
        }
        return didComplete;
    }

    public void updateReport(int taskInstanceId, Map entriesToUpdate) {
        log.debug((Object)("entriesToUpdate " + entriesToUpdate.toString()));
        try {
            Collection reportEntries = ReportUtil.getLocalHome().findByTaskInstanceId(taskInstanceId);
            ReportLocal report = (ReportLocal)EJBUtil.findSingle(reportEntries);
            Collection items = report.getReportItems();
            Iterator iter = items.iterator();
            while (iter.hasNext()) {
                ReportItemLocal entry = (ReportItemLocal)iter.next();
                log.debug((Object)("Checing entry " + entry.getData().toString()));
                Long sid = new Long(entry.getSid());
                String newText = (String)entriesToUpdate.get(sid);
                if (newText == null) continue;
                log.debug((Object)("Updating text to " + newText));
                entry.setBody(newText);
                entriesToUpdate.remove(sid);
            }
            if (!report.getAdvancedMode()) {
                report.clearAllMemberAgreement();
            }
        }
        catch (FinderException e) {
        }
        catch (NamingException e) {
            throw new EJBException((Exception)e);
        }
    }

    public DisplayTaskData completeSession(long userId, int taskInstanceId) throws GroupReportException {
        try {
            Collection entries = ReportUtil.getLocalHome().findByTaskInstanceId(taskInstanceId);
            ReportLocal entry = (ReportLocal)EJBUtil.findSingle(entries);
            if (entry == null) {
                throw new GroupReportException("no such task instance found");
            }
            log.debug((Object)"Sending completion status");
            DisplayTaskData displayTaskData = LearnerServiceDelegate.moveToNextTask(taskInstanceId, userId);
            return displayTaskData;
        }
        catch (NamingException e) {
            throw new EJBException((Exception)e);
        }
        catch (FinderException e) {
            throw new EJBException((Exception)((Object)e));
        }
        catch (TaskInstanceNotFoundException e) {
            throw new EJBException((Exception)e);
        }
        catch (ControllerException e) {
            throw new EJBException((Exception)e);
        }
        catch (SystemException e) {
            throw e;
        }
    }

    private void setContent(int taskInstanceId, Content content) {
        try {
            Collection coll = ReportUtil.getLocalHome().findByTaskInstanceId(taskInstanceId);
            ReportLocal reportData = (ReportLocal)EJBUtil.findSingle(coll);
            if (reportData == null) {
                log.error((Object)("setContent: no group reporting information found '" + taskInstanceId + "'"));
            } else {
                reportData.setTitle(content.getTitle() != null ? content.getTitle() : "");
                if (content.getBody() != null) {
                    String[] headings = StringUtils.split((String)content.getBody(), (String)"^");
                    for (int i = 0; i < headings.length; ++i) {
                        ReportItemLocal reportItem = ReportItemUtil.getLocalHome().create();
                        reportItem.setHeading(headings[i]);
                        reportItem.setBody("");
                        reportData.getReportItems().add(reportItem);
                    }
                }
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("group reporting content is " + (reportData != null ? reportData.getData().toString() + reportData.getReportItems() : "null")));
            }
        }
        catch (CreateException e) {
            e.printStackTrace();
            throw new EJBException((Exception)((Object)e));
        }
        catch (NamingException e) {
            e.printStackTrace();
            throw new EJBException((Exception)e);
        }
        catch (FinderException e) {
            e.printStackTrace();
            throw new EJBException((Exception)((Object)e));
        }
    }

    private Collection convertItemsToData(Collection reportItems) {
        if (reportItems == null) {
            return null;
        }
        Vector<ReportItemData> items = new Vector<ReportItemData>(reportItems.size());
        Iterator iter = reportItems.iterator();
        while (iter.hasNext()) {
            ReportItemLocal itemBean = (ReportItemLocal)iter.next();
            items.add(itemBean.getData());
        }
        return items;
    }

    private Map convertUsersToData(Collection users) {
        if (users == null) {
            return null;
        }
        HashMap<String, ReportLearnerData> items = new HashMap<String, ReportLearnerData>(users.size());
        Iterator iter = users.iterator();
        while (iter.hasNext()) {
            ReportLearnerLocal itemBean = (ReportLearnerLocal)iter.next();
            items.put(itemBean.getUsername(), itemBean.getData());
        }
        return items;
    }

    public Content createOutputContent(ReportLocal reportData) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Creating output content for reportData" + (reportData != null ? reportData.getData().toString() : "null")));
        }
        Content outputContent = new Content(null);
        if (reportData == null) {
            log.warn((Object)"createOutputContent: no reportData information supplied '");
            outputContent.setBaseContentSid(null);
            outputContent.setCreationTool("groupreporting");
            outputContent.setCreatorUserId(-1L);
            outputContent.setDescription("No report found for group");
            outputContent.setTitle("Group Report Missing");
        } else {
            outputContent.setBaseContentSid(reportData.getOutputContentId());
            outputContent.setCreationTool("groupreporting");
            outputContent.setCreatorUserId(-1L);
            outputContent.setTitle(reportData.getTitle());
            StringBuffer description = new StringBuffer(2000);
            String resultsURL = WebUtil.buildToolResultsUrl(GroupReportAction.GROUPREPORT_PATH, "getEditor", reportData.getTaskInstanceId(), GroupReportAction.SHOW_ENTRIES_ONLY + "=true");
            log.debug((Object)("Generated results url: " + resultsURL));
            outputContent.setBodyURL(resultsURL);
            Collection coll = reportData.getReportItems();
            if (coll != null) {
                description.append("\n");
                Iterator iter = coll.iterator();
                while (iter.hasNext()) {
                    ReportItemLocal item = (ReportItemLocal)iter.next();
                    description.append(item.getHeading());
                    description.append("\n");
                    description.append(item.getBody());
                    description.append("\n\n");
                }
            }
            if (description.length() == 0) {
                description.append("No text submitted for report");
            }
            outputContent.setBody(description.toString());
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("set output content to " + outputContent.toString()));
        }
        return outputContent;
    }

    private void sendContent(ReportLocal reportData) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Sending content for reportData: " + (reportData != null ? reportData.toString() : "null")));
        }
        try {
            if (reportData == null) {
                log.error((Object)"sendContent: no group reporting information supplied");
                return;
            }
            Long contentId = reportData.getOutputContentId();
            if (contentId != null) {
                ContentRepositoryLocal repo = ContentRepositoryUtil.getLocalHome().create();
                Content content = this.createOutputContent(reportData);
                log.debug((Object)("Saving content in repository with contentId " + contentId));
                repo.setContent(contentId, content);
            }
        }
        catch (ControllerException e) {
            throw new EJBException((Exception)e);
        }
        catch (NamingException e) {
            throw new EJBException((Exception)e);
        }
        catch (CreateException e) {
            throw new EJBException((Exception)((Object)e));
        }
    }

    public void deleteSession(TaskInstance taskInstance, Long inputContentId, Long outputContentId) throws ToolException, SystemException {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

