/*
 * Decompiled with CFR 0.152.
 */
package com.webmcq.ld.service;

import com.webmcq.ld.controller.ControllerException;
import com.webmcq.ld.controller.TaskInstance;
import com.webmcq.ld.controller.dao.TaskInstanceDAO;
import com.webmcq.ld.controller.dao.TaskInstanceNotFoundException;
import com.webmcq.ld.controller.dto.ControllerDTOFactory;
import com.webmcq.ld.controller.dto.GroupData;
import com.webmcq.ld.service.UserNotFoundException;
import com.webmcq.ld.util.BaseSessionBean;
import com.webmcq.ld.util.exception.SystemException;
import com.webmcq.ld.util.persistence.PersistenceSession;

public abstract class ControllerServiceBean
extends BaseSessionBean {
    public GroupData getTaskGroup(long taskInstanceId) throws ControllerException, UserNotFoundException {
        PersistenceSession sess = null;
        try {
            sess = new PersistenceSession();
            TaskInstanceDAO tidao = new TaskInstanceDAO(sess);
            TaskInstance taskInstance = tidao.find(taskInstanceId);
            sess.flush();
            GroupData groupData = ControllerDTOFactory.buildGroupData(taskInstance.getGroup(), taskInstance.getLearningSession().getSid());
            return groupData;
        }
        catch (TaskInstanceNotFoundException e) {
            this.getSessionContext().setRollbackOnly();
            throw new ControllerException(e);
        }
        catch (SystemException e) {
            this.getSessionContext().setRollbackOnly();
            throw e;
        }
        catch (UserNotFoundException e) {
            this.getSessionContext().setRollbackOnly();
            throw e;
        }
        finally {
            sess.close();
        }
    }
}

