/*
 * Decompiled with CFR 0.152.
 */
package com.webmcq.ld.controller.web;

import com.webmcq.ld.service.ConfigurationKeys;
import com.webmcq.ld.service.ConfigurationServiceDelegate;
import com.webmcq.ld.util.exception.SystemException;
import com.webmcq.ld.util.license.License;
import com.webmcq.ld.util.license.LicenseException;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.apache.log4j.Logger;

public class LicenseCheckerFilter
implements Filter {
    private License license;
    private static Logger log = Logger.getLogger((Class)(class$com$webmcq$ld$controller$web$LicenseCheckerFilter == null ? (class$com$webmcq$ld$controller$web$LicenseCheckerFilter = LicenseCheckerFilter.class$("com.webmcq.ld.controller.web.LicenseCheckerFilter")) : class$com$webmcq$ld$controller$web$LicenseCheckerFilter));
    static /* synthetic */ Class class$com$webmcq$ld$controller$web$LicenseCheckerFilter;

    public void init(FilterConfig config) throws ServletException {
    }

    public void doFilter(ServletRequest req, ServletResponse res, FilterChain chain) throws IOException, ServletException {
        try {
            if (this.license == null) {
                log.debug((Object)"initialising license checker");
                this.license = this.createLicenseChecker();
            }
            if (this.license.isValid()) {
                log.debug((Object)"checking license... valid");
                chain.doFilter(req, res);
            } else {
                log.debug((Object)"checking license... INVALID");
                req.setAttribute("error", (Object)"The license ticket is not valid");
                this.forward(req, res);
            }
        }
        catch (SystemException e) {
            log.debug((Object)("checking license... failed: " + e.getMessage()));
            req.setAttribute("error", (Object)e.getMessage());
            this.forward(req, res);
        }
    }

    private void forward(ServletRequest req, ServletResponse res) throws IOException, ServletException {
        RequestDispatcher dispatcher = req.getRequestDispatcher("/license_error.jsp");
        dispatcher.forward(req, res);
    }

    private License createLicenseChecker() throws SystemException {
        try {
            String ticketFile = ConfigurationServiceDelegate.get(ConfigurationKeys.LICENSE_TICKET_FILE);
            if (ticketFile == null) {
                throw new SystemException("The ticket file location is missing in the configuration.");
            }
            this.license = new License(ticketFile);
            this.license.check();
            return this.license;
        }
        catch (LicenseException e) {
            throw new SystemException(e.getMessage());
        }
    }

    public void destroy() {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

