/*
 * Decompiled with CFR 0.152.
 */
package com.webmcq.ld.controller.util;

import com.webmcq.ld.controller.dto.SimpleMessageData;
import com.webmcq.ld.controller.util.ControllerMessage;
import com.webmcq.ld.util.ObjectMessage;
import com.webmcq.ld.util.WDDXProcessor;
import com.webmcq.ld.util.exception.SystemException;
import java.io.IOException;

public class WDDXUtil {
    private static String noMessageMsg;

    public static String createCriticalErrorMsg(Exception e, String key) throws SystemException {
        try {
            ObjectMessage msg = new ObjectMessage(15, key, e.getMessage());
            return WDDXProcessor.serialize(msg);
        }
        catch (IOException ex) {
            throw new SystemException(ex);
        }
    }

    public static String createErrorMsg(Exception e, String key) throws SystemException {
        try {
            ObjectMessage msg = new ObjectMessage(13, key, e.getMessage());
            return WDDXProcessor.serialize(msg);
        }
        catch (IOException ex) {
            throw new SystemException(ex);
        }
    }

    public static String createACK(String requestName) throws SystemException {
        return WDDXUtil.createACK(requestName, 0L);
    }

    public static String createACK(String requestName, long learningSessionId) throws SystemException {
        try {
            ControllerMessage msg = new ControllerMessage(9, requestName, learningSessionId);
            return WDDXProcessor.serialize(msg);
        }
        catch (IOException ex) {
            throw new SystemException(ex);
        }
    }

    public static String createNoMessage() throws SystemException {
        try {
            if (noMessageMsg == null) {
                ObjectMessage msg = new ObjectMessage(12, "poll");
                msg.setBody("no message");
                noMessageMsg = WDDXProcessor.serialize(msg);
            }
            return noMessageMsg;
        }
        catch (IOException ex) {
            throw new SystemException(ex);
        }
    }

    public static String createMoveMessage(String requestCode, String body) throws SystemException {
        try {
            ObjectMessage msg = new ObjectMessage(40, requestCode, body);
            return WDDXProcessor.serialize(msg);
        }
        catch (IOException ex) {
            throw new SystemException(ex);
        }
    }

    public static String createMultiMessage(String requestCode, String url1, String url2, long learningSessionId) throws SystemException {
        try {
            ControllerMessage msg = new ControllerMessage(41, requestCode, "multi-task", learningSessionId);
            msg.setUrlA(url1);
            msg.setUrlB(url2);
            return WDDXProcessor.serialize(msg);
        }
        catch (IOException ex) {
            throw new SystemException(ex);
        }
    }

    public static String createACKMessage(String requestName, Object body) {
        try {
            ObjectMessage msg = new ObjectMessage(9, requestName, body);
            return WDDXProcessor.serialize(msg);
        }
        catch (IOException e) {
            throw new SystemException(e);
        }
    }

    public static String createACKMessage(String requestName, long sessionid) {
        return WDDXUtil.createACKMessage(requestName, null, sessionid);
    }

    public static String createACKMessage(String requestName, Object body, long sessionid) {
        try {
            ObjectMessage msg = new ObjectMessage(9, requestName, body, sessionid);
            return WDDXProcessor.serialize(msg);
        }
        catch (IOException e) {
            throw new SystemException(e);
        }
    }

    public static String convertSimpleMessage(String requestName, SimpleMessageData data) {
        try {
            ControllerMessage msg = new ControllerMessage(data.getMessageType(), requestName, data.getBody(), data.getSessionId());
            msg.setUrlA(data.getUrlA());
            msg.setUrlB(data.getUrlB());
            return WDDXProcessor.serialize(msg);
        }
        catch (IOException e) {
            throw new SystemException(e);
        }
    }
}

