/*
 * Decompiled with CFR 0.152.
 */
package com.webmcq.ld.controller.session;

import com.webmcq.ld.controller.ControllerException;
import com.webmcq.ld.controller.Learner;
import com.webmcq.ld.controller.LearningSession;
import com.webmcq.ld.controller.MultiTask;
import com.webmcq.ld.controller.MultiTaskInstance;
import com.webmcq.ld.controller.OptionalTask;
import com.webmcq.ld.controller.OptionalTaskInstance;
import com.webmcq.ld.controller.SingleTaskInstance;
import com.webmcq.ld.controller.SyncTask;
import com.webmcq.ld.controller.SyncTaskInstance;
import com.webmcq.ld.controller.Task;
import com.webmcq.ld.controller.TaskInstance;
import com.webmcq.ld.controller.dao.TaskInstanceDAO;
import com.webmcq.ld.controller.dao.TaskInstanceNotFoundException;
import com.webmcq.ld.controller.learner.Group;
import com.webmcq.ld.util.exception.SystemException;
import com.webmcq.ld.util.persistence.PersistenceSession;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import net.sf.hibernate.JDBCException;
import org.apache.log4j.Logger;

public class TaskInstanceFactory {
    private static Logger log = Logger.getLogger((Class)(class$com$webmcq$ld$controller$session$TaskInstanceFactory == null ? (class$com$webmcq$ld$controller$session$TaskInstanceFactory = TaskInstanceFactory.class$("com.webmcq.ld.controller.session.TaskInstanceFactory")) : class$com$webmcq$ld$controller$session$TaskInstanceFactory));
    static /* synthetic */ Class class$com$webmcq$ld$controller$session$TaskInstanceFactory;

    public static TaskInstance createTaskInstance(PersistenceSession sess, LearningSession lsession, Task task, Learner learner) throws ControllerException {
        TaskInstance taskInstance;
        switch (task.getType()) {
            case 2: {
                taskInstance = TaskInstanceFactory.getMutliTaskInstance(sess, lsession, task, learner);
                break;
            }
            case 5: {
                taskInstance = TaskInstanceFactory.getOptionalTaskInstance(sess, lsession, task, learner);
                break;
            }
            case 3: {
                taskInstance = TaskInstanceFactory.getSyncTaskInstance(sess, lsession, task, learner);
                break;
            }
            default: {
                taskInstance = TaskInstanceFactory.getSingleTaskInstance(sess, lsession, task, learner);
            }
        }
        sess.flush();
        return taskInstance;
    }

    private static TaskInstance getOptionalTaskInstance(PersistenceSession sess, LearningSession lsession, Task task, Learner learner) throws ControllerException {
        log.debug((Object)("getOptionalTaskInstance: " + task.getTask()));
        OptionalTask oTask = (OptionalTask)task;
        Iterator i = oTask.getSubTasks().iterator();
        ArrayList<TaskInstance> subTaskInstances = new ArrayList<TaskInstance>();
        while (i.hasNext()) {
            Task subTask = (Task)i.next();
            subTaskInstances.add(TaskInstanceFactory.createTaskInstance(sess, lsession, subTask, learner));
        }
        TaskInstance optionalTaskInstance = TaskInstanceFactory.doGetOptionalTaskInstance(sess, lsession, task, learner, subTaskInstances);
        if (optionalTaskInstance == null) {
            throw new ControllerException("optional task instance for task: " + task.getTask().getSid() + " not found");
        }
        return optionalTaskInstance;
    }

    private static TaskInstance doGetOptionalTaskInstance(PersistenceSession sess, LearningSession lsession, Task task, Learner learner, List subTaskInstances) throws ControllerException {
        Group group = lsession.getLearnerGroup().findGroup(task, learner);
        TaskInstanceDAO tiDao = new TaskInstanceDAO(sess);
        String uniqueCheck = TaskInstanceFactory.genUniqueCheckForOption(subTaskInstances);
        TaskInstance taskInstance = tiDao.findOptionalTask(lsession, task.getTask().getSid(), uniqueCheck);
        if (taskInstance == null) {
            log.debug((Object)"doGetOptionalTaskInstance");
            taskInstance = new OptionalTaskInstance(lsession, group, task, subTaskInstances);
            taskInstance.setUniqueCheck(uniqueCheck);
            try {
                tiDao.insert(taskInstance);
                sess.flushWithJDBCException();
            }
            catch (JDBCException e) {
                if (e.getErrorCode() == 1062) {
                    log.info((Object)"Instance inserted already, ignore");
                    return tiDao.findOptionalTask(lsession, task.getTask().getSid(), uniqueCheck);
                }
                throw new SystemException(e);
            }
            taskInstance.prepareTool();
        } else {
            log.debug((Object)("doGetOptionalTaskInstance: found '" + taskInstance.getSid() + "'"));
        }
        return taskInstance;
    }

    private static TaskInstance getMutliTaskInstance(PersistenceSession sess, LearningSession lsess, Task task, Learner learner) throws ControllerException {
        MultiTask mTask = (MultiTask)task;
        TaskInstance ti1 = TaskInstanceFactory.getSingleTaskInstance(sess, lsess, mTask.getTask1(), learner);
        TaskInstance ti2 = TaskInstanceFactory.getSingleTaskInstance(sess, lsess, mTask.getTask2(), learner);
        return TaskInstanceFactory.doGetMultiTaskInstance(sess, lsess, task, learner, ti1, ti2);
    }

    private static TaskInstance doGetMultiTaskInstance(PersistenceSession sess, LearningSession lsession, Task task, Learner learner, TaskInstance subTask1, TaskInstance subTask2) throws ControllerException, SystemException {
        try {
            Group group = lsession.getLearnerGroup().findGroup(task, learner);
            TaskInstanceDAO tiDao = new TaskInstanceDAO(sess);
            TaskInstance taskInstance = tiDao.findMultiTask(lsession, task.getTask().getSid(), subTask1, subTask2);
            if (taskInstance == null) {
                log.debug((Object)"doGetMultiTaskInstance: not found: create new");
                TaskInstance task1 = tiDao.find(subTask1.getSid());
                TaskInstance task2 = tiDao.find(subTask2.getSid());
                taskInstance = new MultiTaskInstance(lsession, group, task, task1, task2);
                String uniqueCheck = String.valueOf(task1.getSid()) + String.valueOf(task2.getSid());
                taskInstance.setUniqueCheck(uniqueCheck);
                try {
                    tiDao.insert(taskInstance);
                    sess.flushWithJDBCException();
                }
                catch (JDBCException e1) {
                    if (e1.getErrorCode() == 1062) {
                        log.error((Object)"duplicate insertion, we abort and load it from db");
                        log.info((Object)("Loading task instance: learning session [" + lsession.getSid() + "] task id [" + task.getTask().getSid() + "] subTask1[" + subTask1.getSid() + "]" + subTask2.getSid()));
                        return tiDao.findMultiTask(lsession, task.getTask().getSid(), subTask1, subTask2);
                    }
                    throw new SystemException(e1);
                }
            } else {
                log.debug((Object)("doGetMultiTaskInstance: found '" + taskInstance.getSid() + "'"));
            }
            return taskInstance;
        }
        catch (TaskInstanceNotFoundException e) {
            throw new ControllerException(e);
        }
    }

    private static TaskInstance getSingleTaskInstance(PersistenceSession sess, LearningSession lsession, Task task, Learner learner) throws ControllerException {
        Group group = lsession.getLearnerGroup().findGroup(task, learner);
        TaskInstanceDAO tiDao = new TaskInstanceDAO(sess);
        TaskInstance taskInstance = tiDao.find(lsession, task.getSid(), group);
        if (taskInstance == null) {
            log.debug((Object)"getSingleTaskInstance: not found: create new");
            taskInstance = new SingleTaskInstance(lsession, group, task);
            taskInstance.setUniqueCheck(String.valueOf(taskInstance.getGroup().getSid()));
            try {
                tiDao.insert(taskInstance);
                sess.flushWithJDBCException();
            }
            catch (JDBCException e) {
                if (e.getErrorCode() == 1062) {
                    log.error((Object)"duplicate insertion, we abort and load it from db");
                    log.info((Object)("Loading task instance: learning session [" + lsession.getSid() + "] task id [" + task.getSid() + "] group id" + group.getSid() + "]"));
                    return tiDao.find(lsession, task.getSid(), group);
                }
                throw new SystemException(e);
            }
            taskInstance.prepareTool();
        } else {
            log.debug((Object)("getSingleTaskInstance: found '" + taskInstance.getSid() + "'"));
        }
        return taskInstance;
    }

    private static TaskInstance getSyncTaskInstance(PersistenceSession sess, LearningSession lsession, Task task, Learner learner) throws ControllerException {
        log.debug((Object)("getSyncTaskInstance: " + task.getTask()));
        if (!(task instanceof SyncTask)) {
            throw new ControllerException("SyncTask expected but received '" + task.getClass().getName() + "'");
        }
        TaskInstanceDAO tiDao = new TaskInstanceDAO(sess);
        TaskInstance taskInstance = tiDao.findSyncTask(lsession, task.getSid());
        if (taskInstance == null) {
            log.debug((Object)"getSyncTaskInstance: not found: create new");
            taskInstance = new SyncTaskInstance(lsession, lsession.getLearners(), (SyncTask)task);
            taskInstance.setUniqueCheck(String.valueOf(taskInstance.getGroup().getSid()));
            try {
                tiDao.insert(taskInstance);
                sess.flushWithJDBCException();
            }
            catch (JDBCException e) {
                if (e.getErrorCode() == 1062) {
                    log.error((Object)"duplicate insertion, we abort and load it from db");
                    log.info((Object)("Loading task instance: learning session [" + lsession.getSid() + "] task id [" + task.getSid() + "]"));
                    return tiDao.findSyncTask(lsession, task.getSid());
                }
                throw new SystemException(e);
            }
            taskInstance.prepareTool();
        } else {
            log.debug((Object)("getSyncTaskInstance: found '" + taskInstance.getSid() + "'"));
        }
        return taskInstance;
    }

    public static MultiTaskInstance initMultiTask(LearningSession lsession, MultiTask task, PersistenceSession sess, TaskInstanceDAO tiDao) throws ControllerException, SystemException {
        MultiTaskInstance multiTaskInstance = null;
        boolean hasGroupTask = false;
        Group wholeClass = lsession.getLearners();
        SingleTaskInstance subTaskInstance1 = null;
        SingleTaskInstance subTaskInstance2 = null;
        if (task.getTask1().isGroupTask()) {
            hasGroupTask = true;
        } else {
            subTaskInstance1 = TaskInstanceFactory.initNonGroupSimpleTask(lsession, task.getTask1(), wholeClass, sess, tiDao);
        }
        if (task.getTask2().isGroupTask()) {
            hasGroupTask = true;
        } else {
            subTaskInstance2 = TaskInstanceFactory.initNonGroupSimpleTask(lsession, task.getTask2(), wholeClass, sess, tiDao);
        }
        if (!hasGroupTask) {
            multiTaskInstance = (MultiTaskInstance)tiDao.find(lsession, task.getSid(), wholeClass);
            if (multiTaskInstance == null) {
                multiTaskInstance = new MultiTaskInstance(lsession, wholeClass, task, subTaskInstance1, subTaskInstance2);
                String uniqueCheck = String.valueOf(subTaskInstance1.getSid()) + String.valueOf(subTaskInstance2.getSid());
                multiTaskInstance.setUniqueCheck(uniqueCheck);
                try {
                    tiDao.insert(multiTaskInstance);
                    sess.flushWithJDBCException();
                }
                catch (JDBCException e) {
                    if (e.getErrorCode() == 1062) {
                        log.info((Object)"Instance inserted already, we ignor");
                    }
                    throw new SystemException(e);
                }
            } else {
                log.debug((Object)("getMultiTaskInstance: found '" + multiTaskInstance.getSid() + "'"));
            }
        }
        return multiTaskInstance;
    }

    private static SingleTaskInstance initNonGroupSimpleTask(LearningSession lsession, Task task, Group group, PersistenceSession sess, TaskInstanceDAO tiDao) throws ControllerException, SystemException {
        SingleTaskInstance singleTaskInstance = (SingleTaskInstance)tiDao.find(lsession, task.getSid(), group);
        if (singleTaskInstance == null) {
            log.debug((Object)"getSingleTaskInstance: not found: create new");
            singleTaskInstance = new SingleTaskInstance(lsession, group, task);
            singleTaskInstance.setUniqueCheck(String.valueOf(singleTaskInstance.getGroup().getSid()));
            try {
                tiDao.insert(singleTaskInstance);
                sess.flushWithJDBCException();
            }
            catch (JDBCException e) {
                if (e.getErrorCode() == 1062) {
                    log.info((Object)"Instance inserted already, we ignore");
                }
                throw new SystemException(e);
            }
            singleTaskInstance.prepareTool();
        } else {
            log.debug((Object)("getSingleTaskInstance: found '" + singleTaskInstance.getSid() + "'"));
        }
        return singleTaskInstance;
    }

    public static void initSimpleTask(LearningSession lsession, Task task, PersistenceSession sess, TaskInstanceDAO tiDao) throws ControllerException, SystemException {
        if (!task.isGroupTask()) {
            TaskInstanceFactory.initNonGroupSimpleTask(lsession, task, lsession.getLearners(), sess, tiDao);
        }
    }

    public static SingleTaskInstance initGroupingTask(LearningSession lsession, Task task, PersistenceSession sess, TaskInstanceDAO tiDao) throws ControllerException, SystemException {
        return TaskInstanceFactory.initNonGroupSimpleTask(lsession, task, lsession.getLearners(), sess, tiDao);
    }

    public static SyncTaskInstance initSyncTask(LearningSession lsession, Task task, PersistenceSession sess, TaskInstanceDAO tiDao) throws ControllerException, SystemException {
        SyncTaskInstance syncTaskInstance = (SyncTaskInstance)tiDao.find(lsession, task.getSid(), lsession.getLearners());
        if (syncTaskInstance == null) {
            log.debug((Object)"getSingleTaskInstance: not found: create new");
            syncTaskInstance = new SyncTaskInstance(lsession, lsession.getLearners(), (SyncTask)task);
            syncTaskInstance.setUniqueCheck(String.valueOf(syncTaskInstance.getGroup().getSid()));
            try {
                tiDao.insert(syncTaskInstance);
                sess.flushWithJDBCException();
            }
            catch (JDBCException e) {
                if (e.getErrorCode() == 1062) {
                    log.info((Object)"Instance inserted already, we ignor");
                }
                throw new SystemException(e);
            }
            syncTaskInstance.prepareTool();
        } else {
            log.debug((Object)("getSyncTaskInstance: found '" + syncTaskInstance.getSid() + "'"));
        }
        return syncTaskInstance;
    }

    public static void initOptionalTask(LearningSession lsession, OptionalTask task, PersistenceSession sess, TaskInstanceDAO tiDao) throws ControllerException, SystemException {
        boolean hasGroupTask = false;
        Group wholeClass = lsession.getLearners();
        ArrayList<TaskInstance> list = new ArrayList<TaskInstance>();
        Iterator iter = task.getSubTasks().iterator();
        block8: while (iter.hasNext()) {
            Task subTask = (Task)iter.next();
            switch (subTask.getType()) {
                case 2: {
                    MultiTask multiTask = (MultiTask)subTask;
                    list.add(TaskInstanceFactory.initMultiTask(lsession, multiTask, sess, tiDao));
                    if (!multiTask.hasGroupTask()) continue block8;
                    hasGroupTask = true;
                    continue block8;
                }
                case 1: {
                    if (subTask.isGroupTask()) {
                        hasGroupTask = true;
                        continue block8;
                    }
                    list.add(TaskInstanceFactory.initNonGroupSimpleTask(lsession, subTask, wholeClass, sess, tiDao));
                    continue block8;
                }
                case 3: {
                    list.add(TaskInstanceFactory.initSyncTask(lsession, subTask, sess, tiDao));
                    continue block8;
                }
                case 4: {
                    list.add(TaskInstanceFactory.initGroupingTask(lsession, subTask, sess, tiDao));
                    continue block8;
                }
            }
            throw new SystemException("Unexpected task type found in subtasks of optional task");
        }
        if (!hasGroupTask) {
            OptionalTaskInstance optionalTaskInstance = (OptionalTaskInstance)tiDao.find(lsession, task.getSid(), wholeClass);
            if (optionalTaskInstance == null) {
                log.debug((Object)"getOptionalTaskInstance: not found: create new");
                optionalTaskInstance = new OptionalTaskInstance(lsession, wholeClass, task, list);
                optionalTaskInstance.setUniqueCheck(TaskInstanceFactory.genUniqueCheckForOption(list));
                try {
                    tiDao.insert(optionalTaskInstance);
                    sess.flushWithJDBCException();
                }
                catch (JDBCException e) {
                    if (e.getErrorCode() == 1062) {
                        log.info((Object)"Instance inserted already, ignore");
                    }
                    throw new SystemException(e);
                }
                optionalTaskInstance.prepareTool();
            } else {
                log.debug((Object)("getSingleTaskInstance: found '" + optionalTaskInstance.getSid() + "'"));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void initTask(LearningSession lsession, Task task) throws ControllerException, SystemException {
        block8: {
            if (task.isGroupTask()) {
                return;
            }
            PersistenceSession sess = null;
            try {
                sess = new PersistenceSession();
                TaskInstanceDAO tiDao = new TaskInstanceDAO(sess);
                TaskInstance taskInstance = tiDao.find(lsession, task.getSid(), lsession.getLearners());
                if (taskInstance == null) {
                    log.debug((Object)"getSingleTaskInstance: not found: create new");
                    taskInstance = new SingleTaskInstance(lsession, lsession.getLearners(), task);
                    taskInstance.setUniqueCheck(String.valueOf(taskInstance.getGroup().getSid()));
                    try {
                        tiDao.insert(taskInstance);
                    }
                    catch (JDBCException e) {
                        if (e.getErrorCode() == 1062) {
                            log.info((Object)"Instance inserted already, we ignor");
                        }
                        throw new SystemException(e);
                    }
                    sess.flush();
                    taskInstance.prepareTool();
                    break block8;
                }
                log.debug((Object)("getSingleTaskInstance: found '" + taskInstance.getSid() + "'"));
            }
            finally {
                sess.close();
            }
        }
    }

    private static String genUniqueCheckForOption(List list) {
        String uniqueCheck = "";
        TreeSet<String> idSet = new TreeSet<String>();
        Iterator iterTaskInstance = list.iterator();
        while (iterTaskInstance.hasNext()) {
            TaskInstance subTaskInstance = (TaskInstance)iterTaskInstance.next();
            idSet.add(String.valueOf(subTaskInstance.getSid()));
        }
        Iterator iterString = idSet.iterator();
        while (iterString.hasNext()) {
            uniqueCheck = uniqueCheck + (String)iterString.next();
        }
        return uniqueCheck;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

