/*
 * Decompiled with CFR 0.152.
 */
package com.webmcq.ld.controller.preview;

import com.webmcq.ld.controller.Activity;
import com.webmcq.ld.controller.OptionalActivity;
import com.webmcq.ld.controller.design.LearningDesign;
import com.webmcq.ld.controller.design.LearningDesignException;
import com.webmcq.ld.controller.preview.ActivityInstance;
import com.webmcq.ld.controller.preview.LearningDesignIterator;
import com.webmcq.ld.controller.preview.OptionalActivityInstance;
import com.webmcq.ld.controller.preview.PreviewTaskInstanceFactory;
import com.webmcq.ld.controller.preview.SingleActivityInstance;
import com.webmcq.ld.controller.preview.SingleActivityIterator;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class LearningDesignInstance
implements Serializable {
    private LearningDesign design;
    private LearningDesignIterator iterator;
    private PreviewTaskInstanceFactory factory;
    private ActivityInstance activity;
    private Map activityInstancePool;

    public LearningDesignInstance(LearningDesign design, LearningDesignIterator iterator, PreviewTaskInstanceFactory factory) {
        this.design = design;
        this.iterator = iterator;
        this.factory = factory;
        this.activityInstancePool = new HashMap();
    }

    public ActivityInstance getActivityInstance() {
        if (this.iterator.hasNext()) {
            Activity act = this.iterator.next();
            if (act.getType() == 1001) {
                SingleActivityIterator iter = new SingleActivityIterator(act);
                return new SingleActivityInstance(iter, this.factory);
            }
            if (act.getType() == 1002) {
                return new OptionalActivityInstance(null, this.factory, (OptionalActivity)act);
            }
            throw new LearningDesignException("unknown activity type '" + act.getType() + "'");
        }
        return null;
    }

    public boolean hasNext() {
        return this.iterator.hasNext();
    }

    public LearningDesign getLearingDesign() {
        return this.design;
    }
}

