/*
 * Decompiled with CFR 0.152.
 */
package com.webmcq.ld.controller;

import com.webmcq.ld.controller.ControllerException;
import com.webmcq.ld.controller.DisplayTaskData;
import com.webmcq.ld.controller.Learner;
import com.webmcq.ld.controller.LearningSession;
import com.webmcq.ld.controller.Task;
import com.webmcq.ld.controller.TaskInstance;
import com.webmcq.ld.controller.ToolProxy;
import com.webmcq.ld.controller.design.TaskManager;
import com.webmcq.ld.controller.dto.TaskInstanceData;
import com.webmcq.ld.controller.learner.Group;
import org.apache.log4j.Logger;

public class MultiTaskInstance
extends TaskInstance {
    private TaskInstance taskInstance1;
    private TaskInstance taskInstance2;
    private static Logger log = Logger.getLogger((Class)(class$com$webmcq$ld$controller$MultiTaskInstance == null ? (class$com$webmcq$ld$controller$MultiTaskInstance = MultiTaskInstance.class$("com.webmcq.ld.controller.MultiTaskInstance")) : class$com$webmcq$ld$controller$MultiTaskInstance));
    static /* synthetic */ Class class$com$webmcq$ld$controller$MultiTaskInstance;

    protected MultiTaskInstance() {
    }

    public MultiTaskInstance(LearningSession lsession, Group group, Task task, TaskInstance ti1, TaskInstance ti2) {
        super(lsession, group);
        this.setTask(task);
        this.taskInstance1 = ti1;
        this.taskInstance2 = ti2;
    }

    public Task getTask() {
        return TaskManager.getMultiTask(this.getTaskSid(), this.taskInstance1.getTask(), this.taskInstance2.getTask());
    }

    private void setTask(Task task) {
        if (task == null) {
            this.setTaskSid(0L);
        } else {
            this.setTaskSid(task.getSid());
        }
    }

    public TaskInstanceData getData() {
        return new TaskInstanceData(this.getSid(), this.getTask().getTitle(), 0, this.getTaskSid(), this.getLearningSession().getOwnerId(), null, this.getLearningSession().getSid());
    }

    public void prepareTool() throws ControllerException {
        log.debug((Object)"prepareTool");
        this.taskInstance1.prepareTool();
        this.taskInstance2.prepareTool();
    }

    public DisplayTaskData run(Learner learner) {
        log.info((Object)("run: learner " + learner.getSid()));
        String[] urls = this.perform(learner, "run");
        DisplayTaskData displayTaskData = new DisplayTaskData(41);
        displayTaskData.setSessionId(learner.getLearningSession().getSid());
        displayTaskData.setTaskId(this.getSid());
        displayTaskData.setUrlA(urls[0]);
        displayTaskData.setUrlB(urls[1]);
        return displayTaskData;
    }

    public DisplayTaskData view() {
        String[] urls = new String[]{this.taskInstance1.getToolProxy().getUrl(this.taskInstance1, "checkup"), this.taskInstance2.getToolProxy().getUrl(this.taskInstance2, "checkup")};
        DisplayTaskData displayTaskData = new DisplayTaskData(52);
        displayTaskData.setUrlA(urls[0]);
        return displayTaskData;
    }

    public String[] checkup(Learner learner) {
        String[] urls = new String[]{this.taskInstance1.getToolProxy().getUrl(this.taskInstance1, "checkup"), this.taskInstance2.getToolProxy().getUrl(this.taskInstance2, "checkup")};
        urls[0] = urls[0] + "&userId=" + learner.getUserId();
        urls[1] = urls[1] + "&userId=" + learner.getUserId();
        return urls;
    }

    public DisplayTaskData resume(Learner learner) {
        log.info((Object)("resume: learner " + learner.getSid()));
        DisplayTaskData displayTaskData = new DisplayTaskData(50);
        displayTaskData.setSessionId(learner.getLearningSession().getSid());
        displayTaskData.setTaskId(this.getSid());
        displayTaskData.setUrlA(this.taskInstance1.getToolProxy().getUrl(this.taskInstance1, "resume"));
        displayTaskData.setUrlB(this.taskInstance2.getToolProxy().getUrl(this.taskInstance2, "resume"));
        return displayTaskData;
    }

    private String[] perform(Learner learner, String mode) {
        String urlA = this.taskInstance1.getToolProxy().getUrl(this.taskInstance1, mode);
        String urlB = this.taskInstance2.getToolProxy().getUrl(this.taskInstance2, mode);
        String[] urls = new String[]{urlA, urlB};
        return urls;
    }

    public void participate(Learner learner) {
        super.participate(learner);
        this.taskInstance1.participate(learner);
        this.taskInstance2.participate(learner);
    }

    public ToolProxy getToolProxy() {
        return null;
    }

    public void setToolProxy(ToolProxy tool) {
    }

    public TaskInstance getTaskInstance1() {
        return this.taskInstance1;
    }

    public TaskInstance getTaskInstance2() {
        return this.taskInstance2;
    }

    private void setTaskInstance1(TaskInstance taskInstance1) {
        this.taskInstance1 = taskInstance1;
    }

    private void setTaskInstance2(TaskInstance taskInstance2) {
        this.taskInstance2 = taskInstance2;
    }

    public void complete(Learner learner) {
    }

    public boolean isComplete() {
        return this.taskInstance1.isComplete() && this.taskInstance2.isComplete();
    }

    public boolean hasCompleted(Learner learner) {
        return this.taskInstance1.hasCompleted(learner) && this.taskInstance2.hasCompleted(learner);
    }

    public String getToolType() {
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

