/*
 * Decompiled with CFR 0.152.
 */
package com.webmcq.ld.activities.authoring;

import com.webmcq.ld.activities.authoring.HashtableUtils;
import com.webmcq.ld.content.Content;
import com.webmcq.ld.content.GroupingDefnContent;
import com.webmcq.ld.content.MBAuthoringContent;
import com.webmcq.ld.content.MBAuthoringContentTopic;
import com.webmcq.ld.content.QuestionAnswerEntry;
import com.webmcq.ld.content.QuestionContent;
import com.webmcq.ld.content.QuestionEntry;
import com.webmcq.ld.content.SurveyCandidateAnswers;
import com.webmcq.ld.content.SurveyContent;
import com.webmcq.ld.content.SurveyQuestionEntry;
import com.webmcq.ld.content.UrlContent;
import com.webmcq.ld.content.UrlContentEntry;
import com.webmcq.ld.content.UrlContentEntryInstruction;
import com.webmcq.ld.content.VotingContent;
import com.webmcq.ld.content.VotingContentNomination;
import com.webmcq.ld.util.WDDXProcessor;
import com.webmcq.ld.util.WDDXProcessorConversionException;
import com.webmcq.ld.util.exception.BusinessException;
import com.webmcq.ld.util.exception.SystemException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.Vector;
import org.apache.log4j.Logger;

class ContentConverter {
    private static Logger log = Logger.getLogger((Class)(class$com$webmcq$ld$activities$authoring$ContentConverter == null ? (class$com$webmcq$ld$activities$authoring$ContentConverter = ContentConverter.class$("com.webmcq.ld.activities.authoring.ContentConverter")) : class$com$webmcq$ld$activities$authoring$ContentConverter));
    static /* synthetic */ Class class$com$webmcq$ld$activities$authoring$ContentConverter;

    ContentConverter() {
    }

    public void convertToDBData(Hashtable clientObj, Content content, Integer objId) throws WDDXProcessorConversionException, BusinessException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Updating content object " + content + "with " + clientObj));
        }
        content.setBody(HashtableUtils.getValue((String)clientObj.get("body")));
        content.setCreationTool("authoring");
        content.setCreationToolKey(objId.toString());
        content.setDescription(HashtableUtils.getValue((String)clientObj.get("description")));
        content.setTitle(HashtableUtils.getValue((String)clientObj.get("title")));
        content.setReplaceWithDynamic(false);
        Boolean bool = WDDXProcessor.convertToBoolean("Allow to show the user's name ", clientObj.get("contentShowUser"));
        content.setShowUser(bool);
        bool = WDDXProcessor.convertToBoolean("Allow to define the content later ", clientObj.get("contentDefineLater"));
        content.setDefineLater(bool);
        bool = WDDXProcessor.convertToBoolean("Allow to define html ", clientObj.get("isHTML"));
        content.setHTML(bool);
        bool = WDDXProcessor.convertToBoolean("Is later reuse of this tool allowed?", clientObj.get("isReusable"));
        content.setReusable(bool != null ? bool : false);
        if ("grouping".equals(content.theContentType())) {
            GroupingDefnContent gcontent = (GroupingDefnContent)content;
            gcontent.setNumGroups(WDDXProcessor.convertToInteger("Number of groups", clientObj.get("number_groups")));
            gcontent.setMinNumberMembers(WDDXProcessor.convertToInteger("Minimum number of learners in group", clientObj.get("min_number_in_group")));
            gcontent.setMaxNumberMembers(WDDXProcessor.convertToInteger("Maximum number of learners in group", clientObj.get("max_number_in_group")));
        } else if ("voting".equals(content.theContentType())) {
            this.updateVotingContent(clientObj, (VotingContent)content);
        } else if ("MBAuthoring".equals(content.theContentType())) {
            this.updateMBContent(clientObj, (MBAuthoringContent)content);
        } else if ("urlcontent".equals(content.theContentType())) {
            this.updateUrlContent(clientObj, (UrlContent)content);
        } else if ("questioncontent".equals(content.theContentType())) {
            this.updateQuestionContent(clientObj, (QuestionContent)content);
        } else if ("surveycontent".equals(content.theContentType())) {
            this.updateSurveyContent(clientObj, (SurveyContent)content);
        }
    }

    private void updateSurveyContent(Hashtable clientObj, SurveyContent content) throws WDDXProcessorConversionException {
        Iterator iter;
        content.setSummary((String)clientObj.get("summary"));
        SurveyContent scontent = SurveyContent.newInstance(content);
        Vector questionSet = HashtableUtils.getCollectionDataFromHashTable("questions", clientObj);
        log.debug((Object)("Survey question set is " + questionSet.toString()));
        if (scontent.getSurveyQuestions() == null) {
            scontent.setSurveyQuestions(new HashSet());
        }
        Map questionToUpdate = this.buildQuestionMap(scontent.getSurveyQuestions(), scontent.theContentType());
        HashSet<Long> sidsUpdated = new HashSet<Long>();
        if (questionSet != null) {
            iter = questionSet.iterator();
            while (iter.hasNext()) {
                Hashtable questionInput = (Hashtable)iter.next();
                Integer displayOrder = WDDXProcessor.nullSafeCovertToInteger("Order", questionInput.get("order"));
                SurveyQuestionEntry questionData = (SurveyQuestionEntry)questionToUpdate.get(displayOrder);
                if (questionData == null) {
                    questionData = new SurveyQuestionEntry();
                    questionData.setDisplayOrder(displayOrder);
                    scontent.getSurveyQuestions().add(questionData);
                }
                String questionType = (String)questionInput.get("questionType");
                questionData.setQuestionType(questionType);
                String str = (String)questionInput.get("question");
                questionData.setQuestion(str);
                Boolean bool = WDDXProcessor.convertToBoolean("Enable the other field for a choice question ", questionInput.get("isTextBoxEnabled"));
                questionData.setIsTextBoxEnabled(bool != null ? bool : false);
                bool = WDDXProcessor.convertToBoolean("Is the question optional?", questionInput.get("isOptional"));
                questionData.setIsOptional(bool != null ? bool : false);
                this.processSurveyQuestionAnswers(HashtableUtils.getCollectionDataFromHashTable("candidates", questionInput), questionData);
                sidsUpdated.add(new Long(questionData.getSid()));
            }
        }
        iter = scontent.getSurveyQuestions().iterator();
        while (iter.hasNext()) {
            SurveyQuestionEntry questionData = (SurveyQuestionEntry)iter.next();
            if (sidsUpdated.contains(new Long(questionData.getSid()))) continue;
            log.debug((Object)("Removing QuestionEntry entry, no longer needed " + questionData.toString()));
            iter.remove();
        }
        log.debug((Object)("New content is " + scontent.toString()));
    }

    private void processSurveyQuestionAnswers(Collection questionInput, SurveyQuestionEntry questionData) throws WDDXProcessorConversionException {
        if (questionData.getCandidateAnswers() == null) {
            questionData.setCandidateAnswers(new HashSet());
        } else {
            questionData.getCandidateAnswers().clear();
        }
        if (questionInput != null) {
            Iterator candIter = questionInput.iterator();
            while (candIter.hasNext()) {
                Hashtable cand = (Hashtable)candIter.next();
                Integer displayOrder = WDDXProcessor.nullSafeCovertToInteger("Order", cand.get("order"));
                String answerString = (String)cand.get("answer");
                SurveyCandidateAnswers entry = new SurveyCandidateAnswers();
                entry.setAnswerEntry(answerString);
                entry.setDisplayOrder(displayOrder);
                questionData.getCandidateAnswers().add(entry);
            }
        }
    }

    private void updateMBContent(Hashtable clientObj, MBAuthoringContent mbContent) throws WDDXProcessorConversionException, BusinessException {
        mbContent.setTerminationType((String)clientObj.get("terminationType"));
        mbContent.setDurationInDays(WDDXProcessor.convertToInteger("Duration in days", clientObj.get("durationInDays")));
        Boolean bool = WDDXProcessor.convertToBoolean("Is Posting Notified", clientObj.get("isPostingNotified"));
        mbContent.setPostingNotified(bool != null ? bool : false);
        bool = WDDXProcessor.convertToBoolean("Is Posting Moderated", clientObj.get("isPostingModerated"));
        mbContent.setPostingModerated(bool != null ? bool : false);
        bool = WDDXProcessor.convertToBoolean("Is New Topic Allowed", clientObj.get("isNewTopicAllowed"));
        mbContent.setNewTopicAllowed(bool != null ? bool : false);
        Vector topics = (Vector)clientObj.get("topics");
        if (mbContent.getTopics() == null) {
            mbContent.setTopics(new HashSet());
        }
        mbContent.getTopics().clear();
        if (topics != null && topics.size() != 0) {
            Iterator iter = topics.iterator();
            while (iter.hasNext()) {
                Hashtable topicObj = (Hashtable)iter.next();
                Integer topicNumber = WDDXProcessor.convertToInteger("Topic Sequence Number", topicObj.get("number"));
                if (topicNumber == null) {
                    throw new BusinessException("Topic number missing from message board '" + mbContent.getTitle() + "' topic item '" + topicObj.toString() + "'");
                }
                MBAuthoringContentTopic topic = new MBAuthoringContentTopic();
                topic.setTopicNumber(topicNumber);
                topic.setMessage((String)topicObj.get("message"));
                topic.setSubject((String)topicObj.get("subject"));
                topic.setTopicTitle((String)topicObj.get("title"));
                mbContent.getTopics().add(topic);
            }
        }
    }

    private void updateUrlContent(Hashtable clientObj, UrlContent urlContent) throws WDDXProcessorConversionException {
        Iterator iter;
        urlContent.setBodyURL(HashtableUtils.getValue((String)clientObj.get("directoryName")));
        Boolean bool = WDDXProcessor.convertToBoolean("staff submit url at runtime ", clientObj.get("runtimeSubmissionStaffURL"));
        urlContent.setRuntimeSubmissionStaffURL(bool != null ? bool : false);
        bool = WDDXProcessor.convertToBoolean("learner submit url at runtime", clientObj.get("runtimeSubmissionLearnerURL"));
        urlContent.setRuntimeSubmissionLearnerURL(bool != null ? bool : false);
        bool = WDDXProcessor.convertToBoolean("staff submit file at runtime", clientObj.get("runtimeSubmissionStaffFile"));
        urlContent.setRuntimeSubmissionStaffFile(bool != null ? bool : false);
        bool = WDDXProcessor.convertToBoolean("learner submit file at runtime", clientObj.get("runtimeSubmissionLearnerFile"));
        urlContent.setRuntimeSubmissionLearnerFile(bool != null ? bool : false);
        Integer minComplete = WDDXProcessor.convertToInteger("minimum number of urls to complete", clientObj.get("minNumberComplete"));
        urlContent.setMinNumToComplete(minComplete != null ? minComplete : 0);
        Collection urlSet = (Collection)clientObj.get("urls");
        if (urlContent.getUrls() == null) {
            urlContent.setUrls(new HashSet());
        }
        Map urlToUpdate = this.buildUrlMap(urlContent.getUrls());
        HashSet<Long> sidsUpdated = new HashSet<Long>();
        if (urlSet != null) {
            iter = urlSet.iterator();
            while (iter.hasNext()) {
                Hashtable urlInput = (Hashtable)iter.next();
                Integer viewOrder = WDDXProcessor.convertToInteger("Order", urlInput.get("order"));
                UrlContentEntry urlData = (UrlContentEntry)urlToUpdate.get(viewOrder);
                if (urlData == null) {
                    urlData = new UrlContentEntry();
                    urlData.setViewOrder(viewOrder);
                    urlContent.getUrls().add(urlData);
                    log.debug((Object)("Created new content " + urlData));
                } else {
                    log.debug((Object)("Found existing content " + urlData.toString()));
                }
                urlData.setTitle((String)urlInput.get("title"));
                urlData.setUrl((String)urlInput.get("url"));
                bool = WDDXProcessor.convertToBoolean("show buttons for popup window", urlInput.get("showbuttons"));
                urlData.setShowButtons(bool != null ? bool : false);
                bool = WDDXProcessor.convertToBoolean("prefer download", urlInput.get("download"));
                log.debug((Object)("prefer download is " + bool));
                urlData.setPreferDownload(bool != null ? bool : false);
                this.processInstructions((Collection)urlInput.get("instructions"), urlData);
                sidsUpdated.add(urlData.getSid());
            }
        }
        iter = urlContent.getUrls().iterator();
        while (iter.hasNext()) {
            UrlContentEntry urlData = (UrlContentEntry)iter.next();
            if (sidsUpdated.contains(urlData.getSid())) continue;
            iter.remove();
        }
    }

    private void processInstructions(Collection instructionInput, UrlContentEntry urlData) throws WDDXProcessorConversionException {
        if (urlData.getInstructions() == null) {
            urlData.setInstructions(new HashSet());
        } else {
            urlData.getInstructions().clear();
        }
        if (instructionInput != null) {
            Iterator instructIter = instructionInput.iterator();
            while (instructIter.hasNext()) {
                Hashtable instruct = (Hashtable)instructIter.next();
                int viewOrder = WDDXProcessor.convertToInt("Order", instruct.get("order"));
                String text = (String)instruct.get("instruction");
                UrlContentEntryInstruction entry = new UrlContentEntryInstruction();
                entry.setInstruction(text);
                entry.setViewOrder(viewOrder);
                urlData.getInstructions().add(entry);
            }
        }
    }

    private Map buildUrlMap(Collection urls) {
        HashMap<Integer, UrlContentEntry> map = new HashMap<Integer, UrlContentEntry>();
        if (urls != null) {
            Iterator iter = urls.iterator();
            while (iter.hasNext()) {
                UrlContentEntry element = (UrlContentEntry)iter.next();
                map.put(new Integer(element.getViewOrder()), element);
            }
        }
        return map;
    }

    private void updateVotingContent(Hashtable clientObj, VotingContent vcontent) throws WDDXProcessorConversionException {
        Boolean boolTemp = WDDXProcessor.convertToBoolean("allow poll nominations", clientObj.get("nominatePollTime"));
        vcontent.setAllowPollNominations(boolTemp != null ? boolTemp : false);
        boolTemp = WDDXProcessor.convertToBoolean("progress results display", clientObj.get("progressive_display"));
        vcontent.setProgressiveDisplay(boolTemp != null ? boolTemp : false);
        Integer max = WDDXProcessor.convertToInteger("max to choose", clientObj.get("maxChoose"));
        vcontent.setMaxToChoose(max != null ? max : -1);
        String method = (String)clientObj.get("voteMethod");
        vcontent.setVoteMethod(method != null ? method : "equal");
        Collection nominationStrings = (Collection)clientObj.get("nominations");
        if (vcontent.getNominations() == null) {
            vcontent.setNominations(new HashSet());
        }
        vcontent.getNominations().clear();
        if (nominationStrings != null) {
            Iterator iter = nominationStrings.iterator();
            while (iter.hasNext()) {
                VotingContentNomination nomination = new VotingContentNomination();
                nomination.setNomination((String)iter.next());
                nomination.setNumberVotes(0L);
                nomination.setWhenNominated("PREPOLL");
                vcontent.getNominations().add(nomination);
            }
        }
    }

    private void updateQuestionContent(Hashtable clientObj, QuestionContent qcontent) throws WDDXProcessorConversionException {
        Iterator iter;
        log.debug((Object)("Processing question content " + clientObj.toString()));
        Boolean bool = WDDXProcessor.convertToBoolean("Show feedback", clientObj.get("showfeedback"));
        qcontent.setShowFeedback(bool != null ? bool : false);
        bool = WDDXProcessor.convertToBoolean("Allow redo", clientObj.get("allowredo"));
        qcontent.setAllowRedo(bool != null ? bool : false);
        log.debug((Object)("show names " + clientObj.get("showtopusernames") + " passmark " + clientObj.get("minpassmark")));
        bool = WDDXProcessor.convertToBoolean("Show names of users with top marks", clientObj.get("showtopusernames"));
        qcontent.setShowTopMarkNames(bool != null ? bool : false);
        Integer passmark = WDDXProcessor.convertToInteger("Minimum pass mark", clientObj.get("minpassmark"));
        qcontent.setMinimumPassMark(passmark);
        Collection questionSet = (Collection)clientObj.get("questionanswers");
        log.debug((Object)("Question set is " + questionSet.toString()));
        if (qcontent.getQuestions() == null) {
            qcontent.setQuestions(new HashSet());
        }
        Map questionToUpdate = this.buildQuestionMap(qcontent.getQuestions(), qcontent.theContentType());
        HashSet<Long> sidsUpdated = new HashSet<Long>();
        if (questionSet != null) {
            iter = questionSet.iterator();
            while (iter.hasNext()) {
                Hashtable questionInput = (Hashtable)iter.next();
                Integer displayOrder = WDDXProcessor.convertToInteger("Order", questionInput.get("order"));
                QuestionEntry questionData = (QuestionEntry)questionToUpdate.get(displayOrder);
                if (questionData == null) {
                    questionData = new QuestionEntry();
                    questionData.setDisplayOrder(displayOrder);
                    qcontent.getQuestions().add(questionData);
                }
                String str = (String)questionInput.get("question");
                questionData.setQuestion(str);
                str = (String)questionInput.get("feedback");
                questionData.setFeedback(str);
                questionData.setMark(new Integer(1));
                String answer = (String)questionInput.get("answer");
                this.processAnswers((Collection)questionInput.get("candidates"), questionData, answer);
                sidsUpdated.add(questionData.getSid());
            }
        }
        iter = qcontent.getQuestions().iterator();
        while (iter.hasNext()) {
            QuestionEntry questionData = (QuestionEntry)iter.next();
            if (sidsUpdated.contains(questionData.getSid())) continue;
            log.debug((Object)("Removing QuestionEntry entry, no longer needed " + questionData.toString()));
            iter.remove();
        }
        log.debug((Object)("New content is " + qcontent.toString()));
    }

    private void processAnswers(Collection questionInput, QuestionEntry questionData, String answer) throws WDDXProcessorConversionException {
        if (questionData.getCandidateAnswers() == null) {
            questionData.setCandidateAnswers(new HashSet());
        } else {
            questionData.getCandidateAnswers().clear();
        }
        if (questionInput != null) {
            Iterator candIter = questionInput.iterator();
            while (candIter.hasNext()) {
                Hashtable cand = (Hashtable)candIter.next();
                Integer displayOrder = WDDXProcessor.convertToInteger("Order", cand.get("order"));
                String answerString = (String)cand.get("answer");
                QuestionAnswerEntry entry = new QuestionAnswerEntry();
                entry.setAnswer(answerString);
                entry.setDisplayOrder(displayOrder);
                if (answerString != null && answerString.equals(answer)) {
                    entry.setCorrect(true);
                } else {
                    entry.setCorrect(false);
                }
                questionData.getCandidateAnswers().add(entry);
            }
        }
    }

    private Map buildQuestionMap(Collection questions, String questionType) {
        HashMap<Integer, Serializable> map = new HashMap<Integer, Serializable>();
        if (questions != null) {
            Iterator iter = questions.iterator();
            while (iter.hasNext()) {
                Serializable element;
                if (questionType.equals("questioncontent")) {
                    element = (QuestionEntry)iter.next();
                    map.put(((QuestionEntry)element).getDisplayOrder(), element);
                    continue;
                }
                if (!questionType.equals("surveycontent")) continue;
                element = (SurveyQuestionEntry)iter.next();
                map.put(new Integer(((SurveyQuestionEntry)element).getDisplayOrder()), element);
            }
        }
        return map;
    }

    public Hashtable createContentHashtable(Content content) throws BusinessException, SystemException {
        log.debug((Object)("** outputting content type=" + content.theContentType()));
        if (!"authoring".equals(content.getCreationTool())) {
            throw new BusinessException("Trying to send to authoring tool some content that has come from another tool. Not sensible. Content is " + content.toString());
        }
        Hashtable<String, Object> output = new Hashtable<String, Object>();
        output.put("body", HashtableUtils.getValue(content.getBody()));
        output.put("description", HashtableUtils.getValue(content.getDescription()));
        output.put("title", HashtableUtils.getValue(content.getTitle()));
        output.put("objectType", HashtableUtils.getValue(content.theObjectType()));
        output.put("contentType", HashtableUtils.getValue(content.theContentType()));
        output.put("contentShowUser", content.isShowUser() != null ? content.isShowUser() : new Boolean(false));
        output.put("contentDefineLater", content.isDefineLater() != null ? content.isDefineLater() : new Boolean(false));
        output.put("isHTML", content.isHTML() != null ? content.isHTML() : new Boolean(false));
        output.put("isReusable", new Boolean(content.isReusable()));
        Integer id = null;
        try {
            id = new Integer(content.getCreationToolKey());
        }
        catch (Exception e) {
            throw new SystemException("Unable to create id value for content " + content.toString() + ". Unable to convert to number");
        }
        output.put("id", id);
        if ("grouping".equals(content.theContentType())) {
            GroupingDefnContent gcontent = (GroupingDefnContent)content;
            output.put("number_groups", HashtableUtils.getIdInteger(gcontent.getNumGroups()));
            output.put("min_number_in_group", HashtableUtils.getIdInteger(gcontent.getMinNumberMembers()));
            output.put("max_number_in_group", HashtableUtils.getIdInteger(gcontent.getMaxNumberMembers()));
        }
        if ("voting".equals(content.theContentType())) {
            this.outputVotingContentFields(output, (VotingContent)content);
        }
        if ("MBAuthoring".equals(content.theContentType())) {
            this.outputMBContentFields(output, (MBAuthoringContent)content);
        }
        if ("urlcontent".equals(content.theContentType())) {
            this.outputUrlContentFields(output, (UrlContent)content);
        }
        if ("questioncontent".equals(content.theContentType())) {
            this.outputQuestionContentFields(output, (QuestionContent)content);
        }
        if ("surveycontent".equals(content.theContentType())) {
            this.outputSurveyContentFields(output, (SurveyContent)content);
        }
        return output;
    }

    private void outputVotingContentFields(Hashtable output, VotingContent vcontent) {
        String[] nominationStrings;
        output.put("nominatePollTime", new Boolean(vcontent.isAllowPollNominations()));
        output.put("progressive_display", new Boolean(vcontent.isProgressiveDisplay()));
        output.put("maxChoose", new Integer(vcontent.getMaxToChoose()));
        output.put("voteMethod", HashtableUtils.getValue(vcontent.getVoteMethod()));
        Collection nominations = vcontent.getNominations();
        if (nominations == null) {
            nominationStrings = new String[]{};
        } else {
            nominationStrings = new String[nominations.size()];
            Iterator iter = nominations.iterator();
            int i = 0;
            while (iter.hasNext()) {
                VotingContentNomination vcn = (VotingContentNomination)iter.next();
                nominationStrings[i] = vcn.getNomination();
                ++i;
            }
        }
        output.put("nominations", nominationStrings);
    }

    private void outputMBContentFields(Hashtable output, MBAuthoringContent mbContent) {
        output.put("terminationType", HashtableUtils.getValue(mbContent.getTerminationType()));
        output.put("durationInDays", HashtableUtils.getIdInteger(mbContent.getDurationInDays()));
        output.put("isPostingNotified", new Boolean(mbContent.isPostingNotified()));
        output.put("isPostingModerated", new Boolean(mbContent.isPostingModerated()));
        output.put("isNewTopicAllowed", new Boolean(mbContent.isNewTopicAllowed()));
        ArrayList topics = new ArrayList();
        if (mbContent.getTopics() != null) {
            Iterator iter = mbContent.getTopics().iterator();
            while (iter.hasNext()) {
                MBAuthoringContentTopic topic = (MBAuthoringContentTopic)iter.next();
                Hashtable<String, Object> outputTopic = new Hashtable<String, Object>();
                outputTopic.put("title", HashtableUtils.getValue(topic.getTopicTitle()));
                outputTopic.put("subject", HashtableUtils.getValue(topic.getSubject()));
                outputTopic.put("message", HashtableUtils.getValue(topic.getMessage()));
                outputTopic.put("number", new Integer(topic.getTopicNumber()));
                topics.add(outputTopic);
            }
        }
        output.put("topics", topics);
    }

    private void outputUrlContentFields(Hashtable output, UrlContent urlContent) {
        if (urlContent.getBodyURL() != null && urlContent.getBodyURL() != "") {
            output.put("directoryName", urlContent.getBodyURL());
        }
        output.put("minNumberComplete", new Integer(urlContent.getMinNumToComplete()));
        output.put("runtimeSubmissionStaffURL", new Boolean(urlContent.isRuntimeSubmissionStaffURL()));
        output.put("runtimeSubmissionStaffFile", new Boolean(urlContent.isRuntimeSubmissionStaffFile()));
        output.put("runtimeSubmissionLearnerURL", new Boolean(urlContent.isRuntimeSubmissionLearnerURL()));
        output.put("runtimeSubmissionLearnerFile", new Boolean(urlContent.isRuntimeSubmissionLearnerFile()));
        Collection urls = urlContent.getUrls();
        Vector urlOutput = new Vector();
        if (urls != null) {
            Iterator iter = urls.iterator();
            while (iter.hasNext()) {
                UrlContentEntry url = (UrlContentEntry)iter.next();
                Hashtable<String, Object> outputUrl = new Hashtable<String, Object>();
                outputUrl.put("url", url.getUrl());
                outputUrl.put("title", url.getTitle());
                outputUrl.put("order", new Integer(url.getViewOrder()));
                outputUrl.put("download", new Boolean(url.isPreferDownload()));
                outputUrl.put("instructions", this.getInstructions(url));
                outputUrl.put("showbuttons", new Boolean(url.isShowButtons()));
                outputUrl.put("resourcetype", url.getUrlType());
                urlOutput.add(outputUrl);
            }
        }
        output.put("urls", urlOutput);
    }

    private Vector getInstructions(UrlContentEntry url) {
        if (url == null) {
            return new Vector();
        }
        TreeMap<Integer, String> instructions = new TreeMap<Integer, String>();
        Iterator<Object> iter = url.getInstructions().iterator();
        while (iter.hasNext()) {
            UrlContentEntryInstruction entry = (UrlContentEntryInstruction)iter.next();
            instructions.put(new Integer(entry.getViewOrder()), entry.getInstruction());
        }
        Vector<Hashtable> outputVector = new Vector<Hashtable>();
        iter = instructions.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = (Map.Entry)iter.next();
            outputVector.add(this.outputInstruction((Integer)entry.getKey(), (String)entry.getValue()));
        }
        return outputVector;
    }

    private Hashtable outputInstruction(Integer viewOrder, String text) {
        Hashtable<String, Object> output = new Hashtable<String, Object>();
        output.put("order", HashtableUtils.getIdInteger(viewOrder));
        output.put("instruction", HashtableUtils.getValue(text));
        return output;
    }

    private void outputQuestionContentFields(Hashtable output, QuestionContent qContent) {
        output.put("showfeedback", new Boolean(qContent.isShowFeedback()));
        output.put("allowredo", new Boolean(qContent.isAllowRedo()));
        output.put("showtopusernames", new Boolean(qContent.isShowTopMarkNames()));
        output.put("minpassmark", HashtableUtils.getIdInteger(qContent.getMinimumPassMark()));
        Set questions = qContent.getQuestions();
        if (questions == null) {
            output.put("questionanswers", new Object[0]);
        } else {
            TreeMap<Integer, QuestionEntry> sortedQuestions = new TreeMap<Integer, QuestionEntry>();
            Object[] outputArray = new Object[questions.size()];
            Iterator<Object> iter = questions.iterator();
            while (iter.hasNext()) {
                QuestionEntry entry = (QuestionEntry)iter.next();
                sortedQuestions.put(entry.getDisplayOrder(), entry);
            }
            iter = sortedQuestions.values().iterator();
            int index = 0;
            while (iter.hasNext()) {
                QuestionEntry entry = (QuestionEntry)iter.next();
                Hashtable questionOutput = this.outputQuestion(entry);
                outputArray[index++] = questionOutput;
            }
            output.put("questionanswers", outputArray);
        }
    }

    private Hashtable outputQuestion(QuestionEntry question) {
        Hashtable<String, Object> output = new Hashtable<String, Object>();
        output.put("question", HashtableUtils.getValue(question.getQuestion()));
        output.put("feedback", HashtableUtils.getValue(question.getFeedback()));
        output.put("order", HashtableUtils.getIdInteger(question.getDisplayOrder()));
        Set answers = question.getCandidateAnswers();
        if (answers == null) {
            output.put("candidates", new Object[0]);
            output.put("answer", "");
        } else {
            TreeMap<Integer, String> candidateStrings = new TreeMap<Integer, String>();
            Iterator<Object> iter = answers.iterator();
            while (iter.hasNext()) {
                QuestionAnswerEntry entry = (QuestionAnswerEntry)iter.next();
                candidateStrings.put(entry.getDisplayOrder(), entry.getAnswer());
                if (!entry.isCorrect()) continue;
                output.put("answer", entry.getAnswer());
            }
            Object[] outputArray = new Object[candidateStrings.size()];
            iter = candidateStrings.entrySet().iterator();
            int index = 0;
            while (iter.hasNext()) {
                Map.Entry entry = (Map.Entry)iter.next();
                outputArray[index++] = this.outputAnswer((Integer)entry.getKey(), (String)entry.getValue());
            }
            output.put("candidates", outputArray);
        }
        return output;
    }

    private Hashtable outputAnswer(Integer displayOrder, String answerText) {
        Hashtable<String, Object> output = new Hashtable<String, Object>();
        output.put("order", HashtableUtils.getIdInteger(displayOrder));
        output.put("answer", HashtableUtils.getValue(answerText));
        return output;
    }

    private void outputSurveyContentFields(Hashtable output, SurveyContent sContent) {
        output.put("summary", sContent.getSummary());
        Set sortedQuestions = sContent.getSortedQuestions();
        if (sortedQuestions == null) {
            output.put("questions", new Object[0]);
        } else {
            Object[] outputArray = new Object[sortedQuestions.size()];
            int index = 0;
            Iterator iter = sortedQuestions.iterator();
            while (iter.hasNext()) {
                SurveyQuestionEntry entry = (SurveyQuestionEntry)iter.next();
                Hashtable questionOutput = this.outputSurveyQuestion(entry);
                outputArray[index++] = questionOutput;
            }
            output.put("questions", outputArray);
        }
    }

    private Hashtable outputSurveyQuestion(SurveyQuestionEntry entry) {
        Hashtable<String, Object> output = new Hashtable<String, Object>();
        output.put("question", HashtableUtils.getValue(entry.getQuestion()));
        output.put("order", new Integer(entry.getDisplayOrder()));
        output.put("questionType", HashtableUtils.getValue(entry.getQuestionType()));
        output.put("isOptional", new Boolean(entry.getIsOptional()));
        output.put("isTextBoxEnabled", new Boolean(entry.getIsTextBoxEnabled()));
        Set sortedAnswers = entry.getSortedAnswers();
        if (sortedAnswers == null) {
            output.put("candidates", new Object[0]);
        } else {
            Object[] answerOutputs = new Object[sortedAnswers.size()];
            int index = 0;
            Iterator iter = sortedAnswers.iterator();
            while (iter.hasNext()) {
                SurveyCandidateAnswers answer = (SurveyCandidateAnswers)iter.next();
                Hashtable answerOutput = this.outputSurQuestionAnswer(answer.getDisplayOrder(), answer.getAnswerEntry());
                answerOutputs[index++] = answerOutput;
            }
            output.put("candidates", answerOutputs);
        }
        return output;
    }

    private Hashtable outputSurQuestionAnswer(int displayOrder, String answertext) {
        Hashtable<String, Object> output = new Hashtable<String, Object>();
        output.put("order", new Integer(displayOrder));
        output.put("answer", HashtableUtils.getValue(answertext));
        return output;
    }

    public Content createNewContentObject(String contentType) {
        Content aContent = null;
        if (contentType != null) {
            if (contentType.equals("grouping")) {
                aContent = new GroupingDefnContent(null);
            } else if (contentType.equals("voting")) {
                aContent = new VotingContent(null);
            } else if (contentType.equals("MBAuthoring")) {
                aContent = new MBAuthoringContent(null);
            } else if (contentType.equals("urlcontent")) {
                aContent = new UrlContent(null);
            } else if (contentType.equals("questioncontent")) {
                aContent = new QuestionContent(null);
            } else if (contentType.equals("surveycontent")) {
                aContent = new SurveyContent(null);
            }
        }
        if (aContent == null) {
            aContent = new Content(null);
        }
        return aContent;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

