/*
 * Decompiled with CFR 0.152.
 */
package com.webmcq.ld.activities;

import com.webmcq.ld.activities.AbstractTaskVO;
import com.webmcq.ld.activities.GroupDefnVO;
import com.webmcq.ld.activities.GroupingTaskVO;
import com.webmcq.ld.activities.LearningDesignDefnVO;
import com.webmcq.ld.activities.SimpleTaskVO;
import com.webmcq.ld.activities.authoring.ContentDelegate;
import com.webmcq.ld.activities.runtime.LDRuntimeServiceBean;
import com.webmcq.ld.activities.runtime.LDRuntimeServiceException;
import com.webmcq.ld.activities.runtime.interfaces.LDRuntimeService;
import com.webmcq.ld.activities.runtime.interfaces.LDRuntimeServiceHome;
import com.webmcq.ld.content.Content;
import java.rmi.RemoteException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.ejb.CreateException;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.log4j.Logger;

class LearningDesignDefnValidator {
    private static Logger logger = Logger.getLogger((String)(class$com$webmcq$ld$activities$LearningDesignDefnValidator == null ? (class$com$webmcq$ld$activities$LearningDesignDefnValidator = LearningDesignDefnValidator.class$("com.webmcq.ld.activities.LearningDesignDefnValidator")) : class$com$webmcq$ld$activities$LearningDesignDefnValidator).getName());
    LearningDesignDefnVO m_design;
    ContentDelegate m_contentUtil;
    static /* synthetic */ Class class$com$webmcq$ld$activities$LearningDesignDefnValidator;

    protected LearningDesignDefnValidator(LearningDesignDefnVO design) {
        this.m_design = design;
        this.m_contentUtil = new ContentDelegate(design.getContentSids());
    }

    protected String validate() {
        StringBuffer messages = new StringBuffer();
        String newMessages = this.validateGroups();
        if (newMessages != null) {
            messages.append(newMessages);
        }
        return messages.length() > 0 ? messages.toString() : null;
    }

    private String validateGroups() {
        StringBuffer messages = new StringBuffer();
        try {
            InitialContext ctx = new InitialContext();
            LDRuntimeServiceHome home = (LDRuntimeServiceHome)ctx.lookup(LDRuntimeServiceBean.JNDI_NAME);
            LDRuntimeService service = home.create();
            Vector tasks = service.getFirstTask(this.m_design.getSid().intValue());
            HashSet knownTasks = new HashSet();
            if (tasks.size() > 0) {
                Iterator iter = tasks.iterator();
                while (iter.hasNext()) {
                    AbstractTaskVO task = (AbstractTaskVO)iter.next();
                    String newMessages = this.validateGroupsTask(task, service, null, knownTasks);
                    if (newMessages == null || newMessages.length() <= 0) continue;
                    messages.append(newMessages);
                }
            }
        }
        catch (CreateException e) {
            logger.error((Object)"Unable to validate groups as cannot access LDRuntimeService", (Throwable)e);
            messages.append("Validation of groups to tasks failed due to error stepping through the design - ejb creation exception" + e.getMessage());
        }
        catch (RemoteException e) {
            logger.error((Object)"Unable to validate groups as cannot access LDRuntimeService", (Throwable)e);
            messages.append("Validation of groups to tasks failed due to error stepping through the design - ejb remote exception " + e.getMessage());
        }
        catch (NamingException e) {
            logger.error((Object)"Unable to validate groups as cannot access LDRuntimeService", (Throwable)e);
            messages.append("Validation of groups to tasks failed due to error stepping through the design - ejb naming exception " + e.getMessage());
        }
        catch (LDRuntimeServiceException e) {
            logger.error((Object)"Unable to validate groups as cannot access LDRuntimeService returns an error", (Throwable)e);
            messages.append("Validation of groups to tasks failed due to error stepping through the design." + e.getMessage());
        }
        return messages.length() > 0 ? "\n Invalid groups: \n" + messages.toString() : null;
    }

    private String validateGroupsTask(AbstractTaskVO task, LDRuntimeService service, Set knownGroupsSidsIn, Set knownTaskSids) throws RemoteException, LDRuntimeServiceException {
        String newMessages;
        AbstractTaskVO nextTask;
        Iterator iter;
        Vector nextTasks;
        StringBuffer messages = new StringBuffer();
        HashSet<Long> knownGroupsSids = null;
        Long taskSid = task.getSid();
        if (knownTaskSids.contains(taskSid)) {
            return null;
        }
        knownTaskSids.add(taskSid);
        if (task.theTaskType() == 4) {
            knownGroupsSids = knownGroupsSidsIn == null ? new HashSet<Long>() : new HashSet(knownGroupsSidsIn);
            GroupingTaskVO groupTask = (GroupingTaskVO)task;
            GroupDefnVO groupDefn = groupTask.getGroupDefn();
            if (groupDefn != null) {
                Long defnSid = groupDefn.getSid();
                knownGroupsSids.add(defnSid);
            }
        } else {
            knownGroupsSids = knownGroupsSidsIn == null ? new HashSet() : knownGroupsSidsIn;
        }
        Set groupsForTask = task.getGroupsForTask();
        if (groupsForTask != null) {
            Iterator iter2 = groupsForTask.iterator();
            while (iter2.hasNext()) {
                GroupDefnVO defn = (GroupDefnVO)iter2.next();
                if (defn == null) {
                    String taskDescription = this.describeTask(task);
                    messages.append("Task " + taskDescription + " uses group " + "but group definition is missing.\n");
                    continue;
                }
                if (knownGroupsSids.contains(defn.getSid())) continue;
                messages.append("Activity <b>'" + task.getTitle() + "'</b> uses group <b>'" + defn.getId() + "'</b> before grouping has taken place." + " Grouping activities must be placed before any activities that use them." + " Please correct your design.");
            }
        }
        if ((nextTasks = service.getNextTask(this.m_design.getSid().intValue(), task)).size() > 0) {
            iter = nextTasks.iterator();
            while (iter.hasNext()) {
                nextTask = (AbstractTaskVO)iter.next();
                newMessages = this.validateGroupsTask(nextTask, service, knownGroupsSids, knownTaskSids);
                if (newMessages == null || newMessages.length() <= 0) continue;
                messages.append(newMessages);
            }
        }
        if (task.theTaskType() == 5 && (nextTasks = service.getNextTaskAfterInternals(this.m_design.getSid().intValue(), task)).size() > 0) {
            iter = nextTasks.iterator();
            while (iter.hasNext()) {
                nextTask = (AbstractTaskVO)iter.next();
                newMessages = this.validateGroupsTask(nextTask, service, knownGroupsSids, knownTaskSids);
                if (newMessages == null || newMessages.length() <= 0) continue;
                messages.append(newMessages);
            }
        }
        return messages.length() > 0 ? messages.toString() : null;
    }

    private String describeTask(AbstractTaskVO task) {
        StringBuffer taskDescription = new StringBuffer(200);
        String title = task.getTitle();
        String description = task.getDescription();
        taskDescription.append(" id=");
        taskDescription.append(task.getId());
        Map currentContents = this.m_contentUtil.getCurrentContentsAsMapBySid();
        try {
            Content content;
            SimpleTaskVO simpleTask = (SimpleTaskVO)task;
            taskDescription.append(" tool=");
            taskDescription.append(simpleTask.getToolType());
            Long icSid = simpleTask.getInputContentSid();
            if (icSid != null && (content = (Content)currentContents.get(icSid)) != null) {
                title = content.getTitle();
                description = content.getDescription();
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        taskDescription.append(" title=");
        taskDescription.append(title);
        taskDescription.append(" description=");
        taskDescription.append(description);
        return taskDescription.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

