/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.ld.util;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.regex.Pattern;

public class CSVUtil {
    private static final char QUOTE = '\"';
    private static final char COMMA = ',';
    private static final Pattern CONTAINS_NEWLINE = Pattern.compile(".*(\\n|\\r)+.*");
    private static final Pattern CONTAINS_COMMA = Pattern.compile(".*(,)+.*");
    private static final Pattern CONTAINS_QUOTE = Pattern.compile("\"");
    private static final String WRAP_QOUTE = "\"$0\"";
    private static final String ESCAPE_QUOTE = "\"\"";
    private static final Pattern WRAPPED_QUOTE = Pattern.compile("^\"(.*((,|\\n|\\r)+).*)\"$");
    private static final Pattern ESCAPED_QUOTE = Pattern.compile("\"\"");
    private static final String UNWRAP_QOUTE = "$1";
    private static final String UNESCAPE_QUOTE = "\"";

    public static String write(String[] vals) {
        String str = "";
        int lastIndex = vals.length - 1;
        for (int i = 0; i < vals.length; ++i) {
            String wrapped;
            String tmp = CONTAINS_QUOTE.matcher(vals[i]).replaceAll(ESCAPE_QUOTE);
            String string = wrapped = CONTAINS_COMMA.matcher(tmp).find() ? '\"' + tmp + '\"' : tmp;
            if (wrapped.equals(tmp)) {
                wrapped = CONTAINS_COMMA.matcher(tmp).find() ? '\"' + tmp + '\"' : tmp;
            }
            str = str + wrapped + (i == lastIndex ? "" : ",");
        }
        return str;
    }

    public static String[] parse(String str) throws ParseException {
        ArrayList<String> res = new ArrayList<String>();
        int startIndex = 0;
        boolean openQuote = false;
        str = str + ",";
        for (int i = 0; i < str.length(); ++i) {
            char ch = str.charAt(i);
            if (ch == '\"') {
                openQuote = !openQuote;
                continue;
            }
            if (ch != ',' || openQuote) continue;
            String val = str.substring(startIndex, i);
            String tmp = ESCAPED_QUOTE.matcher(val).replaceAll(UNESCAPE_QUOTE);
            res.add(WRAPPED_QUOTE.matcher(tmp).replaceAll(UNWRAP_QOUTE));
            startIndex = i + 1;
        }
        if (openQuote) {
            throw new ParseException("Fail to find matching \" while parsing [" + str + "] ", startIndex);
        }
        String[] resStr = new String[res.size()];
        res.toArray(resStr);
        return resStr;
    }
}

