/*
 * Decompiled with CFR 0.152.
 */
package com.webmcq.ld.ws;

import com.webmcq.ld.activities.LearningDesignDefnVO;
import com.webmcq.ld.activities.authoring.LDWDDXValueObjectFactory;
import com.webmcq.ld.service.UserNotFoundException;
import com.webmcq.ld.service.UserServiceDelegate;
import com.webmcq.ld.usermanagement.UserData;
import com.webmcq.ld.ws.ExtUserLoginMap;
import com.webmcq.ld.ws.ExtUserLoginMapManager;
import com.webmcq.ld.ws.LDRepository;
import com.webmcq.ld.ws.SimpleLearningDesignVO;
import com.webmcq.ld.ws.UserManagementServiceDelegate;
import com.webmcq.ld.ws.dao.ServerNotFoundException;
import java.rmi.RemoteException;
import java.util.List;
import org.apache.log4j.Logger;
import org.lamsfoundation.ld.security.AuthenticateException;
import org.lamsfoundation.ld.security.Authenticator;

public class LearningDesignServiceSoapBindingImpl
implements LDRepository {
    private static Logger log = Logger.getLogger((Class)(class$com$webmcq$ld$ws$LearningDesignServiceSoapBindingImpl == null ? (class$com$webmcq$ld$ws$LearningDesignServiceSoapBindingImpl = LearningDesignServiceSoapBindingImpl.class$("com.webmcq.ld.ws.LearningDesignServiceSoapBindingImpl")) : class$com$webmcq$ld$ws$LearningDesignServiceSoapBindingImpl));
    static /* synthetic */ Class class$com$webmcq$ld$ws$LearningDesignServiceSoapBindingImpl;

    public SimpleLearningDesignVO[] getAllLearningDesigns(String serverId, String datetime, String hashValue, String username) throws RemoteException {
        String login;
        try {
            Authenticator.authenticate(datetime, username, serverId, hashValue);
        }
        catch (AuthenticateException e) {
            log.debug((Object)e);
            throw new RemoteException(e.getMessage(), e);
        }
        catch (ServerNotFoundException e) {
            log.debug((Object)e);
            throw new RemoteException(e.getMessage(), e);
        }
        ExtUserLoginMap map = ExtUserLoginMapManager.getExtUserLoginMapByUsernameAndServerId(username, serverId);
        if (map == null) {
            try {
                login = UserManagementServiceDelegate.getUserDataAndCreateUser(serverId, username);
            }
            catch (Exception e) {
                throw new RemoteException(e.getMessage(), e);
            }
        } else {
            login = map.getLogin();
        }
        try {
            UserData user = UserServiceDelegate.findCompleteUser(login);
            List designList = LDWDDXValueObjectFactory.getInstance().findAllLearningDesignVO(true, user, user.getHomeOrg());
            SimpleLearningDesignVO[] designs = new SimpleLearningDesignVO[designList.size()];
            for (int i = 0; i < designList.size(); ++i) {
                SimpleLearningDesignVO sld;
                String workspace;
                LearningDesignDefnVO ld = (LearningDesignDefnVO)designList.get(i);
                switch (new Long(ld.getReadAccess()).intValue()) {
                    case -1: {
                        workspace = "private";
                        break;
                    }
                    case 0: {
                        workspace = "public";
                        break;
                    }
                    default: {
                        workspace = UserServiceDelegate.findHomeOrganisation(user.getSid()).getName();
                    }
                }
                designs[i] = sld = new SimpleLearningDesignVO(ld.getSid(), ld.getTitle(), workspace);
            }
            log.debug((Object)("Got designs:" + designs));
            return designs;
        }
        catch (UserNotFoundException e) {
            log.debug((Object)e);
            throw new RemoteException(e.getMessage(), e);
        }
        catch (Exception e) {
            log.debug((Object)e);
            throw new RemoteException(e.getMessage(), e);
        }
    }

    public String getAllLearningDesignsAsString(String serverId, String datetime, String hashValue, String username) throws RemoteException {
        SimpleLearningDesignVO[] lds = this.getAllLearningDesigns(serverId, datetime, hashValue, username);
        StringBuffer sbuf = new StringBuffer();
        for (int i = 0; i < lds.length; ++i) {
            sbuf.append(lds[i].getSid() + "," + lds[i].getWorkspace() + "," + lds[i].getTitle() + ":");
        }
        return sbuf.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

