/*
 * Decompiled with CFR 0.152.
 */
package com.webmcq.ld.util.license;

import com.webmcq.ld.util.license.LicenseException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;

public final class LicenseTicketReader {
    private String ticketFile;

    public LicenseTicketReader(String ticketFile) {
        this.ticketFile = ticketFile;
    }

    public String[] getTicket() throws LicenseException {
        File file = new File(this.ticketFile);
        try {
            FileReader fr = new FileReader(file);
            BufferedReader br = new BufferedReader(fr);
            this.readLineStartsWith(br, "--");
            String line2 = this.readLine(br);
            String line3 = this.readLine(br);
            String line4 = this.readLine(br);
            if (!line4.startsWith("--")) {
                throw new LicenseException("ticket file format invalid");
            }
            br.close();
            fr.close();
            String[] ticket = new String[]{line2.trim(), line3.trim()};
            return ticket;
        }
        catch (FileNotFoundException e) {
            throw new LicenseException("license ticket file '" + this.ticketFile + "' not found", e);
        }
        catch (IOException e) {
            throw new LicenseException("error while reading license ticket file", e);
        }
    }

    private String readLineStartsWith(BufferedReader br, String prefix) throws IOException {
        String line = this.readLineTrim(br);
        while (!line.startsWith(prefix)) {
            line = this.readLineTrim(br);
        }
        return line;
    }

    private String readLineTrim(BufferedReader br) throws IOException {
        String line = br.readLine();
        while (true) {
            if (line == null) {
                throw new IOException("unexpected end of file encountered");
            }
            if (line.trim().length() > 0) {
                return line;
            }
            line = br.readLine();
        }
    }

    private String readLine(BufferedReader br) throws IOException {
        String line = br.readLine();
        if (line == null) {
            throw new IOException("unexpected end of file encountered");
        }
        return line;
    }
}

