/*
 * Decompiled with CFR 0.152.
 */
package com.webmcq.ld.util.license;

import com.webmcq.ld.util.license.LicenseException;
import com.webmcq.ld.util.license.LicenseTicketReader;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.apache.commons.codec.EncoderException;
import org.apache.commons.codec.binary.Base64;

public final class License {
    private LicenseTicketReader reader;
    private boolean valid;

    public License(String ticketFile) throws LicenseException {
        this.reader = new LicenseTicketReader(ticketFile);
    }

    public void check() throws LicenseException {
        String ipAddr = this.getIPAddress();
        this.doCheck(ipAddr);
        if (this.valid) {
            return;
        }
        if ("127.0.0.1".equals(ipAddr.trim())) {
            System.out.println("localhost (127.0.0.1) detected.");
            this.valid = true;
        }
    }

    private void doCheck(String addr) throws LicenseException {
        try {
            String[] reads = this.reader.getTicket();
            MessageDigest md = MessageDigest.getInstance("SHA");
            md.update(addr.getBytes("UTF-8"));
            md.update(reads[0].getBytes("UTF-8"));
            byte[] digested = md.digest();
            Base64 encoder = new Base64();
            byte[] encoded = encoder.encode(digested);
            String ticket = new String(encoded, "UTF-8");
            this.valid = ticket.equals(reads[1]);
        }
        catch (NoSuchAlgorithmException e) {
            throw new LicenseException("error while checking license", e);
        }
        catch (UnsupportedEncodingException e) {
            throw new LicenseException("error while checking license", e);
        }
        catch (EncoderException e) {
            throw new LicenseException("error while checking license", e);
        }
    }

    public boolean isValid() {
        return this.valid;
    }

    private String getIPAddress() throws LicenseException {
        try {
            return InetAddress.getLocalHost().getHostAddress();
        }
        catch (UnknownHostException e) {
            throw new LicenseException("could not determine the IP address of the host", e);
        }
    }
}

