/*
 * Decompiled with CFR 0.152.
 */
package com.webmcq.ld.util;

import com.webmcq.ld.service.ConfigurationKeys;
import com.webmcq.ld.service.ConfigurationServiceDelegate;
import java.io.File;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.fileupload.DiskFileUpload;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.log4j.Logger;

public class UploadFileUtil {
    private static Logger logger = Logger.getLogger((Class)(class$com$webmcq$ld$util$UploadFileUtil == null ? (class$com$webmcq$ld$util$UploadFileUtil = UploadFileUtil.class$("com.webmcq.ld.util.UploadFileUtil")) : class$com$webmcq$ld$util$UploadFileUtil));
    private static final int DEFAULT_MAX_SIZE = 5000000;
    private static final int DEFAULT_MEMORY_SIZE = 4096;
    static /* synthetic */ Class class$com$webmcq$ld$util$UploadFileUtil;

    public static List getUploadItems(HttpServletRequest request, boolean useLargeFileSize) throws FileUploadException, Exception {
        return UploadFileUtil.getUploadItems(request, useLargeFileSize, null);
    }

    public static List getUploadItems(HttpServletRequest request, boolean useLargeFileSize, String tempDirNameInput) throws FileUploadException, Exception {
        File dir;
        int max_memory_size;
        int max_size = 5000000;
        String tempDirName = null;
        Integer tempInteger = null;
        if (useLargeFileSize) {
            tempInteger = ConfigurationServiceDelegate.getAsInteger(ConfigurationKeys.UPLOAD_FILE_LARGE_MAX_SIZE);
            if (tempInteger != null) {
                max_size = tempInteger;
            } else {
                logger.warn((Object)"Default Large Max Size for file upload missing, using 5000000");
            }
        } else {
            tempInteger = ConfigurationServiceDelegate.getAsInteger(ConfigurationKeys.UPLOAD_FILE_MAX_SIZE);
            if (tempInteger != null) {
                max_size = tempInteger;
            } else {
                logger.warn((Object)"Default Max Size for file upload missing, using 5000000");
            }
        }
        tempInteger = ConfigurationServiceDelegate.getAsInteger(ConfigurationKeys.UPLOAD_FILE_MAX_MEMORY_SIZE);
        if (tempInteger != null) {
            max_memory_size = tempInteger;
        } else {
            logger.warn((Object)"Default Max Memory Size for file upload missing, using 4096");
            max_memory_size = 4096;
        }
        if (tempDirNameInput != null) {
            tempDirName = tempDirNameInput;
        } else {
            tempDirName = ConfigurationServiceDelegate.get(ConfigurationKeys.LAMS_TEMP_DIR);
            if (tempDirName == null) {
                logger.warn((Object)"Default Temporary Directory missing, using null");
            }
        }
        if (tempDirName != null && !(dir = new File(tempDirName)).exists()) {
            dir.mkdirs();
        }
        DiskFileUpload upload = new DiskFileUpload();
        upload.setSizeMax((long)max_size);
        upload.setSizeThreshold(max_memory_size);
        upload.setRepositoryPath(tempDirName);
        List items = upload.parseRequest(request);
        return items;
    }

    public static float getMaxFileSize() {
        int max_size = 5000000;
        Integer tempInteger = ConfigurationServiceDelegate.getAsInteger(ConfigurationKeys.UPLOAD_FILE_MAX_SIZE);
        if (tempInteger != null) {
            max_size = tempInteger;
        }
        return max_size != 0 ? (float)max_size / 1024.0f / 1024.0f : 0.0f;
    }

    public static float getMaxLargeFileSize() {
        int max_size = 5000000;
        Integer tempInteger = ConfigurationServiceDelegate.getAsInteger(ConfigurationKeys.UPLOAD_FILE_LARGE_MAX_SIZE);
        if (tempInteger != null) {
            max_size = tempInteger;
        }
        return max_size != 0 ? (float)max_size / 1024.0f / 1024.0f : 0.0f;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

