/*
 * Decompiled with CFR 0.152.
 */
package com.webmcq.ld.util;

import com.webmcq.ld.service.ConfigurationKeys;
import com.webmcq.ld.service.interfaces.ConfigurationService;
import com.webmcq.ld.service.interfaces.ConfigurationServiceHome;
import com.webmcq.ld.util.EJBUtil;
import java.rmi.RemoteException;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.ejb.CreateException;
import javax.ejb.EJBException;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.rmi.PortableRemoteObject;
import org.apache.log4j.Logger;

public class SendEmail {
    private static Logger logger = Logger.getLogger((Class)(class$com$webmcq$ld$util$SendEmail == null ? (class$com$webmcq$ld$util$SendEmail = SendEmail.class$("com.webmcq.ld.util.SendEmail")) : class$com$webmcq$ld$util$SendEmail));
    private static String DEFAULT_SMTP_SERVER = "mail";
    private String SMTPServer = null;
    private String administratorEmailAddress = null;
    static /* synthetic */ Class class$com$webmcq$ld$util$SendEmail;
    static /* synthetic */ Class class$com$webmcq$ld$service$interfaces$ConfigurationServiceHome;

    private void setSTMPServerFromConfig() {
        try {
            InitialContext ctx = new InitialContext(EJBUtil.getContextEnv());
            Object objRef = ctx.lookup("ejb/service/ConfigurationService");
            ConfigurationServiceHome home = (ConfigurationServiceHome)PortableRemoteObject.narrow((Object)objRef, (Class)(class$com$webmcq$ld$service$interfaces$ConfigurationServiceHome == null ? (class$com$webmcq$ld$service$interfaces$ConfigurationServiceHome = SendEmail.class$("com.webmcq.ld.service.interfaces.ConfigurationServiceHome")) : class$com$webmcq$ld$service$interfaces$ConfigurationServiceHome));
            ConfigurationService config = home.create();
            String serverName = config.get(ConfigurationKeys.SMTP_SERVER);
            if (serverName != null) {
                this.setSMTPServer(serverName);
            } else {
                logger.warn((Object)("SMTP Server name missing from system configuration. Using" + DEFAULT_SMTP_SERVER));
                this.setSMTPServer(DEFAULT_SMTP_SERVER);
            }
            String mailUser = config.get(ConfigurationKeys.LAMS_ADMIN_EMAIL);
            if (mailUser != null) {
                this.administratorEmailAddress = mailUser;
            } else {
                logger.warn((Object)"LAMS administrator's email address missing from system configuration.");
                this.administratorEmailAddress = null;
            }
        }
        catch (RemoteException e) {
            throw new EJBException((Exception)e);
        }
        catch (CreateException e) {
            throw new EJBException((Exception)((Object)e));
        }
        catch (NamingException e) {
            throw new EJBException((Exception)e);
        }
    }

    public void overrideSMTPServer(String servername) {
        this.setSMTPServer(servername);
    }

    public String sendemail(String[] strArguments, Collection attachments) {
        if (strArguments.length < 2) {
            return "";
        }
        if (this.getSMTPServer() == null) {
            this.setSTMPServerFromConfig();
        }
        String strFromAddress = "";
        String strToAddress = "";
        String strCCAddress = "";
        String strBCCAddress = "";
        String strMessage = "";
        String strSubject = "";
        strToAddress = strArguments[0];
        strFromAddress = strArguments[1] != null ? strArguments[1] : this.administratorEmailAddress;
        logger.debug((Object)("from address is " + strFromAddress));
        if (strArguments.length > 2) {
            strSubject = strArguments[2];
            if (strArguments.length > 3) {
                strMessage = strArguments[3];
                if (strArguments.length > 4) {
                    strCCAddress = strArguments[4];
                    if (strArguments.length > 5) {
                        strBCCAddress = strArguments[5];
                    }
                }
            }
        }
        Properties props = new Properties();
        props.put("mail.smtp.host", this.getSMTPServer());
        Session session = Session.getDefaultInstance((Properties)props, null);
        try {
            MimeMessage msg = new MimeMessage(session);
            msg.setFrom((Address)new InternetAddress(strFromAddress));
            StringTokenizer stzAddresses = new StringTokenizer(strToAddress, ";");
            int nTokens = stzAddresses.countTokens();
            InternetAddress[] address = new InternetAddress[nTokens];
            int i = 0;
            while (stzAddresses.hasMoreTokens()) {
                address[i] = new InternetAddress(stzAddresses.nextToken().trim());
                ++i;
            }
            msg.setRecipients(Message.RecipientType.TO, (Address[])address);
            if (strCCAddress.length() > 0) {
                stzAddresses = new StringTokenizer(strCCAddress, ";");
                nTokens = stzAddresses.countTokens();
                address = new InternetAddress[nTokens];
                i = 0;
                while (stzAddresses.hasMoreTokens()) {
                    address[i] = new InternetAddress(stzAddresses.nextToken().trim());
                    ++i;
                }
                msg.setRecipients(Message.RecipientType.CC, (Address[])address);
            }
            if (strBCCAddress.length() > 0) {
                stzAddresses = new StringTokenizer(strBCCAddress, ";");
                nTokens = stzAddresses.countTokens();
                address = new InternetAddress[nTokens];
                i = 0;
                while (stzAddresses.hasMoreTokens()) {
                    address[i] = new InternetAddress(stzAddresses.nextToken().trim());
                    ++i;
                }
                msg.setRecipients(Message.RecipientType.BCC, (Address[])address);
            }
            msg.setSubject(strSubject);
            msg.setSentDate(new Date());
            MimeMultipart multipart = new MimeMultipart();
            MimeBodyPart messageBodyPart = new MimeBodyPart();
            messageBodyPart.setText(strMessage);
            multipart.addBodyPart((BodyPart)messageBodyPart);
            if (attachments != null) {
                Iterator iter = attachments.iterator();
                while (iter.hasNext()) {
                    String[] attachment = (String[])iter.next();
                    String fullFilename = attachment[0];
                    String shortFilename = attachment[1];
                    String attachmentDescription = attachment[2];
                    logger.debug((Object)("Adding attachment fullname: " + fullFilename + " shortname: " + shortFilename + " description " + attachmentDescription));
                    messageBodyPart = new MimeBodyPart();
                    FileDataSource source = new FileDataSource(fullFilename);
                    messageBodyPart.setDataHandler(new DataHandler((DataSource)source));
                    messageBodyPart.setFileName(shortFilename);
                    messageBodyPart.setDescription(attachmentDescription);
                    multipart.addBodyPart((BodyPart)messageBodyPart);
                }
            }
            msg.setContent((Multipart)multipart);
            Transport.send((Message)msg);
        }
        catch (MessagingException mex) {
            MessagingException ex = mex;
            logger.error((Object)("Send Email Attempt Failed: " + ex.getMessage()));
            return "0";
        }
        return "1";
    }

    private String getSMTPServer() {
        return this.SMTPServer;
    }

    private void setSMTPServer(String sMTPServer) {
        this.SMTPServer = sMTPServer;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

