/*
 * Decompiled with CFR 0.152.
 */
package com.webmcq.ld.util;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class DownloadFile {
    private static Logger log = Logger.getLogger((Class)(class$com$webmcq$ld$util$DownloadFile == null ? (class$com$webmcq$ld$util$DownloadFile = DownloadFile.class$("com.webmcq.ld.util.DownloadFile")) : class$com$webmcq$ld$util$DownloadFile));
    private static final String UTF_8_ENCODING = "UTF-8";
    static /* synthetic */ Class class$com$webmcq$ld$util$DownloadFile;

    public static void download(HttpServletResponse response, ServletContext context, String filename, String fullFilename, String inputMimeType, boolean preferDownload) throws IOException {
        DownloadFile.process(response, context, filename, fullFilename, inputMimeType, preferDownload);
    }

    public static void download(HttpServletResponse response, ServletContext context, String filename, String fullFilename, String inputMimeType) throws IOException {
        DownloadFile.process(response, context, filename, fullFilename, inputMimeType, true);
    }

    public static void send(HttpServletResponse response, ServletContext context, String filename, String fullFilename, String inputMimeType) throws IOException {
        DownloadFile.process(response, context, filename, fullFilename, inputMimeType, false);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void process(HttpServletResponse response, ServletContext context, String filename, String fullFilename, String inputMimeType, boolean saveFile) throws IOException {
        String mimeType = null;
        if (inputMimeType != null) {
            mimeType = inputMimeType;
        } else if (context != null) {
            mimeType = context.getMimeType(filename);
        }
        if (mimeType == null) {
            mimeType = "application/octet-stream";
        }
        log.debug((Object)("Downloading file " + filename + " mime type " + mimeType));
        response.setContentType(mimeType);
        InputStream in = null;
        ServletOutputStream out = null;
        try {
            try {
                int ch;
                File fileob = new File(fullFilename);
                if (!fileob.exists()) throw new IOException("Requested File is missing : " + fullFilename);
                if (saveFile) {
                    log.debug((Object)"Sending as attachment");
                    response.setHeader("Content-Disposition", "attachment;filename=" + filename);
                } else {
                    log.debug((Object)"Sending as inline");
                    response.setHeader("Content-Disposition", "inline;filename=" + filename);
                }
                response.setHeader("Cache-control", "must-revalidate");
                response.addHeader("Content-Description", filename);
                out = response.getOutputStream();
                log.debug((Object)"Writing out file ");
                int count = 0;
                FileInputStream fileToRead = new FileInputStream(fileob);
                in = new BufferedInputStream(fileToRead);
                while ((ch = in.read()) != -1) {
                    out.write((int)((char)ch));
                    ++count;
                }
                log.debug((Object)("Wrote out " + count + " bytes"));
                response.setContentLength(count);
                out.flush();
            }
            catch (IOException e) {
                log.error((Object)("Exception in process():" + e.getMessage()));
                throw new IOException(e.getClass().getName());
            }
            Object var14_14 = null;
        }
        catch (Throwable throwable) {
            Object var14_15 = null;
            try {
                log.debug((Object)"Closing file");
                if (in != null) {
                    in.close();
                }
                if (out == null) throw throwable;
                out.close();
                throw throwable;
            }
            catch (IOException e) {
                log.error((Object)("Error Closing file" + e.getMessage()));
                throw new IOException(e.getClass().getName());
            }
        }
        try {}
        catch (IOException e) {
            log.error((Object)("Error Closing file" + e.getMessage()));
            throw new IOException(e.getClass().getName());
        }
        log.debug((Object)"Closing file");
        if (in != null) {
            in.close();
        }
        if (out == null) return;
        out.close();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void export(HttpServletResponse res, ServletContext context, String designName, String exportType, String exportString) throws IOException, ServletException {
        ServletOutputStream out;
        block8: {
            out = null;
            ByteArrayInputStream bai = null;
            BufferedInputStream bis = null;
            try {
                try {
                    int data;
                    String filename = designName + "." + exportType;
                    byte[] exportBytes = exportString.getBytes(UTF_8_ENCODING);
                    int size = exportBytes.length;
                    res.setContentType("application/x-lams;name=" + StringUtils.replaceChars((String)filename, (char)' ', (char)'_'));
                    res.setHeader("Content-Disposition", "attachment; filename=" + StringUtils.replaceChars((String)filename, (char)' ', (char)'_') + ";");
                    res.setHeader("Cache-Control", "no-cache");
                    res.setHeader("Content-Transfer-Encoding", "binary");
                    res.setContentLength(size);
                    out = res.getOutputStream();
                    bai = new ByteArrayInputStream(exportBytes);
                    bis = new BufferedInputStream(bai);
                    while ((data = bis.read()) != -1) {
                        out.write(data);
                    }
                    Object var13_14 = null;
                    if (bis == null) break block8;
                }
                catch (IOException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new ServletException((Throwable)e);
                }
            }
            catch (Throwable throwable) {
                Object var13_15 = null;
                if (bis != null) {
                    bis.close();
                }
                if (out == null) throw throwable;
                out.flush();
                out.close();
                throw throwable;
            }
            bis.close();
        }
        if (out == null) return;
        out.flush();
        out.close();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

