/*
 * Decompiled with CFR 0.152.
 */
package com.webmcq.ld.usermanagement.sysadmin.web;

import com.webmcq.ld.usermanagement.RequestUtil;
import com.webmcq.ld.usermanagement.UserData;
import com.webmcq.ld.usermanagement.UserManagementAuthorisationException;
import com.webmcq.ld.usermanagement.UserManagementException;
import com.webmcq.ld.usermanagement.UserRole;
import com.webmcq.ld.usermanagement.interfaces.UserManagementService;
import com.webmcq.ld.usermanagement.interfaces.UserManagementServiceUtil;
import com.webmcq.ld.usermanagement.sysadmin.web.SystemAdminAction;
import com.webmcq.ld.usermanagement.sysadmin.web.UserActionForm;
import java.lang.reflect.InvocationTargetException;
import java.rmi.RemoteException;
import java.util.HashSet;
import javax.ejb.CreateException;
import javax.naming.NamingException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.log4j.Logger;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessage;

public class UserAction
extends Action {
    private static Logger log = Logger.getLogger((Class)(class$com$webmcq$ld$usermanagement$sysadmin$web$UserAction == null ? (class$com$webmcq$ld$usermanagement$sysadmin$web$UserAction = UserAction.class$("com.webmcq.ld.usermanagement.sysadmin.web.UserAction")) : class$com$webmcq$ld$usermanagement$sysadmin$web$UserAction));
    public static final String INIT_TAG = "initialise";
    public static final String PROCESS_TAG = "process";
    static /* synthetic */ Class class$com$webmcq$ld$usermanagement$sysadmin$web$UserAction;

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ActionErrors errors = new ActionErrors();
        UserActionForm userForm = (UserActionForm)form;
        Long editUserId = null;
        Long adminUserId = null;
        Long sessionOrgId = RequestUtil.getSessionOrgId(request.getSession());
        if (this.isCancelled(request)) {
            SystemAdminAction adminAction = new SystemAdminAction();
            if (sessionOrgId != null && sessionOrgId != -1L) {
                String screen = adminAction.implOrganisationEdit(mapping, form, request, response, sessionOrgId);
                return mapping.findForward(screen);
            }
            return adminAction.getAdmin(mapping, form, request, response);
        }
        if (errors.isEmpty()) {
            log.debug((Object)("Call update user, based on form data " + userForm.toMap().toString()));
            UserData userData = new UserData();
            try {
                UserManagementService service = UserManagementServiceUtil.getHome().create();
                adminUserId = RequestUtil.getUserId(request, service);
                BeanUtils.copyProperties((Object)userData, (Object)userForm.toMap());
                log.debug((Object)("Copied values " + userData.toString()));
                String[] rolenames = userForm.getRolenames();
                log.debug((Object)("Rolenames from form: " + rolenames));
                userData.setRoles(new HashSet());
                if (rolenames != null) {
                    for (int i = 0; i < rolenames.length; ++i) {
                        String rolename = rolenames[i];
                        UserRole role = UserRole.getRoleByName(rolename);
                        userData.getRoles().add(role);
                    }
                }
                if (userForm.getSid() == null) {
                    log.debug((Object)"Resetting sid in userData to null");
                    userData.setSid(null);
                }
                String password = null;
                if (userForm.getPassword() != null && userForm.getPassword().length() != 0) {
                    password = userForm.getPassword();
                }
                editUserId = service.updateUser(userData, password, false, adminUserId, sessionOrgId);
                if (userForm.getNewMembershipOrganisationId() != null && userForm.getNewMembershipOrganisationId() != -1L) {
                    service.updateUserMembership(editUserId, userForm.getNewMembershipOrganisationId(), userForm.getNewMembershipRight(), userForm.isNewMembershipHomeAccount(), adminUserId);
                }
            }
            catch (RemoteException e) {
                log.error((Object)"Exception occured ", (Throwable)e);
                errors.add("org.apache.struts.action.GLOBAL_MESSAGE", new ActionMessage("error.system"));
            }
            catch (CreateException e) {
                log.error((Object)"Exception occured ", (Throwable)e);
                errors.add("org.apache.struts.action.GLOBAL_MESSAGE", new ActionMessage("error.system"));
            }
            catch (NamingException e) {
                log.error((Object)"Exception occured ", (Throwable)e);
                errors.add("org.apache.struts.action.GLOBAL_MESSAGE", new ActionMessage("error.system"));
            }
            catch (UserManagementException e) {
                log.error((Object)"UserManagementException occured ", (Throwable)e);
                errors.add("org.apache.struts.action.GLOBAL_MESSAGE", new ActionMessage(e.getMessage()));
            }
            catch (UserManagementAuthorisationException e) {
                log.error((Object)"UserManagementAuthorisationException occured ", (Throwable)e);
                errors.add("org.apache.struts.action.GLOBAL_MESSAGE", new ActionMessage(e.getMessage()));
            }
            catch (IllegalAccessException e) {
                log.error((Object)"Exception occured ", (Throwable)e);
                errors.add("org.apache.struts.action.GLOBAL_MESSAGE", new ActionMessage("error.system"));
            }
            catch (InvocationTargetException e) {
                log.error((Object)"Exception occured ", (Throwable)e);
                errors.add("org.apache.struts.action.GLOBAL_MESSAGE", new ActionMessage("error.system"));
            }
        }
        if (!errors.isEmpty()) {
            this.saveErrors(request, errors);
            if (mapping.getInput() != null) {
                return new ActionForward(mapping.getInput());
            }
            return mapping.findForward("error");
        }
        SystemAdminAction adminAction = new SystemAdminAction();
        if (editUserId != null) {
            return mapping.findForward(adminAction.implUserView(mapping, form, request, response, editUserId));
        }
        return mapping.findForward("error");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

