/*
 * Decompiled with CFR 0.152.
 */
package com.webmcq.ld.usermanagement.sysadmin.web;

import com.webmcq.ld.controller.dao.LearningSessionDAO;
import com.webmcq.ld.controller.dto.ClientSessionData;
import com.webmcq.ld.controller.web.ClientSessionDataManager;
import com.webmcq.ld.service.ConfigurationKeys;
import com.webmcq.ld.service.ConfigurationServiceDelegate;
import com.webmcq.ld.usermanagement.OrganisationCompleteData;
import com.webmcq.ld.usermanagement.OrganisationRecursiveData;
import com.webmcq.ld.usermanagement.RequestUtil;
import com.webmcq.ld.usermanagement.Rights;
import com.webmcq.ld.usermanagement.UserData;
import com.webmcq.ld.usermanagement.UserImporter;
import com.webmcq.ld.usermanagement.UserManagementAuthorisationException;
import com.webmcq.ld.usermanagement.UserManagementException;
import com.webmcq.ld.usermanagement.UserMembershipData;
import com.webmcq.ld.usermanagement.UserRole;
import com.webmcq.ld.usermanagement.comparators.UserMembershipDataComparator;
import com.webmcq.ld.usermanagement.interfaces.ShwaaUserData;
import com.webmcq.ld.usermanagement.interfaces.UserManagementService;
import com.webmcq.ld.usermanagement.interfaces.UserManagementServiceUtil;
import com.webmcq.ld.usermanagement.sysadmin.web.LcwSettingActionForm;
import com.webmcq.ld.usermanagement.sysadmin.web.OrganisationAddUsersActionForm;
import com.webmcq.ld.usermanagement.sysadmin.web.OrganisationSimpleActionForm;
import com.webmcq.ld.usermanagement.sysadmin.web.PasswordChangeActionForm;
import com.webmcq.ld.usermanagement.sysadmin.web.UserActionForm;
import com.webmcq.ld.util.UploadFileUtil;
import com.webmcq.ld.util.WebUtil;
import com.webmcq.ld.util.persistence.PersistenceSession;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.ejb.CreateException;
import javax.naming.NamingException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.actions.DispatchAction;

public class SharedAdminAction
extends DispatchAction {
    private static Logger log = Logger.getLogger((Class)(class$com$webmcq$ld$usermanagement$sysadmin$web$SharedAdminAction == null ? (class$com$webmcq$ld$usermanagement$sysadmin$web$SharedAdminAction = SharedAdminAction.class$("com.webmcq.ld.usermanagement.sysadmin.web.SharedAdminAction")) : class$com$webmcq$ld$usermanagement$sysadmin$web$SharedAdminAction));
    public static final String USER_SET_TAG = "userSet";
    public static final String USERID_TAG = "userid";
    public static final String USER_TAG = "user";
    public static final String ORG_DROPDOWN_LABEL_SET_TAG = "orgDropDownLabels";
    public static final String ORG_DROPDOWN_VALUE_SET_TAG = "orgDropDownValues";
    public static final String ORGANISATION_LIST_TAG = "organisationList";
    public static final String PARENT_ORGANISATIONID_TAG = "parentorganisationid";
    public static final String ORGANISATIONID_TAG = "organisationid";
    public static final String ORGANISATION_TAG = "organisation";
    public static final String NAME_PATH_TAG = "namepath";
    public static final String VIEW_ONLY = "viewonly";
    public static final String CREATE_NEW_ACCOUNT_ORG = "accountorganisation";
    public static final String USER_TYPE_TAG = "userType";
    public static final String ORGID_EDITED = "organisationid_edited";
    public static final String MSG = "message";
    static /* synthetic */ Class class$com$webmcq$ld$usermanagement$sysadmin$web$SharedAdminAction;

    public String implAction(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        log.debug((Object)"implAction");
        boolean error = false;
        LinkedList orgs = new LinkedList();
        try {
            UserManagementService service = UserManagementServiceUtil.getHome().create();
            Long adminUserId = RequestUtil.getUserId(request, service);
            orgs.addAll(service.getAllOrganisations(adminUserId));
            if (orgs == null || orgs.size() == 0) {
                log.warn((Object)("No organisations found for user " + adminUserId));
            }
        }
        catch (RemoteException e) {
            log.error((Object)"Exception occured ", (Throwable)e);
            error = true;
        }
        catch (CreateException e) {
            log.error((Object)"Exception occured ", (Throwable)e);
            error = true;
        }
        catch (NamingException e) {
            log.error((Object)"Exception occured ", (Throwable)e);
            error = true;
        }
        catch (UserManagementException e) {
            log.error((Object)"SystemUserException occured ", (Throwable)e);
            error = true;
        }
        request.setAttribute(ORGANISATION_LIST_TAG, orgs);
        log.debug((Object)("implAction: orgs = " + ((Object)orgs).toString()));
        return error ? "error" : "admin";
    }

    public String implUserEdit(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        boolean error;
        UserActionForm newForm;
        block20: {
            log.debug((Object)"implUserEdit");
            Long editUserId = null;
            Long adminUserId = null;
            try {
                if (request.getParameter(USERID_TAG) != null) {
                    editUserId = new Long(request.getParameter(USERID_TAG).trim());
                }
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
            newForm = null;
            error = false;
            try {
                UserManagementService service = UserManagementServiceUtil.getHome().create();
                adminUserId = RequestUtil.getUserId(request, service);
                Long orgId = null;
                try {
                    if (request.getParameter(ORGANISATIONID_TAG) != null) {
                        orgId = new Long(request.getParameter(ORGANISATIONID_TAG).trim());
                    }
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
                OrganisationCompleteData orgData = service.getOrganisation(orgId, adminUserId);
                if (orgData == null) {
                    log.error((Object)("implUserEdit: Organisation not found " + orgId));
                    error = true;
                    break block20;
                }
                UserData user = null;
                if (editUserId == null) {
                    editUserId = new Long(-1L);
                } else {
                    user = service.getCompleteUser(editUserId);
                }
                if (user != null) {
                    newForm = this.setupUserActionForm(editUserId, orgData, user);
                    break block20;
                }
                Integer newRight = null;
                try {
                    newRight = new Integer(WebUtil.readIntParam(request, USER_TYPE_TAG));
                }
                catch (IllegalArgumentException e) {
                    // empty catch block
                }
                log.debug((Object)("request user type is " + newRight));
                newForm = this.setupActionFormNewUser(orgData, newRight);
            }
            catch (RemoteException e) {
                log.error((Object)"Exception occured ", (Throwable)e);
                error = true;
            }
            catch (CreateException e) {
                log.error((Object)"Exception occured ", (Throwable)e);
                error = true;
            }
            catch (NamingException e) {
                log.error((Object)"Exception occured ", (Throwable)e);
                error = true;
            }
            catch (UserManagementException e) {
                log.error((Object)"SystemUserException occured ", (Throwable)e);
                error = true;
            }
            catch (IllegalAccessException e) {
                log.error((Object)"Exception occured ", (Throwable)e);
                error = true;
            }
            catch (InvocationTargetException e) {
                log.error((Object)"Exception occured ", (Throwable)e);
                error = true;
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("implUserEdit: Form is " + newForm.toMap().toString()));
        }
        request.setAttribute("UserActionForm", newForm);
        return error ? "error" : "userentry";
    }

    private UserActionForm setupActionFormNewUser(OrganisationCompleteData orgData, Integer newRight) {
        UserActionForm newForm = new UserActionForm();
        newForm.setCreateNew(true);
        newForm.setOtherMemberships(new TreeSet(new UserMembershipDataComparator()));
        newForm.setRolenames(new String[0]);
        newForm.setNewMembershipHomeAccount(true);
        newForm.setNewMembershipRight(newRight != null ? newRight : Rights.SELECTION);
        newForm.setNewMembershipOrganisationId(orgData.getSid());
        newForm.setNewMembershipOrgName(orgData.getName());
        return newForm;
    }

    private UserActionForm setupUserActionForm(Long editUserId, OrganisationCompleteData orgData, UserData user) throws IllegalAccessException, InvocationTargetException {
        UserActionForm newForm = new UserActionForm();
        BeanUtils.copyProperties((Object)((Object)newForm), (Object)user);
        newForm.setNewMembershipOrganisationId(orgData.getSid());
        newForm.setNewMembershipOrgName(orgData.getName());
        Integer newMembershipRight = null;
        boolean newMembershipHomeAccount = false;
        if (user.getMemberships() != null) {
            Iterator iter = user.getMemberships().iterator();
            while (newMembershipRight == null && iter.hasNext()) {
                UserMembershipData element = (UserMembershipData)iter.next();
                if (!element.getOrgId().equals(orgData.getSid())) continue;
                newMembershipRight = element.getRight();
                newMembershipHomeAccount = element.isAccountHome();
            }
        }
        newForm.setCreateNew(false);
        newForm.setOtherMemberships(user.getMemberships());
        newForm.setRolenames(this.getRolenames(user));
        newForm.setNewMembershipHomeAccount(newMembershipHomeAccount);
        if (newMembershipRight != null) {
            newForm.setNewMembershipRight(newMembershipRight);
        } else {
            log.warn((Object)("Unable to find existing membership for user " + editUserId + " organisation " + orgData.getSid()));
            newForm.setNewMembershipRight(Rights.MEMBERSHIP);
        }
        return newForm;
    }

    private String[] getRolenames(UserData user) {
        String[] rolenames = new String[user.getRoles().size()];
        Iterator iter = user.getRoles().iterator();
        int i = 0;
        while (iter.hasNext()) {
            UserRole role = (UserRole)iter.next();
            rolenames[i] = role.getName();
            ++i;
        }
        return rolenames;
    }

    public String implUserView(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response, Long userIdInput) throws IOException, ServletException {
        log.debug((Object)("doUserView userId=" + userIdInput));
        Long userId = userIdInput;
        if (userId == null && (userId = this.getEditUserId(request)) == null) {
            log.error((Object)("Trying to view user details but the user id was missing. Possible user id parameter userid had value " + request.getParameter(USERID_TAG) + "."));
            return "error";
        }
        UserData user = null;
        boolean error = false;
        try {
            UserManagementService service = UserManagementServiceUtil.getHome().create();
            user = service.getCompleteUser(userId);
        }
        catch (RemoteException e) {
            log.error((Object)"Exception occured ", (Throwable)e);
            error = true;
        }
        catch (CreateException e) {
            log.error((Object)"Exception occured ", (Throwable)e);
            error = true;
        }
        catch (NamingException e) {
            log.error((Object)"Exception occured ", (Throwable)e);
            error = true;
        }
        if (user == null) {
            user = new UserData();
        }
        log.debug((Object)("User is " + user.toString()));
        request.setAttribute(USER_TAG, (Object)user);
        return error ? "error" : "userview";
    }

    public String implPasswordChange(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        log.debug((Object)"implPasswordChange");
        String username = null;
        try {
            username = WebUtil.getUsername(request);
        }
        catch (Exception e) {
            // empty catch block
        }
        PasswordChangeActionForm newForm = new PasswordChangeActionForm();
        newForm.setLogin(username);
        request.setAttribute("PasswordChangeActionForm", (Object)newForm);
        return "passwordchange";
    }

    public String implLCWSetting(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        log.debug((Object)"implLCWSetting");
        LcwSettingActionForm newForm = new LcwSettingActionForm();
        boolean accessible = "true".equalsIgnoreCase(StringUtils.trimToEmpty((String)ConfigurationServiceDelegate.get(ConfigurationKeys.IS_ON_INTERNET)));
        newForm.setAccessible(accessible);
        request.setAttribute("LcwSettingActionForm", (Object)newForm);
        return "lcwsetting";
    }

    public String implImportFile(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response, Long orgIdInput) throws IOException, ServletException {
        boolean error;
        block13: {
            Long orgId = orgIdInput;
            if (orgId == null) {
                orgId = RequestUtil.getLongParameter(request, ORGANISATIONID_TAG);
            }
            error = false;
            UserManagementService service = null;
            try {
                service = UserManagementServiceUtil.getHome().create();
                Long adminUserId = RequestUtil.getUserId(request, service);
                OrganisationCompleteData org = null;
                if (orgId != null && adminUserId != null) {
                    List namePath = service.getParentHierarchy(orgId, adminUserId);
                    log.debug((Object)("Name path is " + namePath));
                    request.setAttribute(NAME_PATH_TAG, (Object)namePath);
                    org = service.getOrganisation(orgId, adminUserId);
                    request.setAttribute(ORGANISATION_TAG, (Object)org);
                    Iterator iter = org.getUsers().entrySet().iterator();
                    Integer right = null;
                    while (right == null && iter.hasNext()) {
                        Map.Entry element = iter.next();
                        UserData user = (UserData)element.getKey();
                        if (!user.getSid().equals(adminUserId)) continue;
                        UserMembershipData mem = (UserMembershipData)element.getValue();
                        right = mem.getRight();
                    }
                    request.setAttribute(VIEW_ONLY, (Object)new Boolean(!Rights.MODIFICATION.equals(right)));
                    FileItem fileToUpload = null;
                    String message = null;
                    List items = null;
                    try {
                        items = UploadFileUtil.getUploadItems(request, false, null);
                        iter = items.iterator();
                        while (iter.hasNext()) {
                            FileItem item = (FileItem)iter.next();
                            log.debug((Object)("Request item: " + item.toString()));
                            if (item.getName() == null || item.getSize() == 0L) continue;
                            fileToUpload = item;
                        }
                    }
                    catch (FileUploadException fue) {
                        log.error((Object)("Unable to upload file from administrator " + adminUserId + ". Exception occured"), (Throwable)fue);
                        message = "Unable to upload file. Error returned by uploader was:" + fue.getMessage();
                    }
                    if (fileToUpload != null) {
                        try {
                            message = UserImporter.importUsers(fileToUpload, org, adminUserId);
                        }
                        catch (IOException ioe) {
                            message = "Unable to read file. Error returned was: " + ioe.getMessage();
                        }
                        if (message != null) {
                            log.error((Object)message);
                        }
                    } else {
                        message = "Something odd has happenned - no error has been found but we haven't received a file. Try again and if this reoccurs, contact supportfor help";
                        log.error((Object)("Something odd has happened - no error has been found (message==null)but we haven't received a file (fileWritten==false). userId=" + adminUserId + " upload items=" + (items != null ? items.toString() : "null")));
                    }
                    request.setAttribute(MSG, (Object)message);
                    break block13;
                }
                error = true;
            }
            catch (Exception e) {
                log.error((Object)"Error occured: ", (Throwable)e);
                error = true;
            }
        }
        return error ? "error" : "organisationentry";
    }

    public String implDeleteUser(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        log.debug((Object)"implDeleteUser");
        Long orgId = null;
        Long deleteUserId = null;
        Long adminUserId = null;
        String message = null;
        boolean error = false;
        OrganisationCompleteData org = null;
        try {
            if (request.getParameter(USERID_TAG) == null) {
                log.error((Object)"implDeleteUser: Id of the user to be deleted not found ");
                return "error";
            }
            deleteUserId = new Long(request.getParameter(USERID_TAG).trim());
            if (request.getParameter(ORGANISATIONID_TAG) == null) {
                log.error((Object)"implDeleteUser: Current organisation Id not found ");
                return "error";
            }
            orgId = new Long(request.getParameter(ORGANISATIONID_TAG).trim());
        }
        catch (NumberFormatException e) {
            log.error((Object)"implDeleteUser: request parameter format error ");
            return "error";
        }
        try {
            UserManagementService service = UserManagementServiceUtil.getHome().create();
            adminUserId = RequestUtil.getUserId(request, service);
            if (adminUserId == null) {
                log.error((Object)("implDeleteUser: Administrator of " + orgId + " not found "));
                return "error";
            }
            org = service.getOrganisation(orgId, adminUserId);
            if (org == null) {
                log.error((Object)("implDeleteUser: Organisation not found " + orgId));
                return "error";
            }
            List namePath = service.getParentHierarchy(orgId, adminUserId);
            log.debug((Object)("Name path is " + namePath));
            request.setAttribute(NAME_PATH_TAG, (Object)namePath);
            Iterator iter = org.getUsers().entrySet().iterator();
            Integer right = null;
            while (right == null && iter.hasNext()) {
                Map.Entry element = iter.next();
                UserData user = (UserData)element.getKey();
                if (!user.getSid().equals(adminUserId)) continue;
                UserMembershipData mem = (UserMembershipData)element.getValue();
                right = mem.getRight();
            }
            request.setAttribute(VIEW_ONLY, (Object)new Boolean(!Rights.MODIFICATION.equals(right)));
            ShwaaUserData user = null;
            user = service.getUser(deleteUserId);
            if (user == null) {
                message = "This user cannot be retrived";
            } else {
                String username = user.getLogin();
                ClientSessionDataManager manager = ClientSessionDataManager.getInstance();
                ClientSessionData data = manager.getDetails(username);
                if (data != null) {
                    message = user.getLogin() + " has logged in and hasn't logged out, " + "so he/she cannot be deleted at this moment. Please try again later.";
                } else {
                    PersistenceSession sess = null;
                    sess = new PersistenceSession();
                    LearningSessionDAO learningSessionDAO = new LearningSessionDAO(sess);
                    List list = learningSessionDAO.findByUser(deleteUserId);
                    if (list.size() > 0) {
                        message = user.getLogin() + " is running some sessions, " + "so he/she cannot be deleted at this moment. Please try again later.";
                    } else {
                        try {
                            message = service.deleteUser(orgId, deleteUserId, adminUserId);
                            if (message == null) {
                                Iterator userIter = org.getUsers().entrySet().iterator();
                                while (userIter.hasNext()) {
                                    Map.Entry entry = userIter.next();
                                    UserData userData = (UserData)entry.getKey();
                                    if (!userData.getSid().equals(deleteUserId)) continue;
                                    userIter.remove();
                                }
                            }
                        }
                        catch (UserManagementAuthorisationException e) {
                            message = "Error was: " + e.getMessage();
                        }
                    }
                }
            }
            request.setAttribute(ORGANISATION_TAG, (Object)org);
        }
        catch (RemoteException e) {
            log.error((Object)"Exception occured ", (Throwable)e);
            error = true;
        }
        catch (CreateException e) {
            log.error((Object)"Exception occured ", (Throwable)e);
            error = true;
        }
        catch (NamingException e) {
            log.error((Object)"Exception occured ", (Throwable)e);
            error = true;
        }
        catch (UserManagementException e) {
            log.error((Object)"SystemUserException occured ", (Throwable)e);
            error = true;
        }
        request.setAttribute(MSG, message);
        return error ? "error" : "organisationentry";
    }

    public String implOrganisationEdit(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response, Long orgIdInput) throws IOException, ServletException {
        log.debug((Object)("doOrganisationEdit orgId" + orgIdInput));
        Long orgId = orgIdInput;
        if (orgId == null) {
            orgId = RequestUtil.getLongParameter(request, ORGANISATIONID_TAG);
        }
        boolean error = false;
        UserManagementService service = null;
        try {
            OrganisationCompleteData org = null;
            Long adminUserId = null;
            if (orgId != null) {
                service = UserManagementServiceUtil.getHome().create();
                adminUserId = RequestUtil.getUserId(request, service);
                org = service.getOrganisation(orgId, adminUserId);
            }
            if (org != null) {
                request.setAttribute(ORGANISATION_TAG, org);
                List namePath = service.getParentHierarchy(orgId, adminUserId);
                log.debug((Object)("Name path is " + namePath));
                request.setAttribute(NAME_PATH_TAG, (Object)namePath);
                Iterator iter = org.getUsers().entrySet().iterator();
                Integer right = null;
                while (right == null && iter.hasNext()) {
                    Map.Entry element = iter.next();
                    UserData user = (UserData)element.getKey();
                    if (!user.getSid().equals(adminUserId)) continue;
                    UserMembershipData mem = (UserMembershipData)element.getValue();
                    right = mem.getRight();
                }
                request.setAttribute(VIEW_ONLY, (Object)new Boolean(!Rights.MODIFICATION.equals(right)));
            } else {
                log.error((Object)("doOrganisationEdit: Organsation " + orgId + " not found"));
                error = true;
            }
        }
        catch (RemoteException e) {
            log.error((Object)"Exception occured ", (Throwable)e);
            error = true;
        }
        catch (CreateException e) {
            log.error((Object)"Exception occured ", (Throwable)e);
            error = true;
        }
        catch (NamingException e) {
            log.error((Object)"Exception occured ", (Throwable)e);
            error = true;
        }
        catch (UserManagementException e) {
            log.error((Object)"UserManagementException occured ", (Throwable)e);
            error = true;
        }
        request.getSession(true).setAttribute(ORGID_EDITED, (Object)orgId);
        return error ? "error" : "organisationentry";
    }

    public String implOrganisationEditSimple(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        OrganisationSimpleActionForm orgform;
        boolean error;
        block16: {
            log.debug((Object)"implOrganisationEditSimple");
            Long orgId = null;
            try {
                if (request.getParameter(ORGANISATIONID_TAG) != null) {
                    orgId = new Long(request.getParameter(ORGANISATIONID_TAG).trim());
                }
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
            error = false;
            Boolean newAccountOrganisation = null;
            newAccountOrganisation = request.getParameter(CREATE_NEW_ACCOUNT_ORG) != null ? new Boolean(request.getParameter(CREATE_NEW_ACCOUNT_ORG)) : Boolean.FALSE;
            orgform = new OrganisationSimpleActionForm();
            try {
                UserManagementService service = UserManagementServiceUtil.getHome().create();
                Long adminUserId = null;
                adminUserId = RequestUtil.getUserId(request, service);
                if (orgId == null || orgId == -1L) {
                    orgform.setSid(new Long(-1L));
                    orgform.setName("");
                    orgform.setDescription("");
                    orgform.setAccountOrganisation(newAccountOrganisation);
                    log.debug((Object)("New account organisation? " + request.getParameter(CREATE_NEW_ACCOUNT_ORG) + " " + newAccountOrganisation));
                    Long parentOrgId = null;
                    try {
                        if (request.getParameter(PARENT_ORGANISATIONID_TAG) != null) {
                            parentOrgId = new Long(request.getParameter(PARENT_ORGANISATIONID_TAG).trim());
                        }
                    }
                    catch (NumberFormatException e) {
                        // empty catch block
                    }
                    OrganisationCompleteData parent = null;
                    if (parentOrgId != null && (parent = service.getOrganisation(parentOrgId, adminUserId)) != null) {
                        orgform.setParentOrgSid(parent.getSid());
                        orgform.setParentOrgName(parent.getName());
                    }
                    if (parent == null) {
                        log.warn((Object)"Creating new top level organisation (parent organisation id not found)");
                    }
                    break block16;
                }
                OrganisationCompleteData org = service.getOrganisation(orgId, adminUserId);
                if (org != null) {
                    log.debug((Object)("Copying properties from org " + org.toString()));
                    orgform.setSid(org.getSid());
                    orgform.setName(org.getName());
                    orgform.setParentOrgSid(org.getParentOrganisationSid());
                    orgform.setDescription(org.getDescription());
                    orgform.setAccountOrganisation(org.isAccountOrganisation());
                } else {
                    log.error((Object)("Organisation id " + orgId + " not found"));
                    error = true;
                }
            }
            catch (RemoteException e) {
                log.error((Object)"Exception occured ", (Throwable)e);
                error = true;
            }
            catch (CreateException e) {
                log.error((Object)"Exception occured ", (Throwable)e);
                error = true;
            }
            catch (NamingException e) {
                log.error((Object)"Exception occured ", (Throwable)e);
                error = true;
            }
            catch (UserManagementException e) {
                log.error((Object)"UserManagementException occured ", (Throwable)e);
                error = true;
            }
        }
        request.setAttribute("OrganisationSimpleActionForm", (Object)orgform);
        return error ? "error" : "organisationentrysimple";
    }

    public String implOrganisationAddUsers(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        log.debug((Object)"implOrganisationAddUsers");
        Long orgId = null;
        try {
            if (request.getParameter(ORGANISATIONID_TAG) != null) {
                orgId = new Long(request.getParameter(ORGANISATIONID_TAG).trim());
            }
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        OrganisationAddUsersActionForm newForm = null;
        boolean error = false;
        if (orgId == null) {
            log.error((Object)"implOrganisationAddUsers: Missing parameter organisationid");
            error = true;
        } else {
            newForm = this.setupOrgAddUserForm(request, orgId);
        }
        if (newForm == null || error) {
            return "error";
        }
        request.setAttribute("OrganisationAddUsersActionForm", (Object)newForm);
        return "organisationaddusers";
    }

    private OrganisationAddUsersActionForm setupOrgAddUserForm(HttpServletRequest request, Long orgId) {
        boolean error = false;
        OrganisationAddUsersActionForm newForm = new OrganisationAddUsersActionForm();
        try {
            Long adminUserId = null;
            UserManagementService service = UserManagementServiceUtil.getHome().create();
            adminUserId = RequestUtil.getUserId(request, service);
            OrganisationCompleteData org = service.getOrganisation(orgId, adminUserId);
            if (org != null) {
                log.debug((Object)("Copying properties from org " + org.toString()));
                newForm.setName(org.getName());
                newForm.setDescription(org.getDescription());
                newForm.setSid(org.getSid());
            } else {
                log.error((Object)("implOrganisationAddUsers: Organisation not found or not available to this user. Id #=" + orgId + " user id " + adminUserId));
                error = true;
            }
            Set orgs = service.getAllOrganisations(adminUserId);
            newForm.setAvailableOrgs(this.flattenOrgs(orgs));
            newForm.setSelectedOrgId(new Long(-1L));
            Integer newRight = null;
            try {
                newRight = new Integer(WebUtil.readIntParam(request, USER_TYPE_TAG));
            }
            catch (IllegalArgumentException e) {
                // empty catch block
            }
            newForm.setAssignRight(newRight != null ? newRight : Rights.SELECTION);
        }
        catch (RemoteException e) {
            log.error((Object)"Exception occured ", (Throwable)e);
            error = true;
        }
        catch (CreateException e) {
            log.error((Object)"Exception occured ", (Throwable)e);
            error = true;
        }
        catch (NamingException e) {
            log.error((Object)"Exception occured ", (Throwable)e);
            error = true;
        }
        catch (UserManagementException e) {
            log.error((Object)"UserManagementException occured ", (Throwable)e);
            error = true;
        }
        if (error) {
            newForm = null;
            return null;
        }
        return newForm;
    }

    private ArrayList flattenOrgs(Set orgSet) {
        ArrayList flatOrgs = new ArrayList();
        if (orgSet != null) {
            Iterator iter = orgSet.iterator();
            while (iter.hasNext()) {
                OrganisationRecursiveData org = (OrganisationRecursiveData)iter.next();
                this.flattenOrgs2(org, flatOrgs);
            }
        }
        return flatOrgs;
    }

    private void flattenOrgs2(OrganisationRecursiveData org, ArrayList flatOrgs) {
        OrganisationRecursiveData[] childOrgs = org.getChildOrganisations();
        org.setChildOrganisations(null);
        flatOrgs.add(org);
        if (childOrgs != null) {
            for (int i = 0; i < childOrgs.length; ++i) {
                if (!childOrgs[i].isAccountOrganisation()) continue;
                this.flattenOrgs2(childOrgs[i], flatOrgs);
            }
        }
    }

    protected Long getEditUserId(HttpServletRequest request) {
        try {
            if (request.getParameter(USERID_TAG) != null) {
                long userId = Long.parseLong(request.getParameter(USERID_TAG).trim());
                return new Long(userId);
            }
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

