/*
 * Decompiled with CFR 0.152.
 */
package com.webmcq.ld.usermanagement;

import com.webmcq.ld.controller.web.WebApplicationContext;
import com.webmcq.ld.usermanagement.OrganisationCompleteData;
import com.webmcq.ld.usermanagement.OrganisationRecursiveData;
import com.webmcq.ld.usermanagement.OrganisationRights;
import com.webmcq.ld.usermanagement.Rights;
import com.webmcq.ld.usermanagement.UserData;
import com.webmcq.ld.usermanagement.UserManagementAuthorisationException;
import com.webmcq.ld.usermanagement.UserManagementException;
import com.webmcq.ld.usermanagement.UserMembershipData;
import com.webmcq.ld.usermanagement.UserRole;
import com.webmcq.ld.usermanagement.comparators.LastNameAlphabeticComparator;
import com.webmcq.ld.usermanagement.comparators.OrganisationRecursiveDataComparator;
import com.webmcq.ld.usermanagement.comparators.UserMembershipDataComparator;
import com.webmcq.ld.usermanagement.interfaces.OrganisationData;
import com.webmcq.ld.usermanagement.interfaces.OrganisationLocal;
import com.webmcq.ld.usermanagement.interfaces.OrganisationMembershipLocal;
import com.webmcq.ld.usermanagement.interfaces.OrganisationPK;
import com.webmcq.ld.usermanagement.interfaces.OrganisationUtil;
import com.webmcq.ld.usermanagement.interfaces.ShwaaGroupLocal;
import com.webmcq.ld.usermanagement.interfaces.ShwaaGroupPK;
import com.webmcq.ld.usermanagement.interfaces.ShwaaGroupUtil;
import com.webmcq.ld.usermanagement.interfaces.ShwaaUserData;
import com.webmcq.ld.usermanagement.interfaces.ShwaaUserDetailLocal;
import com.webmcq.ld.usermanagement.interfaces.ShwaaUserDetailPK;
import com.webmcq.ld.usermanagement.interfaces.ShwaaUserDetailUtil;
import com.webmcq.ld.usermanagement.interfaces.ShwaaUserLocal;
import com.webmcq.ld.usermanagement.interfaces.ShwaaUserPK;
import com.webmcq.ld.usermanagement.interfaces.ShwaaUserUtil;
import com.webmcq.ld.usermanagement.interfaces.UserExtrasLocal;
import com.webmcq.ld.usermanagement.interfaces.UserExtrasPK;
import com.webmcq.ld.usermanagement.interfaces.UserExtrasUtil;
import com.webmcq.ld.util.BaseSessionBean;
import com.webmcq.ld.util.EJBUtil;
import java.security.NoSuchAlgorithmException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.ejb.CreateException;
import javax.ejb.EJBException;
import javax.ejb.FinderException;
import javax.ejb.RemoveException;
import javax.naming.NamingException;
import javax.servlet.ServletContext;
import org.apache.log4j.Logger;
import org.lamsfoundation.ld.util.HashUtil;

public abstract class UserManagementServiceBean
extends BaseSessionBean {
    private static Logger log = Logger.getLogger((Class)(class$com$webmcq$ld$usermanagement$UserManagementServiceBean == null ? (class$com$webmcq$ld$usermanagement$UserManagementServiceBean = UserManagementServiceBean.class$("com.webmcq.ld.usermanagement.UserManagementServiceBean")) : class$com$webmcq$ld$usermanagement$UserManagementServiceBean));
    public static Long NONE_ORGANISATION_SID = new Long(1L);
    public static final String ORG_PREFIX = "org_";
    static /* synthetic */ Class class$com$webmcq$ld$usermanagement$UserManagementServiceBean;

    public Long getUserId(String loginName) {
        log.debug((Object)"Starting getUserId(String loginName)");
        ShwaaUserLocal user = this.getShwaaUserLocal(loginName);
        Long id = user != null ? user.getUid() : null;
        log.debug((Object)"Ending getUserId(String loginName)");
        return id;
    }

    public ShwaaUserData getUser(String loginName) {
        log.debug((Object)"Starting getUser(String loginName)");
        ShwaaUserLocal user = this.getShwaaUserLocal(loginName);
        ShwaaUserData data = user != null ? user.getData() : null;
        log.debug((Object)"Ending getUser(String loginName)");
        return data;
    }

    public ShwaaUserData getUser(Long userSid) {
        log.debug((Object)("Starting getUser: " + userSid));
        ShwaaUserLocal user = this.getShwaaUserLocal(userSid);
        ShwaaUserData data = user != null ? user.getData() : null;
        log.debug((Object)("Ending getUser: " + userSid));
        return data;
    }

    public UserData getCompleteUser(String loginName) {
        log.debug((Object)"Starting getCompleteUser(String loginName)");
        UserData data = null;
        ShwaaUserLocal shwaaUser = this.getShwaaUserLocal(loginName);
        data = this.getCompleteUser(shwaaUser);
        log.debug((Object)"Ending getCompleteUser(String loginName)");
        return data;
    }

    public UserData getCompleteUser(Long userSid) {
        log.debug((Object)"Starting getCompleteUser(Long userSid)");
        UserData data = null;
        ShwaaUserLocal shwaaUser = this.getShwaaUserLocal(userSid);
        data = this.getCompleteUser(shwaaUser);
        log.debug((Object)"Ending getCompleteUser(Long userSid)");
        return data;
    }

    private UserData getCompleteUser(ShwaaUserLocal user) {
        log.debug((Object)"Starting getCompleteUser(ShwaaUserLocal user)");
        Object[] beans = null;
        UserData data = null;
        if (user != null) {
            beans = this.loadDependentBeans(user);
            data = this.createUserData((ShwaaUserLocal)beans[0], (UserExtrasLocal)beans[1], (ShwaaUserDetailLocal)beans[2]);
        }
        log.debug((Object)"Ending getCompleteUser(ShwaaUserLocal user)");
        return data;
    }

    private Object[] loadDependentBeans(ShwaaUserLocal shwaaUser) {
        UserExtrasLocal userExtras = null;
        ShwaaUserDetailLocal shwaaUserDetail = null;
        try {
            UserExtrasPK extrasPK = new UserExtrasPK(shwaaUser.getUid());
            userExtras = UserExtrasUtil.getLocalHome().findByPrimaryKey(extrasPK);
        }
        catch (FinderException e) {
            log.warn((Object)("Dependent object UserExtras missing for user " + shwaaUser.getData().toString() + " Cannot continue"), (Throwable)e);
            throw new EJBException((Exception)((Object)e));
        }
        catch (NamingException e) {
            log.error((Object)"Naming exception occured ", (Throwable)e);
            throw new EJBException((Exception)e);
        }
        try {
            ShwaaUserDetailPK pk = new ShwaaUserDetailPK(shwaaUser.getUid());
            shwaaUserDetail = ShwaaUserDetailUtil.getLocalHome().findByPrimaryKey(pk);
        }
        catch (FinderException e) {
            log.warn((Object)("Dependent object ShwaaUserDetail missing for user " + shwaaUser.getData().toString() + " Cannot continue"), (Throwable)e);
            throw new EJBException((Exception)((Object)e));
        }
        catch (NamingException e) {
            log.error((Object)"Naming exception occured ", (Throwable)e);
            throw new EJBException((Exception)e);
        }
        Object[] arr = new Object[]{shwaaUser, userExtras, shwaaUserDetail};
        return arr;
    }

    private ShwaaUserLocal getShwaaUserLocal(Long userSid) {
        ShwaaUserLocal shwaaUser = null;
        try {
            ShwaaUserPK pk = new ShwaaUserPK(userSid);
            shwaaUser = ShwaaUserUtil.getLocalHome().findByPrimaryKey(pk);
        }
        catch (FinderException e) {
        }
        catch (NamingException e) {
            log.error((Object)"Exception occured", (Throwable)e);
            throw new EJBException((Exception)e);
        }
        return shwaaUser;
    }

    private ShwaaUserLocal getShwaaUserLocal(String loginName) {
        ShwaaUserLocal shwaaUser = null;
        try {
            Collection entries = ShwaaUserUtil.getLocalHome().findByLogin(loginName);
            shwaaUser = (ShwaaUserLocal)EJBUtil.findSingle(entries);
        }
        catch (FinderException e) {
        }
        catch (NamingException e) {
            log.error((Object)"Exception occured", (Throwable)e);
            throw new EJBException((Exception)e);
        }
        return shwaaUser;
    }

    private UserData createUserData(ShwaaUserLocal shwaaUser, UserExtrasLocal user, ShwaaUserDetailLocal shwaaUserDetail) {
        if (shwaaUser == null) {
            return null;
        }
        UserData data = new UserData();
        data.setSid(shwaaUser.getUid());
        data.setFirstName(shwaaUser.getFirstName());
        data.setLastName(shwaaUser.getLastName());
        data.setLogin(shwaaUser.getLogin());
        HashSet<UserRole> roles = new HashSet<UserRole>();
        Iterator iter = shwaaUser.getRoles().iterator();
        while (iter.hasNext()) {
            ShwaaGroupLocal swhaaGroup = (ShwaaGroupLocal)iter.next();
            UserRole role = new UserRole(swhaaGroup.getGid(), swhaaGroup.getGroupName());
            roles.add(role);
        }
        data.setRoles(roles);
        if (shwaaUserDetail != null) {
            data.setAddress(shwaaUserDetail.getAddress());
            data.setDepartment(shwaaUserDetail.getDepartment());
            data.setEmail(shwaaUserDetail.getEmail());
            data.setFax(shwaaUserDetail.getFax());
            data.setJobTitle(shwaaUserDetail.getJobTitle());
            data.setMobile(shwaaUserDetail.getMobile());
            data.setOrganisation(shwaaUserDetail.getOrganisation());
            data.setPhone(shwaaUserDetail.getPhone());
        }
        data.setDisabled(user.getDisabled());
        iter = shwaaUser.getMemberships().iterator();
        TreeSet<UserMembershipData> memberDataSet = new TreeSet<UserMembershipData>(new UserMembershipDataComparator());
        while (iter.hasNext()) {
            OrganisationMembershipLocal membershipEJB = (OrganisationMembershipLocal)iter.next();
            OrganisationLocal org = membershipEJB.getOrganisation();
            if (org != null) {
                UserMembershipData memberData = new UserMembershipData(shwaaUser, org, membershipEJB.getRight(), membershipEJB.getAccountHome());
                memberDataSet.add(memberData);
                continue;
            }
            log.warn((Object)("Membership with no organisation " + membershipEJB.getData().toString()));
        }
        data.setMemberships(memberDataSet);
        return data;
    }

    public Long updateUser(UserData userData, String newPassword, boolean modifiedOrganisations, Long adminUserId, Long orgId) throws UserManagementException, UserManagementAuthorisationException {
        if (userData == null) {
            return null;
        }
        log.debug((Object)("Updating user using " + userData.toString() + " password " + newPassword));
        if (userData.getLogin() == null) {
            throw new UserManagementException("error.username.length");
        }
        if (userData.getLogin().length() > 250) {
            throw new UserManagementException("error.username.length");
        }
        ShwaaUserLocal adminUser = null;
        if (modifiedOrganisations && (adminUser = this.getShwaaUserLocal(adminUserId)) == null) {
            throw new UserManagementAuthorisationException("error.user.notfound");
        }
        ShwaaUserLocal shwaaUser = null;
        UserExtrasLocal userExtras = null;
        ShwaaUserDetailLocal shwaaUserDetail = null;
        boolean isUpdate = true;
        if (userData.getSid() != null && userData.getSid() != -1L) {
            shwaaUser = this.getShwaaUserLocal(userData.getSid());
            Object[] objs = this.loadDependentBeans(shwaaUser);
            if (objs == null || objs[0] == null) {
                throw new UserManagementException("error.user.notfound");
            }
            userExtras = objs[1] != null ? (UserExtrasLocal)objs[1] : this.createUserExtras(shwaaUser.getUid());
            shwaaUserDetail = objs[2] != null ? (ShwaaUserDetailLocal)objs[2] : this.createShwaaUserDetail(shwaaUser.getUid());
            if (newPassword != null) {
                try {
                    shwaaUser.setPassword(HashUtil.md5(newPassword));
                }
                catch (NoSuchAlgorithmException e) {
                    throw new EJBException((Exception)e);
                }
            }
            if (!shwaaUser.getLogin().equals(userData.getLogin())) {
                if (this.checkLoginUsed(userData.getLogin()) != null) {
                    throw new UserManagementException("error.username.unique");
                }
                shwaaUser.setLogin(userData.getLogin());
            }
        } else {
            isUpdate = false;
            try {
                log.debug((Object)"Creating new user ");
                if (this.checkLoginUsed(userData.getLogin()) != null) {
                    throw new UserManagementException("error.username.unique");
                }
                shwaaUser = ShwaaUserUtil.getLocalHome().create(userData.getLogin(), HashUtil.md5(newPassword));
                userExtras = this.createUserExtras(shwaaUser.getUid());
                shwaaUserDetail = this.createShwaaUserDetail(shwaaUser.getUid());
            }
            catch (CreateException e) {
                log.error((Object)"Exception occured", (Throwable)e);
                throw new EJBException((Exception)((Object)e));
            }
            catch (NamingException e) {
                log.error((Object)"Exception occured", (Throwable)e);
                throw new EJBException((Exception)e);
            }
            catch (NoSuchAlgorithmException e) {
                log.error((Object)"Exception occurred", (Throwable)e);
                throw new EJBException((Exception)e);
            }
        }
        userExtras.setDisabled(userData.getDisabled() != null ? userData.getDisabled() : false);
        shwaaUser.setFirstName(userData.getFirstName());
        shwaaUser.setLastName(userData.getLastName());
        this.updateRoles(userData.getRoles(), shwaaUser);
        shwaaUserDetail.setAddress(userData.getAddress());
        shwaaUserDetail.setDepartment(userData.getDepartment());
        shwaaUserDetail.setEmail(userData.getEmail());
        shwaaUserDetail.setFax(userData.getFax());
        shwaaUserDetail.setJobTitle(userData.getJobTitle());
        shwaaUserDetail.setMobile(userData.getMobile());
        shwaaUserDetail.setOrganisation(userData.getOrganisation());
        shwaaUserDetail.setPhone(userData.getPhone());
        if (modifiedOrganisations) {
            this.processModifiedOrganisations(shwaaUser, userData.getMemberships(), adminUser);
        }
        if (isUpdate) {
            this.updateCachedOrgUpdateUser(orgId, userData);
        }
        log.debug((Object)("Saved user, sid is " + shwaaUser.getUid()));
        return shwaaUser.getUid();
    }

    private Long checkLoginUsed(String login) {
        ShwaaUserLocal user = null;
        user = this.getShwaaUserLocal(login);
        return user != null ? user.getUid() : null;
    }

    private void processModifiedOrganisations(ShwaaUserLocal shwaaUser, SortedSet memberships, ShwaaUserLocal adminUser) throws UserManagementException, UserManagementAuthorisationException {
        HashSet candidatesToRemove = new HashSet(shwaaUser.getMemberships());
        log.debug((Object)("processModifiedOrganisations: current number of memberships " + candidatesToRemove.size()));
        log.debug((Object)("# memberships to be updated/created :" + shwaaUser.getMemberships().size()));
        Iterator newIter = memberships.iterator();
        while (newIter.hasNext()) {
            UserMembershipData newMembership = (UserMembershipData)newIter.next();
            OrganisationMembershipLocal membershipBean = this.updateUserMembershipSingle(shwaaUser, newMembership.getOrgId(), newMembership.getRight(), newMembership.isAccountHome(), adminUser);
            candidatesToRemove.remove(membershipBean);
        }
        log.debug((Object)("After while loop, number of memberships left in candidates to remove (ie not updated therefore assume not wanted) " + candidatesToRemove.size()));
        Iterator iter = candidatesToRemove.iterator();
        while (iter.hasNext()) {
            OrganisationMembershipLocal element = (OrganisationMembershipLocal)iter.next();
            this.removeUserMembership(element.getUser(), element.getOrganisation());
        }
        log.debug((Object)("# memberships to be after updates:" + shwaaUser.getMemberships().size()));
    }

    private void updateRoles(Set userRoles, ShwaaUserLocal shwaaUser) {
        Set roles = shwaaUser.getRoles();
        try {
            roles.clear();
            if (userRoles != null) {
                Iterator iter = userRoles.iterator();
                while (iter.hasNext()) {
                    UserRole roleData = (UserRole)iter.next();
                    ShwaaGroupPK pk = new ShwaaGroupPK(new Long(roleData.getId()));
                    ShwaaGroupLocal ejb = ShwaaGroupUtil.getLocalHome().findByPrimaryKey(pk);
                    roles.add(ejb);
                }
            }
        }
        catch (FinderException e) {
            log.error((Object)"Exception occured", (Throwable)e);
            throw new EJBException((Exception)((Object)e));
        }
        catch (NamingException e) {
            log.error((Object)"Exception occured", (Throwable)e);
            throw new EJBException((Exception)e);
        }
    }

    public void updateUserMembership(Long editUserId, Long organisationId, Integer right, boolean accountHome, Long adminUserId) throws UserManagementException, UserManagementAuthorisationException {
        ShwaaUserLocal editUser;
        if (log.isDebugEnabled()) {
            log.debug((Object)("updateUserMembership: userId " + editUserId + " orgId " + organisationId + " right " + right + " adminUserId " + adminUserId));
        }
        if ((editUser = this.getShwaaUserLocal(editUserId)) == null) {
            throw new UserManagementException("error.user.notfound");
        }
        ShwaaUserLocal adminUser = this.getShwaaUserLocal(adminUserId);
        if (adminUser == null) {
            throw new UserManagementException("error.user.notfound");
        }
        this.updateUserMembershipSingle(editUser, organisationId, right, accountHome, adminUser);
    }

    private OrganisationMembershipLocal updateUserMembershipSingle(ShwaaUserLocal editUser, Long orgId, Integer right, boolean accountHome, ShwaaUserLocal adminUser) throws UserManagementAuthorisationException, UserManagementException {
        try {
            OrganisationLocal org = this.getOrganisationLocal(orgId);
            OrganisationRights.checkRightsAddUserToOrganisation(org, adminUser);
            OrganisationMembershipLocal membership = org.updateMembership(editUser, right, accountHome);
            this.updateCachedOrgAddMembership(orgId, editUser, org, right, accountHome);
            return membership;
        }
        catch (NamingException e) {
            log.error((Object)"Exception occured", (Throwable)e);
            throw new EJBException((Exception)e);
        }
        catch (CreateException e) {
            log.error((Object)"Exception occured", (Throwable)e);
            throw new EJBException((Exception)((Object)e));
        }
    }

    private UserExtrasLocal createUserExtras(Long uid) throws UserManagementException {
        UserExtrasLocal userExtras = null;
        try {
            userExtras = UserExtrasUtil.getLocalHome().create(uid);
            userExtras.setDisabled(false);
        }
        catch (CreateException e) {
            log.error((Object)"Exception occured", (Throwable)e);
            throw new EJBException((Exception)((Object)e));
        }
        catch (NamingException e) {
            log.error((Object)"Exception occured", (Throwable)e);
            throw new EJBException((Exception)e);
        }
        return userExtras;
    }

    private ShwaaUserDetailLocal createShwaaUserDetail(Long uid) throws UserManagementException {
        ShwaaUserDetailLocal shwaaUserDetail;
        try {
            shwaaUserDetail = ShwaaUserDetailUtil.getLocalHome().create(uid);
        }
        catch (CreateException e) {
            log.error((Object)"Exception occured", (Throwable)e);
            throw new EJBException((Exception)((Object)e));
        }
        catch (NamingException e) {
            log.error((Object)"Exception occured", (Throwable)e);
            throw new EJBException((Exception)e);
        }
        return shwaaUserDetail;
    }

    public void updatePassword(String loginName, String newPassword) throws UserManagementException {
        if (loginName == null || newPassword == null) {
            return;
        }
        ShwaaUserLocal shwaaUser = this.getShwaaUserLocal(loginName);
        if (shwaaUser == null) {
            throw new UserManagementException("error.user.notfound");
        }
        try {
            shwaaUser.setPassword(HashUtil.md5(newPassword));
        }
        catch (NoSuchAlgorithmException e) {
            throw new EJBException((Exception)e);
        }
    }

    public OrganisationCompleteData getHomeOrganisation(Long userId) throws UserManagementException {
        log.debug((Object)("getHomeOrganisation id=" + userId));
        ShwaaUserLocal user = this.getShwaaUserLocal(userId);
        if (user == null) {
            throw new UserManagementException("error.user.notfound");
        }
        Iterator iter = user.getMemberships().iterator();
        OrganisationCompleteData data = null;
        while (data == null && iter.hasNext()) {
            OrganisationMembershipLocal element = (OrganisationMembershipLocal)iter.next();
            if (!element.getAccountHome()) continue;
            data = this.createHomeOrgByRight(element.getOrganisation(), element.getRight(), userId);
        }
        return data;
    }

    public OrganisationCompleteData getOrganisation(Long orgId, Long userId) throws UserManagementException {
        log.debug((Object)("getOrganisation id=" + orgId));
        ServletContext context = WebApplicationContext.getInstance().getServletContext();
        OrganisationCompleteData data = (OrganisationCompleteData)context.getAttribute(ORG_PREFIX + orgId);
        if (data != null) {
            log.debug((Object)"get cached organisation complete data.");
        } else {
            OrganisationLocal organisation = this.getOrganisationLocal(orgId);
            if (organisation == null) {
                throw new UserManagementException("error.organisation.notfound");
            }
            Object[] memberships = organisation.getMembership().toArray();
            for (int i = 0; i < memberships.length; ++i) {
                OrganisationMembershipLocal membership = (OrganisationMembershipLocal)memberships[i];
                ShwaaUserLocal user = membership.getUser();
                if (user != null) {
                    if (!user.getUid().equals(userId)) continue;
                    data = this.createOrgByRight(organisation, memberships, membership.getRight(), userId);
                    this.cacheOrganisation(orgId, data);
                    break;
                }
                log.warn((Object)("getOrganisation: membership with no user " + membership.getData().toString()));
            }
        }
        return data;
    }

    private OrganisationCompleteData createOrgByRight(OrganisationLocal organisation, Object[] memberships, Integer right, Long userId) {
        log.debug((Object)"createOrgByRight: Start");
        OrganisationCompleteData data = null;
        OrganisationLocal parent = organisation.getParentOrganisation();
        if (Rights.canModify(right)) {
            log.debug((Object)"createOrgByRight: can modify, create org. ");
            data = new OrganisationCompleteData(organisation.getSid(), organisation.getName(), organisation.getDescription(), organisation.getAccountOrganisation(), parent != null ? parent.getSid() : null, false, true);
        } else if (Rights.canSelect(right)) {
            log.debug((Object)"createOrgByRight: can select, create org. ");
            data = new OrganisationCompleteData(organisation.getSid(), organisation.getName(), organisation.getDescription(), organisation.getAccountOrganisation(), parent != null ? parent.getSid() : null, true, true);
        }
        if (data != null) {
            log.debug((Object)"createOrgByRight: adding child orgs ");
            data.addChildOrganisationsFromEJB(organisation.getChildOrganisations(), userId);
            log.debug((Object)"createOrgByRight: adding users ");
            TreeMap<UserData, UserMembershipData> users = new TreeMap<UserData, UserMembershipData>(new LastNameAlphabeticComparator());
            for (int i = 0; i < memberships.length; ++i) {
                OrganisationMembershipLocal membership = (OrganisationMembershipLocal)memberships[i];
                Object[] beans = this.loadDependentBeans(membership.getUser());
                UserData userData = this.createUserData((ShwaaUserLocal)beans[0], (UserExtrasLocal)beans[1], (ShwaaUserDetailLocal)beans[2]);
                UserMembershipData memberData = new UserMembershipData((ShwaaUserLocal)beans[0], organisation, membership.getRight(), membership.getAccountHome());
                users.put(userData, memberData);
            }
            data.setUsers(users);
        }
        log.debug((Object)"createOrgByRight: End");
        return data;
    }

    private OrganisationCompleteData createHomeOrgByRight(OrganisationLocal organisation, Integer right, Long userId) {
        log.debug((Object)"createHomeOrgByRight: Start");
        OrganisationCompleteData data = null;
        OrganisationLocal parent = organisation.getParentOrganisation();
        if (Rights.canModify(right)) {
            log.debug((Object)"createHomeOrgByRight: can modify, create org. ");
            data = new OrganisationCompleteData(organisation.getSid(), organisation.getName(), organisation.getDescription(), organisation.getAccountOrganisation(), parent != null ? parent.getSid() : null, false, true);
        } else if (Rights.canSelect(right)) {
            log.debug((Object)"createHomeOrgByRight: can select, create org. ");
            data = new OrganisationCompleteData(organisation.getSid(), organisation.getName(), organisation.getDescription(), organisation.getAccountOrganisation(), parent != null ? parent.getSid() : null, true, true);
        }
        log.debug((Object)"createHomeOrgByRight: End");
        return data;
    }

    private OrganisationLocal getOrganisationLocal(Long sid) throws UserManagementException {
        OrganisationLocal organisation = null;
        try {
            OrganisationPK pk = new OrganisationPK(sid);
            organisation = OrganisationUtil.getLocalHome().findByPrimaryKey(pk);
        }
        catch (FinderException e) {
        }
        catch (NamingException e) {
            log.error((Object)"Exception occured", (Throwable)e);
            throw new EJBException((Exception)e);
        }
        return organisation;
    }

    public Long updateOrganisation(OrganisationCompleteData newOrganisation, boolean modifiedMemberships, Long adminUserId) throws UserManagementException, UserManagementAuthorisationException {
        ShwaaUserLocal adminUser;
        if (newOrganisation == null) {
            return null;
        }
        this.updateCachedOrgSimpleUpdate(newOrganisation);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Updating organisation using " + newOrganisation.toString()));
        }
        if ((adminUser = this.getShwaaUserLocal(adminUserId)) == null) {
            throw new UserManagementAuthorisationException("error.user.notfound");
        }
        OrganisationLocal currOrganisation = null;
        try {
            boolean createdNew = false;
            if (newOrganisation.getSid() != null && newOrganisation.getSid() != -1L) {
                currOrganisation = this.getOrganisationLocal(newOrganisation.getSid());
                OrganisationRights.checkModifyOrganisation(currOrganisation, adminUser);
            } else {
                currOrganisation = OrganisationUtil.getLocalHome().create();
                createdNew = true;
            }
            currOrganisation.setName(newOrganisation.getName());
            currOrganisation.setDescription(newOrganisation.getDescription());
            currOrganisation.setAccountOrganisation(newOrganisation.isAccountOrganisation());
            currOrganisation.setVisible(newOrganisation.isVisible());
            if (modifiedMemberships) {
                this.updateMembership(newOrganisation, currOrganisation);
            }
            if (createdNew) {
                log.debug((Object)"Calling updateMembership on current organistion to add creation user ");
                currOrganisation.updateMembership(adminUser, Rights.MODIFICATION, false);
            }
            if (newOrganisation.getParentOrganisationSid() != null && newOrganisation.getParentOrganisationSid() != 0L) {
                OrganisationLocal parent = this.getOrganisationLocal(newOrganisation.getParentOrganisationSid());
                if (parent == null) {
                    log.error((Object)("Trying to update organisation " + currOrganisation.getSid() + ". Trying to set parent organisation " + newOrganisation.getParentOrganisationSid() + ", organisation not found."));
                    throw new UserManagementException("error.organisation.notfound");
                }
                currOrganisation.setParentOrganisation(parent);
                this.updateCachedOrgAddChildOrg(parent.getSid(), currOrganisation, adminUserId);
            }
            log.debug((Object)("Returning id" + currOrganisation.getSid()));
            return currOrganisation.getSid();
        }
        catch (CreateException e) {
            log.error((Object)"Exception occured", (Throwable)e);
            throw new EJBException((Exception)((Object)e));
        }
        catch (NamingException e) {
            log.error((Object)"Exception occured", (Throwable)e);
            throw new EJBException((Exception)e);
        }
    }

    private void updateMembership(OrganisationCompleteData newOrganisation, OrganisationLocal currOrganisation) throws UserManagementException {
        HashSet candidatesToRemove = new HashSet(currOrganisation.getMembership());
        if (log.isDebugEnabled()) {
            log.debug((Object)("addUsersToOrganisation: Before adding users, organisation has " + currOrganisation.getMembership().size() + " users"));
        }
        try {
            SortedMap users = newOrganisation.getUsers();
            if (users != null) {
                Iterator iter = users.keySet().iterator();
                while (iter.hasNext()) {
                    UserData user = (UserData)iter.next();
                    ShwaaUserLocal shwaaUser = this.getShwaaUserLocal(user.getSid());
                    if (user.getSid() == null || shwaaUser == null) {
                        log.error((Object)("updateMembership: updating membership for user but user not found. Unable to update. User was: " + user.toString()));
                        throw new UserManagementException("error.system");
                    }
                    UserMembershipData membershipData = (UserMembershipData)users.get(user);
                    OrganisationMembershipLocal membership = currOrganisation.updateMembership(shwaaUser, membershipData.getRight(), membershipData.isAccountHome());
                    candidatesToRemove.remove(membership);
                }
            }
        }
        catch (CreateException e) {
            log.error((Object)"Exception occured", (Throwable)e);
            throw new EJBException((Exception)((Object)e));
        }
        catch (NamingException e) {
            log.error((Object)"Exception occured", (Throwable)e);
            throw new EJBException((Exception)e);
        }
        log.debug((Object)"Cleaning up the untouched candidates");
        Iterator iter = candidatesToRemove.iterator();
        while (iter.hasNext()) {
            OrganisationMembershipLocal element = (OrganisationMembershipLocal)iter.next();
            this.removeUserMembership(element.getUser(), element.getOrganisation());
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("addUsersToOrganisation: After adding users, organisation has " + currOrganisation.getMembership().size() + " users"));
        }
    }

    private boolean removeUserMembership(ShwaaUserLocal user, OrganisationLocal org) throws UserManagementException {
        OrganisationMembershipLocal membershipEJB = null;
        Integer origRight = null;
        boolean homeAccount = false;
        Set memberships = org.getMembership();
        Iterator iter = memberships.iterator();
        while (membershipEJB == null && iter.hasNext()) {
            OrganisationMembershipLocal element = (OrganisationMembershipLocal)iter.next();
            if (!element.getUser().getUid().equals(user.getUid()) || !log.isDebugEnabled()) continue;
            log.debug((Object)("Found matching user, removing from organisation sid relationship" + element.getData().toString()));
            origRight = element.getRight();
            membershipEJB = element;
            homeAccount = element.getAccountHome();
            iter.remove();
        }
        if (membershipEJB != null) {
            log.debug((Object)"Now removing from user sid relationship");
            user.getMemberships().remove(membershipEJB);
            try {
                log.debug((Object)"Deleting the membership ejb");
                membershipEJB.remove();
            }
            catch (RemoveException e) {
                return false;
            }
        }
        if (homeAccount) {
            OrganisationLocal noneOrg = this.getOrganisationLocal(NONE_ORGANISATION_SID);
            if (noneOrg == null) {
                log.error((Object)("Removed user " + user.getLogin() + " from existing home account organisation but cannot attach to " + " None organisation as that organisation cannot be found"));
            } else {
                try {
                    noneOrg.updateMembership(user, origRight, true);
                }
                catch (NamingException e) {
                    log.error((Object)"Exception occured ", (Throwable)e);
                    throw new EJBException((Exception)e);
                }
                catch (CreateException e) {
                    log.error((Object)"Exception occured ", (Throwable)e);
                    throw new EJBException((Exception)((Object)e));
                }
            }
        }
        return true;
    }

    public boolean removeUserMembership(Long userId, Long organisationId, Long adminUserId) throws UserManagementException, UserManagementAuthorisationException {
        ShwaaUserLocal user;
        if (log.isDebugEnabled()) {
            log.debug((Object)("removeUserMembership: userId " + userId + " orgId " + organisationId));
        }
        if ((user = this.getShwaaUserLocal(userId)) == null) {
            throw new UserManagementException("error.user.notfound");
        }
        ShwaaUserLocal adminUser = this.getShwaaUserLocal(adminUserId);
        if (adminUser == null) {
            throw new UserManagementException("error.user.notfound");
        }
        OrganisationLocal org = this.getOrganisationLocal(organisationId);
        if (org == null) {
            log.debug((Object)("===>NULL with organisationId:" + organisationId));
        }
        OrganisationRights.checkModifyOrganisation(org, adminUser);
        boolean isSuccess = this.removeUserMembership(user, org);
        if (isSuccess) {
            this.updateCachedOrgRemoveMembership(organisationId, userId);
        }
        return isSuccess;
    }

    private void updateCachedOrgRemoveMembership(Long orgId, Long userId) {
        ServletContext context = WebApplicationContext.getInstance().getServletContext();
        OrganisationCompleteData data = (OrganisationCompleteData)context.getAttribute(ORG_PREFIX + orgId);
        if (data != null) {
            Iterator iter = data.getUsers().keySet().iterator();
            while (iter.hasNext()) {
                UserData userData = (UserData)iter.next();
                if (!userData.getSid().equals(userId)) continue;
                data.getUsers().remove(userData);
                break;
            }
            this.cacheOrganisation(orgId, data);
        }
    }

    private void updateCachedOrgAddChildOrg(Long orgId, OrganisationLocal child, Long userId) {
        ServletContext context = WebApplicationContext.getInstance().getServletContext();
        OrganisationCompleteData data = (OrganisationCompleteData)context.getAttribute(ORG_PREFIX + orgId);
        if (data != null) {
            data.getChildOrganisations().put(child.getSid(), child.getName());
            Integer right = child.getRight(userId);
            if (right != null) {
                data.getChildOrganisationRights().put(child.getSid(), right);
            }
            this.cacheOrganisation(orgId, data);
        }
    }

    private void updateCachedOrgSimpleUpdate(OrganisationCompleteData orgData) {
        ServletContext context = WebApplicationContext.getInstance().getServletContext();
        OrganisationCompleteData data = (OrganisationCompleteData)context.getAttribute(ORG_PREFIX + orgData.getSid());
        if (data != null) {
            data.setName(orgData.getName());
            data.setDescription(orgData.getDescription());
            this.cacheOrganisation(data.getSid(), data);
        }
    }

    private void updateCachedOrgUpdateUser(Long orgId, UserData userData) {
        ServletContext context = WebApplicationContext.getInstance().getServletContext();
        OrganisationCompleteData data = (OrganisationCompleteData)context.getAttribute(ORG_PREFIX + orgId);
        if (data != null) {
            Iterator iter = data.getUsers().keySet().iterator();
            while (iter.hasNext()) {
                UserData user = (UserData)iter.next();
                if (!user.getLogin().equals(userData.getLogin())) continue;
                UserMembershipData membership = (UserMembershipData)data.getUsers().get(user);
                data.getUsers().remove(user);
                data.getUsers().put(userData, membership);
                this.cacheOrganisation(orgId, data);
                break;
            }
        }
    }

    private void updateCachedOrgAddMembership(Long orgId, ShwaaUserLocal user, OrganisationLocal org, Integer right, boolean accountHome) {
        ServletContext context = WebApplicationContext.getInstance().getServletContext();
        OrganisationCompleteData data = (OrganisationCompleteData)context.getAttribute(ORG_PREFIX + orgId);
        if (data != null) {
            UserData userData = this.getCompleteUser(user);
            UserMembershipData memberData = new UserMembershipData(user, org, right, accountHome);
            Iterator iter = data.getUsers().keySet().iterator();
            boolean userExisted = false;
            UserData userExists = null;
            while (iter.hasNext()) {
                userExists = (UserData)iter.next();
                if (!userData.getLogin().equals(userExists.getLogin())) continue;
                userExisted = true;
                break;
            }
            if (userExisted) {
                data.getUsers().remove(userExists);
            }
            data.getUsers().put(userData, memberData);
            this.cacheOrganisation(orgId, data);
        }
    }

    public String deleteUser(Long organisationId, Long userId, Long adminUserId) throws UserManagementException, UserManagementAuthorisationException {
        ShwaaUserLocal user;
        String errorMessage = null;
        if (log.isDebugEnabled()) {
            log.debug((Object)("removeUserMembership: userId " + userId));
        }
        if ((user = this.getShwaaUserLocal(userId)) == null) {
            throw new UserManagementException("error.user.notfound");
        }
        ShwaaUserLocal adminUser = this.getShwaaUserLocal(adminUserId);
        if (adminUser == null) {
            throw new UserManagementException("error.user.notfound");
        }
        OrganisationRights.checkModifyOrganisation(this.getOrganisationLocal(organisationId), adminUser);
        Iterator iter = user.getMemberships().iterator();
        while (iter.hasNext()) {
            OrganisationMembershipLocal membership = (OrganisationMembershipLocal)iter.next();
            OrganisationLocal org = membership.getOrganisation();
            org.getMembership().remove(membership);
            iter.remove();
            try {
                log.debug((Object)"Deleting the membership ejb");
                membership.remove();
                this.updateCachedOrgRemoveMembership(org.getSid(), userId);
            }
            catch (RemoveException e) {
                errorMessage = e.getMessage();
                return errorMessage;
            }
        }
        try {
            user.remove();
        }
        catch (EJBException e) {
            errorMessage = e.getMessage();
        }
        catch (RemoveException e) {
            errorMessage = errorMessage != null ? errorMessage + e.getMessage() : e.getMessage();
        }
        return errorMessage;
    }

    public boolean deleteUser(String login) throws UserManagementException {
        ShwaaUserLocal user = this.getShwaaUserLocal(login);
        return this.deleteUser(user);
    }

    private boolean deleteUser(ShwaaUserLocal user) throws UserManagementException {
        log.debug((Object)("enter deleting user:" + user.getLogin()));
        if (user == null) {
            throw new UserManagementException("error.user.notfound");
        }
        if (user.getMemberships() != null) {
            Object[] memberships = user.getMemberships().toArray();
            log.debug((Object)"start loop on user's memberships");
            for (int i = 0; i < memberships.length; ++i) {
                OrganisationMembershipLocal membership = (OrganisationMembershipLocal)memberships[i];
                Long orgId = membership.getOrganisation().getSid();
                try {
                    log.debug((Object)("deleting membership:" + membership.getSid()));
                    membership.remove();
                    this.updateCachedOrgRemoveMembership(orgId, user.getUid());
                    continue;
                }
                catch (RemoveException e) {
                    return false;
                }
            }
        }
        try {
            log.debug((Object)("deleting user:" + user.getLogin()));
            user.remove();
            return true;
        }
        catch (EJBException e) {
            return false;
        }
        catch (RemoveException e) {
            return false;
        }
    }

    public Set getSessionOrganisations(Long userId) throws UserManagementException {
        OrganisationLocal org;
        log.debug((Object)("getSessionOrganisationsBelongedTo: userId " + userId));
        ShwaaUserLocal user = this.getShwaaUserLocal(userId);
        if (user == null) {
            throw new UserManagementException("error.user.notfound");
        }
        LinkedList<OrganisationLocal> allOrgSelect = new LinkedList<OrganisationLocal>();
        HashMap<Long, Integer> allOrgRights = new HashMap<Long, Integer>();
        Iterator iter = user.getMemberships().iterator();
        while (iter.hasNext()) {
            OrganisationMembershipLocal membership = (OrganisationMembershipLocal)iter.next();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Checking membership " + membership.getData().toString()));
            }
            if (membership.getOrganisation() == null) {
                log.warn((Object)("getAllOrganisations: Membership with no organisation. Skipping. " + membership.getData().toString()));
                continue;
            }
            org = membership.getOrganisation();
            if (org.getAccountOrganisation()) continue;
            allOrgSelect.add(org);
            allOrgRights.put(org.getSid(), membership.getRight());
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("All session organisations which user belongs to" + ((Object)allOrgSelect).toString()));
        }
        TreeSet<OrganisationRecursiveData> orgDatas = new TreeSet<OrganisationRecursiveData>(new OrganisationRecursiveDataComparator());
        while (allOrgSelect.size() > 0) {
            org = (OrganisationLocal)allOrgSelect.get(0);
            orgDatas.add(this.createRecursiveOrganisation(org, allOrgSelect, allOrgRights));
        }
        log.debug((Object)("getSessionOrganisationsBelongedTo: returning " + orgDatas));
        return orgDatas;
    }

    public OrganisationData[] getSessionOrganisationsLearner(Long userId) throws UserManagementException {
        log.debug((Object)("getSessionOrganisationsBelongedTo: userId " + userId));
        ShwaaUserLocal user = this.getShwaaUserLocal(userId);
        if (user == null) {
            throw new UserManagementException("error.user.notfound");
        }
        LinkedList<OrganisationLocal> allOrgSelect = new LinkedList<OrganisationLocal>();
        Iterator iter = user.getMemberships().iterator();
        while (iter.hasNext()) {
            OrganisationMembershipLocal membership = (OrganisationMembershipLocal)iter.next();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Checking membership " + membership.getData().toString()));
            }
            if (membership.getOrganisation() == null) {
                log.warn((Object)("getAllOrganisations: Membership with no organisation. Skipping. " + membership.getData().toString()));
                continue;
            }
            OrganisationLocal org = membership.getOrganisation();
            if (org.getAccountOrganisation()) continue;
            allOrgSelect.add(org);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("All session organisations which user belongs to" + ((Object)allOrgSelect).toString()));
        }
        OrganisationData[] orgDatas = new OrganisationData[allOrgSelect.size()];
        for (int iIndex = 0; iIndex < allOrgSelect.size(); ++iIndex) {
            OrganisationData org;
            OrganisationLocal child = (OrganisationLocal)allOrgSelect.get(iIndex);
            orgDatas[iIndex] = org = child.getData();
        }
        log.debug((Object)("getSessionOrganisationsBelongedTo: returning " + orgDatas));
        return orgDatas;
    }

    public Set getAllOrganisations(Long userId) throws UserManagementException {
        log.debug((Object)("getAllOrganisations: userId " + userId));
        ShwaaUserLocal user = this.getShwaaUserLocal(userId);
        if (user == null) {
            throw new UserManagementException("error.user.notfound");
        }
        LinkedList<OrganisationLocal> allOrgSelect = new LinkedList<OrganisationLocal>();
        HashMap<Long, Integer> allOrgRights = new HashMap<Long, Integer>();
        Iterator iter = user.getMemberships().iterator();
        while (iter.hasNext()) {
            OrganisationMembershipLocal membership = (OrganisationMembershipLocal)iter.next();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Checking membership " + membership.getData().toString()));
            }
            if (membership.getOrganisation() == null) {
                log.warn((Object)("getAllOrganisations: Membership with no organisation. Skipping. " + membership.getData().toString()));
                continue;
            }
            if (!OrganisationRights.canModify(membership.getRight()) && !OrganisationRights.canSelect(membership.getRight())) continue;
            allOrgSelect.add(membership.getOrganisation());
            allOrgRights.put(membership.getOrganisation().getSid(), membership.getRight());
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("All selectable organisations " + ((Object)allOrgSelect).toString()));
        }
        TreeSet<OrganisationRecursiveData> orgDatas = new TreeSet<OrganisationRecursiveData>(new OrganisationRecursiveDataComparator());
        while (allOrgSelect.size() > 0) {
            OrganisationLocal org = (OrganisationLocal)allOrgSelect.get(0);
            orgDatas.add(this.createRecursiveOrganisation(org, allOrgSelect, allOrgRights));
        }
        log.debug((Object)("getAllOrganisations: returning " + orgDatas));
        return orgDatas;
    }

    private OrganisationRecursiveData createRecursiveOrganisation(OrganisationLocal org, List allOrgSelect, Map allOrgRights) {
        Integer right;
        log.debug((Object)("OrganisationRecursiveData: org " + org.toString()));
        OrganisationRecursiveData[] childArray = null;
        if (org.getChildOrganisations() != null) {
            TreeSet<OrganisationRecursiveData> childOrgs = new TreeSet<OrganisationRecursiveData>(new OrganisationRecursiveDataComparator());
            Iterator iter = org.getChildOrganisations().iterator();
            while (iter.hasNext()) {
                OrganisationLocal child = (OrganisationLocal)iter.next();
                log.debug((Object)("Checking child " + child.toString() + " against known orgs"));
                if (!allOrgSelect.contains(child)) continue;
                log.debug((Object)"recursing....");
                OrganisationRecursiveData newChild = this.createRecursiveOrganisation(child, allOrgSelect, allOrgRights);
                childOrgs.add(newChild);
            }
            if (childOrgs.size() > 0) {
                childArray = childOrgs.toArray(new OrganisationRecursiveData[childOrgs.size()]);
            }
        }
        boolean readOnly = !OrganisationRights.canModify(right = (Integer)allOrgRights.get(org.getSid()));
        OrganisationRecursiveData data = new OrganisationRecursiveData(org.getSid(), org.getName(), org.getDescription(), org.getAccountOrganisation(), childArray, readOnly, right);
        allOrgSelect.remove(org);
        log.debug((Object)("Returning data " + data.toString()));
        return data;
    }

    public SortedSet getUsersFromOrganisation(Long orgId, Long adminUserId) throws UserManagementException, UserManagementAuthorisationException {
        log.debug((Object)("getUsersFromOrganisation id=" + orgId));
        return this.getUsersFromOrg(orgId, adminUserId, false);
    }

    public SortedSet getHomeUsersFromOrganisation(Long orgId, Long adminUserId) throws UserManagementException, UserManagementAuthorisationException {
        log.debug((Object)("getHomeUsersFromOrganisation id=" + orgId));
        return this.getUsersFromOrg(orgId, adminUserId, true);
    }

    private SortedSet getUsersFromOrg(Long orgId, Long adminUserId, boolean homeOnly) throws UserManagementException, UserManagementAuthorisationException {
        ShwaaUserLocal adminUser = this.getShwaaUserLocal(adminUserId);
        if (adminUser == null) {
            throw new UserManagementException("error.user.notfound");
        }
        OrganisationLocal org = OrganisationRights.checkRightsSelectOrganisation(orgId, adminUser);
        TreeSet<ShwaaUserData> users = new TreeSet<ShwaaUserData>(new LastNameAlphabeticComparator());
        Iterator iter = org.getMembership().iterator();
        while (iter.hasNext()) {
            OrganisationMembershipLocal element = (OrganisationMembershipLocal)iter.next();
            if (homeOnly && !element.getAccountHome()) continue;
            users.add(element.getUser().getData());
        }
        log.debug((Object)("Returning users" + users.toString()));
        return users;
    }

    public List getParentHierarchy(Long orgId, Long userId) throws UserManagementException {
        OrganisationLocal org = this.getOrganisationLocal(orgId);
        LinkedList<String> path = new LinkedList<String>();
        if (org != null) {
            path.add(0, org.getName());
            path.add(0, org.getSid().toString());
            while (org.getParentOrganisation() != null) {
                org = org.getParentOrganisation();
                path.add(0, org.getRightDescription(userId));
                path.add(0, org.getName());
                path.add(0, org.getSid().toString());
            }
        }
        log.debug((Object)("Returning " + path.toString()));
        return path;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cacheOrganisation(Long orgId, OrganisationCompleteData org) {
        ServletContext context;
        ServletContext servletContext = context = WebApplicationContext.getInstance().getServletContext();
        synchronized (servletContext) {
            context.setAttribute(ORG_PREFIX + orgId, (Object)org);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void invalidateCachedOrganisation(Long orgId) {
        ServletContext context;
        ServletContext servletContext = context = WebApplicationContext.getInstance().getServletContext();
        synchronized (servletContext) {
            context.removeAttribute(ORG_PREFIX + orgId);
        }
    }

    public boolean deleteOrganisation(long sid, boolean recursive, boolean rebuildTree) {
        try {
            OrganisationLocal parentOrg;
            int i;
            log.debug((Object)("deleting Organisation:" + sid));
            OrganisationLocal org = this.getOrganisationLocal(new Long(sid));
            if (recursive) {
                if (org.getChildOrganisations() != null && org.getChildOrganisations().size() > 0) {
                    Object[] childOrgs = org.getChildOrganisations().toArray();
                    for (i = 0; i < childOrgs.length; ++i) {
                        OrganisationLocal childOrg = (OrganisationLocal)childOrgs[i];
                        this.deleteOrganisation(childOrg.getSid(), recursive, rebuildTree);
                    }
                }
            } else if (rebuildTree && (parentOrg = org.getParentOrganisation()) != null && org.getChildOrganisations() != null && org.getChildOrganisations().size() > 0) {
                Object[] childOrgs = org.getChildOrganisations().toArray();
                for (int i2 = 0; i2 < childOrgs.length; ++i2) {
                    OrganisationLocal childOrg = (OrganisationLocal)childOrgs[i2];
                    childOrg.setParentOrganisation(parentOrg);
                    this.invalidateCachedOrganisation(childOrg.getSid());
                }
            }
            if (org.getMembership() != null && org.getMembership().size() > 0) {
                Object[] memberships = org.getMembership().toArray();
                for (i = 0; i < memberships.length; ++i) {
                    OrganisationMembershipLocal membership = (OrganisationMembershipLocal)memberships[i];
                    if (!membership.getAccountHome()) continue;
                    this.deleteUser(membership.getUser());
                }
            }
            if (org.getParentOrganisation() != null) {
                this.invalidateCachedOrganisation(org.getParentOrganisation().getSid());
            }
            this.invalidateCachedOrganisation(org.getSid());
            org.remove();
            return true;
        }
        catch (Exception e) {
            log.debug((Object)("Exception occured: " + e.getMessage()));
            return false;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

