/*
 * Decompiled with CFR 0.152.
 */
package com.webmcq.ld.tool.voterank;

import com.webmcq.ld.activities.AbstractTaskVO;
import com.webmcq.ld.activities.SimpleTaskVO;
import com.webmcq.ld.content.Content;
import com.webmcq.ld.content.VotingContent;
import com.webmcq.ld.content.VotingContentNomination;
import com.webmcq.ld.content.interfaces.ContentRepositoryLocal;
import com.webmcq.ld.content.interfaces.ContentRepositoryUtil;
import com.webmcq.ld.controller.ControllerException;
import com.webmcq.ld.controller.DisplayTaskData;
import com.webmcq.ld.controller.LearningSession;
import com.webmcq.ld.controller.TaskInstance;
import com.webmcq.ld.controller.dao.TaskInstanceNotFoundException;
import com.webmcq.ld.controller.dto.GroupData;
import com.webmcq.ld.controller.dto.TaskInstanceData;
import com.webmcq.ld.service.ContentServiceDelegate;
import com.webmcq.ld.service.ControllerServiceDelegate;
import com.webmcq.ld.service.LearnerServiceDelegate;
import com.webmcq.ld.service.UserNotFoundException;
import com.webmcq.ld.tool.StaffMonitorNotifier;
import com.webmcq.ld.tool.ToolException;
import com.webmcq.ld.tool.voterank.PollContentBean;
import com.webmcq.ld.tool.voterank.VoteRankException;
import com.webmcq.ld.tool.voterank.dto.AllVoteData;
import com.webmcq.ld.tool.voterank.dto.PollContentNominationResultsData;
import com.webmcq.ld.tool.voterank.dto.PollDTOFactory;
import com.webmcq.ld.tool.voterank.interfaces.PollContentLocal;
import com.webmcq.ld.tool.voterank.interfaces.PollContentUtil;
import com.webmcq.ld.tool.voterank.interfaces.PollNominationData;
import com.webmcq.ld.tool.voterank.interfaces.PollNominationLocal;
import com.webmcq.ld.tool.voterank.interfaces.PollNominationPK;
import com.webmcq.ld.tool.voterank.interfaces.PollNominationUtil;
import com.webmcq.ld.tool.voterank.interfaces.VoteLocal;
import com.webmcq.ld.tool.voterank.interfaces.VoteUtil;
import com.webmcq.ld.tool.voterank.web.VoteRankAction;
import com.webmcq.ld.util.BaseSessionBean;
import com.webmcq.ld.util.EJBUtil;
import com.webmcq.ld.util.WebUtil;
import com.webmcq.ld.util.exception.SystemException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.ejb.CreateException;
import javax.ejb.EJBException;
import javax.ejb.FinderException;
import javax.naming.NamingException;
import org.apache.log4j.Logger;

public abstract class VoteRankServiceBean
extends BaseSessionBean {
    private static Logger log = Logger.getLogger((Class)(class$com$webmcq$ld$tool$voterank$VoteRankServiceBean == null ? (class$com$webmcq$ld$tool$voterank$VoteRankServiceBean = VoteRankServiceBean.class$("com.webmcq.ld.tool.voterank.VoteRankServiceBean")) : class$com$webmcq$ld$tool$voterank$VoteRankServiceBean));
    static /* synthetic */ Class class$com$webmcq$ld$tool$voterank$VoteRankServiceBean;

    private PollContentLocal getPollContentLocal(int taskInstanceId) throws FinderException {
        PollContentLocal pollData = null;
        try {
            Collection entries = PollContentUtil.getLocalHome().findByTaskInstanceId(taskInstanceId);
            pollData = (PollContentLocal)EJBUtil.findSingle(entries);
        }
        catch (NamingException e) {
            log.error((Object)"Naming exception thrown trying to get the poll content", (Throwable)e);
            throw new EJBException((Exception)e);
        }
        return pollData;
    }

    public void createSession(AbstractTaskVO task, TaskInstanceData taskInstance, GroupData group, String outputContentDestination, Long inputContentId, Long outputContentId) throws ToolException, SystemException {
        try {
            this.createSession((SimpleTaskVO)task, taskInstance, group, outputContentId);
            if (inputContentId != null) {
                Content content = ContentServiceDelegate.getContent(inputContentId);
                this.setContent((int)taskInstance.getSid(), content);
            }
            this.sendContent((int)taskInstance.getSid());
            this.notifyVotesReceived(taskInstance.getSid(), taskInstance.getTitle());
        }
        catch (ControllerException e) {
            this.getSessionContext().setRollbackOnly();
            log.error((Object)("Unable to create session, task=" + (task != null ? task.toString() : "null") + "; taskInstance =" + (taskInstance != null ? taskInstance.toString() : "null")), (Throwable)e);
            throw new ToolException(e);
        }
        catch (Exception e) {
            this.getSessionContext().setRollbackOnly();
            log.error((Object)("Unable to create session, task=" + (task != null ? task.toString() : "null") + "; taskInstance =" + (taskInstance != null ? taskInstance.toString() : "null")), (Throwable)e);
            throw new SystemException(e);
        }
    }

    private void notifyVotesReceived(long taskInstanceId, String title) throws SystemException {
        try {
            String toolpath = "/tool/voterank/voterank.do?method=getAllVotes&sessionId=" + taskInstanceId;
            StaffMonitorNotifier.notifyControllerOfURL(taskInstanceId, "ranking", title, toolpath);
        }
        catch (ControllerException e) {
            throw new SystemException(e);
        }
    }

    private void createSession(SimpleTaskVO task, TaskInstanceData instance, GroupData group, Long outputContentId) {
        try {
            PollContentLocal pollData = this.getPollContentLocal((int)instance.getSid());
            if (pollData != null) {
                log.warn((Object)("Session for task instance " + instance.toString() + " already exists. Not creating a new set of poll data."));
            } else {
                pollData = PollContentUtil.getLocalHome().create();
                pollData.setTaskInstanceId(instance.getSid());
                pollData.setOutputContentId(outputContentId);
                if (group == null) {
                    log.error((Object)"createSession: no initial group. Setting up poll with no voters");
                } else {
                    this.updateNumberOfVoters(pollData, group);
                }
                log.debug((Object)("Created pollContent with task instance id" + pollData.getTaskInstanceId()));
            }
        }
        catch (NamingException e) {
            throw new EJBException((Exception)e);
        }
        catch (FinderException e) {
            throw new EJBException((Exception)((Object)e));
        }
        catch (CreateException e) {
            throw new EJBException((Exception)((Object)e));
        }
    }

    private GroupData refreshGroupData(PollContentLocal pollInfo) throws SystemException {
        if (pollInfo == null) {
            log.error((Object)"refreshGroupData: Unable to refresh group information as pollInfo is null");
            return null;
        }
        GroupData group = null;
        try {
            group = ControllerServiceDelegate.getTaskGroup(pollInfo.getTaskInstanceId());
            if (group != null) {
                this.updateNumberOfVoters(pollInfo, group);
            } else {
                log.error((Object)"refreshGroupData: call to ControllerServiceDelegate.getTaskGroup(taskInstanceId) returned null");
            }
        }
        catch (UserNotFoundException e) {
            log.error((Object)"refreshGroupData: call to ControllerServiceDelegate.getTaskGroup threw exception.", (Throwable)e);
        }
        catch (ControllerException e) {
            log.error((Object)("refreshGroupData: call to ControllerServiceDelegate.getTaskGroup threw exception. Not updating poll " + pollInfo.getTaskInstanceId()), (Throwable)e);
        }
        return group;
    }

    private void updateNumberOfVoters(PollContentLocal pollInfo, GroupData group) {
        if (group != null && pollInfo != null) {
            int numVoters = group.getMembers().keySet().size();
            pollInfo.setNumVoters(numVoters);
            log.debug((Object)("updateNumberOfVoters: poll " + pollInfo.getSid() + " set number of voters to " + numVoters));
        }
    }

    private boolean isUserInGroup(long userId, GroupData group) {
        if (group != null) {
            Set groupUserIds = group.getMembers().keySet();
            return groupUserIds.contains(new Long(userId));
        }
        log.error((Object)"isUserInGroup: Group is null, hence no users in group");
        return false;
    }

    public PollContentNominationResultsData getInfoNomineesByTaskInstance(int taskInstanceId) {
        try {
            PollContentLocal entry = this.getPollContentLocal(taskInstanceId);
            if (entry != null) {
                return PollDTOFactory.getNominations(entry);
            }
        }
        catch (FinderException e) {
            log.error((Object)("Unable to find vote ranking data, taskInstanceId " + taskInstanceId));
            throw new EJBException((Exception)((Object)e));
        }
        return null;
    }

    public PollNominationData[] getNomineesData(int taskInstanceId) {
        try {
            PollContentLocal entry = this.getPollContentLocal(taskInstanceId);
            PollNominationData[] nomineData = null;
            if (entry != null) {
                nomineData = new PollNominationData[entry.getNominations().size()];
                Iterator itr = entry.getNominations().iterator();
                int i = 0;
                while (itr.hasNext()) {
                    PollNominationLocal nomination = (PollNominationLocal)itr.next();
                    nomineData[i] = nomination.getData();
                    ++i;
                }
            }
            return nomineData;
        }
        catch (FinderException e) {
            log.error((Object)("Unable to find vote ranking data, taskInstanceId " + taskInstanceId));
            throw new EJBException((Exception)((Object)e));
        }
    }

    public PollContentNominationResultsData getInfoResultsByTaskInstance(int taskInstanceId) {
        try {
            PollContentLocal entry = this.getPollContentLocal(taskInstanceId);
            if (entry != null) {
                return PollDTOFactory.getSummaryResultsData(entry);
            }
        }
        catch (FinderException e) {
            log.error((Object)("Unable to find vote ranking data, taskInstanceId " + taskInstanceId));
            throw new EJBException((Exception)((Object)e));
        }
        return null;
    }

    public PollContentNominationResultsData getInfoVotesByVoter(int taskInstanceId, long userId) {
        try {
            PollContentLocal entry = this.getPollContentLocal(taskInstanceId);
            if (entry != null) {
                return PollDTOFactory.getIndividualResultsData(userId, entry);
            }
        }
        catch (FinderException e) {
            log.error((Object)("Unable to find vote ranking data, taskInstanceId " + taskInstanceId));
            throw new EJBException((Exception)((Object)e));
        }
        return null;
    }

    public AllVoteData getAllVotes(int taskInstanceId, long curLearningSessionId) {
        try {
            HashMap cachedUserForLearningSession = LearningSession.getInstance().getLearningSessionUsers(String.valueOf(curLearningSessionId));
            PollContentLocal entry = this.getPollContentLocal(taskInstanceId);
            if (entry != null) {
                return PollDTOFactory.getAllIndividualResultsData(entry, cachedUserForLearningSession);
            }
        }
        catch (FinderException e) {
            log.error((Object)("Unable to find vote ranking data, taskInstanceId " + taskInstanceId));
            throw new EJBException((Exception)((Object)e));
        }
        return null;
    }

    public PollContentLocal validateSession(long userId, int taskInstanceId) throws VoteRankException {
        try {
            Object displayTaskData = null;
            PollContentLocal entry = this.getPollContentLocal(taskInstanceId);
            if (entry == null) {
                throw new VoteRankException("no such session found: id=" + taskInstanceId + " user id=" + userId);
            }
            return entry;
        }
        catch (FinderException e) {
            log.error((Object)("Unable to find vote ranking data, taskInstanceId " + taskInstanceId));
            throw new EJBException((Exception)((Object)e));
        }
    }

    public DisplayTaskData completeSession(long userId, int taskInstanceId) throws VoteRankException {
        try {
            DisplayTaskData displayTaskData = null;
            PollContentLocal entry = this.getPollContentLocal(taskInstanceId);
            if (entry == null) {
                throw new VoteRankException("no such session found: id=" + taskInstanceId + " user id=" + userId);
            }
            displayTaskData = LearnerServiceDelegate.moveToNextTask(taskInstanceId, userId);
            return displayTaskData;
        }
        catch (FinderException e) {
            log.error((Object)("Unable to find vote ranking data, taskInstanceId " + taskInstanceId));
            throw new EJBException((Exception)((Object)e));
        }
        catch (TaskInstanceNotFoundException e) {
            throw new VoteRankException("Task Instance not found: " + taskInstanceId, e);
        }
        catch (ControllerException e) {
            throw new VoteRankException("Controller reported an error", e);
        }
        catch (SystemException e) {
            throw e;
        }
    }

    private void setContent(int taskInstanceId, Content content) {
        try {
            PollContentLocal pollData = this.getPollContentLocal(taskInstanceId);
            if (pollData == null) {
                log.debug((Object)("setContent: no poll information found '" + taskInstanceId + "'"));
            } else {
                pollData.setTitle(content.getTitle());
                pollData.setContent(content.getBody());
                pollData.setDescription(content.getDescription());
                pollData.setDefineLater(content.isDefineLater());
                if ("voting".equals(content.theContentType())) {
                    VotingContent vcontent = (VotingContent)content;
                    pollData.setMaxToChoose(vcontent.getMaxToChoose());
                    pollData.setVoteMethod(vcontent.getVoteMethod());
                    pollData.setAllowPollNominations(vcontent.isAllowPollNominations());
                    pollData.setProgressiveDisplay(vcontent.isProgressiveDisplay());
                    if (vcontent.getNominations() != null) {
                        Iterator iter = vcontent.getNominations().iterator();
                        while (iter.hasNext()) {
                            PollNominationLocal nom = PollNominationUtil.getLocalHome().create();
                            Object obj = iter.next();
                            VotingContentNomination inputNom = (VotingContentNomination)obj;
                            nom.setText(inputNom.getNomination());
                            pollData.addNomination(nom);
                        }
                    }
                } else {
                    pollData.setMaxToChoose(-1);
                    pollData.setVoteMethod("equal");
                    pollData.setAllowPollNominations(true);
                }
            }
        }
        catch (CreateException e) {
            throw new EJBException((Exception)((Object)e));
        }
        catch (NamingException e) {
            throw new EJBException((Exception)e);
        }
        catch (FinderException e) {
            log.debug((Object)("setContent: no poll information found '" + taskInstanceId + "'"), (Throwable)e);
            throw new EJBException((Exception)((Object)e));
        }
    }

    public void putVote(int taskInstanceId, long userId, Set votes) throws VoteRankException {
        try {
            PollContentLocal pollInfo = this.getPollContentLocal(taskInstanceId);
            if (log.isDebugEnabled()) {
                log.debug((Object)("in putVote, number voters " + pollInfo.getNumVoters() + " already votedvoters remaining is " + pollInfo.getNumVotersVoted()));
            }
            GroupData group = this.refreshGroupData(pollInfo);
            Collection entries = pollInfo.getIndividualVotes(userId);
            if (entries != null && entries.size() > 0) {
                log.error((Object)("Task Instance " + taskInstanceId + " Learner " + userId + " is trying to revote. New votes are " + votes + ". Probably occured due to doing page refresh. New votes are being ignored"));
            } else {
                if (pollInfo.getCompletionStatus() == PollContentBean.COMPLETE) {
                    log.error((Object)("Received votes for poll after poll complete. New votes ignored. Poll Info " + pollInfo.getData().toString() + " userId " + userId + ". Throwing exception."));
                    throw new VoteRankException("Received votes for poll after poll complete. Votes ignored.");
                }
                pollInfo.setNumVotersVoted(pollInfo.getNumVotersVoted() + 1);
                Iterator voteIter = votes.iterator();
                while (voteIter.hasNext()) {
                    VoteLocal vote = VoteUtil.getLocalHome().create((String)voteIter.next(), false);
                    vote.setVoteValue(1L);
                    vote.setUserId(userId);
                    pollInfo.addIndividualVote(vote);
                }
            }
        }
        catch (CreateException e) {
            log.error((Object)("putVote: exception occured taskInstanceId=" + taskInstanceId + " userId=" + userId), (Throwable)e);
            throw new EJBException((Exception)((Object)e));
        }
        catch (NamingException e) {
            log.error((Object)("putVote: exception occured taskInstanceId=" + taskInstanceId + " userId=" + userId), (Throwable)e);
            throw new EJBException((Exception)e);
        }
        catch (FinderException e) {
            log.error((Object)("putVote: Unable to find vote ranking data taskInstanceId=" + taskInstanceId + " userId=" + userId), (Throwable)e);
            throw new EJBException((Exception)((Object)e));
        }
    }

    public boolean isVoteEndedOrHasVoted(long userId, int taskInstanceId) {
        try {
            boolean isVoteEnded = true;
            boolean hasVoted = false;
            PollContentLocal pollInfo = this.getPollContentLocal(taskInstanceId);
            if (pollInfo != null) {
                Collection votes;
                boolean bl = isVoteEnded = pollInfo.getCompletionStatus() == PollContentBean.COMPLETE;
                if (!isVoteEnded && (votes = pollInfo.getIndividualVotes(userId)) != null && votes.size() > 0) {
                    hasVoted = true;
                }
            }
            return isVoteEnded || hasVoted;
        }
        catch (FinderException e) {
            log.error((Object)("Unable to find vote ranking data, taskInstanceId " + taskInstanceId));
            throw new EJBException((Exception)((Object)e));
        }
    }

    public boolean isVoteEnded(int taskInstanceId) {
        try {
            PollContentLocal pollInfo = this.getPollContentLocal(taskInstanceId);
            if (pollInfo != null) {
                return pollInfo.getCompletionStatus() == PollContentBean.COMPLETE;
            }
            return true;
        }
        catch (FinderException e) {
            log.error((Object)("Unable to find vote ranking data, taskInstanceId " + taskInstanceId));
            throw new EJBException((Exception)((Object)e));
        }
    }

    public void markVoteEnded(int taskInstanceId) {
        try {
            PollContentLocal pollInfo = this.getPollContentLocal(taskInstanceId);
            this.markVoteEnded(pollInfo);
        }
        catch (FinderException e) {
            log.error((Object)("Unable to find vote ranking data, taskInstanceId " + taskInstanceId));
            throw new EJBException((Exception)((Object)e));
        }
    }

    public void markVoteEnded(PollContentLocal pollInfo) {
        if (pollInfo != null) {
            pollInfo.setCompletionComplete();
        }
    }

    public boolean hasVoted(long userId, int taskInstanceId) {
        try {
            Collection votes;
            PollContentLocal pollInfo = this.getPollContentLocal(taskInstanceId);
            if (pollInfo != null && (votes = pollInfo.getIndividualVotes(userId)) != null && votes.size() > 0) {
                return true;
            }
        }
        catch (FinderException e) {
            log.error((Object)("Unable to find vote ranking data, taskInstanceId " + taskInstanceId));
            throw new EJBException((Exception)((Object)e));
        }
        return false;
    }

    public void updatePollingDefineLater(boolean defineLater, int taskInstanceId) {
        try {
            PollContentLocal pollInfo = this.getPollContentLocal(taskInstanceId);
            if (pollInfo != null) {
                pollInfo.setDefineLater(new Boolean(defineLater));
            }
        }
        catch (FinderException e) {
            log.error((Object)("Unable to find vote ranking data, taskInstanceId " + taskInstanceId));
            throw new EJBException((Exception)((Object)e));
        }
    }

    public VotingContent createOutputContent(PollContentLocal pollData) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Creating output content for pollData" + (pollData != null ? pollData.toString() : "null")));
        }
        VotingContent outputContent = new VotingContent(null);
        if (pollData == null) {
            log.warn((Object)"createOutputContent: no poll information supplied '");
            outputContent.setBaseContentSid(null);
            outputContent.setAllowPollNominations(false);
            outputContent.setCreationTool("ranking");
            outputContent.setCreatorUserId(-1L);
            outputContent.setDescription("Input details lost");
            outputContent.setMaxToChoose(-1);
            outputContent.setTitle("Poll Information Missing");
        } else {
            outputContent.setBaseContentSid(pollData.getOutputContentId());
            outputContent.setAllowPollNominations(pollData.getAllowPollNominations());
            outputContent.setCreationTool("ranking");
            outputContent.setCreatorUserId(-1L);
            outputContent.setDescription(pollData.getDescription());
            outputContent.setMaxToChoose(pollData.getMaxToChoose());
            outputContent.setTitle(pollData.getTitle());
            String resultsURL = WebUtil.buildToolResultsUrl(VoteRankAction.VOTERANK_PATH, "getAllResults", pollData.getTaskInstanceId(), VoteRankAction.SHOW_VOTES_ONLY + "=true");
            outputContent.setBodyURL(resultsURL);
            Collection coll = pollData.getSummaryVotes();
            Iterator iter = coll.iterator();
            StringBuffer description = new StringBuffer(2000);
            if (outputContent.getNominations() == null) {
                outputContent.setNominations(new HashSet());
            }
            while (iter.hasNext()) {
                VoteLocal vote = (VoteLocal)iter.next();
                description.append(vote.getNomination());
                description.append("\t");
                description.append(vote.getNumVotes());
                description.append(" votes\n");
                VotingContentNomination outputNomination = new VotingContentNomination();
                outputNomination.setNomination(vote.getNomination());
                outputNomination.setNumberVotes(vote.getVoteValue());
                if (pollData.isPrePollNomination(vote.getNomination())) {
                    outputNomination.setWhenNominated("PREPOLL");
                } else {
                    outputNomination.setWhenNominated("POLL");
                }
                outputContent.getNominations().add(outputNomination);
            }
            outputContent.setBody(description.toString());
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("set output content to " + outputContent.toString()));
        }
        return outputContent;
    }

    private void sendContent(int taskInstanceId) {
        log.debug((Object)("Sending content for taskInstanceId: " + taskInstanceId));
        try {
            Long contentId;
            PollContentLocal pollData = this.getPollContentLocal(taskInstanceId);
            if (pollData != null && (contentId = pollData.getOutputContentId()) != null) {
                ContentRepositoryLocal repo = ContentRepositoryUtil.getLocalHome().create();
                VotingContent content = this.createOutputContent(pollData);
                log.debug((Object)("Saving content in repository with contentId " + contentId));
                repo.setContent(contentId, content);
            }
        }
        catch (FinderException e) {
            log.error((Object)("Unable to find vote ranking data, taskInstanceId " + taskInstanceId));
            throw new EJBException((Exception)((Object)e));
        }
        catch (ControllerException e) {
            throw new EJBException((Exception)e);
        }
        catch (NamingException e) {
            throw new EJBException((Exception)e);
        }
        catch (CreateException e) {
            throw new EJBException((Exception)((Object)e));
        }
        log.error((Object)("sendContent: no poll information information found '" + taskInstanceId + "'"));
    }

    public void insertNomination(int taskInstanceId, String newNomination) throws VoteRankException {
        try {
            PollContentLocal pollData = this.getPollContentLocal(taskInstanceId);
            if (pollData == null) {
                log.error((Object)"");
                throw new VoteRankException("");
            }
            PollNominationLocal nomination = PollNominationUtil.getLocalHome().create();
            nomination.setText(newNomination);
            pollData.addNomination(nomination);
        }
        catch (FinderException e) {
            throw new VoteRankException(e);
        }
        catch (CreateException e) {
            throw new VoteRankException(e);
        }
        catch (NamingException e) {
            throw new VoteRankException(e);
        }
    }

    public void removeNomination(int taskInstanceId, int nominationId) throws VoteRankException {
        try {
            PollContentLocal pollData = this.getPollContentLocal(taskInstanceId);
            if (pollData == null) {
                log.error((Object)"");
                throw new VoteRankException("");
            }
            PollNominationPK pk = new PollNominationPK(nominationId);
            PollNominationLocal nomination = PollNominationUtil.getLocalHome().findByPrimaryKey(pk);
            pollData.removeNomination(nomination);
        }
        catch (FinderException e) {
            throw new VoteRankException(e);
        }
        catch (NamingException e) {
            throw new VoteRankException(e);
        }
    }

    public void deleteSession(TaskInstance taskInstance, Long inputContentId, Long outputContentId) throws ToolException, SystemException {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

