/*
 * Decompiled with CFR 0.152.
 */
package com.webmcq.ld.tool.survey.entity;

import com.webmcq.ld.tool.survey.entity.SurCandidateAnswerVO;
import com.webmcq.ld.tool.survey.entity.SurQuestionUsersVO;
import com.webmcq.ld.tool.survey.entity.SurSurveyVO;
import com.webmcq.ld.tool.survey.entity.SurUserResponseVO;
import com.webmcq.ld.util.exception.SystemException;
import java.io.Serializable;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.labels.PieSectionLabelGenerator;
import org.jfree.chart.labels.StandardPieItemLabelGenerator;
import org.jfree.chart.plot.PiePlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.DefaultCategoryDataset;
import org.jfree.data.general.DefaultPieDataset;
import org.jfree.data.general.PieDataset;

public class SurQuestionVO
implements Serializable,
Comparable {
    private Long questionId;
    private String question;
    private int isTextboxEnabled;
    private int isOptional;
    private String questionType;
    private int displayOrder;
    private SurSurveyVO survey;
    private Set surCandidateAnswers;
    private Set responses;
    private Set questionUsers;
    private String[] userResponses = new String[0];
    private String otherResponse;
    private int numberOfOpenRes;
    private int totalNumOfRes;
    private int totalNumOfQuestionUsers;
    private Set answerIndex = new TreeSet();

    public SurQuestionVO(String question, int isTextboxEnabled, String questionType, int displayOrder, SurSurveyVO survey, Set surCandidateAnswers, Set responses) {
        this.question = question;
        this.isTextboxEnabled = isTextboxEnabled;
        this.questionType = questionType;
        this.displayOrder = displayOrder;
        this.survey = survey;
        this.surCandidateAnswers = surCandidateAnswers;
        this.responses = responses;
    }

    public SurQuestionVO() {
    }

    public SurQuestionVO(SurSurveyVO survey, Set surCandidateAnswers, Set surAnswers) {
        this.survey = survey;
        this.surCandidateAnswers = surCandidateAnswers;
        this.responses = surAnswers;
    }

    public Long getQuestionId() {
        return this.questionId;
    }

    public void setQuestionId(Long questionId) {
        this.questionId = questionId;
    }

    public String getQuestion() {
        return this.question;
    }

    public void setQuestion(String question) {
        this.question = question;
    }

    public int getIsTextboxEnabled() {
        return this.isTextboxEnabled;
    }

    public void setIsTextboxEnabled(int isTextboxEnabled) {
        this.isTextboxEnabled = isTextboxEnabled;
    }

    public int getIsOptional() {
        return this.isOptional;
    }

    public void setIsOptional(int isOptional) {
        this.isOptional = isOptional;
    }

    public String getQuestionType() {
        return this.questionType;
    }

    public void setQuestionType(String questionType) {
        this.questionType = questionType;
    }

    public int getDisplayOrder() {
        return this.displayOrder;
    }

    public void setDisplayOrder(int displayOrder) {
        this.displayOrder = displayOrder;
    }

    public SurSurveyVO getSurvey() {
        return this.survey;
    }

    public void setSurvey(SurSurveyVO survey) {
        this.survey = survey;
    }

    public Set getSurCandidateAnswers() {
        if (this.surCandidateAnswers == null) {
            this.setSurCandidateAnswers(new TreeSet());
        }
        return this.surCandidateAnswers;
    }

    public void setSurCandidateAnswers(Set surCandidateAnswers) {
        this.surCandidateAnswers = surCandidateAnswers;
    }

    public Set getResponses() {
        if (this.responses == null) {
            this.setResponses(new TreeSet());
        }
        return this.responses;
    }

    public void setResponses(Set responses) {
        this.responses = responses;
    }

    public Set getQuestionUsers() {
        return this.questionUsers;
    }

    public void setQuestionUsers(Set questionUsers) {
        this.questionUsers = questionUsers;
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("sid", (Object)this.getQuestionId()).toString();
    }

    public boolean equals(Object other) {
        if (!(other instanceof SurQuestionVO)) {
            return false;
        }
        SurQuestionVO castOther = (SurQuestionVO)other;
        return new EqualsBuilder().append((Object)this.getQuestionId(), (Object)castOther.getQuestionId()).append((Object)this.getQuestion(), (Object)castOther.getQuestion()).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.getQuestionId()).append((Object)this.getQuestion()).toHashCode();
    }

    public int compareTo(Object o) {
        SurQuestionVO question = (SurQuestionVO)o;
        return this.displayOrder - question.displayOrder;
    }

    public String[] getUserResponses() {
        return this.userResponses;
    }

    public void setUserResponses(String[] userResponse) {
        this.userResponses = userResponse;
    }

    public String getOtherResponse() {
        return this.otherResponse == null ? null : this.otherResponse.trim();
    }

    public void setOtherResponse(String otherResponse) {
        this.otherResponse = otherResponse;
    }

    public int getNumberOfOpenRes() {
        int numOfOpRes = 0;
        Iterator i = this.surCandidateAnswers.iterator();
        while (i.hasNext()) {
            SurCandidateAnswerVO curCAnswer = (SurCandidateAnswerVO)i.next();
            if (curCAnswer.getDisplayOrder() != -1) continue;
            numOfOpRes += curCAnswer.getNumberOfResponse();
        }
        this.numberOfOpenRes = numOfOpRes;
        return this.numberOfOpenRes;
    }

    public ArrayList getUserResponsesAsList(long userId, String username) {
        if (!this.isResponseAvailable() && this.getIsOptional() == 0) {
            throw new SystemException("Can't create user response object for compulsory question without response information");
        }
        ArrayList<SurUserResponseVO> responses = new ArrayList<SurUserResponseVO>();
        for (int i = 0; i < this.userResponses.length; ++i) {
            if (this.userResponses[i].trim().equals("")) continue;
            responses.add(new SurUserResponseVO(this.userResponses[i].trim(), new Date(System.currentTimeMillis()), this));
        }
        if (this.otherResponse != null && !this.otherResponse.trim().equals("")) {
            responses.add(new SurUserResponseVO(this.otherResponse, new Date(System.currentTimeMillis()), this));
        }
        return responses;
    }

    private boolean isResponseAvailable() {
        if (this.getUserResponses().length == 0 && this.getOtherResponse() == null) {
            return false;
        }
        return this.getUserResponses().length != 0 || !this.getOtherResponse().equals("");
    }

    public int getTotalNumOfRes() {
        return this.responses.size();
    }

    public int getTotalNumOfQuestionUsers() {
        return this.getQuestionUsers().size();
    }

    public String getXLSCandidateAnswerString() {
        StringBuffer sb = new StringBuffer();
        sb.append("Question:\t" + this.getQuestion() + "\n").append("Possible Answers:\n");
        int index = 1;
        Iterator i = this.getSurCandidateAnswers().iterator();
        while (i.hasNext()) {
            SurCandidateAnswerVO answer = (SurCandidateAnswerVO)i.next();
            if (answer.getDisplayOrder() == -1) continue;
            sb.append("a" + index + "\t" + answer.getAnswerEntry() + "\n");
            this.setAnswerIndex("a" + index);
            ++index;
        }
        if (this.getQuestionType().trim().equals("textEntry") || this.getIsTextboxEnabled() != 0) {
            sb.append("a" + index + "\t" + "Open response" + "\n");
            this.setAnswerIndex("a" + index);
        }
        return sb.toString();
    }

    public String getXLSQuestionUserString() {
        StringBuffer sb = new StringBuffer();
        sb.append("Student\t");
        Iterator i = this.getAnswerIndex().iterator();
        while (i.hasNext()) {
            sb.append((String)i.next() + " \t");
        }
        sb.append(" \n");
        i = this.getQuestionUsers().iterator();
        while (i.hasNext()) {
            SurQuestionUsersVO qUser = (SurQuestionUsersVO)i.next();
            sb.append(qUser.getUsername() + " \t");
            Iterator j = this.getSurCandidateAnswers().iterator();
            while (j.hasNext()) {
                SurCandidateAnswerVO answer = (SurCandidateAnswerVO)j.next();
                if (answer.getDisplayOrder() != -1) {
                    if (qUser.isChosenByUser(answer.getAnswerEntry())) {
                        sb.append("x \t");
                    } else {
                        sb.append(" \t");
                    }
                }
                if (answer.getDisplayOrder() != -1 || !qUser.isChosenByUser(answer.getAnswerEntry())) continue;
                sb.append(answer.getAnswerEntry());
            }
            sb.append("\n");
            if (!this.getQuestionType().trim().equals("textEntry")) continue;
            sb.append(qUser.getTextEntry() + " \n");
        }
        sb.append("Totals\t");
        i = this.getSurCandidateAnswers().iterator();
        while (i.hasNext()) {
            SurCandidateAnswerVO answer = (SurCandidateAnswerVO)i.next();
            if (answer.getDisplayOrder() == -1) continue;
            sb.append(answer.getNumberOfResponse() + " \t");
        }
        if (this.getQuestionType().trim().equals("textEntry") || this.getIsTextboxEnabled() != 0) {
            sb.append(this.getNumberOfOpenRes() + " \n");
        }
        return sb.toString();
    }

    private Set getAnswerIndex() {
        return this.answerIndex;
    }

    private void setAnswerIndex(String answerIndex) {
        this.answerIndex.add(answerIndex);
    }

    public void setUpResponses(String username) {
        LinkedList response = new LinkedList();
        Iterator i = this.getQuestionUsers().iterator();
        while (i.hasNext()) {
            SurQuestionUsersVO qUser = (SurQuestionUsersVO)i.next();
            if (!qUser.getUsername().trim().equals(username)) continue;
            response.addAll(qUser.getPredefinedResponse());
        }
        this.setUserResponses(response.toArray(new String[response.size()]));
    }

    public void setUpOtherResponse(String username) {
        Iterator i = this.getQuestionUsers().iterator();
        while (i.hasNext()) {
            SurQuestionUsersVO qUser = (SurQuestionUsersVO)i.next();
            if (!qUser.getUsername().trim().equals(username)) continue;
            this.setOtherResponse(qUser.getOtherResponse());
        }
    }

    public boolean isResponsesForQuestion(List userRes) {
        ArrayList responses = new ArrayList(userRes);
        Iterator i = responses.iterator();
        while (i.hasNext()) {
            SurUserResponseVO res = (SurUserResponseVO)i.next();
            if (!res.getSurveyQuestion().getQuestionId().equals(this.getQuestionId())) continue;
            return true;
        }
        return false;
    }

    public boolean isOtherResponseAvailable() {
        return this.otherResponse != null && !this.otherResponse.equals("");
    }

    public JFreeChart createPieChart() {
        DefaultPieDataset data = new DefaultPieDataset();
        NumberFormat formatter = NumberFormat.getPercentInstance();
        Iterator i = this.surCandidateAnswers.iterator();
        while (i.hasNext()) {
            SurCandidateAnswerVO answer = (SurCandidateAnswerVO)i.next();
            if (answer.getDisplayOrder() == -1) continue;
            double percent = Math.round((double)answer.getNumberOfResponse() / (double)this.getTotalNumOfRes() * 100.0);
            data.setValue((Comparable)((Object)("a" + answer.getDisplayOrder())), percent / 100.0);
        }
        if (this.getIsTextboxEnabled() == 1) {
            double percent = Math.round((double)this.getNumberOfOpenRes() / (double)this.getTotalNumOfRes() * 100.0);
            data.setValue((Comparable)((Object)"Open Response"), percent / 100.0);
        }
        JFreeChart chart = ChartFactory.createPieChart3D((String)("Question " + this.displayOrder + " Pie Chart"), (PieDataset)data, (boolean)true, (boolean)false, (boolean)false);
        PiePlot plot = (PiePlot)chart.getPlot();
        plot.setLabelGenerator((PieSectionLabelGenerator)new StandardPieItemLabelGenerator("{0} ({1})", formatter, formatter));
        return chart;
    }

    public JFreeChart createColumnChart() {
        DefaultCategoryDataset dataset = new DefaultCategoryDataset();
        Iterator i = this.surCandidateAnswers.iterator();
        while (i.hasNext()) {
            SurCandidateAnswerVO answer = (SurCandidateAnswerVO)i.next();
            if (answer.getDisplayOrder() == -1) continue;
            double percent = Math.round((double)answer.getNumberOfResponse() / (double)this.getTotalNumOfRes() * 100.0);
            dataset.setValue(percent, (Comparable)((Object)("a" + answer.getDisplayOrder())), (Comparable)((Object)("a" + answer.getDisplayOrder())));
        }
        if (this.getIsTextboxEnabled() == 1) {
            double percent = Math.round((double)this.getNumberOfOpenRes() / (double)this.getTotalNumOfRes() * 100.0);
            dataset.setValue(percent, (Comparable)((Object)"Open Response"), (Comparable)((Object)"Open Response"));
        }
        JFreeChart chart = ChartFactory.createBarChart3D((String)("Question " + this.displayOrder + " Column Chart"), (String)"Candidate Answer", (String)"Percentage", (CategoryDataset)dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)false);
        return chart;
    }
}

